/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.IArchiveReference;
import org.eclipse.update.core.SiteContentProvider;
import org.eclipse.update.core.VersionedIdentifier;

public class SiteFileContentProvider
extends SiteContentProvider {
    private String path;
    public static final String SITE_TYPE = "org.eclipse.update.core.file";

    public SiteFileContentProvider(URL url) {
        super(url);
    }

    private String getFeaturePath(VersionedIdentifier featureIdentifier) {
        String path = this.getURL().getFile();
        String featurePath = String.valueOf(path) + "features/" + featureIdentifier.toString();
        return featurePath;
    }

    public URL getArchiveReference(String archiveId) throws CoreException {
        URL contentURL = null;
        contentURL = this.getArchiveURLfor(archiveId);
        if (contentURL == null) {
            return super.getArchiveReference(archiveId);
        }
        return contentURL;
    }

    private URL getArchiveURLfor(String archiveId) {
        URL result = null;
        boolean found = false;
        IArchiveReference[] siteArchives = this.getSite().getArchives();
        if (siteArchives.length > 0) {
            int i = 0;
            while (i < siteArchives.length && !found) {
                if (archiveId.trim().equalsIgnoreCase(siteArchives[i].getPath())) {
                    result = siteArchives[i].getURL();
                    found = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

