/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFilePluginContentConsumer
extends ContentConsumer {
    private IPluginEntry pluginEntry;
    private ISite site;
    private boolean closed = false;
    private String oldPath;
    private String newPath;
    private List installedFiles;

    public SiteFilePluginContentConsumer(IPluginEntry pluginEntry, ISite site) {
        this.pluginEntry = pluginEntry;
        this.site = site;
        this.installedFiles = new ArrayList();
    }

    public void store(ContentReference contentReference, IProgressMonitor monitor) throws CoreException {
        block15: {
            InputStream inStream = null;
            String pluginPath = null;
            if (this.closed) {
                UpdateCore.warn("Attempt to store in a closed SiteFilePluginContentConsumer", new Exception());
                return;
            }
            try {
                try {
                    File localFile;
                    URL newURL = new URL(this.site.getURL(), "plugins/" + this.pluginEntry.getVersionedIdentifier().toString());
                    pluginPath = newURL.getFile();
                    String contentKey = contentReference.getIdentifier();
                    inStream = contentReference.getInputStream();
                    pluginPath = String.valueOf(pluginPath) + (pluginPath.endsWith(File.separator) ? contentKey : String.valueOf(File.separator) + contentKey);
                    if (pluginPath.endsWith("\\plugin.xml") || pluginPath.endsWith("/plugin.xml")) {
                        this.oldPath = pluginPath.replace(File.separatorChar, '/');
                        localFile = new File(this.oldPath);
                        if (localFile.exists()) {
                            throw Utilities.newCoreException(Policy.bind("UpdateManagerUtils.FileAlreadyExists", new Object[]{localFile}), null);
                        }
                        this.newPath = pluginPath = ErrorRecoveryLog.getLocalRandomIdentifier(pluginPath);
                        ErrorRecoveryLog.getLog().appendPath("PLUGIN", pluginPath);
                    }
                    if (pluginPath.endsWith("\\fragment.xml") || pluginPath.endsWith("/fragment.xml")) {
                        this.oldPath = pluginPath.replace(File.separatorChar, '/');
                        localFile = new File(this.oldPath);
                        if (localFile.exists()) {
                            throw Utilities.newCoreException(Policy.bind("UpdateManagerUtils.FileAlreadyExists", new Object[]{localFile}), null);
                        }
                        this.newPath = pluginPath = ErrorRecoveryLog.getLocalRandomIdentifier(pluginPath);
                        ErrorRecoveryLog.getLog().appendPath("FRAGMENT", pluginPath);
                    }
                    UpdateManagerUtils.copyToLocal(inStream, pluginPath, null);
                    UpdateManagerUtils.checkPermissions(contentReference, pluginPath);
                    this.installedFiles.add(pluginPath);
                }
                catch (IOException e) {
                    throw Utilities.newCoreException(Policy.bind("GlobalConsumer.ErrorCreatingFile", pluginPath), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var8_11 = null;
            if (inStream == null) break block15;
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to close a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        if (this.newPath != null) {
            ErrorRecoveryLog.getLog().appendPath("RENAME", this.newPath);
            File fileToRename = new File(this.newPath);
            boolean sucess = false;
            if (fileToRename.exists()) {
                File renamedFile = new File(this.oldPath);
                sucess = fileToRename.renameTo(renamedFile);
            }
            if (!sucess) {
                String msg = Policy.bind("ContentConsumer.UnableToRename", this.newPath, this.oldPath);
                throw Utilities.newCoreException(msg, new Exception(msg));
            }
        }
        if (this.site instanceof SiteFile) {
            ((SiteFile)this.site).addPluginEntry(this.pluginEntry);
        }
        this.closed = true;
    }

    public void abort() throws CoreException {
        if (this.closed) {
            UpdateCore.warn("Attempt to abort a closed SiteFilePluginContentConsumer", new Exception());
            return;
        }
        boolean sucess = true;
        if (this.oldPath != null) {
            ErrorRecoveryLog.getLog().appendPath("DELETE", this.oldPath);
            File fileToRemove = new File(this.oldPath);
            if (fileToRemove.exists()) {
                sucess = fileToRemove.delete();
            }
        }
        if (!sucess) {
            String msg = Policy.bind("Unable to delete", this.oldPath);
            UpdateCore.log(msg, null);
        } else {
            Iterator iter = this.installedFiles.iterator();
            File featureFile = null;
            while (iter.hasNext()) {
                String path = (String)iter.next();
                featureFile = new File(path);
                UpdateManagerUtils.removeFromFileSystem(featureFile);
            }
            try {
                URL newURL = new URL(this.site.getURL(), "plugins/" + this.pluginEntry.getVersionedIdentifier().toString());
                String pluginPath = newURL.getFile();
                UpdateManagerUtils.removeEmptyDirectoriesFromFileSystem(new File(pluginPath));
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(e.getMessage(), e);
            }
        }
        this.closed = true;
    }
}

