/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFactoryExtension;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.SiteURLContentProvider;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteURLFactory
extends BaseSiteFactory
implements ISiteFactoryExtension {
    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        return this.createSite(url, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISite createSite(URL url, IProgressMonitor monitor) throws CoreException, InvalidSiteTypeException {
        InputStream siteStream;
        Site site;
        block13: {
            ISite iSite;
            block12: {
                site = null;
                siteStream = null;
                try {
                    try {
                        SiteURLContentProvider contentProvider = new SiteURLContentProvider(url);
                        URL resolvedURL = URLEncoder.encode(url);
                        Response response = UpdateCore.getPlugin().get(resolvedURL);
                        UpdateManagerUtils.checkConnectionResult(response, resolvedURL);
                        siteStream = response.getInputStream(monitor);
                        if (siteStream == null) {
                            iSite = null;
                            Object var9_11 = null;
                            if (siteStream == null) return iSite;
                            break block12;
                        }
                        SiteURLFactory factory = this;
                        site = (Site)factory.parseSite(siteStream);
                        site.setSiteContentProvider(contentProvider);
                        contentProvider.setSite(site);
                        site.resolve(url, url);
                        site.markReadOnly();
                        break block13;
                    }
                    catch (MalformedURLException e) {
                        String string;
                        if (url == null) {
                            string = "";
                            throw Utilities.newCoreException(Policy.bind("SiteURLFactory.UnableToCreateURL", string), e);
                        }
                        string = url.toExternalForm();
                        throw Utilities.newCoreException(Policy.bind("SiteURLFactory.UnableToCreateURL", string), e);
                    }
                    catch (IOException e) {
                        String string;
                        if (url == null) {
                            string = "";
                            throw Utilities.newCoreException(Policy.bind("SiteURLFactory.UnableToAccessSiteStream", string), 42, e);
                        }
                        string = url.toExternalForm();
                        throw Utilities.newCoreException(Policy.bind("SiteURLFactory.UnableToAccessSiteStream", string), 42, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    if (siteStream == null) throw throwable;
                    try {
                        siteStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            siteStream.close();
            return iSite;
        }
        Object var9_13 = null;
        if (siteStream == null) return site;
        try {}
        catch (IOException iOException) {
            return site;
        }
        siteStream.close();
        return site;
    }

    public boolean canParseSiteType(String type) {
        return super.canParseSiteType(type) || "org.eclipse.update.core.http".equalsIgnoreCase(type);
    }
}

