/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.notify.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DelegatingEList;

public abstract class DelegatingNotifyingListImpl
extends DelegatingEList
implements NotifyingList {
    public DelegatingNotifyingListImpl() {
    }

    public DelegatingNotifyingListImpl(Collection collection) {
        super(collection);
    }

    public Object getNotifier() {
        return null;
    }

    public Object getFeature() {
        return null;
    }

    public int getFeatureID() {
        return -1;
    }

    protected int getFeatureID(Class expectedClass) {
        return this.getFeatureID();
    }

    protected boolean hasInverse() {
        return false;
    }

    protected boolean canContainNull() {
        return !this.hasInverse();
    }

    protected boolean isNotificationRequired() {
        return false;
    }

    protected NotificationChain inverseAdd(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected NotificationChain inverseRemove(Object object, NotificationChain notifications) {
        return notifications;
    }

    protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index) {
        return new NotificationImpl(eventType, oldObject, newObject, index){

            public Object getNotifier() {
                return DelegatingNotifyingListImpl.this.getNotifier();
            }

            public Object getFeature() {
                return DelegatingNotifyingListImpl.this.getFeature();
            }

            public int getFeatureID(Class expectedClass) {
                return DelegatingNotifyingListImpl.this.getFeatureID(expectedClass);
            }
        };
    }

    protected void dispatchNotification(Notification notification) {
        ((Notifier)this.getNotifier()).eNotify(notification);
    }

    public void addUnique(Object object) {
        if (this.isNotificationRequired()) {
            int index = this.size();
            super.addUnique(index, object);
            NotificationImpl notification = this.createNotification(3, null, object, index);
            if (this.hasInverse()) {
                NotificationChain notifications = this.inverseAdd(object, null);
                if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            NotificationChain notifications;
            super.addUnique(object);
            if (this.hasInverse() && (notifications = this.inverseAdd(object, null)) != null) {
                notifications.dispatch();
            }
        }
    }

    public void addUnique(int index, Object object) {
        if (this.isNotificationRequired()) {
            super.addUnique(index, object);
            NotificationImpl notification = this.createNotification(3, null, object, index);
            if (this.hasInverse()) {
                NotificationChain notifications = this.inverseAdd(object, null);
                if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            NotificationChain notifications;
            super.addUnique(index, object);
            if (this.hasInverse() && (notifications = this.inverseAdd(object, null)) != null) {
                notifications.dispatch();
            }
        }
    }

    public boolean addAllUnique(Collection collection) {
        return this.addAllUnique(this.size(), collection);
    }

    public boolean addAllUnique(int index, Collection collection) {
        int collectionSize = collection.size();
        if (collectionSize == 0) {
            return false;
        }
        if (this.isNotificationRequired()) {
            NotificationImpl notification;
            super.addAllUnique(index, collection);
            NotificationImpl notificationImpl = notification = collectionSize == 1 ? this.createNotification(3, null, collection.iterator().next(), index) : this.createNotification(5, null, collection, index);
            if (this.hasInverse()) {
                NotificationChain notifications = null;
                int lastIndex = index + collectionSize;
                int i = index;
                while (i < lastIndex) {
                    notifications = this.inverseAdd(this.delegateGet(i), notifications);
                    ++i;
                }
                if (notifications == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                this.dispatchNotification(notification);
            }
        } else {
            super.addAllUnique(index, collection);
            if (this.hasInverse()) {
                NotificationChain notifications = null;
                int lastIndex = index + collectionSize;
                int i = index;
                while (i < lastIndex) {
                    notifications = this.inverseAdd(this.delegateGet(i), notifications);
                    ++i;
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            }
        }
        return true;
    }

    public NotificationChain basicAdd(Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            int index = this.size();
            super.addUnique(index, object);
            NotificationImpl notification = this.createNotification(3, null, object, index);
            if (notifications == null) {
                notifications = notification;
            } else {
                notifications.add(this.createNotification(3, null, object, index));
            }
        } else {
            super.addUnique(this.size(), object);
        }
        return notifications;
    }

    public Object remove(int index) {
        NotificationChain notifications;
        if (this.isNotificationRequired()) {
            NotificationImpl notification = this.createNotification(4, super.remove(index), null, index);
            Object oldObject = notification.getOldValue();
            if (this.hasInverse() && oldObject != null) {
                NotificationChain notifications2 = this.inverseRemove(oldObject, null);
                if (notifications2 == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications2.add(notification);
                    notifications2.dispatch();
                }
            } else {
                this.dispatchNotification(notification);
            }
            return oldObject;
        }
        Object oldObject = super.remove(index);
        if (this.hasInverse() && oldObject != null && (notifications = this.inverseRemove(oldObject, null)) != null) {
            notifications.dispatch();
        }
        return oldObject;
    }

    public boolean removeAll(Collection collection) {
        int[] positions;
        boolean result;
        block19: {
            block18: {
                result = false;
                positions = null;
                if (!this.isNotificationRequired()) break block18;
                int listSize = collection.size();
                if (listSize <= 0) break block19;
                BasicEList list = new BasicEList(collection);
                Object[] objects = list.data();
                positions = new int[listSize];
                int count = 0;
                ListIterator i = this.delegateListIterator();
                block0: while (i.hasNext()) {
                    Object object = i.next();
                    int j = listSize;
                    while (--j >= 0) {
                        if (!this.equalObjects(object, objects[j])) continue;
                        if (count != j) {
                            Object x = objects[count];
                            objects[count] = objects[j];
                            objects[j] = x;
                        }
                        positions[count++] = i.previousIndex();
                        continue block0;
                    }
                }
                if (count <= 0) break block19;
                result = true;
                int i2 = count;
                while (--i2 >= 0) {
                    super.remove(positions[i2]);
                }
                if (count != listSize) {
                    int i3 = listSize;
                    while (--i3 >= count) {
                        list.remove(i3);
                    }
                    int[] oldPositions = positions;
                    positions = new int[count];
                    System.arraycopy(oldPositions, 0, positions, 0, count);
                }
                collection = list;
                break block19;
            }
            collection = this.getDuplicates(collection);
            ListIterator i = this.delegateListIterator();
            while (i.hasNext()) {
                if (!collection.contains(i.next())) continue;
                super.remove(i.previousIndex());
                result = true;
            }
        }
        if (result) {
            if (this.isNotificationRequired()) {
                NotificationImpl notification;
                int collectionSize = collection.size();
                NotificationImpl notificationImpl = notification = collectionSize == 1 ? this.createNotification(4, collection.iterator().next(), null, positions[0]) : this.createNotification(6, collection, positions, positions[0]);
                if (this.hasInverse()) {
                    NotificationChain notifications = null;
                    Iterator i = collection.iterator();
                    while (i.hasNext()) {
                        notifications = this.inverseRemove(i.next(), notifications);
                    }
                    if (notifications == null) {
                        this.dispatchNotification(notification);
                    } else {
                        notifications.add(notification);
                        notifications.dispatch();
                    }
                } else {
                    this.dispatchNotification(notification);
                }
            } else if (this.hasInverse()) {
                NotificationChain notifications = null;
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    notifications = this.inverseRemove(i.next(), notifications);
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            }
            return true;
        }
        return false;
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        int index = this.indexOf(object);
        if (index != -1) {
            Object oldObject = super.remove(index);
            if (this.isNotificationRequired()) {
                NotificationImpl notification = this.createNotification(4, oldObject, null, index);
                if (notifications == null) {
                    notifications = notification;
                } else {
                    notifications.add(notification);
                }
            }
        }
        return notifications;
    }

    public void clear() {
        if (this.isNotificationRequired()) {
            int size = this.size();
            if (size > 0) {
                NotificationImpl notification;
                BasicEList collection = new BasicEList(this.basicList());
                int collectionSize = size;
                this.doClear(collectionSize, collection.data());
                NotificationImpl notificationImpl = notification = collectionSize == 1 ? this.createNotification(4, collection.get(0), null, -1) : this.createNotification(6, collection, null, -1);
                if (this.hasInverse()) {
                    NotificationChain notifications = null;
                    Iterator i = collection.iterator();
                    while (i.hasNext()) {
                        notifications = this.inverseRemove(i.next(), notifications);
                    }
                    if (notifications == null) {
                        this.dispatchNotification(notification);
                    } else {
                        notifications.add(notification);
                        notifications.dispatch();
                    }
                } else {
                    this.dispatchNotification(notification);
                }
            } else {
                super.clear();
                this.dispatchNotification(this.createNotification(6, Collections.EMPTY_LIST, null, -1));
            }
        } else if (this.hasInverse()) {
            int size = this.size();
            if (size > 0) {
                Object[] oldData = this.delegateToArray();
                int oldSize = size;
                this.doClear(size, oldData);
                NotificationChain notifications = null;
                int i = 0;
                while (i < oldSize) {
                    notifications = this.inverseRemove(oldData[i], notifications);
                    ++i;
                }
                if (notifications != null) {
                    notifications.dispatch();
                }
            } else {
                super.clear();
            }
        } else {
            super.clear();
        }
    }

    public Object setUnique(int index, Object object) {
        if (this.isNotificationRequired()) {
            NotificationImpl notification = this.createNotification(1, super.setUnique(index, object), object, index);
            Object oldObject = notification.getOldValue();
            if (this.hasInverse() && !this.equalObjects(oldObject, object)) {
                NotificationChain notifications = null;
                if (oldObject != null) {
                    notifications = this.inverseRemove(oldObject, null);
                }
                if ((notifications = this.inverseAdd(object, notifications)) == null) {
                    this.dispatchNotification(notification);
                } else {
                    notifications.add(notification);
                    notifications.dispatch();
                }
            } else {
                this.dispatchNotification(notification);
            }
            return oldObject;
        }
        Object oldObject = super.setUnique(index, object);
        if (this.hasInverse() && !this.equalObjects(oldObject, object)) {
            NotificationChain notifications = null;
            if (oldObject != null) {
                notifications = this.inverseRemove(oldObject, null);
            }
            if ((notifications = this.inverseAdd(object, notifications)) != null) {
                notifications.dispatch();
            }
        }
        return oldObject;
    }

    public NotificationChain basicSet(int index, Object object, NotificationChain notifications) {
        if (this.isNotificationRequired()) {
            NotificationImpl notification = this.createNotification(1, super.setUnique(index, object), object, index);
            if (notifications == null) {
                notifications = notification;
            } else {
                notifications.add(notification);
            }
        } else {
            super.setUnique(index, object);
        }
        return notifications;
    }

    public Object move(int targetIndex, int sourceIndex) {
        Object object = super.move(targetIndex, sourceIndex);
        if (this.isNotificationRequired()) {
            this.dispatchNotification(this.createNotification(7, new Integer(sourceIndex), object, targetIndex));
        }
        return object;
    }
}

