/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.api;

import com.ibm.hwmca.api.APIAlreadyInitializedException;
import com.ibm.hwmca.api.APIEvent;
import com.ibm.hwmca.api.APIEventQualifier;
import com.ibm.hwmca.api.APIException;
import com.ibm.hwmca.api.APINotInitializedException;
import com.ibm.hwmca.api.SNMPData;
import com.ibm.hwmca.api.SNMPException;
import com.ibm.hwmca.api.SNMPSocket;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

public class APIConnection {
    public static boolean debug = false;
    public static final String HWMCA_BASE_ID = "1.3.6.1.4.1.2.6.42";
    public static final String HWMCA_OBJECT_PREFIX = "1.3.6.1.4.1.2.6.42.";
    public static final String HWMCA_CONSOLE_ID = "1.3.6.1.4.1.2.6.42.0";
    public static final String HWMCA_CFG_CPC_GROUP_ID = "1.3.6.1.4.1.2.6.42.1";
    public static final String HWMCA_CFG_CPC_ID = "1.3.6.1.4.1.2.6.42.1.0";
    public static final String HWMCA_CPC_IMAGE_GROUP_ID = "1.3.6.1.4.1.2.6.42.2";
    public static final String HWMCA_CPC_IMAGE_ID = "1.3.6.1.4.1.2.6.42.2.0";
    public static final String HWMCA_GROUPS_GROUP_ID = "1.3.6.1.4.1.2.6.42.3";
    public static final String HWMCA_GROUPS_OBJECT_ID = "1.3.6.1.4.1.2.6.42.3.0";
    public static final String HWMCA_COMMAND_PREFIX = "1.3.6.1.4.1.2.6.42.4.";
    public static final String HWMCA_ACT_RESET_OBJECT_ID = "1.3.6.1.4.1.2.6.42.5.0";
    public static final String HWMCA_ACT_IMAGE_OBJECT_ID = "1.3.6.1.4.1.2.6.42.6.0";
    public static final String HWMCA_ACT_LOAD_OBJECT_ID = "1.3.6.1.4.1.2.6.42.7.0";
    public static final String HWMCA_ACTIVATE_COMMAND = "1.3.6.1.4.1.2.6.42.4.1";
    public static final String HWMCA_DEACTIVATE_COMMAND = "1.3.6.1.4.1.2.6.42.4.2";
    public static final String HWMCA_SEND_OPSYS_COMMAND = "1.3.6.1.4.1.2.6.42.4.3";
    public static final String HWMCA_RESETNORMAL_COMMAND = "1.3.6.1.4.1.2.6.42.4.4";
    public static final String HWMCA_START_COMMAND = "1.3.6.1.4.1.2.6.42.4.5";
    public static final String HWMCA_STOP_COMMAND = "1.3.6.1.4.1.2.6.42.4.6";
    public static final String HWMCA_PSWRESTART_COMMAND = "1.3.6.1.4.1.2.6.42.4.7";
    public static final String HWMCA_INITIALIZE_API = "1.3.6.1.4.1.2.6.42.4.8";
    public static final String HWMCA_TERMINATE_API = "1.3.6.1.4.1.2.6.42.4.9";
    public static final String HWMCA_LOAD_COMMAND = "1.3.6.1.4.1.2.6.42.4.10";
    public static final String HWMCA_HW_MESSAGE_REFRESH_COMMAND = "1.3.6.1.4.1.2.6.42.4.11";
    public static final String HWMCA_RESETCLEAR_COMMAND = "1.3.6.1.4.1.2.6.42.4.12";
    public static final String HWMCA_HW_MESSAGE_DELETE_COMMAND = "1.3.6.1.4.1.2.6.42.4.13";
    public static final String HWMCA_ACTIVATE_CBU_COMMAND = "1.3.6.1.4.1.2.6.42.4.14";
    public static final String HWMCA_UNDO_CBU_COMMAND = "1.3.6.1.4.1.2.6.42.4.15";
    public static final String HWMCA_IMPORT_PROFILE_COMMAND = "1.3.6.1.4.1.2.6.42.4.16";
    public static final String HWMCA_EXPORT_PROFILE_COMMAND = "1.3.6.1.4.1.2.6.42.4.17";
    public static final String HWMCA_RESERVE_COMMAND = "1.3.6.1.4.1.2.6.42.4.18";
    public static final String HWMCA_EXTERNAL_INTERRUPT_COMMAND = "1.3.6.1.4.1.2.6.42.4.19";
    public static final String HWMCA_SCSI_LOAD_COMMAND = "1.3.6.1.4.1.2.6.42.4.20";
    public static final String HWMCA_SCSI_DUMP_COMMAND = "1.3.6.1.4.1.2.6.42.4.21";
    public static final String HWMCA_SHUTDOWN_RESTART_COMMAND = "1.3.6.1.4.1.2.6.42.4.22";
    public static final String HWMCA_COMMAND_OBJECT_ID_SUFFIX = "0.1";
    public static final String HWMCA_COMMAND_CONDITION_CODE_SUFFIX = "0.2";
    public static final String HWMCA_COMMAND_LAST_INDICATOR_SUFFIX = "0.3";
    public static final String HWMCA_NAME_SUFFIX = "1.0";
    public static final String HWMCA_PARENT_NAME_SUFFIX = "2.0";
    public static final String HWMCA_OPSYS_NAME_SUFFIX = "3.0";
    public static final String HWMCA_OPSYS_TYPE_SUFFIX = "4.0";
    public static final String HWMCA_OPSYS_LEVEL_SUFFIX = "5.0";
    public static final String HWMCA_SYSPLEX_NAME_SUFFIX = "6.0";
    public static final String HWMCA_STATUS_ERROR_SUFFIX = "7.0";
    public static final String HWMCA_BUSY_SUFFIX = "8.0";
    public static final String HWMCA_MESSAGE_SUFFIX = "9.0";
    public static final String HWMCA_MESSAGE_TYPE_SUFFIX = "9.1";
    public static final String HWMCA_MESSAGE_TEXT_SUFFIX = "9.2";
    public static final String HWMCA_MESSAGE_MSG_ID_SUFFIX = "9.3";
    public static final String HWMCA_MESSAGE_DATE_SUFFIX = "9.4";
    public static final String HWMCA_MESSAGE_TIME_SUFFIX = "9.5";
    public static final String HWMCA_MESSAGE_ALARM_SUFFIX = "9.6";
    public static final String HWMCA_MESSAGE_PRIORITY_SUFFIX = "9.7";
    public static final String HWMCA_MESSAGE_HELD_SUFFIX = "9.8";
    public static final String HWMCA_MESSAGE_PROMPT_TEXT_SUFFIX = "9.9";
    public static final String HWMCA_MESSAGE_OSNAME_TEXT_SUFFIX = "9.10";
    public static final String HWMCA_MESSAGE_REFRESH_SUFFIX = "9.11";
    public static final String HWMCA_MESSAGE_TIMESTAMP = "9.12";
    public static final String HWMCA_MESSAGE_IMAGE_LIST = "9.13";
    public static final String HWMCA_STATUS_SUFFIX = "10.0";
    public static final String HWMCA_EXPECTED_STATUS_SUFFIX = "11.0";
    public static final String HWMCA_IMLMODE_SUFFIX = "12.0";
    public static final String HWMCA_ACTIVATION_PROFILE_SUFFIX = "13.0";
    public static final String HWMCA_LAST_ACT_PROFILE_SUFFIX = "14.0";
    public static final String HWMCA_IP_ADDRESS_SUFFIX = "15.0";
    public static final String HWMCA_SNA_ADDRESS_SUFFIX = "16.0";
    public static final String HWMCA_MODEL_SUFFIX = "17.0";
    public static final String HWMCA_TYPE_SUFFIX = "18.0";
    public static final String HWMCA_MACHINE_SERIAL_SUFFIX = "19.0";
    public static final String HWMCA_CPC_SERIAL_SUFFIX = "20.0";
    public static final String HWMCA_CPC_ID_SUFFIX = "21.0";
    public static final String HWMCA_OBJECT_TYPE_SUFFIX = "22.0";
    public static final String HWMCA_GROUP_CONTENTS_SUFFIX = "23.0";
    public static final String HWMCA_ACT_RESET_LIST_SUFFIX = "24.0";
    public static final String HWMCA_ACT_IMAGE_LIST_SUFFIX = "25.0";
    public static final String HWMCA_ACT_LOAD_LIST_SUFFIX = "26.0";
    public static final String HWMCA_ACT_PROFILE_IOCDS_SUFFIX = "27.0";
    public static final String HWMCA_ACT_PROFILE_IPLADDR_SUFFIX = "28.0";
    public static final String HWMCA_ACT_PROFILE_IPLPARM_SUFFIX = "29.0";
    public static final String HWMCA_WEIGHT_SUFFIX = "30.0";
    public static final String HWMCA_CAPPED_SUFFIX = "31.0";
    public static final String HWMCA_CBU_INSTALLED_SUFFIX = "32.0";
    public static final String HWMCA_CBU_ACTIVATED_SUFFIX = "33.0";
    public static final String HWMCA_CBU_ACTIVATION_DATE_SUFFIX = "34.0";
    public static final String HWMCA_CBU_EXPIRATION_DATE_SUFFIX = "35.0";
    public static final String HWMCA_NUMBER_CBU_TEST_LEFT_SUFFIX = "36.0";
    public static final String HWMCA_REAL_CBU_ACTIVATION_AVAILABLE_SUFFIX = "37.0";
    public static final String HWMCA_MINIMUM_WEIGHT_SUFFIX = "38.0";
    public static final String HWMCA_MAXIMUM_WEIGHT_SUFFIX = "39.0";
    public static final String HWMCA_WLM_MANAGED_SUFFIX = "40.0";
    public static final String HWMCA_CURRENT_WEIGHT_SUFFIX = "41.0";
    public static final String HWMCA_CURRENT_CAPPED_SUFFIX = "42.0";
    public static final String HWMCA_DEFINED_CAPACITY_SUFFIX = "43.0";
    public static final String HWMCA_RESERVE_ID_SUFFIX = "44.0";
    public static final String HWMCA_ALERT_SUFFIX = "45.0";
    public static final String HWMCA_SERVICE_REQUIRED_SUFFIX = "46.0";
    public static final String HWMCA_DEGRADED_SUFFIX = "47.0";
    public static final String HWMCA_CBU_ENABLED_SUFFIX = "48.0";
    public static final String HWMCA_CLUSTER_NAME_SUFFIX = "49.0";
    public static final String HWMCA_CLUSTER_LIST_SUFFIX = "50.0";
    public static final String HWMCA_PARTITION_ID_SUFFIX = "51.0";
    public static final String HWMCA_ACT_PROFILE_IPLTYPE_SUFFIX = "52.0";
    public static final String HWMCA_ACT_PROFILE_WWPN_SUFFIX = "53.0";
    public static final String HWMCA_ACT_PROFILE_BPS_SUFFIX = "54.0";
    public static final String HWMCA_ACT_PROFILE_LUN_SUFFIX = "55.0";
    public static final String HWMCA_ACT_PROFILE_BRLBA_SUFFIX = "56.0";
    public static final String HWMCA_ACT_PROFILE_OSLOADPARM_SUFFIX = "57.0";
    public static final String HWMCA_EVENT_TEXT_SUFFIX = "58.0";
    public static final String HWMCA_EVENT_TIMESTAMP_SUFFIX = "59.0";
    public static final String HWMCA_IFA_WEIGHT_SUFFIX = "60.0";
    public static final String HWMCA_IFA_CAPPED_SUFFIX = "61.0";
    public static final String HWMCA_IFA_MINIMUM_WEIGHT_SUFFIX = "62.0";
    public static final String HWMCA_IFA_MAXIMUM_WEIGHT_SUFFIX = "63.0";
    public static final String HWMCA_IFA_CURRENT_WEIGHT_SUFFIX = "64.0";
    public static final String HWMCA_IFA_CURRENT_CAPPED_SUFFIX = "65.0";
    public static final String HWMCA_IFL_WEIGHT_SUFFIX = "66.0";
    public static final String HWMCA_IFL_CAPPED_SUFFIX = "67.0";
    public static final String HWMCA_IFL_MINIMUM_WEIGHT_SUFFIX = "68.0";
    public static final String HWMCA_IFL_MAXIMUM_WEIGHT_SUFFIX = "69.0";
    public static final String HWMCA_IFL_CURRENT_WEIGHT_SUFFIX = "70.0";
    public static final String HWMCA_IFL_CURRENT_CAPPED_SUFFIX = "71.0";
    public static final String HWMCA_ICF_WEIGHT_SUFFIX = "72.0";
    public static final String HWMCA_ICF_CAPPED_SUFFIX = "73.0";
    public static final String HWMCA_ICF_MINIMUM_WEIGHT_SUFFIX = "74.0";
    public static final String HWMCA_ICF_MAXIMUM_WEIGHT_SUFFIX = "75.0";
    public static final String HWMCA_ICF_CURRENT_WEIGHT_SUFFIX = "76.0";
    public static final String HWMCA_ICF_CURRENT_CAPPED_SUFFIX = "77.0";
    public static final int HWMCA_DIRECT_INITIALIZE = 0x20000000;
    public static final int HWMCA_FORCE_CLIENT_PATH = 0x10000000;
    public static final int HWMCA_SNMP_VERSION_2 = 0x8000000;
    private static final int HWMCA_EVENT_USE_TCP = 0x40000000;
    public static final int HWMCA_TOLERATE_LOST_EVENTS = 0x2000000;
    public static final int HWMCA_QUALIFIER_SPECIFIED = 0x800000;
    public static final int HWMCA_HARDWARE_MESSAGE = 1;
    public static final int HWMCA_OPSYS_MESSAGE = 2;
    public static final int HWMCA_NOT_DEGRADED = 0;
    public static final int HWMCA_DEGRADED_MEM = 1;
    public static final int HWMCA_DEGRADED_MBA = 2;
    public static final int HWMCA_DEGRADED_NODE = 4;
    public static final int HWMCA_DEGRADED_RING = 8;
    public static final int HWMCA_DEGRADED_CBU = 16;
    public static final int HWMCA_DEGRADED_MRU = 32;
    public static final int HWMCA_DEGRADED_AMBIENT = 64;
    public static final int HWMCA_DEGRADED_MRU_IML = 128;
    public static final int HWMCA_STATUS_OPERATING = 1;
    public static final int HWMCA_STATUS_NOT_OPERATING = 2;
    public static final int HWMCA_STATUS_NO_POWER = 4;
    public static final int HWMCA_STATUS_NOT_ACTIVATED = 8;
    public static final int HWMCA_STATUS_EXCEPTIONS = 16;
    public static final int HWMCA_STATUS_STATUS_CHECK = 32;
    public static final int HWMCA_STATUS_SERVICE = 64;
    public static final int HWMCA_STATUS_LINKNOTACTIVE = 128;
    public static final int HWMCA_STATUS_POWERSAVE = 256;
    public static final int HWMCA_STATUS_SERIOUSALERT = 512;
    public static final int HWMCA_STATUS_ALERT = 1024;
    public static final int HWMCA_STATUS_ENVALERT = 2048;
    public static final int HWMCA_STATUS_SERVICE_REQ = 4096;
    public static final int HWMCA_STATUS_DEGRADED = 8192;
    public static final int HWMCA_IML_ESA390_MODE = 1;
    public static final int HWMCA_IML_S370_MODE = 2;
    public static final int HWMCA_IML_FM_MODE = 6;
    public static final int HWMCA_IML_FMAE_MODE = 7;
    public static final int HWMCA_IML_HM_MODE = 8;
    public static final int HWMCA_IML_HMEA_MODE = 9;
    public static final int HWMCA_IML_HMEX_MODE = 10;
    public static final int HWMCA_IML_LPAR_MODE = 11;
    public static final int HWMCA_IML_ESA390TPF_MODE = 12;
    public static final int HWMCA_IML_CF_PROD_MODE = 13;
    public static final int HWMCA_IML_FMEX_MODE = 14;
    public static final int HWMCA_IML_HMAS_MODE = 15;
    public static final int HWMCA_IML_LINUXO_MODE = 16;
    public static final int HWMCA_IPLTYPE_STANDARD = 1;
    public static final int HWMCA_IPLTYPE_SCSI = 2;
    public static final int HWMCA_IPLTYPE_SCSIDUMP = 3;
    public static final int HWMCA_CPC_GROUP = 1;
    public static final int HWMCA_CPC_IMAGE_GROUP = 2;
    public static final int HWMCA_CPC_USER_GROUP = 3;
    public static final int HWMCA_CPC_IMAGE_USER_GROUP = 4;
    public static final int HWMCA_CPC_OBJECT = 5;
    public static final int HWMCA_CPC_IMAGE_OBJECT = 6;
    public static final int HWMCA_CF_OBJECT = 7;
    public static final int HWMCA_ACT_PROFILE_RESET = 8;
    public static final int HWMCA_ACT_PROFILE_IMAGE = 9;
    public static final int HWMCA_ACT_PROFILE_LOAD = 10;
    public static final int HWMCA_RESTART_APPLICATION = 1;
    public static final int HWMCA_RESTART_CONSOLE = 2;
    public static final int HWMCA_SHUTDOWN_CONSOLE = 3;
    public static final int HWMCA_RESTART_APPLICATION_ALTERNATE = 4;
    public static final int HWMCA_RESTART_CONSOLE_ALTERNATE = 5;
    public static final int HWMCA_SHUTDOWN_CONSOLE_ALTERNATE = 6;
    public static final int HWMCA_CMD_NO_ERROR = 0;
    public static final int HWMCA_CMD_NO_SUCH_OBJECT = 1;
    public static final int HWMCA_CMD_INVALID_DATA_TYPE = 2;
    public static final int HWMCA_CMD_INVALID_DATA_LENGTH = 3;
    public static final int HWMCA_CMD_INVALID_DATA_PTR = 4;
    public static final int HWMCA_CMD_INVALID_DATA_VALUE = 5;
    public static final int HWMCA_CMD_INVALID_INIT_PTR = 6;
    public static final int HWMCA_CMD_INVALID_ID_PTR = 7;
    public static final int HWMCA_CMD_INVALID_DATATYPE_PTR = 10;
    public static final int HWMCA_CMD_INVALID_PARAMETER = 13;
    public static final int HWMCA_CMD_REQUEST_ALLOC_ERROR = 17;
    public static final int HWMCA_CMD_REQUEST_SEND_ERROR = 18;
    public static final int HWMCA_CMD_TIMEOUT = 19;
    public static final int HWMCA_CMD_REQUEST_RECV_ERROR = 20;
    public static final int HWMCA_CMD_SNMP_ERROR = 21;
    public static final int HWMCA_CMD_INVALID_TIMEOUT = 22;
    public static final int HWMCA_CMD_INVALID_CMD = 23;
    public static final int HWMCA_CMD_OBJECT_BUSY = 24;
    public static final int HWMCA_CMD_INVALID_OBJECT = 25;
    public static final int HWMCA_CMD_COMMAND_FAILED = 26;
    public static final int HWMCA_CMD_INITTERM_OK = 27;
    public static final int HWMCA_CMD_CBU_DISRUPTIVE_OK = 28;
    public static final int HWMCA_CMD_CBU_PARTIAL_HW = 29;
    public static final int HWMCA_CMD_CBU_NO_SPARES = 30;
    public static final int HWMCA_CMD_CBU_TEMPORARY = 31;
    public static final int HWMCA_CMD_CBU_NOT_ENABLED = 32;
    public static final int HWMCA_CMD_CBU_NOT_AUTHORIZED = 33;
    public static final int HWMCA_CMD_CBU_FAILED = 34;
    public static final int HWMCA_CMD_CBU_ALREADY_ACTIVE = 35;
    public static final int HWMCA_CMD_CBU_INPROGRESS = 36;
    public static final int HWMCA_CMD_CBU_CPSAP_SPLIT_CHG = 37;
    private boolean _isConnected = false;
    private int _eventMask = 0;
    private SNMPSocket _snmpSocket;
    private ServerSocket _eventSocket;
    private Socket _acceptSocket;
    private int _timeout = 30000;

    public APIConnection() throws SocketException {
        APIConnection.trace("-> APIConnection()");
        int pass = 1;
        this._snmpSocket = new SNMPSocket();
        int start = this._snmpSocket.getLocalPort();
        this._eventSocket = null;
        do {
            APIConnection.trace("Pass #" + pass + ".");
            if (this._snmpSocket != null) {
                APIConnection.trace("_snmpSocket not null, port=[" + this._snmpSocket.getLocalPort() + "].");
                if (this._eventSocket == null) {
                    APIConnection.trace("_eventSocket is null");
                    try {
                        this._eventSocket = new ServerSocket(this._snmpSocket.getLocalPort());
                        APIConnection.trace("_eventSocket successfully created with the same port");
                    }
                    catch (IOException ex) {
                        this._snmpSocket.close();
                        this._snmpSocket = null;
                        ++start;
                    }
                } else {
                    APIConnection.trace("_eventSocket not null, port=[" + this._eventSocket.getLocalPort() + "].");
                }
            } else {
                APIConnection.trace("_snmpSocket is null");
                try {
                    this._snmpSocket = new SNMPSocket(start);
                }
                catch (SocketException ex) {
                    ++start;
                }
            }
            ++pass;
        } while (this._snmpSocket == null || this._eventSocket == null);
        APIConnection.trace("Done - _eventSocket port=[" + this._eventSocket.getLocalPort() + "].");
        APIConnection.trace("Done - _snmpSocket port=[" + this._snmpSocket.getLocalPort() + "].");
        APIConnection.trace("<- APIConnection()");
    }

    public APIConnection(String community, InetAddress addr) throws SocketException, APIAlreadyInitializedException {
        this();
        APIConnection.trace("-> APIConnection(community, addr)");
        this.setCommunity(community);
        this.setAddress(addr);
        APIConnection.trace("<- APIConnection(community, addr)");
    }

    public APIConnection(String community, String host) throws SocketException, UnknownHostException, APIAlreadyInitializedException {
        this();
        APIConnection.trace("-> APIConnection(community, host)");
        this.setCommunity(community);
        this.setAddress(InetAddress.getByName(host));
        APIConnection.trace("<- APIConnection(community, host)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress addr) throws APIAlreadyInitializedException {
        APIConnection aPIConnection = this;
        synchronized (aPIConnection) {
            if (this._isConnected) {
                throw new APIAlreadyInitializedException();
            }
            this._snmpSocket.setAddress(addr);
        }
    }

    public InetAddress getAddress() {
        return this._snmpSocket.getAddress();
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTargetPort(int port) {
        this._snmpSocket.setTargetPort(port);
    }

    public int getTargetPort() {
        return this._snmpSocket.getTargetPort();
    }

    public void setCommunity(String community) {
        this._snmpSocket.setCommunity(community);
    }

    public String getCommunity() {
        return this._snmpSocket.getCommunity();
    }

    public SNMPSocket getSNMPSocket() {
        return this._snmpSocket;
    }

    public synchronized void Initialize(int eventMask) throws IOException, SNMPException, UnknownHostException {
        APIConnection.trace("-> APIConnection.Initialize");
        this.doInitOrTerm(HWMCA_INITIALIZE_API, eventMask, null);
        this._isConnected = true;
        this._eventMask = eventMask;
        APIConnection.trace("<- APIConnection.Initialize");
    }

    public synchronized void Initialize(int eventMask, APIEventQualifier[] qualifiers) throws IOException, SNMPException, UnknownHostException {
        APIConnection.trace("-> APIConnection.Initialize");
        this.doInitOrTerm(HWMCA_INITIALIZE_API, eventMask, qualifiers);
        this._isConnected = true;
        this._eventMask = eventMask;
        APIConnection.trace("<- APIConnection.Initialize");
    }

    public synchronized void Terminate() throws APIException, IOException, SNMPException, UnknownHostException {
        APIConnection.trace("-> APIConnection.Terminate");
        if (this._isConnected) {
            this.doInitOrTerm(HWMCA_TERMINATE_API, this._eventMask, null);
            this._isConnected = false;
            this._eventMask = 0;
            if (this._acceptSocket != null) {
                this._acceptSocket.close();
                this._acceptSocket = null;
            }
        } else {
            throw new APINotInitializedException();
        }
        APIConnection.trace("<- APIConnection.Terminate");
    }

    private void doInitOrTerm(String cmd, int eventMask, APIEventQualifier[] qualifiers) throws IOException, SNMPException, UnknownHostException {
        APIConnection.trace("-> APIConnection.doInitOrTerm");
        int datalength = 14;
        if (HWMCA_INITIALIZE_API.equals(cmd) && (eventMask & 0x800000) == 0x800000) {
            byte[] btmp = null;
            block6: for (int i = 0; qualifiers != null && i < qualifiers.length; ++i) {
                datalength += 4;
                APIConnection.trace("qualifier[" + i + "] = [" + qualifiers[i] + "]");
                switch (qualifiers[i].getType()) {
                    case 1: {
                        datalength += 4;
                        if (qualifiers[i].getData().getType() != 4) {
                            throw new IllegalArgumentException("Event qualifier has type of HWMCA_QUALIFIER_TYPE_NAME, but data is not of the correct type.");
                        }
                        btmp = qualifiers[i].getData().getBytes();
                        datalength += btmp.length;
                        if (btmp[btmp.length - 1] == 0) continue block6;
                        ++datalength;
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid event qualifier type of " + qualifiers[i].getType() + " specified.");
                    }
                }
            }
            if (qualifiers != null && (eventMask & 0x800000) == 0x800000) {
                datalength += 8;
            }
        }
        int lengthlength = SNMPData.encodeLength(datalength, null, 0);
        APIConnection.trace("using data length of " + datalength + ".");
        byte[] bData = new byte[1 + lengthlength + datalength];
        bData[0] = 4;
        SNMPData.encodeLength(datalength, bData, 1);
        int dataoffset = lengthlength + 1;
        byte[] bTargetAddr = this._snmpSocket.getAddress().getAddress();
        byte[] bLocalAddr = null;
        bLocalAddr = this._snmpSocket.getAddress().equals(InetAddress.getByName("127.0.0.1")) ? InetAddress.getByName("127.0.0.1").getAddress() : InetAddress.getLocalHost().getAddress();
        int tmpPort = this._snmpSocket.getLocalPort();
        byte[] bPort = new byte[2];
        bPort[1] = (byte)tmpPort;
        bPort[0] = (byte)(tmpPort >>>= 8);
        tmpPort = eventMask + 0x40000000;
        if (this._snmpSocket.getVersion() == 1) {
            tmpPort += 0x8000000;
        }
        byte[] bEventMask = new byte[4];
        bEventMask[3] = (byte)tmpPort;
        bEventMask[2] = (byte)(tmpPort >>>= 8);
        bEventMask[1] = (byte)(tmpPort >>>= 8);
        bEventMask[0] = (byte)(tmpPort >>>= 8);
        System.arraycopy(bLocalAddr, 0, bData, dataoffset, bLocalAddr.length);
        System.arraycopy(bPort, 0, bData, dataoffset + 4, bPort.length);
        System.arraycopy(bEventMask, 0, bData, dataoffset + 6, bEventMask.length);
        System.arraycopy(bTargetAddr, 0, bData, dataoffset + 10, bLocalAddr.length);
        if (HWMCA_INITIALIZE_API.equals(cmd) && (eventMask & 0x800000) == 0x800000) {
            int i;
            byte[] btmp = null;
            dataoffset += 14;
            block7: for (i = 0; qualifiers != null && i < qualifiers.length; ++i) {
                tmpPort = qualifiers[i].getEventMask();
                bEventMask[3] = (byte)tmpPort;
                bEventMask[2] = (byte)(tmpPort >>>= 8);
                bEventMask[1] = (byte)(tmpPort >>>= 8);
                bEventMask[0] = (byte)(tmpPort >>>= 8);
                System.arraycopy(bEventMask, 0, bData, dataoffset, bEventMask.length);
                dataoffset += 4;
                switch (qualifiers[i].getType()) {
                    case 1: {
                        tmpPort = qualifiers[i].getType();
                        bEventMask[3] = (byte)tmpPort;
                        bEventMask[2] = (byte)(tmpPort >>>= 8);
                        bEventMask[1] = (byte)(tmpPort >>>= 8);
                        bEventMask[0] = (byte)(tmpPort >>>= 8);
                        System.arraycopy(bEventMask, 0, bData, dataoffset, bEventMask.length);
                        btmp = qualifiers[i].getData().getBytes();
                        System.arraycopy(btmp, 0, bData, dataoffset += 4, btmp.length);
                        dataoffset += btmp.length;
                        if (btmp[btmp.length - 1] == 0) continue block7;
                        bData[dataoffset] = 0;
                        ++dataoffset;
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid event qualifier type of " + qualifiers[i].getType() + " specified.");
                    }
                }
            }
            for (i = 0; i < 8; ++i) {
                bData[dataoffset + i] = -1;
            }
        }
        SNMPData[] parmdata = new SNMPData[]{new SNMPData(bData, 0)};
        this.Command(HWMCA_CONSOLE_ID, cmd, parmdata);
        APIConnection.trace("<- APIConnection.doInitOrTerm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SNMPData Get(String oid) throws IOException, SNMPException {
        APIConnection.trace("-> APIConnection.Get");
        SNMPData data = null;
        SNMPSocket sNMPSocket = this._snmpSocket;
        synchronized (sNMPSocket) {
            this._snmpSocket.setSoTimeout(this._timeout);
            data = this._snmpSocket.Get(oid);
        }
        APIConnection.trace("<- APIConnection.Get");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SNMPData[] GetNext(String oid) throws IOException, SNMPException {
        APIConnection.trace("-> APIConnection.GetNext");
        SNMPData[] data = null;
        SNMPSocket sNMPSocket = this._snmpSocket;
        synchronized (sNMPSocket) {
            this._snmpSocket.setSoTimeout(this._timeout);
            data = this._snmpSocket.GetNext(oid);
        }
        APIConnection.trace("<- APIConnection.GetNext");
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Set(String oid, SNMPData data) throws IOException, SNMPException {
        APIConnection.trace("-> APIConnection.Set");
        SNMPSocket sNMPSocket = this._snmpSocket;
        synchronized (sNMPSocket) {
            this._snmpSocket.setSoTimeout(this._timeout);
            this._snmpSocket.Set(oid, data);
        }
        APIConnection.trace("<- APIConnection.Set");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Command(String target, String cmd, SNMPData[] parms) throws IOException, SNMPException {
        APIConnection.trace("-> APIConnection.Command");
        SNMPSocket sNMPSocket = this._snmpSocket;
        synchronized (sNMPSocket) {
            this._snmpSocket.setSoTimeout(this._timeout);
            SNMPData targetparm = SNMPData.fromStringNullTerm(target);
            if (parms == null) {
                SNMPData nullParm = SNMPData.fromNull();
                parms = new SNMPData[]{nullParm};
            }
            int parmsize = 1;
            parmsize += targetparm.getLength();
            for (int i = 0; i < parms.length; ++i) {
                parmsize += parms[i].getLength();
            }
            int lenlen = SNMPData.encodeLength(parmsize, null, 0);
            byte[] bparms = new byte[parmsize += lenlen];
            bparms[0] = 4;
            int offset = 1;
            offset += SNMPData.encodeLength(parmsize - 1 - lenlen, bparms, offset);
            int copylen = targetparm.getLength();
            System.arraycopy(targetparm.getBytes(), 0, bparms, offset, copylen);
            offset += copylen;
            for (int i = 0; i < parms.length; ++i) {
                copylen = parms[i].getLength();
                System.arraycopy(parms[i].getBytes(), 0, bparms, offset, copylen);
                offset += copylen;
            }
            SNMPData parmdata = new SNMPData(bparms, 0);
            this._snmpSocket.Set(cmd, parmdata);
        }
        APIConnection.trace("<- APIConnection.Command");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIEvent WaitEvent() throws APIException, IOException, SNMPException {
        APIConnection.trace("-> APIConnection.WaitEvent");
        APIEvent event = null;
        APIConnection aPIConnection = this;
        synchronized (aPIConnection) {
            if (this._isConnected) {
                long startTime = System.currentTimeMillis();
                int waitTime = this._timeout;
                if (this._acceptSocket == null) {
                    do {
                        this._eventSocket.setSoTimeout(waitTime);
                        this._acceptSocket = this._eventSocket.accept();
                        if (this._timeout != 0) {
                            waitTime = this._timeout - (int)(System.currentTimeMillis() - startTime);
                        }
                        if (!this._acceptSocket.getInetAddress().equals(this._snmpSocket.getAddress())) {
                            this._acceptSocket.close();
                            this._acceptSocket = null;
                        }
                        if (waitTime >= 0) continue;
                        throw new InterruptedIOException("Timeout waiting for event connection");
                    } while (this._acceptSocket == null);
                }
                Socket socket = this._acceptSocket;
                synchronized (socket) {
                    boolean bHaveEvent = false;
                    BufferedInputStream in = new BufferedInputStream(this._acceptSocket.getInputStream());
                    byte[] bInitial = new byte[10];
                    do {
                        this._acceptSocket.setSoTimeout(waitTime);
                        int readLen = in.read(bInitial, 0, bInitial.length);
                        if (readLen >= bInitial.length) {
                            int[] aLen = new int[2];
                            SNMPData.decodeLength(aLen, bInitial, 1);
                            APIConnection.trace("Need a buffer of [" + (1 + aLen[0] + aLen[1]) + "] for the total event.");
                            byte[] bEvent = new byte[1 + aLen[0] + aLen[1]];
                            System.arraycopy(bInitial, 0, bEvent, 0, bInitial.length);
                            readLen = in.read(bEvent, bInitial.length, bEvent.length - bInitial.length);
                            if (readLen >= bEvent.length - bInitial.length) {
                                APIConnection.dumpBytes("event packet =", bEvent, 0, bEvent.length);
                                int offset = 2 + aLen[0];
                                SNMPData.decodeLength(aLen, bEvent, offset);
                                SNMPData.decodeLength(aLen, bEvent, offset += 1 + aLen[0] + aLen[1]);
                                if (bEvent[offset += aLen[0] + aLen[1]] == -92) {
                                    APIConnection.trace("WaitEvent packet was a trap PDU");
                                    bHaveEvent = true;
                                    SNMPData.decodeLength(aLen, bEvent, ++offset);
                                    SNMPData.decodeLength(aLen, bEvent, offset += 1 + aLen[0]);
                                    SNMPData.decodeLength(aLen, bEvent, offset += 1 + aLen[0] + aLen[1]);
                                    SNMPData.decodeLength(aLen, bEvent, offset += 1 + aLen[0] + aLen[1]);
                                    SNMPData.decodeLength(aLen, bEvent, offset += 1 + aLen[0] + aLen[1]);
                                    SNMPData.decodeLength(aLen, bEvent, offset += 1 + aLen[0] + aLen[1]);
                                    SNMPData.decodeLength(aLen, bEvent, offset += 1 + aLen[0] + aLen[1]);
                                    offset += aLen[0];
                                    Vector<SNMPData> bindings = new Vector<SNMPData>();
                                    APIConnection.trace("WaitEvent about to begin looping through the variable bindings list");
                                    while (offset < bEvent.length && bEvent[offset] == 48) {
                                        APIConnection.trace("WaitEvent about to work on the sequence part");
                                        SNMPData.decodeLength(aLen, bEvent, ++offset);
                                        APIConnection.trace("WaitEvent about to work on the object id part");
                                        bindings.addElement(new SNMPData(bEvent, (offset += 1 + aLen[0]) - 1));
                                        SNMPData.decodeLength(aLen, bEvent, offset);
                                        APIConnection.trace("WaitEvent about to work on the data type part");
                                        bindings.addElement(new SNMPData(bEvent, offset += aLen[0] + aLen[1]));
                                        SNMPData.decodeLength(aLen, bEvent, offset + 1);
                                        offset += 1 + aLen[0] + aLen[1];
                                    }
                                    APIConnection.trace("WaitEvent out of variable bindings list loop");
                                    Object[] data = new SNMPData[bindings.size()];
                                    bindings.copyInto(data);
                                    event = APIEvent.getEventObject(this, (SNMPData[])data);
                                } else {
                                    APIConnection.trace("WaitEvent packet was NOT a trap PDU");
                                }
                                if (this._timeout != 0) {
                                    waitTime = this._timeout - (int)(System.currentTimeMillis() - startTime);
                                }
                                if (waitTime >= 0) continue;
                                throw new InterruptedIOException("Timeout waiting for event data");
                            }
                            throw new InterruptedIOException("Not enough data available");
                        }
                        throw new InterruptedIOException("Not enough data available");
                    } while (!bHaveEvent);
                }
            } else {
                throw new APINotInitializedException();
            }
        }
        APIConnection.trace("<- APIConnection.WaitEvent");
        return event;
    }

    public String toString() {
        String s = super.toString() + ";\n" + "SNMPSocket[" + this._snmpSocket.toString() + "];\n" + "connected=" + this._isConnected + ";\n" + "eventMask=" + this._eventMask + ";\n";
        return s;
    }

    static void trace(String str) {
        if (debug) {
            System.out.println(str);
        }
    }

    static void dumpBytes(String str, byte[] buf, int offset, int len) {
        if (debug) {
            System.out.println(str);
            int j = 1;
            int i = offset;
            while (i < offset + len) {
                String s = Integer.toHexString(buf[i]);
                if (s.length() == 1) {
                    s = "0" + s;
                } else if (s.length() > 2) {
                    s = s.substring(s.length() - 2);
                }
                if (j == 1) {
                    System.out.print("     ");
                }
                System.out.print(s + " ");
                if (j == 16) {
                    System.out.println("");
                    j = 0;
                }
                ++i;
                ++j;
            }
            if (j != 0) {
                System.out.println("");
            }
        }
    }

    public static String BuildId(String prefix, String attribute, String group, String object) {
        APIConnection.trace("-> APIConnection.BuildId");
        String oid = "";
        if (prefix != null && prefix.length() > 0) {
            oid = prefix;
        }
        if (attribute != null && attribute.length() > 0) {
            oid = oid + "." + attribute;
        }
        if (group != null && group.length() > 0) {
            oid = oid + "." + APIConnection.getUniqueName(group);
        }
        if (object != null && object.length() > 0) {
            oid = oid + "." + APIConnection.getUniqueName(object);
        }
        APIConnection.trace("<- APIConnection.BuildId");
        return oid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String BuildAttributeId(String oid, String attribute) {
        APIConnection.trace("-> APIConnection.BuildAttributeId");
        String attr = "";
        String[] prefixArray = new String[]{HWMCA_CONSOLE_ID, HWMCA_CFG_CPC_ID, HWMCA_CFG_CPC_GROUP_ID, HWMCA_CPC_IMAGE_ID, HWMCA_CPC_IMAGE_GROUP_ID, HWMCA_GROUPS_OBJECT_ID, HWMCA_GROUPS_GROUP_ID, HWMCA_COMMAND_PREFIX, HWMCA_ACT_RESET_OBJECT_ID, HWMCA_ACT_IMAGE_OBJECT_ID, HWMCA_ACT_LOAD_OBJECT_ID, null};
        if (oid == null || oid.length() <= 0) throw new IllegalArgumentException("Invalid object identifier specified.");
        if (attribute == null || attribute.length() <= 0) throw new IllegalArgumentException("Invalid attribute identifier specified.");
        boolean bFound = false;
        int i = 0;
        while (prefixArray[i] != null && !bFound) {
            if (oid.startsWith(prefixArray[i])) {
                bFound = true;
                attr = prefixArray[i] + "." + attribute + oid.substring(prefixArray[i].length());
            }
            ++i;
        }
        if (!bFound) {
            throw new IllegalArgumentException("Invalid object identifier specified.");
        }
        APIConnection.trace("<- APIConnection.BuildAttributeId");
        return attr;
    }

    private static String getUniqueName(String name) {
        int len;
        int[] tl = new int[16];
        int[] th = new int[16];
        tl[0] = 0;
        tl[8] = 638119352;
        tl[1] = 79764919;
        tl[9] = 583659535;
        tl[2] = 159529838;
        tl[10] = 797628118;
        tl[3] = 222504665;
        tl[11] = 726387553;
        tl[4] = 319059676;
        tl[12] = 890018660;
        tl[5] = 398814059;
        tl[13] = 835552979;
        tl[6] = 445009330;
        tl[14] = 1015980042;
        tl[7] = 507990021;
        tl[15] = 944750013;
        th[0] = 0;
        th[8] = 1762451694;
        th[1] = 1276238704;
        th[9] = 622672798;
        th[2] = -1742489888;
        th[10] = -248556018;
        th[3] = -734892656;
        th[11] = -1119974018;
        th[4] = 881225847;
        th[12] = 1569362073;
        th[5] = 2023205639;
        th[13] = 295390185;
        th[6] = -1398421865;
        th[14] = -978770311;
        th[7] = -525066777;
        th[15] = -1984365303;
        int id = -1;
        byte[] cps = null;
        if (name != null && name.length() > 0) {
            cps = name.getBytes();
            len = cps.length;
        } else {
            len = 0;
        }
        for (int i = 0; i <= len; ++i) {
            byte tmpcps = i == len ? (byte)0 : cps[i];
            byte w = (byte)(tmpcps ^ id >>> 24);
            id = id << 8 & 0xFFFFFF00;
            byte il = (byte)(w & 0xF);
            byte ih = (byte)(w >>> 4 & 0xF);
            id ^= tl[il];
            id ^= th[ih];
        }
        long lid = id;
        lid ^= 0xFFFFFFFFFFFFFFFFL;
        lid <<= 32;
        return Long.toString(lid >>>= 32);
    }
}

