/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.api;

import com.ibm.hwmca.api.APIConnection;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SNMPData
implements Serializable {
    public static final byte TYPE_SEQUENCE = 48;
    public static final byte TYPE_NULL = 5;
    public static final byte TYPE_INTEGER = 2;
    public static final byte TYPE_OCTETSTRING = 4;
    public static final byte TYPE_OBJECTID = 6;
    public static final byte TYPE_IPADDRESS = 64;
    public static final byte TYPE_TIMETICKS = 67;
    private static final int INT_HIBIT = 128;
    private byte[] _asn1 = null;
    private Object _object = null;

    public SNMPData(byte[] asn1Data, int offset) throws IllegalArgumentException {
        APIConnection.trace("-> SNMPData(byte[], int)");
        int[] aLen = new int[2];
        switch (asn1Data[offset]) {
            case 5: {
                if (asn1Data[offset + 1] == 0) {
                    this._asn1 = new byte[2];
                    this._asn1[0] = asn1Data[offset];
                    this._asn1[1] = asn1Data[offset + 1];
                    break;
                }
                throw new IllegalArgumentException("Invalid length for NULL datatype specified.");
            }
            case 2: 
            case 4: 
            case 6: 
            case 64: {
                SNMPData.decodeLength(aLen, asn1Data, offset + 1);
                if (aLen[1] > 0) {
                    this._asn1 = new byte[1 + aLen[0] + aLen[1]];
                    System.arraycopy(asn1Data, offset, this._asn1, 0, this._asn1.length);
                    break;
                }
                throw new IllegalArgumentException("Invalid zero length for non-NULL datatype specified.");
            }
            default: {
                throw new IllegalArgumentException("Invalid type indicator specified.");
            }
        }
        APIConnection.trace("<- SNMPData(byte[], int)");
    }

    public byte[] getBytes() {
        APIConnection.trace("-> SNMPData.getBytes");
        byte[] newBytes = null;
        if (this._asn1 != null) {
            newBytes = new byte[this._asn1.length];
            System.arraycopy(this._asn1, 0, newBytes, 0, newBytes.length);
        }
        APIConnection.trace("<- SNMPData.getBytes");
        return newBytes;
    }

    public int getLength() {
        APIConnection.trace("-> SNMPData.getLength");
        APIConnection.trace("<- SNMPData.getLength");
        return this._asn1.length;
    }

    public byte getType() {
        APIConnection.trace("-> SNMPData.getType");
        APIConnection.trace("<- SNMPData.getType");
        return this._asn1[0];
    }

    public Object toObject() {
        APIConnection.trace("-> SNMPData.toObject");
        if (this._object == null) {
            switch (this._asn1[0]) {
                case 2: {
                    this._object = new Integer(SNMPData.decodeInteger(this._asn1, 0));
                    break;
                }
                case 64: {
                    this._object = SNMPData.decodeInetAddress(this._asn1, 0);
                    break;
                }
                case 4: {
                    this._object = SNMPData.decodeString(this._asn1, 0);
                    break;
                }
                case 6: {
                    this._object = SNMPData.decodeOID(this._asn1, 0);
                    break;
                }
            }
        }
        Object o = this._object;
        APIConnection.trace("<- SNMPData.toObject");
        return o;
    }

    public String toString() {
        APIConnection.trace("-> SNMPData.toString");
        String s = this._asn1[0] == 5 ? "" : this.toObject().toString();
        APIConnection.trace("<- SNMPData.toString");
        return s;
    }

    public String toStringNoNullTerm() {
        APIConnection.trace("-> SNMPData.toStringNoNullTerm");
        byte[] nullterm = new byte[]{0};
        String s = this.toString();
        if (s.endsWith(new String(nullterm))) {
            s = s.substring(0, s.length() - 1);
        }
        APIConnection.trace("<- SNMPData.toStringNoNullTerm");
        return s;
    }

    public static SNMPData fromInteger(int value) {
        byte[] bint = SNMPData.encodeInteger(value);
        SNMPData data = new SNMPData(bint, 0);
        data._object = new Integer(value);
        return data;
    }

    public static SNMPData fromString(String value) {
        byte[] bstr = SNMPData.encodeString(value);
        SNMPData data = new SNMPData(bstr, 0);
        data._object = value;
        return data;
    }

    public static SNMPData fromStringNullTerm(String value) {
        byte[] nullterm = new byte[]{0};
        String tmpstr = value + new String(nullterm);
        byte[] bstr = SNMPData.encodeString(tmpstr);
        SNMPData data = new SNMPData(bstr, 0);
        data._object = value;
        return data;
    }

    public static SNMPData fromObjectID(String value) {
        byte[] boid = SNMPData.encodeOID(value);
        SNMPData data = new SNMPData(boid, 0);
        data._object = value;
        return data;
    }

    public static SNMPData fromInetAddress(InetAddress value) {
        byte[] bip = new byte[6];
        byte[] binet = value.getAddress();
        bip[0] = 64;
        bip[1] = 4;
        bip[2] = binet[0];
        bip[3] = binet[1];
        bip[4] = binet[2];
        bip[5] = binet[3];
        SNMPData data = new SNMPData(bip, 0);
        data._object = value;
        return data;
    }

    public static SNMPData fromNull() {
        byte[] bnull = new byte[]{5, 0};
        return new SNMPData(bnull, 0);
    }

    public static int encodeLength(int inLength, byte[] bout, int offset) {
        APIConnection.trace("-> SNMPData.encodeLength - input length=[" + inLength + "].");
        int lengthLength = 0;
        int outpos = 0;
        if (inLength < 128) {
            if (bout != null) {
                bout[offset + outpos] = (byte)inLength;
            }
            ++lengthLength;
        } else {
            int i;
            byte[] abLength = new byte[4];
            int tmpLength = inLength;
            for (i = 0; i < abLength.length; ++i) {
                abLength[i] = (byte)tmpLength;
                tmpLength >>>= 8;
            }
            lengthLength = abLength.length;
            for (i = abLength.length - 1; i >= 0 && abLength[i] == 0; --i) {
                --lengthLength;
            }
            if (bout != null) {
                bout[offset + outpos] = (byte)(128 + lengthLength);
                ++outpos;
                for (i = lengthLength - 1; i >= 0; --i) {
                    bout[offset + outpos] = abLength[i];
                    ++outpos;
                }
            }
            ++lengthLength;
        }
        if (bout != null) {
            APIConnection.dumpBytes("encoded length =", bout, offset, lengthLength);
        }
        APIConnection.trace("<- SNMPData.encodeLength - output length=[" + lengthLength + "].");
        return lengthLength;
    }

    public static void decodeLength(int[] aLen, byte[] asn1Data, int offset) {
        APIConnection.trace("-> SNMPData.decodeLength");
        aLen[1] = 0;
        aLen[0] = 0;
        if ((byte)(asn1Data[offset] >>> 7) != 0) {
            aLen[0] = asn1Data[offset] & 0x7F;
            for (int i = 1; i <= aLen[0]; ++i) {
                aLen[1] = aLen[1] << 8;
                int tmpData = asn1Data[offset + i] & 0x7F;
                aLen[1] = asn1Data[offset + i] == tmpData ? aLen[1] + tmpData : aLen[1] + (tmpData + 128);
            }
            aLen[0] = aLen[0] + 1;
        } else {
            aLen[0] = 1;
            aLen[1] = asn1Data[offset];
        }
        APIConnection.trace("length of length=[" + aLen[0] + "]; length=[" + aLen[1] + "].");
        APIConnection.trace("<- SNMPData.decodeLength");
    }

    public static byte[] encodeOID(String oid) {
        APIConnection.trace("-> SNMPData.encodeOID");
        int strlen = oid.length();
        char[] choid = null;
        byte[] boid = null;
        if (oid.endsWith(".")) {
            choid = new char[strlen];
            oid.getChars(0, oid.length(), choid, 0);
            --strlen;
        } else {
            choid = new char[strlen + 1];
            oid.getChars(0, oid.length(), choid, 0);
            choid[choid.length - 1] = 46;
        }
        int bpos = 0;
        for (int i = 0; i < 2; ++i) {
            StringBuffer part = new StringBuffer("");
            long a = 0L;
            long b = 0L;
            long c = 0L;
            int blen = 0;
            int pos = 1;
            char[] ach = new char[1];
            for (int j = 0; j < strlen + 1; ++j) {
                ach[0] = choid[j];
                if (choid[j] == '.') {
                    switch (pos) {
                        case 1: {
                            a = Long.parseLong(part.toString());
                            ++pos;
                            break;
                        }
                        case 2: {
                            b = Long.parseLong(part.toString());
                            ++pos;
                            ++blen;
                            if (i != 1) break;
                            boid[bpos] = (byte)(a * 40L + b);
                            ++bpos;
                            break;
                        }
                        default: {
                            a = Long.parseLong(part.toString());
                            b = 1L;
                            while (a / b >= 128L) {
                                b *= 128L;
                            }
                            while (b >= 128L) {
                                c = a / b;
                                if (i == 1) {
                                    boid[bpos] = (byte)(128L + c);
                                    ++bpos;
                                }
                                ++blen;
                                a -= c * b;
                                b /= 128L;
                            }
                            if (i == 1) {
                                boid[bpos] = (byte)a;
                                ++bpos;
                            }
                            ++blen;
                        }
                    }
                    part = new StringBuffer("");
                    continue;
                }
                ach[0] = choid[j];
                part.append(ach);
            }
            if (i != 0) continue;
            int olen = blen;
            blen += SNMPData.encodeLength(olen, null, 0);
            boid = new byte[++blen];
            bpos = 0;
            boid[bpos] = 6;
            ++bpos;
            bpos += SNMPData.encodeLength(olen, boid, bpos);
        }
        APIConnection.dumpBytes("encoded OID =", boid, 0, boid.length);
        APIConnection.trace("<- SNMPData.encodeOID");
        return boid;
    }

    public static String decodeOID(byte[] asn1, int offset) {
        APIConnection.trace("-> SNMPData.decodeOID");
        StringBuffer theoid = new StringBuffer("");
        if (asn1[offset] == 6) {
            int[] aLen = new int[2];
            SNMPData.decodeLength(aLen, asn1, offset + 1);
            theoid.append("1.").append(Byte.toString((byte)(asn1[offset + aLen[0] + 1] - 40)));
            for (int i = offset + aLen[0] + 2; i < offset + aLen[0] + 1 + aLen[1]; ++i) {
                long value = 0L;
                while ((asn1[i] & 0x80) != 0 && i < offset + aLen[0] + 1 + aLen[1]) {
                    value += (long)(asn1[i] & 0x7F);
                    value <<= 7;
                    ++i;
                }
                theoid.append(".").append(Long.toString(value += (long)asn1[i]));
            }
        } else {
            throw new IllegalArgumentException("Invalid datatype; not an object ID.");
        }
        APIConnection.trace("<- SNMPData.decodeOID; OID=[" + theoid + "]");
        return theoid.toString();
    }

    public static byte[] encodeInteger(int value) {
        APIConnection.trace("-> SNMPData.encodeInteger");
        byte[] bint = null;
        byte[] bTmpInt = new byte[4];
        int tmpValue = value;
        for (int i = 0; i < bTmpInt.length; ++i) {
            bTmpInt[i] = (byte)tmpValue;
            tmpValue >>>= 8;
        }
        int intLength = bTmpInt.length;
        for (int i = bTmpInt.length - 1; i > 0 && bTmpInt[i] == 0; --i) {
            --intLength;
        }
        if (value > 0 && (bTmpInt[intLength - 1] & 0x80) != 0) {
            ++intLength;
        }
        int blen = intLength;
        blen += SNMPData.encodeLength(intLength, null, 0);
        bint = new byte[++blen];
        int bpos = 0;
        bint[bpos] = 2;
        ++bpos;
        bpos += SNMPData.encodeLength(intLength, bint, bpos);
        for (int i = intLength - 1; i >= 0; --i) {
            bint[bpos] = bTmpInt[i];
            ++bpos;
        }
        APIConnection.dumpBytes("encoded integer =", bint, 0, bint.length);
        APIConnection.trace("<- SNMPData.encodeInteger");
        return bint;
    }

    public static int decodeInteger(byte[] asn1, int offset) {
        return SNMPData.decodeInteger(asn1, offset, false);
    }

    public static int decodeInteger(byte[] asn1, int offset, boolean withSign) {
        APIConnection.trace("-> SNMPData.decodeInteger");
        int theint = 0;
        if (asn1[offset] == 2) {
            int[] aLen = new int[2];
            SNMPData.decodeLength(aLen, asn1, offset + 1);
            APIConnection.trace("length of length=[" + aLen[0] + "]; length=[" + aLen[1] + "].");
            theint = withSign && aLen[1] > 0 && (asn1[offset + aLen[0] + 1] & 0x80) != 0 ? -1 : 0;
            for (int i = offset + aLen[0] + 1; i < offset + aLen[0] + 1 + aLen[1]; ++i) {
                theint <<= 8;
                if ((asn1[offset] & 0x80) != 0) {
                    theint |= asn1[i] & 0xFF;
                } else {
                    theint += asn1[i] & 0x7F;
                    if ((asn1[i] & 0x80) != 0) {
                        theint += 128;
                    }
                }
                APIConnection.trace("offset=[" + i + "]; byte=[" + asn1[i] + "]; theint=[" + theint + "].");
            }
        } else {
            throw new IllegalArgumentException("Invalid datatype; not an integer.");
        }
        APIConnection.trace("<- SNMPData.decodeInteger; integer=[" + theint + "]");
        return theint;
    }

    public static byte[] encodeString(String value) {
        APIConnection.trace("-> SNMPData.encodeString");
        byte[] bstr = null;
        byte[] binstr = null;
        try {
            binstr = value.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            binstr = value.getBytes();
        }
        int blen = 1;
        blen += SNMPData.encodeLength(binstr.length, null, 0);
        bstr = new byte[blen += binstr.length];
        int bpos = 0;
        bstr[bpos] = 4;
        ++bpos;
        bpos += SNMPData.encodeLength(binstr.length, bstr, bpos);
        System.arraycopy(binstr, 0, bstr, bpos, binstr.length);
        APIConnection.dumpBytes("encoded string=", bstr, 0, bstr.length);
        APIConnection.trace("<- SNMPData.encodeString");
        return bstr;
    }

    public static String decodeString(byte[] asn1, int offset) {
        APIConnection.trace("-> SNMPData.decodeString");
        String s = "";
        if (asn1[offset] == 4) {
            int[] aLen = new int[2];
            SNMPData.decodeLength(aLen, asn1, offset + 1);
            try {
                s = new String(asn1, offset + 1 + aLen[0], aLen[1], "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                s = new String(asn1, offset + 1 + aLen[0], aLen[1]);
            }
        } else {
            throw new IllegalArgumentException("Invalid datatype; not a String.");
        }
        APIConnection.trace("<- SNMPData.decodeString; string=[" + s + "]");
        return s;
    }

    public static byte[] encodeInetAddress(InetAddress value) {
        APIConnection.trace("-> SNMPData.encodeInetAddress");
        byte[] binaddr = value.getAddress();
        byte[] baddr = new byte[2 + binaddr.length];
        baddr[0] = 64;
        baddr[1] = (byte)binaddr.length;
        System.arraycopy(binaddr, 0, baddr, 2, binaddr.length);
        APIConnection.dumpBytes("encoded string=", baddr, 0, baddr.length);
        APIConnection.trace("<- SNMPData.encodeInetAddress");
        return baddr;
    }

    public static InetAddress decodeInetAddress(byte[] asn1, int offset) {
        APIConnection.trace("-> SNMPData.decodeInetAddress");
        InetAddress addr = null;
        if (asn1[offset] == 64) {
            int[] aLen = new int[2];
            SNMPData.decodeLength(aLen, asn1, offset + 1);
            byte[] newasn1 = new byte[1 + aLen[0] + aLen[1]];
            System.arraycopy(asn1, offset, newasn1, 0, newasn1.length);
            newasn1[0] = 2;
            int intaddr = SNMPData.decodeInteger(newasn1, 0);
            String s = "";
            for (int i = 0; i < 4; ++i) {
                s = i == 3 ? Integer.toString(intaddr & 0xFF) + s : "." + Integer.toString(intaddr & 0xFF) + s;
                intaddr >>>= 8;
            }
            try {
                addr = InetAddress.getByName(s);
            }
            catch (UnknownHostException ex) {
                throw new IllegalArgumentException("Invalid data resulted in UnknownHostException.");
            }
        } else {
            throw new IllegalArgumentException("Invalid datatype; not a internet address.");
        }
        APIConnection.trace("<- SNMPData.decodeInetAddress; address=[" + addr + "]");
        return addr;
    }
}

