/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.api;

import com.ibm.hwmca.api.APIConnection;
import com.ibm.hwmca.api.SNMPBadValueException;
import com.ibm.hwmca.api.SNMPData;
import com.ibm.hwmca.api.SNMPEndOfMibViewException;
import com.ibm.hwmca.api.SNMPException;
import com.ibm.hwmca.api.SNMPInconsistentNameException;
import com.ibm.hwmca.api.SNMPInconsistentValueException;
import com.ibm.hwmca.api.SNMPNoSuchInstanceException;
import com.ibm.hwmca.api.SNMPNoSuchNameException;
import com.ibm.hwmca.api.SNMPNoSuchObjectException;
import com.ibm.hwmca.api.SNMPReadOnlyException;
import com.ibm.hwmca.api.SNMPResourceUnavailableException;
import com.ibm.hwmca.api.SNMPTooBigException;
import com.ibm.hwmca.api.SNMPWrongLengthException;
import com.ibm.hwmca.api.SNMPWrongTypeException;
import com.ibm.hwmca.api.SNMPWrongValueException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class SNMPSocket
extends DatagramSocket {
    public static final int SNMP_VERSION1 = 0;
    public static final int SNMP_VERSION2 = 1;
    public static final int AGENT_PORT = 161;
    private static final byte PDU_GET = -96;
    private static final byte PDU_GETN = -95;
    private static final byte PDU_RESP = -94;
    private static final byte PDU_SET = -93;
    public static final byte PDU_TRAP = -92;
    private static final int SNMP_NO_ERROR = 0;
    private InetAddress _addr;
    private int _port = 161;
    private int _requestID = 0;
    private Object _requestIDLock = new Object();
    private String _community = "public";
    private int _version = 0;

    public SNMPSocket() throws SocketException {
        APIConnection.trace("-> SNMPSocket()");
        APIConnection.trace("<- SNMPSocket()");
    }

    public SNMPSocket(int port) throws SocketException {
        super(port);
        APIConnection.trace("-> SNMPSocket(port)");
        APIConnection.trace("<- SNMPSocket(port)");
    }

    public SNMPSocket(int port, InetAddress addr) throws SocketException {
        super(port, addr);
        APIConnection.trace("-> SNMPSocket(port, addr)");
        APIConnection.trace("<- SNMPSocket(port, addr)");
    }

    public SNMPData Get(String oid) throws IOException, SNMPException {
        APIConnection.trace("-> SNMPSocket.Get");
        SNMPData[] data = null;
        if (oid == null || oid.length() <= 0) {
            throw new IllegalArgumentException("Invalid object ID specified.");
        }
        Object[] objects = this.formatRequest((byte)-96, oid, SNMPData.fromNull());
        data = this.sendReceiveRequest(objects);
        APIConnection.trace("<- SNMPSocket.Get");
        return data[1];
    }

    public SNMPData[] GetNext(String oid) throws IOException, SNMPException {
        APIConnection.trace("-> SNMPSocket.GetNext");
        SNMPData[] data = null;
        if (oid == null || oid.length() <= 0) {
            throw new IllegalArgumentException("Invalid object ID specified.");
        }
        Object[] objects = this.formatRequest((byte)-95, oid, SNMPData.fromNull());
        data = this.sendReceiveRequest(objects);
        APIConnection.trace("<- SNMPSocket.GetNext");
        return data;
    }

    public void Set(String oid, SNMPData data) throws IOException, SNMPException {
        APIConnection.trace("-> SNMPSocket.Set");
        if (oid == null || oid.length() <= 0) {
            throw new IllegalArgumentException("Invalid object ID specified.");
        }
        Object[] objects = this.formatRequest((byte)-93, oid, data);
        SNMPData[] dataout = this.sendReceiveRequest(objects);
        APIConnection.trace("<- SNMPSocket.Set");
    }

    public void setAddress(InetAddress addr) {
        this._addr = addr;
    }

    public InetAddress getAddress() {
        return this._addr;
    }

    public void setTargetPort(int port) {
        this._port = port;
    }

    public int getTargetPort() {
        return this._port;
    }

    public void setCommunity(String community) {
        this._community = community;
    }

    public String getCommunity() {
        return this._community;
    }

    public void setVersion(int version) throws IllegalArgumentException {
        switch (version) {
            case 0: 
            case 1: {
                this._version = version;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid SNMP version specified.");
            }
        }
    }

    public int getVersion() {
        return this._version;
    }

    public String toString() {
        String s = super.toString() + ";\n" + "local port=" + this.getLocalPort() + ";\n" + "target port=" + this._port + ";\n" + "version=" + this._version + ";\n" + "community=" + this._community + ";\n";
        s = this._addr == null ? s + "target address=null;\n" : s + "target address=" + this.getAddress().toString() + ";\n";
        return s;
    }

    private synchronized SNMPData[] sendReceiveRequest(Object[] objects) throws IOException, SNMPException {
        APIConnection.trace("-> SNMPSocket.sendReceiveRequest");
        SNMPData[] data = new SNMPData[2];
        int requestID = (Integer)objects[0];
        byte[] packet = (byte[])objects[1];
        DatagramPacket out = new DatagramPacket(packet, packet.length, this._addr, this._port);
        this.send(out);
        int blen = 1024;
        boolean toosmall = true;
        byte[] bin = new byte[blen];
        DatagramPacket in = new DatagramPacket(bin, bin.length);
        boolean keeptrying = true;
        while (true) {
            int[] aLen;
            this.receive(in);
            if (in.getLength() < bin.length) {
                toosmall = false;
            } else {
                APIConnection.trace("SNMP receive buffer too small...");
                if (bin[0] == 48) {
                    aLen = new int[2];
                    SNMPData.decodeLength(aLen, bin, 1);
                    APIConnection.trace("Need a buffer of [" + (1 + aLen[0] + aLen[1]) + "].");
                    blen = 2 + aLen[0] + aLen[1];
                } else {
                    blen += 1024;
                }
                bin = new byte[blen];
                in.setData(bin);
                in.setLength(bin.length);
                APIConnection.trace("SNMP receive buffer being increased to " + blen + ".");
                this.send(out);
            }
            if (toosmall) continue;
            if (this._port == in.getPort()) {
                if (this._addr.equals(in.getAddress())) {
                    APIConnection.dumpBytes("response packet =", bin, 0, in.getLength());
                    aLen = new int[2];
                    int offset = 1;
                    SNMPData.decodeLength(aLen, bin, offset);
                    SNMPData.decodeLength(aLen, bin, offset += aLen[0] + 1);
                    SNMPData.decodeLength(aLen, bin, offset += aLen[0] + aLen[1] + 1);
                    if (bin[offset += aLen[0] + aLen[1]] == -94) {
                        SNMPData.decodeLength(aLen, bin, ++offset);
                        int responseID = SNMPData.decodeInteger(bin, offset += aLen[0], true);
                        SNMPData.decodeLength(aLen, bin, ++offset);
                        if (responseID == requestID) {
                            keeptrying = false;
                            int statusCode = SNMPData.decodeInteger(bin, offset += aLen[0] + aLen[1], true);
                            SNMPData.decodeLength(aLen, bin, ++offset);
                            block0 : switch (statusCode) {
                                case 0: {
                                    SNMPData.decodeLength(aLen, bin, offset += aLen[0] + aLen[1] + 1);
                                    SNMPData.decodeLength(aLen, bin, offset += aLen[0] + aLen[1] + 1);
                                    SNMPData.decodeLength(aLen, bin, offset += aLen[0] + 1);
                                    SNMPData.decodeLength(aLen, bin, offset += aLen[0] + 1);
                                    data[0] = new SNMPData(bin, offset - 1);
                                    switch (bin[offset += aLen[0] + aLen[1]] & 0xFF) {
                                        case 128: {
                                            throw new SNMPNoSuchObjectException("No such object");
                                        }
                                        case 129: {
                                            throw new SNMPNoSuchInstanceException("No such instance");
                                        }
                                        case 130: {
                                            throw new SNMPEndOfMibViewException("End of MIB reached");
                                        }
                                        case 2: 
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 64: {
                                            data[1] = new SNMPData(bin, offset);
                                            break block0;
                                        }
                                    }
                                    throw new SNMPException("Unsupported data type", 5);
                                }
                                case 2: {
                                    throw new SNMPNoSuchNameException("No such name");
                                }
                                case 4: {
                                    throw new SNMPReadOnlyException("Attribute is read only");
                                }
                                case 1: {
                                    throw new SNMPTooBigException("Response data too large");
                                }
                                case 3: {
                                    throw new SNMPBadValueException("Bad data value");
                                }
                                case 10: {
                                    throw new SNMPWrongValueException("Wrong data value");
                                }
                                case 7: {
                                    throw new SNMPWrongTypeException("Wrong data type");
                                }
                                case 8: {
                                    throw new SNMPWrongLengthException("Wrong data length");
                                }
                                case 12: {
                                    throw new SNMPInconsistentValueException("Inconsistent value");
                                }
                                case 18: {
                                    throw new SNMPInconsistentNameException("Inconsistent name");
                                }
                                case 13: {
                                    throw new SNMPResourceUnavailableException("Resource unavailable");
                                }
                                default: {
                                    throw new SNMPException("Unknown SNMP error", bin[offset]);
                                }
                            }
                        }
                    }
                } else {
                    APIConnection.trace("packet received from the address, so try again.");
                }
            } else {
                APIConnection.trace("packet received from the wrong port, so try again.");
            }
            if (!keeptrying) break;
        }
        APIConnection.trace("<- SNMPSocket.sendReceiveRequest");
        return data;
    }

    private Object[] formatRequest(byte pdu, String oid, SNMPData data) {
        APIConnection.trace("-> SNMPSocket.formatRequest");
        Object[] objects = new Object[2];
        byte[] packet = null;
        if (oid.length() != 0) {
            int requestLength = 0;
            requestLength += data.getLength();
            byte[] encodedOID = SNMPData.encodeOID(oid);
            int sequence2Length = requestLength += encodedOID.length;
            int sequence1Length = requestLength += SNMPData.encodeLength(sequence2Length, null, 0) + 1;
            requestLength += SNMPData.encodeLength(sequence1Length, null, 0) + 1;
            byte[] bErrorIndex = SNMPData.encodeInteger(0);
            requestLength += bErrorIndex.length;
            byte[] bRequestStatus = SNMPData.encodeInteger(0);
            requestLength += bRequestStatus.length;
            objects[0] = new Integer(this.getRequestID());
            byte[] bRequestId = SNMPData.encodeInteger((Integer)objects[0]);
            int PDULength = requestLength += bRequestId.length;
            requestLength += SNMPData.encodeLength(PDULength, null, 0) + 1;
            byte[] bCommunity = SNMPData.encodeString(this._community);
            requestLength += bCommunity.length;
            byte[] bVersion = SNMPData.encodeInteger(this._version);
            int mainSequenceLength = requestLength += bVersion.length;
            packet = new byte[requestLength += SNMPData.encodeLength(mainSequenceLength, null, 0) + 1];
            objects[1] = packet;
            int offset = 0;
            packet[offset++] = 48;
            offset += SNMPData.encodeLength(mainSequenceLength, packet, offset);
            System.arraycopy(bVersion, 0, packet, offset, bVersion.length);
            System.arraycopy(bCommunity, 0, packet, offset += bVersion.length, bCommunity.length);
            offset += bCommunity.length;
            packet[offset++] = pdu;
            offset += SNMPData.encodeLength(PDULength, packet, offset);
            System.arraycopy(bRequestId, 0, packet, offset, bRequestId.length);
            System.arraycopy(bRequestStatus, 0, packet, offset += bRequestId.length, bRequestStatus.length);
            System.arraycopy(bErrorIndex, 0, packet, offset += bRequestStatus.length, bErrorIndex.length);
            offset += bErrorIndex.length;
            packet[offset++] = 48;
            offset += SNMPData.encodeLength(sequence1Length, packet, offset);
            packet[offset++] = 48;
            offset += SNMPData.encodeLength(sequence2Length, packet, offset);
            System.arraycopy(encodedOID, 0, packet, offset, encodedOID.length);
            byte[] bData = data.getBytes();
            System.arraycopy(bData, 0, packet, offset += encodedOID.length, bData.length);
            offset += bData.length;
            APIConnection.dumpBytes("packet with request ID=[" + objects[0] + "]=", packet, 0, packet.length);
        }
        APIConnection.trace("<- SNMPSocket.formatRequest");
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRequestID() {
        int retint = 0;
        Object object = this._requestIDLock;
        synchronized (object) {
            retint = this._requestID++;
        }
        return retint;
    }
}

