/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.api;

import com.ibm.hwmca.api.APIConnection;
import com.ibm.hwmca.api.SNMPData;
import com.ibm.hwmca.api.SNMPTrap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;

public class SNMPTrapSender {
    protected static DatagramSocket socket;
    protected static final String DEFAULT_COMMUNITY = "public";
    protected static final long initTime;
    protected static final int SNMP_TRAP_PORT = 162;

    public static void sendTrap(SNMPTrap trap, String addr) throws IOException {
        InetAddress inetAddr = InetAddress.getByName(addr);
        SNMPTrapSender.sendTrap(trap, inetAddr, 162, DEFAULT_COMMUNITY);
    }

    public static void sendTrap(SNMPTrap trap, InetAddress addr) throws IOException {
        SNMPTrapSender.sendTrap(trap, addr, 162, DEFAULT_COMMUNITY);
    }

    public static void sendTrap(SNMPTrap trap, String addr, String community) throws IOException {
        InetAddress inetAddr = InetAddress.getByName(addr);
        SNMPTrapSender.sendTrap(trap, inetAddr, 162, community);
    }

    public static void sendTrap(SNMPTrap trap, String addr, String agentAddr, String community) throws IOException {
        InetAddress inetAddr = InetAddress.getByName(addr);
        InetAddress agentInetAddr = InetAddress.getByName(agentAddr);
        SNMPTrapSender.sendTrap(trap, inetAddr, 162, agentInetAddr, community);
    }

    public static void sendTrap(SNMPTrap trap, InetAddress addr, String community) throws IOException {
        SNMPTrapSender.sendTrap(trap, addr, 162, community);
    }

    public static void sendTrap(SNMPTrap trap, InetAddress addr, InetAddress agentAddr, String community) throws IOException {
        SNMPTrapSender.sendTrap(trap, addr, 162, agentAddr, community);
    }

    public static void sendTrap(SNMPTrap trap, InetAddress addr, int port, String community) throws IOException {
        APIConnection.trace("-> SNMPTrapSender.sendTrap(trap," + addr + "," + port + "," + community + ")");
        byte[] buf = SNMPTrapSender.buildTrapPacket(trap, community);
        DatagramPacket packet = new DatagramPacket(buf, buf.length, addr, port);
        socket.send(packet);
        APIConnection.trace("<- SNMPTrapSender.sendTrap");
    }

    public static void sendTrap(SNMPTrap trap, InetAddress addr, int port, InetAddress agentAddr, String community) throws IOException {
        APIConnection.trace("-> SNMPTrapSender.sendTrap(trap," + addr + "," + port + "," + agentAddr + "," + community + ")");
        byte[] buf = SNMPTrapSender.buildTrapPacket(trap, agentAddr, community);
        DatagramPacket packet = new DatagramPacket(buf, buf.length, addr, port);
        socket.send(packet);
        APIConnection.trace("<- SNMPTrapSender.sendTrap");
    }

    public static void sendTrap(SNMPTrap trap, List list, String community) throws IOException {
        byte[] buf = SNMPTrapSender.buildTrapPacket(trap, community);
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        packet.setPort(162);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            InetAddress addr = null;
            if (o instanceof InetAddress) {
                addr = (InetAddress)o;
            } else if (o instanceof String) {
                addr = InetAddress.getByName((String)o);
            } else {
                throw new IllegalArgumentException("List entry was not a String or InetAddress object");
            }
            packet.setAddress(addr);
            socket.send(packet);
        }
    }

    public static void sendTrap(SNMPTrap trap, List list, InetAddress agentAddr, String community) throws IOException {
        byte[] buf = SNMPTrapSender.buildTrapPacket(trap, agentAddr, community);
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        packet.setPort(162);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            InetAddress addr = null;
            if (o instanceof InetAddress) {
                addr = (InetAddress)o;
            } else if (o instanceof String) {
                addr = InetAddress.getByName((String)o);
            } else {
                throw new IllegalArgumentException("List entry was not a String or InetAddress object");
            }
            packet.setAddress(addr);
            socket.send(packet);
        }
    }

    public static void sendTrapToConfiguredHosts(SNMPTrap trap, String filename, String key) throws IOException {
        SNMPTrapSender.sendTrapToConfiguredHosts(trap, filename, key, DEFAULT_COMMUNITY);
    }

    public static void sendTrapToConfiguredHosts(SNMPTrap trap, String filename, String key, String community) throws IOException {
        APIConnection.trace("-> SNMPTrapSender.sendTrapToConfiguredHosts([" + trap + "], " + key + ", " + community + ")");
        File snmpTrapsFile = new File(filename);
        if (snmpTrapsFile.exists() && snmpTrapsFile.canRead()) {
            APIConnection.trace("SNMPTrapSender.sendTrapToConfiguredHosts: loading traps properties file.");
            FileInputStream fis = new FileInputStream(snmpTrapsFile);
            Properties props = new Properties();
            props.load(fis);
            ArrayList<Object> hosts = new ArrayList<Object>();
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String keyList = (String)entry.getValue();
                if (!keyList.matches(".*" + key + ".*")) continue;
                APIConnection.trace("SNMPTrapSender.sendTrapToConfiguredHosts: found matching key.. adding: " + entry.getKey());
                hosts.add(entry.getKey());
            }
            if (!hosts.isEmpty()) {
                it = hosts.iterator();
                while (it.hasNext()) {
                    String addr = (String)((Object)it.next());
                    SNMPTrapSender.sendTrap(trap, addr, community);
                }
            } else {
                APIConnection.trace("SNMPTrapSender.sendTrapToConfiguredHosts: no hosts configured to receive this trap.");
            }
        } else {
            APIConnection.trace("SNMPTrapSender.sendTrapToConfiguredHosts: Unable to read traps file.");
            throw new IOException("Unable to read trap configuration file.");
        }
        APIConnection.trace("<- SNMPTrapSender.sendTrapToConfiguredHosts");
    }

    public static byte[] buildTrapPacket(SNMPTrap trap, String community) {
        InetAddress localHost;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            APIConnection.trace("caught UnknownHostException from getLocalHost in buildTrapPacket");
            throw new RuntimeException("InetAddress.getLocalHost() threw UnkownHostException");
        }
        return SNMPTrapSender.buildTrapPacket(trap, localHost, community);
    }

    public static byte[] buildTrapPacket(SNMPTrap trap, InetAddress agentAddr, String community) {
        int len;
        byte[] enterpriseBuf = SNMPData.encodeOID(trap.getEnterpriseId());
        byte[] agentAddrBuf = SNMPData.encodeInetAddress(agentAddr);
        byte[] genericBuf = SNMPData.encodeInteger(6);
        byte[] specificBuf = SNMPData.encodeInteger(trap.getCode() & 0xFFFF);
        int timestamp = (int)(System.currentTimeMillis() - initTime) / 10;
        byte[] timestampBuf = SNMPData.encodeInteger(timestamp);
        timestampBuf[0] = 67;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ListIterator it = trap.getVarBinds().listIterator();
        while (it.hasNext()) {
            byte[] valueBuf;
            SNMPTrap.VarBind varBind = (SNMPTrap.VarBind)it.next();
            byte[] oidBuf = SNMPData.encodeOID(varBind.oid);
            switch (varBind.type) {
                case 0: {
                    if (varBind.value == null) {
                        valueBuf = SNMPData.fromNull().getBytes();
                        break;
                    }
                    if (varBind.value instanceof String) {
                        valueBuf = SNMPData.encodeString((String)varBind.value);
                        break;
                    }
                    if (varBind.value instanceof Integer) {
                        valueBuf = SNMPData.encodeInteger((Integer)varBind.value);
                        break;
                    }
                    if (varBind.value instanceof InetAddress) {
                        valueBuf = SNMPData.encodeInetAddress((InetAddress)varBind.value);
                        break;
                    }
                    throw new IllegalArgumentException("VarBind had invalid value type: " + varBind.value.getClass().getName());
                }
                case 5: {
                    valueBuf = SNMPData.fromNull().getBytes();
                    break;
                }
                case 2: {
                    if (varBind.value instanceof Integer) {
                        valueBuf = SNMPData.encodeInteger((Integer)varBind.value);
                        break;
                    }
                    if (varBind.value instanceof String) {
                        valueBuf = SNMPData.encodeInteger(Integer.parseInt((String)varBind.value));
                        break;
                    }
                    throw new IllegalArgumentException("VarBind had invalid value type for integer: " + varBind.value.getClass().getName());
                }
                case 4: {
                    if (varBind.value instanceof String) {
                        valueBuf = SNMPData.encodeString((String)varBind.value);
                        break;
                    }
                    if (varBind.value instanceof byte[]) {
                        valueBuf = SNMPData.encodeString(new String((byte[])varBind.value));
                        break;
                    }
                    throw new IllegalArgumentException("VarBind had invalid value type for octetstring: " + varBind.value.getClass().getName());
                }
                case 6: {
                    if (varBind.value instanceof String) {
                        valueBuf = SNMPData.encodeOID((String)varBind.value);
                        break;
                    }
                    throw new IllegalArgumentException("VarBind had invalid value type for oid: " + varBind.value.getClass().getName());
                }
                case 64: {
                    if (varBind.value instanceof InetAddress) {
                        valueBuf = SNMPData.encodeInetAddress((InetAddress)varBind.value);
                        break;
                    }
                    if (varBind.value instanceof String) {
                        try {
                            valueBuf = SNMPData.encodeInetAddress(InetAddress.getByName((String)varBind.value));
                            break;
                        }
                        catch (UnknownHostException e) {
                            throw new IllegalArgumentException("IP lookup failed for: " + varBind.value);
                        }
                    }
                    throw new IllegalArgumentException("VarBind had invalid value type for ip: " + varBind.value.getClass().getName());
                }
                default: {
                    throw new IllegalArgumentException("VarBind had invalid type: " + varBind.type);
                }
            }
            bout.write(48);
            len = oidBuf.length + valueBuf.length;
            if (len < 127) {
                bout.write(len);
            } else if (len < 255) {
                bout.write(129);
                bout.write(len);
            } else if (len < 65535) {
                bout.write(130);
                bout.write(len >> 8 & 0xFF);
                bout.write(len & 0xFF);
            } else {
                APIConnection.trace("VarBind value too large: " + len);
                throw new IllegalArgumentException("VarBind value too large: " + len);
            }
            bout.write(oidBuf, 0, oidBuf.length);
            bout.write(valueBuf, 0, valueBuf.length);
        }
        byte[] boutBuf = bout.toByteArray();
        int lengthOfLength = SNMPData.encodeLength(boutBuf.length, null, 0);
        byte[] varBindBuf = new byte[1 + lengthOfLength + boutBuf.length];
        varBindBuf[0] = 48;
        SNMPData.encodeLength(boutBuf.length, varBindBuf, 1);
        System.arraycopy(boutBuf, 0, varBindBuf, 1 + lengthOfLength, boutBuf.length);
        len = enterpriseBuf.length + agentAddrBuf.length + genericBuf.length + specificBuf.length + timestampBuf.length + varBindBuf.length;
        lengthOfLength = SNMPData.encodeLength(len, null, 0);
        byte[] trapPduBuf = new byte[1 + lengthOfLength + len];
        trapPduBuf[0] = -92;
        SNMPData.encodeLength(len, trapPduBuf, 1);
        int offset = 1 + lengthOfLength;
        System.arraycopy(enterpriseBuf, 0, trapPduBuf, offset, enterpriseBuf.length);
        System.arraycopy(agentAddrBuf, 0, trapPduBuf, offset += enterpriseBuf.length, agentAddrBuf.length);
        System.arraycopy(genericBuf, 0, trapPduBuf, offset += agentAddrBuf.length, genericBuf.length);
        System.arraycopy(specificBuf, 0, trapPduBuf, offset += genericBuf.length, specificBuf.length);
        System.arraycopy(timestampBuf, 0, trapPduBuf, offset += specificBuf.length, timestampBuf.length);
        System.arraycopy(varBindBuf, 0, trapPduBuf, offset += timestampBuf.length, varBindBuf.length);
        byte[] versionBuf = SNMPData.encodeInteger(0);
        byte[] communityBuf = SNMPData.encodeString(community);
        len = versionBuf.length + communityBuf.length + trapPduBuf.length;
        lengthOfLength = SNMPData.encodeLength(len, null, 0);
        byte[] packet = new byte[1 + lengthOfLength + len];
        packet[0] = 48;
        SNMPData.encodeLength(len, packet, 1);
        offset = 1 + lengthOfLength;
        System.arraycopy(versionBuf, 0, packet, offset, versionBuf.length);
        System.arraycopy(communityBuf, 0, packet, offset += versionBuf.length, communityBuf.length);
        System.arraycopy(trapPduBuf, 0, packet, offset += communityBuf.length, trapPduBuf.length);
        return packet;
    }

    public static void main(String[] args) {
        try {
            SNMPTrap trap = new SNMPTrap("1.3.6.1.4.1.2.6.42.1", 1);
            trap.addVarBind(new SNMPTrap.VarBind("1.3.6.1.4.1.2.6.42.1.1", "Hello"));
            trap.addVarBind(new SNMPTrap.VarBind("1.3.6.1.4.1.2.6.42.1.2", "World!"));
            SNMPTrapSender.sendTrap(trap, "127.0.0.1");
            SNMPTrapSender.sendTrap(trap, "127.0.0.1", "9.60.73.36", DEFAULT_COMMUNITY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        initTime = System.currentTimeMillis();
        try {
            socket = new DatagramSocket();
        }
        catch (SocketException e) {
            StringWriter traceBuffer = new StringWriter();
            e.printStackTrace(new PrintWriter(traceBuffer));
            APIConnection.trace(traceBuffer.toString());
        }
    }
}

