/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.api;

import com.ibm.hwmca.api.APIConnection;
import com.ibm.hwmca.api.APIEvent;
import com.ibm.hwmca.api.SNMPData;

public class TestAPICommands {
    static APIConnection conn = null;
    static String targetOid = "";
    static String cmdOid = "";

    public static void printUsage() {
        System.out.println("Usage: TestAPICommands <host> <community> execCPCCmd <cpc> <cmdId> [arg*]");
        System.out.println("Usage: TestAPICommands <host> <community> execImageCmd <cpc> <image> <cmdId> [arg*]");
        System.out.println("\nAvailable CPC Commands:");
        System.out.println("Activate:       4.1 [profile] [force]");
        System.out.println("Deactivate:     4.2 [force]");
        System.out.println("HW Msg Refresh: 4.11");
        System.out.println("HW Msg Delete:  4.13 <timestamp>");
        System.out.println("Activate CBU:   4.14 <isTest>");
        System.out.println("Undo CBU:       4.15");
        System.out.println("Import Profile: 4.16 <profile>");
        System.out.println("Export Profile: 4.17 <profile>");
        System.out.println("Reserve:        4.18 <request/release> <application>");
        System.out.println("\nAvailable Image Commands:");
        System.out.println("Activate:      4.1 [profile] [force]");
        System.out.println("Deactivate:    4.2 [force]");
        System.out.println("Send OS Cmd:   4.3 <isPriority> <cmd>");
        System.out.println("Reset Normal:  4.4 [force]");
        System.out.println("Start:         4.5");
        System.out.println("Stop:          4.6");
        System.out.println("PSW Restart:   4.7");
        System.out.println("Load:          4.10 [addr] [parm] [clear] [timeout] [store] [force]");
        System.out.println("Reset Clear:   4.12 [force]");
        System.out.println("Ext Interrupt: 4.19 <proc number>");
        System.out.println("SCSI Load:     4.20 [addr] [parm] [port name] [LUN] [boot selector] [os specific parm] [boot record LBA] [force]");
        System.out.println("SCSI Dump:     4.21 [addr] [parm] [port name] [LUN] [boot selector] [os specific parm] [boot record LBA] [force]");
        if (conn != null) {
            try {
                TestAPICommands.debugPrint("Terminating.");
                conn.Terminate();
            }
            catch (Exception e) {
                TestAPICommands.debugPrint(e);
            }
        }
        System.exit(-1);
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            TestAPICommands.printUsage();
        }
        String host = args[0];
        String community = args[1];
        String op = args[2];
        try {
            conn = new APIConnection(community, host);
            conn.setTimeout(180000);
            System.out.println("Initializing...");
            conn.Initialize(0);
            System.out.println("Initialized.");
            if ("execCPCCmd".equals(op)) {
                String cpcName = args[3];
                String cmd = args[4];
                targetOid = APIConnection.BuildId("1.3.6.1.4.1.2.6.42.1.0", null, null, cpcName);
                cmdOid = "1.3.6.1.4.1.2.6.42." + cmd;
                TestAPICommands.debugPrint("targetOid: " + targetOid);
                if ("4.1".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length > 5) {
                        cmdArgs = new SNMPData[args.length - 5];
                        TestAPICommands.debugPrint("Profile arg specified");
                        cmdArgs[0] = SNMPData.fromString(args[5]);
                    }
                    if (args.length > 6) {
                        TestAPICommands.debugPrint("Force arg specified");
                        cmdArgs[1] = SNMPData.fromInteger(Integer.parseInt(args[6]));
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.1", cmdArgs);
                } else if ("4.2".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length == 6) {
                        TestAPICommands.debugPrint("Force specified");
                        cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[5]))};
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.2", cmdArgs);
                } else if ("4.11".equals(cmd)) {
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.11", null);
                } else if ("4.13".equals(cmd)) {
                    if (args.length != 6) {
                        TestAPICommands.printUsage();
                    }
                    SNMPData[] cmdArgs = new SNMPData[]{SNMPData.fromString(args[5])};
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.13", cmdArgs);
                } else if ("4.14".equals(cmd)) {
                    if (args.length != 6) {
                        TestAPICommands.printUsage();
                    }
                    SNMPData[] cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[5]))};
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.14", cmdArgs);
                } else if ("4.15".equals(cmd)) {
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.15", null);
                } else if ("4.16".equals(cmd)) {
                    if (args.length != 6) {
                        TestAPICommands.printUsage();
                    }
                    SNMPData[] cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[5]))};
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.16", cmdArgs);
                } else if ("4.17".equals(cmd)) {
                    if (args.length != 6) {
                        TestAPICommands.printUsage();
                    }
                    SNMPData[] cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[5]))};
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.17", cmdArgs);
                } else if ("4.18".equals(cmd)) {
                    if (args.length != 7) {
                        TestAPICommands.printUsage();
                    }
                    SNMPData[] cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[5])), SNMPData.fromString(args[6])};
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.18", cmdArgs);
                }
            } else if ("execImageCmd".equals(op)) {
                if (args.length < 6) {
                    TestAPICommands.printUsage();
                }
                String imgName = args[3] + "\n" + args[4];
                String cmd = args[5];
                targetOid = APIConnection.BuildId("1.3.6.1.4.1.2.6.42.2.0", null, null, imgName);
                cmdOid = "1.3.6.1.4.1.2.6.42." + cmd;
                TestAPICommands.debugPrint("targetOid: " + targetOid);
                if ("4.1".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length == 7) {
                        TestAPICommands.debugPrint("Profile arg specified");
                        cmdArgs = new SNMPData[]{SNMPData.fromString(args[6])};
                    } else if (args.length == 8) {
                        TestAPICommands.debugPrint("Profile and force args specified");
                        cmdArgs = new SNMPData[]{SNMPData.fromString(args[6]), SNMPData.fromInteger(Integer.parseInt(args[7]))};
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.1", cmdArgs);
                } else if ("4.2".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length == 7) {
                        TestAPICommands.debugPrint("Force specified");
                        cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[6]))};
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.2", cmdArgs);
                } else if ("4.3".equals(cmd)) {
                    if (args.length != 8) {
                        TestAPICommands.printUsage();
                    }
                    SNMPData[] cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[6])), SNMPData.fromString(args[7])};
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.3", cmdArgs);
                } else if ("4.4".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length == 7) {
                        TestAPICommands.debugPrint("Force param specified");
                        cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[6]))};
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.4", cmdArgs);
                } else if ("4.5".equals(cmd)) {
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.5", null);
                } else if ("4.6".equals(cmd)) {
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.6", null);
                } else if ("4.7".equals(cmd)) {
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.7", null);
                } else if ("4.10".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length > 6) {
                        cmdArgs = new SNMPData[args.length - 6];
                        TestAPICommands.debugPrint("Load address specified");
                        cmdArgs[0] = SNMPData.fromString(args[6]);
                    }
                    if (args.length > 7) {
                        TestAPICommands.debugPrint("Load parm specified");
                        cmdArgs[1] = SNMPData.fromString(args[7]);
                    }
                    if (args.length > 8) {
                        TestAPICommands.debugPrint("Clear specified");
                        cmdArgs[2] = SNMPData.fromInteger(Integer.parseInt(args[8]));
                    }
                    if (args.length > 9) {
                        TestAPICommands.debugPrint("Timeout specified");
                        cmdArgs[3] = SNMPData.fromInteger(Integer.parseInt(args[9]));
                    }
                    if (args.length > 10) {
                        TestAPICommands.debugPrint("Store Status specified");
                        cmdArgs[4] = SNMPData.fromInteger(Integer.parseInt(args[10]));
                    }
                    if (args.length > 11) {
                        TestAPICommands.debugPrint("Force specified");
                        cmdArgs[5] = SNMPData.fromInteger(Integer.parseInt(args[11]));
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.10", cmdArgs);
                } else if ("4.12".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length == 7) {
                        TestAPICommands.debugPrint("Force param specified");
                        cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[6]))};
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.12", cmdArgs);
                } else if ("4.19".equals(cmd)) {
                    if (args.length != 7) {
                        TestAPICommands.printUsage();
                    }
                    SNMPData[] cmdArgs = new SNMPData[]{SNMPData.fromInteger(Integer.parseInt(args[6]))};
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.19", cmdArgs);
                } else if ("4.20".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length > 6) {
                        cmdArgs = new SNMPData[args.length - 6];
                        TestAPICommands.debugPrint("Load address specified");
                        cmdArgs[0] = SNMPData.fromString(args[6]);
                    }
                    if (args.length > 7) {
                        TestAPICommands.debugPrint("Load parm specified");
                        cmdArgs[1] = SNMPData.fromString(args[7]);
                    }
                    if (args.length > 8) {
                        TestAPICommands.debugPrint("WW Port specified");
                        cmdArgs[2] = SNMPData.fromString(args[8]);
                    }
                    if (args.length > 9) {
                        TestAPICommands.debugPrint("Logical unit number specified");
                        cmdArgs[3] = SNMPData.fromString(args[9]);
                    }
                    if (args.length > 10) {
                        TestAPICommands.debugPrint("Disk partition id specified");
                        cmdArgs[4] = SNMPData.fromInteger(Integer.parseInt(args[10]));
                    }
                    if (args.length > 11) {
                        TestAPICommands.debugPrint("OS specific parms specified");
                        cmdArgs[5] = SNMPData.fromString(args[11]);
                    }
                    if (args.length > 12) {
                        TestAPICommands.debugPrint("Boot record LBA specified");
                        cmdArgs[6] = SNMPData.fromString(args[12]);
                    }
                    if (args.length > 13) {
                        TestAPICommands.debugPrint("Force specified");
                        cmdArgs[7] = SNMPData.fromInteger(Integer.parseInt(args[13]));
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.20", cmdArgs);
                } else if ("4.21".equals(cmd)) {
                    SNMPData[] cmdArgs = null;
                    if (args.length > 6) {
                        cmdArgs = new SNMPData[args.length - 6];
                        TestAPICommands.debugPrint("Load address specified");
                        cmdArgs[0] = SNMPData.fromString(args[6]);
                    }
                    if (args.length > 7) {
                        TestAPICommands.debugPrint("Load parm specified");
                        cmdArgs[1] = SNMPData.fromString(args[7]);
                    }
                    if (args.length > 8) {
                        TestAPICommands.debugPrint("WW Port specified");
                        cmdArgs[2] = SNMPData.fromString(args[8]);
                    }
                    if (args.length > 9) {
                        TestAPICommands.debugPrint("Logical unit number specified");
                        cmdArgs[3] = SNMPData.fromString(args[9]);
                    }
                    if (args.length > 10) {
                        TestAPICommands.debugPrint("Disk partition id specified");
                        cmdArgs[4] = SNMPData.fromInteger(Integer.parseInt(args[10]));
                    }
                    if (args.length > 11) {
                        TestAPICommands.debugPrint("OS specific parms specified");
                        cmdArgs[5] = SNMPData.fromString(args[11]);
                    }
                    if (args.length > 12) {
                        TestAPICommands.debugPrint("Boot record LBA specified");
                        cmdArgs[6] = SNMPData.fromString(args[12]);
                    }
                    if (args.length > 13) {
                        TestAPICommands.debugPrint("Force specified");
                        cmdArgs[7] = SNMPData.fromInteger(Integer.parseInt(args[13]));
                    }
                    TestAPICommands.startEventThread();
                    conn.Command(targetOid, "1.3.6.1.4.1.2.6.42.4.21", cmdArgs);
                }
            }
        }
        catch (Exception e) {
            TestAPICommands.debugPrint(e);
        }
    }

    public static void startEventThread() {
        TestAPICommands.debugPrint("Starting Event listener in another thread");
        new Thread(){

            public void run() {
                try {
                    SNMPData[] retData;
                    while (true) {
                        APIEvent evt;
                        if ((evt = conn.WaitEvent()).getType() == 0) {
                            retData = evt.getEventData();
                            TestAPICommands.debugPrint("evt.getObjectId(): " + evt.getObjectId());
                            TestAPICommands.debugPrint("retData[3]: " + retData[3].toString());
                            TestAPICommands.debugPrint("targetOid: " + targetOid);
                            TestAPICommands.debugPrint("cmdOid: " + cmdOid);
                            if (evt.getObjectId().startsWith(targetOid) && retData[3].toString().startsWith(cmdOid)) break;
                            TestAPICommands.debugPrint("Command response didn't match our request.. ignoring");
                            continue;
                        }
                        TestAPICommands.debugPrint("Ignoring non-command response event: " + evt.getClass().getName());
                    }
                    System.out.println("RC: " + retData[5]);
                    TestAPICommands.debugPrint("terminating.");
                    conn.Terminate();
                }
                catch (Exception e) {
                    TestAPICommands.debugPrint(e);
                }
            }
        }.start();
    }

    public static void debugPrint(Object e) {
        if (e instanceof Throwable) {
            ((Throwable)e).printStackTrace(System.err);
        } else {
            System.err.println(e);
        }
    }
}

