/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.api;

import com.ibm.hwmca.api.APIConnection;
import com.ibm.hwmca.api.SNMPData;
import com.ibm.hwmca.api.SNMPException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TestAPIObjects {
    public static APIConnection conn = null;
    static final HashMap STATUS_MAP = new HashMap();
    static final HashMap BOOLEAN_MAP = new HashMap();
    static final HashMap MODE_MAP = new HashMap();

    public static void main(String[] args) {
        if (args.length < 3) {
            TestAPIObjects.printUsage();
        }
        String host = args[0];
        String community = args[1];
        String op = args[2];
        try {
            conn = new APIConnection(community, host);
            conn.setTimeout(180000);
            System.out.println("Initializing...");
            conn.Initialize(0);
            System.out.println("Initialized.");
            if ("listImages".equals(op)) {
                TestAPIObjects.listObjects("1.3.6.1.4.1.2.6.42.2", "1.3.6.1.4.1.2.6.42.2.0");
            } else if ("listCPCs".equals(op)) {
                TestAPIObjects.listObjects("1.3.6.1.4.1.2.6.42.1", "1.3.6.1.4.1.2.6.42.1.0");
            } else if ("listGroup".equals(op)) {
                if (args.length < 4) {
                    TestAPIObjects.printUsage();
                }
                TestAPIObjects.listGroup(args[3]);
            } else if ("getConsoleData".equals(op)) {
                String oid = "1.3.6.1.4.1.2.6.42.0" + "." + "1.0";
                TestAPIObjects.printData("Name", oid);
                oid = "1.3.6.1.4.1.2.6.42.0" + "." + "16.0";
                TestAPIObjects.printData("SNA Address", oid);
                oid = "1.3.6.1.4.1.2.6.42.0" + "." + "23.0";
                TestAPIObjects.printData("Group Contents", oid);
            } else if ("getImageData".equals(op)) {
                if (args.length < 5) {
                    TestAPIObjects.printUsage();
                }
                String imgName = args[3] + "\n" + args[4];
                String groupName = null;
                String prefix = "1.3.6.1.4.1.2.6.42.2.0";
                if (args.length == 6) {
                    groupName = args[5];
                    prefix = "1.3.6.1.4.1.2.6.42.3.0";
                }
                TestAPIObjects.getObjectData(prefix, imgName, groupName, true);
            } else if ("getCPCData".equals(op)) {
                if (args.length < 4) {
                    TestAPIObjects.printUsage();
                }
                String groupName = null;
                String prefix = "1.3.6.1.4.1.2.6.42.1.0";
                if (args.length == 5) {
                    groupName = args[4];
                    prefix = "1.3.6.1.4.1.2.6.42.3.0";
                }
                TestAPIObjects.getObjectData(prefix, args[3], groupName, false);
            } else if ("setImageData".equals(op)) {
                if (args.length < 7) {
                    TestAPIObjects.printUsage();
                }
                String imgName = args[3] + "\n" + args[4];
                String attr = args[5];
                String value = args[6];
                TestAPIObjects.setObjectData("1.3.6.1.4.1.2.6.42.2.0", imgName, attr, value);
            } else if ("setCPCData".equals(op)) {
                if (args.length < 6) {
                    TestAPIObjects.printUsage();
                }
                String cpcName = args[3];
                String attr = args[4];
                String value = args[5];
                TestAPIObjects.setObjectData("1.3.6.1.4.1.2.6.42.1.0", cpcName, attr, value);
            } else {
                TestAPIObjects.printUsage();
            }
            TestAPIObjects.debugPrint("Terminating.");
            conn.Terminate();
        }
        catch (Exception e) {
            TestAPIObjects.debugPrint(e);
        }
    }

    public static void printUsage() {
        System.out.println("Usage: TestAPIObjects <host> <community> listImages");
        System.out.println("Usage: TestAPIObjects <host> <community> listCPCs");
        System.out.println("Usage: TestAPIObjects <host> <community> listGroup <group>");
        System.out.println("Usage: TestAPIObjects <host> <community> getConsoleData");
        System.out.println("Usage: TestAPIObjects <host> <community> getImageData <cpc> <image> [group]");
        System.out.println("Usage: TestAPIObjects <host> <community> getCPCData <cpc> [group]");
        System.out.println("Usage: TestAPIObjects <host> <community> setImageData <cpc> <image> <attr> <value>");
        System.out.println("Usage: TestAPIObjects <host> <community> setCPCData <cpc> <attr> <value>");
        System.out.println("\nSettable attributes for Images:");
        System.out.println("\tAcceptable Status:   11.0");
        System.out.println("\tActivation Profile:  13.0");
        System.out.println("\tInitial Proc Weight: 30.0");
        System.out.println("\tWeight Capped:       31.0");
        System.out.println("\tMin Proc Weight:     38.0");
        System.out.println("\tMax Proc Weight:     39.0");
        System.out.println("\tWLM Enabled:         40.0");
        System.out.println("\tDefined Capacity:    43.0");
        System.out.println("\nSettable attributes for CPCs:");
        System.out.println("\tAcceptable Status:   11.0");
        System.out.println("\tActivation Profile:  13.0");
        if (conn != null) {
            TestAPIObjects.debugPrint("Terminating.");
            try {
                conn.Terminate();
            }
            catch (Exception e) {
                TestAPIObjects.debugPrint(e);
            }
        }
        System.exit(-1);
    }

    public static void printData(SNMPData data) {
        System.out.println(data.toString());
    }

    public static void printIntData(String label, String oid, Map mappings) {
        try {
            TestAPIObjects.debugPrint("getting oid: " + oid);
            SNMPData retData = conn.Get(oid);
            System.out.print(label + ": ");
            if (retData.getType() == 2) {
                System.out.println(mappings.get(retData.toObject()));
            } else {
                System.out.println("ERROR: expected integer type.. got type " + retData.getType());
            }
        }
        catch (Exception e) {
            TestAPIObjects.debugPrint(e);
        }
    }

    public static void printData(String label, String oid) {
        try {
            TestAPIObjects.debugPrint("getting oid: " + oid);
            SNMPData retData = conn.Get(oid);
            System.out.print(label + ": ");
            if (retData.getType() == 5) {
                System.out.println("null");
            } else {
                System.out.println(retData);
            }
        }
        catch (Exception e) {
            TestAPIObjects.debugPrint(e);
        }
    }

    public static void setIntData(String value, String oid) throws IOException, SNMPException {
        try {
            SNMPData setData = SNMPData.fromInteger(Integer.parseInt(value));
            conn.Set(oid, setData);
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid value for expected status: " + value);
            TestAPIObjects.debugPrint(e);
        }
    }

    public static void listObjects(String groupId, String prefix) throws IOException, SNMPException {
        String oid = APIConnection.BuildId(groupId, "23.0", null, null);
        TestAPIObjects.debugPrint("getting oid: " + oid);
        SNMPData retData = conn.Get(oid);
        if (retData.getType() == 4) {
            TestAPIObjects.debugPrint("got value: " + retData);
            String[] fullOids = ((String)retData.toObject()).split(" ");
            for (int i = 0; i < fullOids.length; ++i) {
                String fullOid = fullOids[i];
                if (fullOid.endsWith("\u0000")) {
                    fullOid = fullOid.substring(0, fullOid.length() - 1);
                }
                String objId = fullOid.substring(fullOid.lastIndexOf(".") + 1);
                TestAPIObjects.debugPrint("objId is " + objId);
                oid = prefix + "." + "1.0" + "." + objId;
                TestAPIObjects.debugPrint("getting name of object: " + oid);
                retData = conn.Get(oid);
                System.out.println(i + 1 + ". " + retData);
            }
        } else {
            TestAPIObjects.debugPrint("Invalid return from Get: " + retData);
        }
    }

    public static void listGroup(String groupName) throws IOException, SNMPException {
        String groupId = APIConnection.BuildId(null, null, null, groupName).substring(1);
        String oid = "1.3.6.1.4.1.2.6.42.3.23.0." + groupId;
        TestAPIObjects.debugPrint("getting oid: " + oid);
        SNMPData retData = conn.Get(oid);
        if (retData.getType() == 4) {
            TestAPIObjects.debugPrint("got value: " + retData);
            String[] fullOids = ((String)retData.toObject()).split(" ");
            for (int i = 0; i < fullOids.length; ++i) {
                String fullOid = fullOids[i];
                if (fullOid.endsWith("\u0000")) {
                    fullOid = fullOid.substring(0, fullOid.length() - 1);
                }
                String objId = fullOid.substring(fullOid.lastIndexOf(".") + 1);
                TestAPIObjects.debugPrint("objId is " + objId);
                oid = "1.3.6.1.4.1.2.6.42.3.0.1.0." + groupId + "." + objId;
                TestAPIObjects.debugPrint("getting name of object: " + oid);
                retData = conn.Get(oid);
                System.out.println(i + 1 + ". " + retData);
            }
        } else {
            TestAPIObjects.debugPrint("Invalid return from Get: " + retData);
        }
    }

    public static void getObjectData(String prefix, String name, String groupName, boolean images) {
        String oid = APIConnection.BuildId(prefix, "1.0", groupName, name);
        TestAPIObjects.printData("Name", oid);
        oid = APIConnection.BuildId(prefix, "10.0", groupName, name);
        TestAPIObjects.printIntData("Status", oid, STATUS_MAP);
        oid = APIConnection.BuildId(prefix, "7.0", groupName, name);
        TestAPIObjects.printIntData("Status Error", oid, BOOLEAN_MAP);
        oid = APIConnection.BuildId(prefix, "11.0", groupName, name);
        TestAPIObjects.printData("Acceptable Status", oid);
        oid = APIConnection.BuildId(prefix, "8.0", groupName, name);
        TestAPIObjects.printIntData("Busy", oid, BOOLEAN_MAP);
        oid = APIConnection.BuildId(prefix, "9.0", groupName, name);
        TestAPIObjects.printIntData("Message Indicator", oid, BOOLEAN_MAP);
        oid = APIConnection.BuildId(prefix, "12.0", groupName, name);
        TestAPIObjects.printIntData("IML Mode", oid, MODE_MAP);
        oid = APIConnection.BuildId(prefix, "13.0", groupName, name);
        TestAPIObjects.printData("Act Profile", oid);
        oid = APIConnection.BuildId(prefix, "14.0", groupName, name);
        TestAPIObjects.printData("Last Act Profile", oid);
        if (images) {
            oid = APIConnection.BuildId(prefix, "2.0", groupName, name);
            TestAPIObjects.printData("Parent Name", oid);
            oid = APIConnection.BuildId(prefix, "3.0", groupName, name);
            TestAPIObjects.printData("OS Name", oid);
            oid = APIConnection.BuildId(prefix, "4.0", groupName, name);
            TestAPIObjects.printData("OS Type", oid);
            oid = APIConnection.BuildId(prefix, "5.0", groupName, name);
            TestAPIObjects.printData("OS Level", oid);
            oid = APIConnection.BuildId(prefix, "6.0", groupName, name);
            TestAPIObjects.printData("Sysplex", oid);
            oid = APIConnection.BuildId(prefix, "30.0", groupName, name);
            TestAPIObjects.printData("Init Proc Weight", oid);
            oid = APIConnection.BuildId(prefix, "31.0", groupName, name);
            TestAPIObjects.printIntData("Init Capped", oid, BOOLEAN_MAP);
            oid = APIConnection.BuildId(prefix, "38.0", groupName, name);
            TestAPIObjects.printData("Min Weight", oid);
            oid = APIConnection.BuildId(prefix, "39.0", groupName, name);
            TestAPIObjects.printData("Max Weight", oid);
            oid = APIConnection.BuildId(prefix, "41.0", groupName, name);
            TestAPIObjects.printData("Curr Weight", oid);
            oid = APIConnection.BuildId(prefix, "42.0", groupName, name);
            TestAPIObjects.printIntData("Curr Capped", oid, BOOLEAN_MAP);
            oid = APIConnection.BuildId(prefix, "40.0", groupName, name);
            TestAPIObjects.printIntData("WLM Enabled", oid, BOOLEAN_MAP);
            oid = APIConnection.BuildId(prefix, "43.0", groupName, name);
            TestAPIObjects.printData("Defined Capacity", oid);
            oid = APIConnection.BuildId(prefix, "49.0", groupName, name);
            TestAPIObjects.printData("Cluster Name", oid);
            oid = APIConnection.BuildId(prefix, "51.0", groupName, name);
            TestAPIObjects.printData("Partition ID", oid);
        } else {
            oid = APIConnection.BuildId(prefix, "15.0", groupName, name);
            TestAPIObjects.printData("IP Address", oid);
            oid = APIConnection.BuildId(prefix, "16.0", groupName, name);
            TestAPIObjects.printData("SNA Address", oid);
            oid = APIConnection.BuildId(prefix, "18.0", groupName, name);
            TestAPIObjects.printData("Machine Type", oid);
            oid = APIConnection.BuildId(prefix, "17.0", groupName, name);
            TestAPIObjects.printData("Machine Model", oid);
            oid = APIConnection.BuildId(prefix, "19.0", groupName, name);
            TestAPIObjects.printData("Machine Serial", oid);
            oid = APIConnection.BuildId(prefix, "20.0", groupName, name);
            TestAPIObjects.printData("CPC Serial", oid);
            oid = APIConnection.BuildId(prefix, "21.0", groupName, name);
            TestAPIObjects.printData("CPC Identifier", oid);
            oid = APIConnection.BuildId(prefix, "32.0", groupName, name);
            TestAPIObjects.printIntData("CBU Installed", oid, BOOLEAN_MAP);
            oid = APIConnection.BuildId(prefix, "33.0", groupName, name);
            TestAPIObjects.printIntData("CBU Activated", oid, BOOLEAN_MAP);
            oid = APIConnection.BuildId(prefix, "34.0", groupName, name);
            TestAPIObjects.printData("CBU Activation Date", oid);
            oid = APIConnection.BuildId(prefix, "35.0", groupName, name);
            TestAPIObjects.printData("CBU Expiration Date", oid);
            oid = APIConnection.BuildId(prefix, "36.0", groupName, name);
            TestAPIObjects.printData("CBU Tests Left", oid);
            oid = APIConnection.BuildId(prefix, "37.0", groupName, name);
            TestAPIObjects.printIntData("Real CBU Available", oid, BOOLEAN_MAP);
            oid = APIConnection.BuildId(prefix, "44.0", groupName, name);
            TestAPIObjects.printData("Reserve Id", oid);
            oid = APIConnection.BuildId(prefix, "46.0", groupName, name);
            TestAPIObjects.printIntData("Service Required", oid, BOOLEAN_MAP);
            oid = APIConnection.BuildId(prefix, "47.0", groupName, name);
            TestAPIObjects.printData("Degraded", oid);
            oid = APIConnection.BuildId(prefix, "48.0", groupName, name);
            TestAPIObjects.printIntData("CBU Enabled", oid, BOOLEAN_MAP);
            oid = APIConnection.BuildId(prefix, "50.0", groupName, name);
            TestAPIObjects.printData("Cluster List", oid);
        }
    }

    public static void setObjectData(String prefix, String name, String attr, String value) throws IOException, SNMPException {
        String oid = APIConnection.BuildId(prefix, attr, null, name);
        TestAPIObjects.debugPrint("set oid: " + oid);
        if ("11.0".equals(attr)) {
            TestAPIObjects.setIntData(value, oid);
        } else if ("13.0".equals(attr)) {
            SNMPData setData = SNMPData.fromString(value);
            conn.Set(oid, setData);
        } else if ("1.3.6.1.4.1.2.6.42.2.0".equals(prefix)) {
            if ("30.0".equals(attr)) {
                TestAPIObjects.setIntData(value, oid);
            } else if ("31.0".equals(attr)) {
                TestAPIObjects.setIntData(value, oid);
            } else if ("38.0".equals(attr)) {
                TestAPIObjects.setIntData(value, oid);
            } else if ("39.0".equals(attr)) {
                TestAPIObjects.setIntData(value, oid);
            } else if ("40.0".equals(attr)) {
                TestAPIObjects.setIntData(value, oid);
            } else if ("43.0".equals(attr)) {
                TestAPIObjects.setIntData(value, oid);
            } else {
                System.out.println("Attribute " + attr + " is not settable");
            }
        } else {
            System.out.println("Attribute " + attr + " is not settable");
        }
    }

    public static void debugPrint(Object o) {
        if (o instanceof Throwable) {
            ((Throwable)o).printStackTrace(System.err);
        } else {
            System.err.println(o);
        }
    }

    static {
        STATUS_MAP.put(new Integer(1), "Operating");
        STATUS_MAP.put(new Integer(2), "Not Operating");
        STATUS_MAP.put(new Integer(4), "No Power");
        STATUS_MAP.put(new Integer(8), "Not Activated");
        STATUS_MAP.put(new Integer(16), "Exceptions");
        STATUS_MAP.put(new Integer(32), "Status Check");
        STATUS_MAP.put(new Integer(64), "Service");
        STATUS_MAP.put(new Integer(128), "Link Not Active");
        STATUS_MAP.put(new Integer(256), "Powersave");
        STATUS_MAP.put(new Integer(512), "Serious Alert");
        STATUS_MAP.put(new Integer(1024), "Alert");
        STATUS_MAP.put(new Integer(2048), "Environmental Alert");
        STATUS_MAP.put(new Integer(4096), "Service Required");
        STATUS_MAP.put(new Integer(8192), "Degraded");
        MODE_MAP.put(new Integer(0), "Not Set");
        MODE_MAP.put(new Integer(1), "ESA/390");
        MODE_MAP.put(new Integer(2), "S/370");
        MODE_MAP.put(new Integer(6), "FM");
        MODE_MAP.put(new Integer(7), "FMAE");
        MODE_MAP.put(new Integer(8), "HM");
        MODE_MAP.put(new Integer(9), "HMEA");
        MODE_MAP.put(new Integer(10), "HMEX");
        MODE_MAP.put(new Integer(11), "LPAR");
        MODE_MAP.put(new Integer(12), "ESA/390 TPF");
        MODE_MAP.put(new Integer(13), "CF");
        MODE_MAP.put(new Integer(14), "FMEX");
        MODE_MAP.put(new Integer(15), "HMAS");
        MODE_MAP.put(new Integer(16), "Linux/390");
        BOOLEAN_MAP.put(new Integer(0), "False");
        BOOLEAN_MAP.put(new Integer(1), "True");
    }
}

