/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.api;

import com.ibm.hwmca.api.APIConnection;
import com.ibm.hwmca.api.SNMPData;

public class TestAPIProfiles {
    public static APIConnection conn = null;

    public static void printUsage() {
        System.out.println("Usage: TestAPIProfiles <host> <community> listImageProfiles <cpc>");
        System.out.println("Usage: TestAPIProfiles <host> <community> listResetProfiles <cpc>");
        System.out.println("Usage: TestAPIProfiles <host> <community> listLoadProfiles <cpc>");
        System.out.println("Usage: TestAPIProfiles <host> <community> getImageProfileData <cpc> <profile name>");
        System.out.println("Usage: TestAPIProfiles <host> <community> getResetProfileData <cpc> <profile name>");
        System.out.println("Usage: TestAPIProfiles <host> <community> getLoadProfileData <cpc> <profile name>");
        if (conn != null) {
            try {
                conn.Terminate();
            }
            catch (Exception e) {
                TestAPIProfiles.debugPrint(e);
            }
        }
        System.exit(-1);
    }

    public static void printData(SNMPData data) {
        System.out.println(data.toString());
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            TestAPIProfiles.printUsage();
        }
        String host = args[0];
        String community = args[1];
        String op = args[2];
        try {
            conn = new APIConnection(community, host);
            conn.setTimeout(180000);
            System.out.println("Initializing...");
            conn.Initialize(0);
            System.out.println("Initialized.");
            if ("listImageProfiles".equals(op)) {
                TestAPIProfiles.listProfiles("1.3.6.1.4.1.2.6.42.6.0", "25.0", args[3]);
            } else if ("listResetProfiles".equals(op)) {
                TestAPIProfiles.listProfiles("1.3.6.1.4.1.2.6.42.5.0", "24.0", args[3]);
            } else if ("listLoadProfiles".equals(op)) {
                TestAPIProfiles.listProfiles("1.3.6.1.4.1.2.6.42.7.0", "26.0", args[3]);
            } else {
                if (args.length < 5) {
                    TestAPIProfiles.printUsage();
                }
                if ("getImageProfileData".equals(op)) {
                    TestAPIProfiles.getProfileData("1.3.6.1.4.1.2.6.42.6.0", args[3], args[4]);
                } else if ("getResetProfileData".equals(op)) {
                    TestAPIProfiles.getProfileData("1.3.6.1.4.1.2.6.42.5.0", args[3], args[4]);
                } else if ("getLoadProfileData".equals(op)) {
                    TestAPIProfiles.getProfileData("1.3.6.1.4.1.2.6.42.7.0", args[3], args[4]);
                } else {
                    TestAPIProfiles.printUsage();
                }
            }
            TestAPIProfiles.debugPrint("Terminating.");
            conn.Terminate();
        }
        catch (Exception e) {
            TestAPIProfiles.debugPrint(e);
        }
    }

    public static void printData(String label, String oid) {
        try {
            TestAPIProfiles.debugPrint("getting oid: " + oid);
            SNMPData retData = conn.Get(oid);
            System.out.print(label + ": ");
            if (retData.getType() == 5) {
                System.out.println("null");
            } else {
                System.out.println(retData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getProfileData(String prefix, String cpcName, String profileName) throws Exception {
        System.out.println("Profile Data for " + cpcName + " : " + profileName);
        String oid = APIConnection.BuildId(prefix, "1.0", cpcName, profileName);
        TestAPIProfiles.printData("Name", oid);
        if (prefix.equals("1.3.6.1.4.1.2.6.42.5.0")) {
            oid = APIConnection.BuildId(prefix, "27.0", cpcName, profileName);
            TestAPIProfiles.printData("IOCDS", oid);
        } else {
            oid = APIConnection.BuildId(prefix, "28.0", cpcName, profileName);
            TestAPIProfiles.printData("Load Address", oid);
            oid = APIConnection.BuildId(prefix, "29.0", cpcName, profileName);
            TestAPIProfiles.printData("Load Parameter", oid);
            if (prefix.equals("1.3.6.1.4.1.2.6.42.6.0")) {
                oid = APIConnection.BuildId(prefix, "30.0", cpcName, profileName);
                TestAPIProfiles.printData("Initial Proc Weight", oid);
                oid = APIConnection.BuildId(prefix, "31.0", cpcName, profileName);
                TestAPIProfiles.printData("Weight Capped", oid);
                oid = APIConnection.BuildId(prefix, "38.0", cpcName, profileName);
                TestAPIProfiles.printData("Min Weight", oid);
                oid = APIConnection.BuildId(prefix, "39.0", cpcName, profileName);
                TestAPIProfiles.printData("Max Weight", oid);
                oid = APIConnection.BuildId(prefix, "40.0", cpcName, profileName);
                TestAPIProfiles.printData("WLM Enabled", oid);
                oid = APIConnection.BuildId(prefix, "43.0", cpcName, profileName);
                TestAPIProfiles.printData("Defined Capacity", oid);
            }
        }
    }

    public static void listProfiles(String prefix, String cpcAttr, String cpcName) throws Exception {
        String oid = APIConnection.BuildId("1.3.6.1.4.1.2.6.42.1.0", cpcAttr, null, cpcName);
        TestAPIProfiles.debugPrint("getting oid: " + oid);
        SNMPData retData = conn.Get(oid);
        if (retData.getType() == 4) {
            TestAPIProfiles.debugPrint("got value: " + retData);
            String[] fullOids = ((String)retData.toObject()).split(" ");
            for (int i = 0; i < fullOids.length; ++i) {
                String fullOid = fullOids[i];
                if (fullOid.endsWith("\u0000")) {
                    fullOid = fullOid.substring(0, fullOid.length() - 1);
                }
                String profileId = fullOid.substring(fullOid.lastIndexOf(".") + 1);
                String subId = fullOid.substring(0, fullOid.lastIndexOf("."));
                String cpcId = subId.substring(subId.lastIndexOf(".") + 1);
                TestAPIProfiles.debugPrint("profileId is " + profileId);
                TestAPIProfiles.debugPrint("cpcId is " + cpcId);
                oid = prefix + "." + "1.0" + "." + cpcId + "." + profileId;
                TestAPIProfiles.debugPrint("getting name of profile: " + oid);
                retData = conn.Get(oid);
                System.out.println(i + 1 + ". " + retData);
            }
        } else {
            TestAPIProfiles.debugPrint("Invalid return from Get: " + retData);
        }
    }

    public static void debugPrint(Object o) {
        if (o instanceof Throwable) {
            ((Throwable)o).printStackTrace(System.err);
        } else {
            System.err.println(o);
        }
    }
}

