/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.PreloadFile;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.jar.Manifest;

public class ExtClassLoader
extends URLClassLoader
implements WsClassLoader {
    protected ArrayList containedPaths = new ArrayList();
    String classpath = null;
    private PreloadFile preloadFile = new PreloadFile(this);
    private boolean accumulatingPreloadCodeSources = true;
    private boolean accumulatingPreloadClasses = false;

    public ExtClassLoader(String string) {
        this(string, Thread.currentThread().getContextClassLoader());
    }

    public ExtClassLoader(ClassLoader classLoader) {
        this((String)null, classLoader);
    }

    public ExtClassLoader(String string, ClassLoader classLoader) {
        super(new URL[0], classLoader);
        if (string != null) {
            this.addPath(string);
        }
        this.removeJVMClassLoaderPath();
        this.accumulatingPreloadCodeSources = false;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class<?> clazz = super.findClass(string);
        if (WSLauncher.debug) {
            WSLauncher.out.println("[Loaded " + string + "]");
        }
        if (this.accumulatingPreloadClasses) {
            this.preloadFile.recordClassLoad(string);
        }
        return clazz;
    }

    protected String findLibrary(String string) {
        final String string2 = System.mapLibraryName(string);
        if (WSLauncher.debug) {
            WSLauncher.out.println("looking for library: " + string2);
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    int n = ExtClassLoader.this.containedPaths.size();
                    for (int i = 0; i < n; ++i) {
                        File file;
                        URL uRL = (URL)ExtClassLoader.this.containedPaths.get(i);
                        File file2 = new File(uRL.getFile());
                        if (!file2.isDirectory() || !(file = new File(file2, string2)).exists()) continue;
                        if (WSLauncher.debug) {
                            WSLauncher.out.println("library found: " + file.getPath());
                        }
                        return file.getPath();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public void addPath(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                Object[] objectArray;
                File file = new File(stringTokenizer.nextToken());
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.addURL(file.toURL());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!file.isDirectory() || (objectArray = file.list()) == null) continue;
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = ((String)objectArray[i]).toLowerCase();
                    if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
                    File file2 = new File(file, (String)objectArray[i]);
                    try {
                        this.addURL(file2.toURL());
                        if (!this.accumulatingPreloadCodeSources) continue;
                        this.preloadFile.addLiveCodeSourceInfo(file2.toURL().toExternalForm());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void addURL(URL uRL) {
        if (!this.containedPaths.contains(uRL)) {
            this.containedPaths.add(uRL);
            super.addURL(uRL);
            this.classpath = null;
        }
    }

    public String getClassPath() {
        if (this.classpath == null) {
            StringBuffer stringBuffer = new StringBuffer();
            URL[] uRLArray = super.getURLs();
            for (int i = 0; i < uRLArray.length; ++i) {
                try {
                    File file = new File(uRLArray[i].getFile());
                    stringBuffer.append(file.getCanonicalPath());
                    stringBuffer.append(File.pathSeparator);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuffer.append(System.getProperty("java.class.path"));
            this.classpath = stringBuffer.toString();
        }
        return this.classpath;
    }

    public URL[] getURLs() {
        return null;
    }

    public URL[] _getURLs() {
        return super.getURLs();
    }

    public void enablePreloadRecording(String string) {
        this.preloadFile.setPreloadPath(string);
        this.accumulatingPreloadClasses = true;
    }

    public void disablePreloadRecording() {
        if (this.accumulatingPreloadClasses) {
            this.accumulatingPreloadClasses = false;
            try {
                this.preloadFile.rollUpChanges();
            }
            catch (Exception exception) {
                exception.printStackTrace(WSLauncher.out);
            }
        }
    }

    public void preloadClasses() {
        int n = 0;
        String string = null;
        try {
            this.preloadFile.lock();
        }
        catch (Exception exception) {
            WSLauncher.out.println("Exception trying to lock preload file.  Don't preload");
            exception.printStackTrace(WSLauncher.out);
            return;
        }
        if (this.preloadFile.checkCRC()) {
            while ((string = this.preloadFile.getNextPreloadClass()) != null) {
                if (this.findLoadedClass(string) != null) continue;
                try {
                    byte[] byArray;
                    int n2 = string.lastIndexOf(46);
                    if (n2 == -1 || (byArray = this.preloadFile.getByteCodes(string)) == null) continue;
                    String string2 = string.substring(0, n2);
                    Package package_ = this.getPackage(string2);
                    CodeSource codeSource = this.preloadFile.getCurrentCodeSource();
                    if (package_ == null) {
                        Manifest manifest = this.preloadFile.getCurrentManifest();
                        if (manifest != null) {
                            this.definePackage(string2, manifest, codeSource.getLocation());
                        } else {
                            this.definePackage(string2, null, null, null, null, null, null, null);
                        }
                    }
                    this.defineClass(string, byArray, 0, byArray.length, codeSource);
                    ++n;
                }
                catch (Throwable throwable) {
                    this.preloadFile.recordFailedClassLoad(string);
                }
            }
        }
        this.preloadFile.unlock();
        WSLauncher.debug("Number of preloaded classes was " + n);
    }

    private void processPreloadPath(String string, boolean bl) {
        block9: {
            File file;
            block8: {
                if (string == null) {
                    return;
                }
                file = new File(string);
                if (!file.isDirectory()) break block8;
                String[] stringArray = file.list();
                if (stringArray == null) break block9;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].toLowerCase();
                    if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
                    File file2 = new File(file, stringArray[i]);
                    if (!this.accumulatingPreloadCodeSources) continue;
                    try {
                        if (bl) {
                            this.preloadFile.addLiveCodeSourceInfo(file2.toURL().toExternalForm());
                            continue;
                        }
                        this.preloadFile.removeLiveCodeSourceInfo(file2.toURL().toExternalForm());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                break block9;
            }
            if (!file.exists()) break block9;
            try {
                if (bl) {
                    this.preloadFile.addLiveCodeSourceInfo(file.toURL().toExternalForm());
                }
                this.preloadFile.removeLiveCodeSourceInfo(file.toURL().toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void removeJVMClassLoaderPath() {
        String string = System.getProperty("java.class.path");
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            for (int i = stringArray.length - 1; i >= 0; --i) {
                this.processPreloadPath(stringArray[i], false);
            }
        }
    }
}

