/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.PathChecksum;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.security.util.AccessController;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class PreloadFile {
    private static final byte CODESOURCE = 0;
    private static final byte CLASSDATA = 1;
    private static int LIVE_CODESOURCE_MAP_SIZE = 300;
    private Map liveCodeSourceInfo = new HashMap(LIVE_CODESOURCE_MAP_SIZE);
    private static final CodeSourceInfo EMPTY_CODE_SOURCE = new CodeSourceInfo("");
    private CodeSourceInfo lastRecordedCodeSource = EMPTY_CODE_SOURCE;
    private CodeSourceInfo lastCodeSourceRead = EMPTY_CODE_SOURCE;
    private boolean lastCodeSourceReadIsValid = false;
    private String preloadPath = null;
    private File preloadFile = null;
    private FileInputStream fileInputStream = null;
    private FileChannel fileChannel = null;
    private FileLock fl = null;
    private DataInputStream inputStream = null;
    private DataOutputStream outputStream = null;
    private String outputStreamPath = null;
    private long preloadFileCRC = -1L;
    private long checkPathCRC = -1L;
    private boolean clearFileOnWrite = false;
    private boolean modificationsHaveBeenMade = false;
    private ExtClassLoader grClassLoader = null;
    private HashSet failedClasses = new HashSet();

    protected PreloadFile(ExtClassLoader extClassLoader) {
        this.grClassLoader = extClassLoader;
    }

    protected void setPreloadPath(String string) {
        this.preloadPath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordClassLoad(String string) {
        if (this.failedClasses.contains(string)) {
            return;
        }
        if (string.indexOf("db2j") != -1) {
            return;
        }
        this.modificationsHaveBeenMade = true;
        try {
            PreloadFile preloadFile = this;
            synchronized (preloadFile) {
                DataOutputStream dataOutputStream = this.getOutputStream();
                dataOutputStream.writeUTF(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WSLauncher.out);
        }
    }

    protected void recordFailedClassLoad(String string) {
        this.failedClasses.add(string);
    }

    protected void addLiveCodeSourceInfo(String string) {
        this.liveCodeSourceInfo.put(string, new CodeSourceInfo(string));
    }

    protected void removeLiveCodeSourceInfo(String string) {
        this.liveCodeSourceInfo.remove(string);
    }

    protected void lock() throws FileNotFoundException, IOException {
        if (this.fl == null) {
            this.getInputStream();
            this.fl = this.fileChannel.lock(0L, Long.MAX_VALUE, true);
        }
    }

    protected void unlock() {
        if (this.fl != null) {
            try {
                this.fl.release();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(WSLauncher.out);
            }
            this.fl = null;
        }
    }

    protected boolean checkCRC() {
        long l;
        String string = System.getProperty("ibm.websphere.preload.checkpath");
        if (string == null) {
            string = System.getProperty("was.install.root") + File.separator + "classes";
        }
        this.checkPathCRC = PathChecksum.pathChecksum(string);
        this.preloadFileCRC = PathChecksum.pathChecksum(this.preloadPath);
        if (this.preloadFile.length() == 0L) {
            this.clearFileOnWrite = true;
            return false;
        }
        if (this.inputStream == null) {
            try {
                this.getInputStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }
        try {
            l = this.inputStream.readLong();
        }
        catch (IOException iOException) {
            return false;
        }
        if (l != this.checkPathCRC) {
            this.clearFileOnWrite = true;
            return false;
        }
        return true;
    }

    protected String getNextPreloadClass() {
        try {
            DataInputStream dataInputStream = this.getInputStream();
            String string = null;
            while ((string = dataInputStream.readUTF()) != null) {
                byte by = dataInputStream.readByte();
                if (by == 0) {
                    String string2 = dataInputStream.readUTF();
                    by = dataInputStream.readByte();
                    this.lastCodeSourceRead = this.getLiveCodeSourceInfo(string2);
                    boolean bl = this.lastCodeSourceReadIsValid = this.lastCodeSourceRead != null;
                }
                if (!this.lastCodeSourceReadIsValid) continue;
                return string;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace(WSLauncher.out);
        }
        return null;
    }

    protected byte[] getByteCodes(String string) {
        try {
            String string2 = string.replace('.', '/') + ".class";
            return this.lastCodeSourceRead.getByteCodes(string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(WSLauncher.out);
            return null;
        }
    }

    protected CodeSource getCurrentCodeSource() throws MalformedURLException {
        return this.lastCodeSourceRead.getCodeSource();
    }

    protected Manifest getCurrentManifest() throws IOException {
        return this.lastCodeSourceRead.jarFile.getManifest();
    }

    protected void rollUpChanges() throws IOException {
        this.closeInputStream();
        this.getOutputStream().close();
        if (this.modificationsHaveBeenMade) {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.preloadFile, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                WSLauncher.trace("preload.error.write");
            }
            if (randomAccessFile != null) {
                FileChannel fileChannel = randomAccessFile.getChannel();
                fileChannel.lock();
                long l = PathChecksum.streamChecksum(this.preloadFile.getAbsolutePath(), randomAccessFile);
                if (l == this.preloadFileCRC) {
                    File file = new File(this.outputStreamPath);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                    File file2 = File.createTempFile("preload", "tmp");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                    String string = file2.getAbsolutePath();
                    this.copyPreloadData(dataInputStream, dataOutputStream);
                    dataInputStream.close();
                    fileInputStream.close();
                    dataOutputStream.close();
                    fileOutputStream.close();
                    fileInputStream = new FileInputStream(file2);
                    FileChannel fileChannel2 = fileInputStream.getChannel();
                    if (this.clearFileOnWrite) {
                        fileChannel.truncate(0L);
                        randomAccessFile.writeLong(this.checkPathCRC);
                    }
                    fileChannel.transferFrom(fileChannel2, fileChannel.size(), fileChannel2.size());
                    fileChannel2.close();
                    fileInputStream.close();
                    randomAccessFile.close();
                    file2.delete();
                }
            }
        }
        new File(this.outputStreamPath).delete();
    }

    private void copyPreloadData(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        long l = 0L;
        try {
            URL uRL = null;
            while ((string = dataInputStream.readUTF()) != null) {
                CodeSourceInfo codeSourceInfo;
                final String string4 = string.replace('.', '/') + ".class";
                try {
                    uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() {
                            return PreloadFile.this.grClassLoader.getResource(string4);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    privilegedActionException.printStackTrace(WSLauncher.out);
                }
                if (uRL == null) continue;
                string2 = uRL.getFile();
                int n = string2.lastIndexOf(33);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((codeSourceInfo = this.getLiveCodeSourceInfo(string2)) != null) {
                    ++l;
                    bl2 = true;
                    if (!string2.equals(string3)) {
                        string3 = string2;
                        bl = true;
                    }
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    dataOutputStream.writeUTF(string);
                    if (bl) {
                        dataOutputStream.writeByte(0);
                        dataOutputStream.writeUTF(string2);
                    }
                    dataOutputStream.writeByte(1);
                }
                bl = false;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            exception.printStackTrace(WSLauncher.out);
        }
    }

    private CodeSourceInfo getLiveCodeSourceInfo(String string) {
        return (CodeSourceInfo)this.liveCodeSourceInfo.get(string);
    }

    private DataOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            File file = File.createTempFile("preload", "tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.outputStream = new DataOutputStream(fileOutputStream);
            this.outputStreamPath = file.getAbsolutePath();
        }
        return this.outputStream;
    }

    private DataInputStream getInputStream() throws FileNotFoundException {
        if (this.inputStream == null) {
            this.preloadFile = new File(this.preloadPath);
            this.fileInputStream = new FileInputStream(this.preloadFile);
            this.fileChannel = this.fileInputStream.getChannel();
            this.inputStream = new DataInputStream(this.fileInputStream);
            this.lastCodeSourceReadIsValid = false;
        }
        return this.inputStream;
    }

    private void closeInputStream() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.fileChannel.close();
            this.fileInputStream.close();
            this.inputStream = null;
        }
    }

    private static class CodeSourceInfo {
        String url = null;
        JarFile jarFile = null;
        CodeSource codeSource = null;

        CodeSourceInfo(String string) {
            this.url = string;
        }

        public boolean equals(Object object) {
            CodeSourceInfo codeSourceInfo = (CodeSourceInfo)object;
            return codeSourceInfo.url == this.url;
        }

        private JarFile getJarFile() {
            try {
                if (this.jarFile == null) {
                    URL uRL = new URL(this.url);
                    File file = new File(uRL.getFile());
                    this.jarFile = new JarFile(file);
                }
                return this.jarFile;
            }
            catch (Exception exception) {
                return null;
            }
        }

        private CodeSource getCodeSource() throws MalformedURLException {
            if (this.codeSource == null) {
                this.codeSource = new CodeSource(new URL(this.url), null);
            }
            return this.codeSource;
        }

        private byte[] getByteCodes(String string) throws IOException {
            ZipEntry zipEntry;
            JarFile jarFile = this.getJarFile();
            if (jarFile != null && (zipEntry = jarFile.getEntry(string)) != null) {
                byte[] byArray = new byte[(int)zipEntry.getSize()];
                DataInputStream dataInputStream = new DataInputStream(jarFile.getInputStream(zipEntry));
                dataInputStream.readFully(byArray);
                dataInputStream.close();
                return byArray;
            }
            return null;
        }
    }
}

