/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.validation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.validation.IReporter;
import com.ibm.ws.sm.validation.CompositeValidator;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.validation.ValidationPolicy;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.util.Properties;

public abstract class ValidationHelper {
    public static final String pgmVersion = "1.5";
    public static final String pgmUpdate = "8/13/02";
    protected static TraceComponent tc = ValidationManagerException.register(class$com$ibm$ws$sm$validation$ValidationHelper == null ? (class$com$ibm$ws$sm$validation$ValidationHelper = ValidationHelper.class$("com.ibm.ws.sm.validation.ValidationHelper")) : class$com$ibm$ws$sm$validation$ValidationHelper);
    public static final String IMPLEMENTATION_CLASS_PROPERTY_NAME = "com.ibm.ws.sm.validation.helperClassName";
    public static final String DEFAULT_IMPLEMENTATION_CLASS = "com.ibm.ws.sm.validation.impl.ValidationHelperImpl";
    protected static ValidationHelper instance = null;
    static /* synthetic */ Class class$com$ibm$ws$sm$validation$ValidationHelper;

    public static ValidationHelper getInstance() throws ValidationManagerException {
        if (instance == null) {
            instance = ValidationHelper.createInstance();
        }
        return instance;
    }

    protected static ValidationHelper createInstance() throws ValidationManagerException {
        ValidationHelper validationHelper;
        Class<?> clazz;
        String string;
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Creating validation helper implementation.");
        }
        if ((string = System.getProperty(IMPLEMENTATION_CLASS_PROPERTY_NAME)) == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"Defaulting helper implementation class");
            }
            string = DEFAULT_IMPLEMENTATION_CLASS;
        }
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)("Helper Class: " + string));
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationManagerException.createException(tc, "Failed to find helper class", "WSVM0001E", new Object[]{string}, classNotFoundException);
        }
        try {
            validationHelper = (ValidationHelper)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw ValidationManagerException.createException(tc, "Failed to create helper class", "WSVM0002E", new Object[]{string}, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.error((TraceComponent)tc, (String)"WSVM0003E", (Object)string);
            throw ValidationManagerException.createException(tc, "Failed to access helper class", "WSVM0003E", new Object[]{string}, illegalAccessException);
        }
        return validationHelper;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public static ValidationPolicy createPolicy() throws ValidationManagerException {
        return ValidationHelper.getInstance().createPolicyInstance();
    }

    public static ValidationManagerRegistry getRegistry() throws ValidationManagerException {
        return ValidationHelper.getInstance().getRegistryInstance();
    }

    public static void clearRegistry() throws ValidationManagerException {
        ValidationHelper.getInstance().clearRegistryInstance();
    }

    public static void validate(Properties properties, IReporter iReporter) throws WorkSpaceException, ValidationManagerException {
        ValidationHelper.getInstance().compositeValidate(properties, iReporter);
    }

    public static CompositeValidator createValidator(Properties properties) throws ValidationManagerException {
        return ValidationHelper.getInstance().createCompositeValidator(properties);
    }

    public abstract ValidationPolicy createPolicyInstance();

    public abstract ValidationManagerRegistry getRegistryInstance();

    public abstract void clearRegistryInstance();

    public abstract CompositeValidator createCompositeValidator(Properties var1);

    public abstract void compositeValidate(Properties var1, IReporter var2) throws WorkSpaceException, ValidationManagerException;

    public abstract void compositeValidate(String var1, String var2, IReporter var3) throws WorkSpaceException, ValidationManagerException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

