/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.validation.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.validation.IValidator;
import com.ibm.ws.sm.validation.ContextValidationMessages;
import com.ibm.ws.sm.validation.DocumentValidationMessages;
import com.ibm.ws.sm.validation.ValidationManager;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationPolicy;
import com.ibm.ws.sm.validation.impl.ContextValidationMessagesImpl;
import com.ibm.ws.sm.validation.impl.DocumentValidationMessagesImpl;
import com.ibm.ws.sm.validation.impl.IValidationHelper;
import com.ibm.ws.sm.validation.impl.MetaDataHelper;
import com.ibm.ws.sm.validation.impl.ValidationHelperImpl;
import com.ibm.ws.sm.validation.impl.ValidatorValidationMessagesImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpacePersistentObject;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ValidationManagerImpl
implements ValidationManager {
    public static final String pgmVersion = "1.8";
    public static final String pgmUpdate = "8/7/02";
    protected static TraceComponent tc = ValidationHelperImpl.register(class$com$ibm$ws$sm$validation$impl$ValidationManagerImpl == null ? (class$com$ibm$ws$sm$validation$impl$ValidationManagerImpl = ValidationManagerImpl.class$("com.ibm.ws.sm.validation.impl.ValidationManagerImpl")) : class$com$ibm$ws$sm$validation$impl$ValidationManagerImpl);
    protected WorkSpace workSpace;
    protected RepositoryMetaData metaData;
    protected ValidationPolicy policy;
    protected ValidationPolicy activePolicy;
    protected Hashtable explicitContexts;
    protected Hashtable explicitFiles;
    protected Hashtable activeFiles;
    protected IValidationHelper iHelper;
    protected MetaDataHelper metaDataHelper;
    protected boolean isValidating;
    static /* synthetic */ Class class$com$ibm$ws$sm$validation$impl$ValidationManagerImpl;

    protected ValidationManagerImpl(WorkSpace workSpace, RepositoryMetaData repositoryMetaData, ValidationPolicy validationPolicy) {
        this.workSpace = workSpace;
        this.metaData = repositoryMetaData;
        this.policy = validationPolicy;
        this.acquirePolicy();
        this.iHelper = new IValidationHelper();
        this.metaDataHelper = new MetaDataHelper();
        this.initializeTables();
        this.recoverActive();
        this.applyInitialPolicy();
        this.isValidating = false;
    }

    public static boolean wsFileValidatable(WorkSpaceFile workSpaceFile) {
        RepositoryDocumentType repositoryDocumentType = workSpaceFile.getType();
        return repositoryDocumentType != null && ValidationManagerImpl.repDocTypeValidatable(repositoryDocumentType);
    }

    public static boolean repDocTypeValidatable(RepositoryDocumentType repositoryDocumentType) {
        return !repositoryDocumentType.getValidatorDefs().isEmpty();
    }

    public static List getValidatableFiles(RepositoryContext repositoryContext) {
        ArrayList<WorkSpaceFile> arrayList = new ArrayList<WorkSpaceFile>();
        RepositoryContextType repositoryContextType = repositoryContext.getType();
        List list = repositoryContextType.getChildDocumentTypes();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string;
            WorkSpaceFile workSpaceFile;
            RepositoryDocumentType repositoryDocumentType = (RepositoryDocumentType)list.get(i);
            if (!ValidationManagerImpl.repDocTypeValidatable(repositoryDocumentType) || (workSpaceFile = repositoryContext.getFile(string = repositoryDocumentType.getFilePattern())) == null) continue;
            arrayList.add(workSpaceFile);
        }
        return arrayList;
    }

    protected void acquirePolicy() {
        this.activePolicy = (ValidationPolicy)this.getPolicy().clone();
    }

    protected void initializeTables() {
        this.explicitContexts = new Hashtable();
        this.explicitFiles = new Hashtable();
        this.activeFiles = new Hashtable();
    }

    protected void recoverActive() {
        this.recoverActive(this.workSpace.getRootContext());
    }

    protected void recoverActive(RepositoryContext repositoryContext) {
        String string = repositoryContext.getURI();
        Tr.entry((TraceComponent)tc, (String)"recoverActive", (Object)string);
        if (this.isActivationPersisted(repositoryContext)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Noted Persisted:", (Object)string);
            }
            ContextValidationMessagesImpl contextValidationMessagesImpl = this.basicCreateContextMessages(repositoryContext);
            this.storeExplicitContext(repositoryContext, contextValidationMessagesImpl);
            this.fillWithEnclosed(repositoryContext, contextValidationMessagesImpl);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Context is not active:", (Object)string);
            }
            this.recoverLocalExplicit(repositoryContext);
            Iterator iterator = repositoryContext.getChildren().iterator();
            while (iterator.hasNext()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
                if (this.isDeleted((WorkSpacePersistentObject)repositoryContext)) continue;
                this.recoverActive(repositoryContext2);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"recoverActive", (Object)string);
    }

    protected void fillWithEnclosed(RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        this.fillWithLocal(repositoryContext, contextValidationMessagesImpl);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext)) continue;
            this.fillWithEnclosed(repositoryContext2, contextValidationMessagesImpl);
        }
    }

    protected void fillWithLocal(RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Filling local files for: context", (Object)repositoryContext.getURI());
        }
        Iterator iterator = ValidationManagerImpl.getValidatableFiles(repositoryContext).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"Placing file: ", (Object)workSpaceFile.getURI());
            }
            this.placeLocal(workSpaceFile, contextValidationMessagesImpl);
        }
    }

    protected void placeLocal(WorkSpaceFile workSpaceFile, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.basicCreateDocumentMessages(workSpaceFile, true);
        this.storeActiveFile(workSpaceFile, documentValidationMessagesImpl);
        contextValidationMessagesImpl.addChildMessages(documentValidationMessagesImpl);
    }

    protected void recoverLocalExplicit(RepositoryContext repositoryContext) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Recovering local for context:", (Object)repositoryContext.getURI());
        }
        Iterator iterator = ValidationManagerImpl.getValidatableFiles(repositoryContext).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (this.isActivationPersisted(workSpaceFile)) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"Noted Persisted");
                }
                DocumentValidationMessagesImpl documentValidationMessagesImpl = this.basicCreateDocumentMessages(workSpaceFile, true);
                this.storeExplicitFile(workSpaceFile, documentValidationMessagesImpl);
                this.storeActiveFile(workSpaceFile, documentValidationMessagesImpl);
                continue;
            }
            if (!bl) continue;
            Tr.debug((TraceComponent)tc, (String)"No persistence");
        }
    }

    protected void applyInitialPolicy() {
        if (this.getPolicy().getIncludeAll()) {
            this.policyEnabledAll(this.getPolicy());
        }
    }

    public void policyEnabledAll(ValidationPolicy validationPolicy) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Policy has enabled all validation.");
        }
        this.enableAll(this.getWorkSpace().getRootContext());
    }

    protected void enableAll(RepositoryContext repositoryContext) {
        if (!this.isEnabled(repositoryContext)) {
            this.doEnableAll(repositoryContext);
        }
    }

    protected void doEnableAll(RepositoryContext repositoryContext) {
        this.enableAllLocal(repositoryContext);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext2)) continue;
            this.enableAll(repositoryContext2);
        }
    }

    protected void enableAllLocal(RepositoryContext repositoryContext) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)("Enabling local files of context: " + repositoryContext.getURI()));
        }
        Iterator iterator = ValidationManagerImpl.getValidatableFiles(repositoryContext).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            String string = workSpaceFile.getURI();
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"Testing file:", (Object)string);
            }
            if (this.isDeleted((WorkSpacePersistentObject)workSpaceFile)) {
                if (!bl) continue;
                Tr.debug((TraceComponent)tc, (String)"Ignoring file: Deleted");
                continue;
            }
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"Enabling file");
            }
            this.enableValidation(workSpaceFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void policyChanged(ValidationPolicy validationPolicy) throws ValidationManagerException {
        Tr.entry((TraceComponent)tc, (String)"policyChanged");
        if (validationPolicy != this.getPolicy()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Strange: Policy is not the original policy");
            }
            Tr.exit((TraceComponent)tc, (String)"policyChanged");
            return;
        }
        this.acquirePolicy();
        this.stopValidating();
        try {
            this.disableValidation();
            try {
                this.getWorkSpace().releaseUnchanged(true);
            }
            catch (WorkSpaceException workSpaceException) {
                Tr.error((TraceComponent)tc, (String)"WSVM1040E", (Object)((Object)workSpaceException));
                String string = ValidationHelperImpl.fetchMessage("WSVM1040E");
                throw new ValidationManagerException(string, workSpaceException);
            }
            if (this.getPolicy().getIncludeAll()) {
                this.policyEnabledAll(this.getPolicy());
            } else {
                this.recoverChanged();
            }
        }
        finally {
            this.startValidating();
            Tr.exit((TraceComponent)tc, (String)"policyChanged");
        }
    }

    protected void recoverChanged() {
        Tr.entry((TraceComponent)tc, (String)"recoverChanged");
        boolean bl = tc.isDebugEnabled();
        Iterator iterator = this.getWorkSpace().getModifiedList().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (bl) {
                String string = workSpaceFile.getURI();
                Tr.debug((TraceComponent)tc, (String)("Noted changed file: " + string));
            }
            if (workSpaceFile.getType() == null) {
                if (!bl) continue;
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
                continue;
            }
            this.handleByPolicy(workSpaceFile);
        }
        Tr.exit((TraceComponent)tc, (String)"recoverChanged");
    }

    protected void startValidating() {
        this.isValidating = true;
    }

    protected void stopValidating() {
        this.isValidating = false;
    }

    protected boolean isValidating() {
        return this.isValidating;
    }

    protected IValidationHelper getIHelper() {
        return this.iHelper;
    }

    protected MetaDataHelper getMetaDataHelper() {
        return this.metaDataHelper;
    }

    protected IValidator basicCreateValidator(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating validator:", (Object)string);
        }
        return this.getIHelper().createValidator(string);
    }

    protected List selectValidatorClassNames(List list, WorkSpaceFile workSpaceFile) {
        RepositoryDocumentType repositoryDocumentType = workSpaceFile.getType();
        if (repositoryDocumentType == null) {
            return new ArrayList();
        }
        return this.getMetaDataHelper().selectValidatorClassNames(list, repositoryDocumentType);
    }

    protected List selectValidatorClassNamesByType(List list, WorkSpaceFile workSpaceFile) {
        RepositoryDocumentType repositoryDocumentType = workSpaceFile.getType();
        if (repositoryDocumentType == null) {
            return new ArrayList();
        }
        return this.getMetaDataHelper().selectValidatorClassNamesByType(list, repositoryDocumentType);
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    protected RepositoryMetaData getMetaData() {
        return this.metaData;
    }

    public ValidationPolicy getPolicy() {
        return this.policy;
    }

    protected Hashtable getExplicitContexts() {
        return this.explicitContexts;
    }

    protected List collectExplicitContexts() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getExplicitContexts().keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    protected ContextValidationMessagesImpl locateExplicitContext(RepositoryContext repositoryContext) {
        return (ContextValidationMessagesImpl)this.getExplicitContexts().get(repositoryContext);
    }

    protected void storeExplicitContext(RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        this.getExplicitContexts().put(repositoryContext, contextValidationMessagesImpl);
    }

    protected ContextValidationMessagesImpl removeExplicitContext(RepositoryContext repositoryContext) {
        return (ContextValidationMessagesImpl)this.getExplicitContexts().remove(repositoryContext);
    }

    protected Hashtable getExplicitFiles() {
        return this.explicitFiles;
    }

    protected List collectExplicitFiles() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getExplicitFiles().keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    protected DocumentValidationMessagesImpl locateExplicitFile(WorkSpaceFile workSpaceFile) {
        return (DocumentValidationMessagesImpl)this.getExplicitFiles().get(workSpaceFile);
    }

    protected void storeExplicitFile(WorkSpaceFile workSpaceFile, DocumentValidationMessagesImpl documentValidationMessagesImpl) {
        this.getExplicitFiles().put(workSpaceFile, documentValidationMessagesImpl);
    }

    protected DocumentValidationMessagesImpl removeExplicitFile(WorkSpaceFile workSpaceFile) {
        return (DocumentValidationMessagesImpl)this.getExplicitFiles().remove(workSpaceFile);
    }

    protected Hashtable getActiveFiles() {
        return this.activeFiles;
    }

    protected List collectActiveFiles() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getActiveFiles().keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    protected DocumentValidationMessagesImpl locateActiveFile(WorkSpaceFile workSpaceFile) {
        return (DocumentValidationMessagesImpl)this.getActiveFiles().get(workSpaceFile);
    }

    protected void storeActiveFile(WorkSpaceFile workSpaceFile, DocumentValidationMessagesImpl documentValidationMessagesImpl) {
        this.getActiveFiles().put(workSpaceFile, documentValidationMessagesImpl);
    }

    protected DocumentValidationMessagesImpl removeActiveFile(WorkSpaceFile workSpaceFile) {
        return (DocumentValidationMessagesImpl)this.getActiveFiles().remove(workSpaceFile);
    }

    protected void persistActivation(WorkSpaceFile workSpaceFile, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Persisting file activation", (Object)new Object[]{workSpaceFile.getURI(), new Boolean(bl)});
        }
        if (bl) {
            try {
                workSpaceFile.setProperty("com.ibm.ws.sm.workspace.validation.isActive", "true");
            }
            catch (WorkSpaceException workSpaceException) {
                Tr.error((TraceComponent)tc, (String)"WSVM1030E", (Object)new String[]{workSpaceFile.getURI(), "com.ibm.ws.sm.workspace.validation.isActive", workSpaceException.toString()});
            }
        } else {
            try {
                workSpaceFile.removeProperty("com.ibm.ws.sm.workspace.validation.isActive");
            }
            catch (WorkSpaceException workSpaceException) {
                Tr.error((TraceComponent)tc, (String)"WSVM1031E", (Object)new String[]{workSpaceFile.getURI(), "com.ibm.ws.sm.workspace.validation.isActive", workSpaceException.toString()});
            }
        }
    }

    protected void persistActivation(RepositoryContext repositoryContext, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Persisting context activation", (Object)new Object[]{repositoryContext.getURI(), new Boolean(bl)});
        }
        if (bl) {
            try {
                repositoryContext.setProperty("com.ibm.ws.sm.workspace.validation.isActive", "true");
            }
            catch (WorkSpaceException workSpaceException) {
                Tr.error((TraceComponent)tc, (String)"WSVM1032E", (Object)new String[]{repositoryContext.getURI(), "com.ibm.ws.sm.workspace.validation.isActive", workSpaceException.toString()});
            }
        } else {
            try {
                repositoryContext.removeProperty("com.ibm.ws.sm.workspace.validation.isActive");
            }
            catch (WorkSpaceException workSpaceException) {
                Tr.error((TraceComponent)tc, (String)"WSVM1033E", (Object)new String[]{repositoryContext.getURI(), "com.ibm.ws.sm.workspace.validation.isActive", workSpaceException.toString()});
            }
        }
    }

    protected boolean isActivationPersisted(WorkSpaceFile workSpaceFile) {
        boolean bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Testing file activation", (Object)workSpaceFile.getURI());
        }
        boolean bl2 = bl = workSpaceFile.getProperty("com.ibm.ws.sm.workspace.validation.isActive") != null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Activation status: ", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected boolean isActivationPersisted(RepositoryContext repositoryContext) {
        boolean bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Testing context activation", (Object)repositoryContext.getURI());
        }
        boolean bl2 = bl = repositoryContext.getProperty("com.ibm.ws.sm.workspace.validation.isActive") != null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Activation status: ", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected void storeDocumentValidation(WorkSpaceFile workSpaceFile, DocumentValidationMessagesImpl documentValidationMessagesImpl) {
        this.storeActiveFile(workSpaceFile, documentValidationMessagesImpl);
        this.persistActivation(workSpaceFile, true);
    }

    protected DocumentValidationMessagesImpl removeDocumentValidation(WorkSpaceFile workSpaceFile) {
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.removeActiveFile(workSpaceFile);
        if (documentValidationMessagesImpl != null) {
            this.removeExplicitFile(workSpaceFile);
            this.persistActivation(workSpaceFile, false);
        }
        return documentValidationMessagesImpl;
    }

    protected void storeContextValidation(RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        this.storeExplicitContext(repositoryContext, contextValidationMessagesImpl);
        this.persistActivation(repositoryContext, true);
    }

    protected ContextValidationMessagesImpl removeContextValidation(RepositoryContext repositoryContext) {
        ContextValidationMessagesImpl contextValidationMessagesImpl = this.removeExplicitContext(repositoryContext);
        if (contextValidationMessagesImpl != null) {
            this.persistActivation(repositoryContext, false);
        }
        return contextValidationMessagesImpl;
    }

    protected ContextValidationMessagesImpl basicCreateContextMessages(RepositoryContext repositoryContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating context messages structure:", (Object)repositoryContext.getURI());
        }
        return new ContextValidationMessagesImpl(this, repositoryContext);
    }

    protected DocumentValidationMessagesImpl basicCreateDocumentMessages(WorkSpaceFile workSpaceFile, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating document messages structure:", (Object)workSpaceFile.getURI());
        }
        return new DocumentValidationMessagesImpl(this, workSpaceFile, bl);
    }

    protected ValidatorValidationMessagesImpl basicCreateValidatorMessages(DocumentValidationMessagesImpl documentValidationMessagesImpl, String string) {
        IValidator iValidator;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Creating validator messages structure");
        }
        ValidatorValidationMessagesImpl validatorValidationMessagesImpl = (iValidator = this.basicCreateValidator(string)).getClass().getName().equals(string) ? new ValidatorValidationMessagesImpl(documentValidationMessagesImpl, iValidator) : new ValidatorValidationMessagesImpl(documentValidationMessagesImpl, string, iValidator);
        return validatorValidationMessagesImpl;
    }

    protected ContextValidationMessagesImpl createContextMessages(RepositoryContext repositoryContext) {
        ContextValidationMessagesImpl contextValidationMessagesImpl = this.basicCreateContextMessages(repositoryContext);
        this.storeContextValidation(repositoryContext, contextValidationMessagesImpl);
        return contextValidationMessagesImpl;
    }

    protected DocumentValidationMessagesImpl createDocumentMessages(WorkSpaceFile workSpaceFile) {
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.basicCreateDocumentMessages(workSpaceFile, true);
        this.storeDocumentValidation(workSpaceFile, documentValidationMessagesImpl);
        return documentValidationMessagesImpl;
    }

    protected boolean isEnclosed(RepositoryContext repositoryContext) {
        while (repositoryContext != null && this.locateExplicitContext(repositoryContext) == null) {
            repositoryContext = repositoryContext.getParentContext();
        }
        return repositoryContext != null;
    }

    protected ContextValidationMessagesImpl locateEnclosingContext(WorkSpaceFile workSpaceFile) {
        ContextValidationMessagesImpl contextValidationMessagesImpl = null;
        for (RepositoryContext repositoryContext = workSpaceFile.getContext(); repositoryContext != null && (contextValidationMessagesImpl = this.locateExplicitContext(repositoryContext)) != null; repositoryContext = repositoryContext.getParentContext()) {
        }
        return contextValidationMessagesImpl;
    }

    protected void removeEnclosedContexts(RepositoryContext repositoryContext) {
        this.removeContextValidation(repositoryContext);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext2)) continue;
            this.removeEnclosedContexts(repositoryContext2);
        }
    }

    protected void removeEnclosedDocuments(RepositoryContext repositoryContext) {
        this.removeLocalDocuments(repositoryContext);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext2)) continue;
            this.removeEnclosedDocuments(repositoryContext2);
        }
    }

    protected void removeLocalDocuments(RepositoryContext repositoryContext) {
        Iterator iterator = repositoryContext.getAllList(false).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (workSpaceFile.getType() == null || this.isDeleted((WorkSpacePersistentObject)workSpaceFile)) continue;
            this.removeDocumentValidation(workSpaceFile);
        }
    }

    protected void ensureLocalDocuments(RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        Iterator iterator = repositoryContext.getAllList(false).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (workSpaceFile.getType() == null || this.isDeleted((WorkSpacePersistentObject)workSpaceFile)) continue;
            DocumentValidationMessagesImpl documentValidationMessagesImpl = this.locateActiveFile(workSpaceFile);
            if (documentValidationMessagesImpl == null) {
                documentValidationMessagesImpl = this.createDocumentMessages(workSpaceFile);
            } else {
                this.removeExplicitFile(workSpaceFile);
            }
            contextValidationMessagesImpl.addChildMessages(documentValidationMessagesImpl);
        }
    }

    protected void ensureEnclosedDocuments(RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        this.ensureLocalDocuments(repositoryContext, contextValidationMessagesImpl);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext2)) continue;
            this.ensureEnclosedDocuments(repositoryContext2, contextValidationMessagesImpl);
        }
    }

    protected ContextValidationMessagesImpl createLinkedContextMessages(RepositoryContext repositoryContext) {
        this.removeEnclosedContexts(repositoryContext);
        ContextValidationMessagesImpl contextValidationMessagesImpl = this.createContextMessages(repositoryContext);
        this.ensureEnclosedDocuments(repositoryContext, contextValidationMessagesImpl);
        return contextValidationMessagesImpl;
    }

    protected void scanEnclosedDocuments(RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        this.scanLocalDocuments(repositoryContext, contextValidationMessagesImpl);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext2)) continue;
            this.scanEnclosedDocuments(repositoryContext2, contextValidationMessagesImpl);
        }
    }

    protected void scanLocalDocuments(RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        Iterator iterator = repositoryContext.getAllList(false).iterator();
        while (iterator.hasNext()) {
            DocumentValidationMessagesImpl documentValidationMessagesImpl;
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (workSpaceFile.getType() == null || this.isDeleted((WorkSpacePersistentObject)workSpaceFile) || (documentValidationMessagesImpl = this.locateActiveFile(workSpaceFile)) == null) continue;
            contextValidationMessagesImpl.addChildMessages(documentValidationMessagesImpl);
        }
    }

    protected ContextValidationMessagesImpl createUnlinkedContextMessages(RepositoryContext repositoryContext) {
        ContextValidationMessagesImpl contextValidationMessagesImpl = this.basicCreateContextMessages(repositoryContext);
        this.scanEnclosedDocuments(repositoryContext, contextValidationMessagesImpl);
        return contextValidationMessagesImpl;
    }

    protected WorkSpaceFile locateRootDocument(RepositoryContext repositoryContext) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)("Locating root document of context: " + repositoryContext.getURI()));
        }
        Iterator iterator = repositoryContext.getAllList(false).iterator();
        RepositoryDocumentType repositoryDocumentType = repositoryContext.getType().getRootDocumentType();
        if (repositoryDocumentType == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"No set root document type; returning null");
            }
            return null;
        }
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)("Noted root document type: " + repositoryDocumentType.getFilePattern()));
        }
        WorkSpaceFile workSpaceFile = null;
        while (workSpaceFile == null && iterator.hasNext()) {
            WorkSpaceFile workSpaceFile2 = (WorkSpaceFile)iterator.next();
            if (workSpaceFile2.getType() == null || this.isDeleted((WorkSpacePersistentObject)workSpaceFile2) || workSpaceFile2.getType() != repositoryDocumentType) continue;
            workSpaceFile = workSpaceFile2;
        }
        if (bl) {
            if (workSpaceFile == null) {
                Tr.debug((TraceComponent)tc, (String)"No root document was found");
            } else {
                Tr.debug((TraceComponent)tc, (String)("Found root document: " + workSpaceFile.getURI()));
            }
        }
        return workSpaceFile;
    }

    public void enableValidation(WorkSpaceFile workSpaceFile) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Request to enable validation for file:", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
            }
        } else if (this.locateActiveFile(workSpaceFile) == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"Enabling");
            }
            DocumentValidationMessagesImpl documentValidationMessagesImpl = this.createDocumentMessages(workSpaceFile);
            this.storeExplicitFile(workSpaceFile, documentValidationMessagesImpl);
        } else if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Already Enabled");
        }
    }

    public void enableValidationOfParents(WorkSpaceFile workSpaceFile) {
        for (RepositoryContext repositoryContext = workSpaceFile.getContext(); repositoryContext != null; repositoryContext = repositoryContext.getParentContext()) {
            WorkSpaceFile workSpaceFile2 = this.locateRootDocument(repositoryContext);
            if (workSpaceFile2 == null) continue;
            this.enableValidation(workSpaceFile2);
        }
    }

    public void enableValidationOfLocalSiblings(WorkSpaceFile workSpaceFile) {
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        Iterator iterator = repositoryContext.getAllList(false).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile2 = (WorkSpaceFile)iterator.next();
            if (workSpaceFile2 == workSpaceFile || workSpaceFile2.getType() == null || this.isDeleted((WorkSpacePersistentObject)workSpaceFile2)) continue;
            this.enableValidation(workSpaceFile2);
        }
    }

    public void enableValidation(RepositoryContext repositoryContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Enabling validation for context:", (Object)repositoryContext.getURI());
        }
        if (!this.isEnclosed(repositoryContext)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Enabling");
            }
            this.createLinkedContextMessages(repositoryContext);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Enabled through enclosing context");
        }
    }

    public void enableValidation() {
        this.enableValidation(this.getWorkSpace().getRootContext());
    }

    public void disableValidation(WorkSpaceFile workSpaceFile) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Request to disable validation for file:", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
            }
            return;
        }
        if (this.removeExplicitFile(workSpaceFile) == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"No explicit validation; ignoring");
            }
            return;
        }
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Found explicit validation; removing persisted activation");
        }
        this.removeDocumentValidation(workSpaceFile);
    }

    public void disableValidation(RepositoryContext repositoryContext) {
        RepositoryContext repositoryContext2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Request to disable validation for context:", (Object)repositoryContext.getURI());
        }
        if ((repositoryContext2 = repositoryContext.getParentContext()) == null || !this.isEnclosed(repositoryContext2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Disabling");
            }
            this.removeEnclosedContexts(repositoryContext);
            this.removeEnclosedDocuments(repositoryContext);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Enclosed; ignoring request");
        }
    }

    public void disableValidation() {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Disabling all validation");
        }
        Iterator iterator = this.getExplicitContexts().keySet().iterator();
        while (iterator.hasNext()) {
            object = (RepositoryContext)iterator.next();
            this.persistActivation((RepositoryContext)object, false);
        }
        object = this.getActiveFiles().keySet().iterator();
        while (object.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)object.next();
            this.persistActivation(workSpaceFile, false);
        }
        this.initializeTables();
    }

    public boolean isEnabled(WorkSpaceFile workSpaceFile) {
        return this.locateActiveFile(workSpaceFile) != null;
    }

    public boolean isEnabled(RepositoryContext repositoryContext) {
        return this.isEnclosed(repositoryContext);
    }

    public boolean isEnabled() {
        return this.isEnabled(this.getWorkSpace().getRootContext());
    }

    protected void clearEnclosedDocuments(RepositoryContext repositoryContext) {
        this.clearLocalDocuments(repositoryContext);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext2)) continue;
            this.clearEnclosedDocuments(repositoryContext2);
        }
    }

    protected void clearLocalDocuments(RepositoryContext repositoryContext) {
        Iterator iterator = repositoryContext.getAllList(false).iterator();
        while (iterator.hasNext()) {
            DocumentValidationMessagesImpl documentValidationMessagesImpl;
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (workSpaceFile.getType() == null || this.isDeleted((WorkSpacePersistentObject)workSpaceFile) || (documentValidationMessagesImpl = this.locateActiveFile(workSpaceFile)) == null) continue;
            documentValidationMessagesImpl.clear();
        }
    }

    public void clearResults(WorkSpaceFile workSpaceFile) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Clear results for file:", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
            }
            return;
        }
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.locateActiveFile(workSpaceFile);
        if (documentValidationMessagesImpl == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no active validation; ignoring");
            }
            return;
        }
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"File has active validation: clearing");
        }
        documentValidationMessagesImpl.clear();
    }

    public void clearResults(RepositoryContext repositoryContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Clear results for context:", (Object)repositoryContext.getURI());
        }
        this.clearEnclosedDocuments(repositoryContext);
    }

    public void clearResults() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Clearing all results");
        }
        Iterator iterator = this.getActiveFiles().values().iterator();
        while (iterator.hasNext()) {
            DocumentValidationMessagesImpl documentValidationMessagesImpl = (DocumentValidationMessagesImpl)iterator.next();
            documentValidationMessagesImpl.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trigger(DocumentValidationMessagesImpl documentValidationMessagesImpl) {
        this.startValidating();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Triggering validation for file:", (Object)documentValidationMessagesImpl.getDocumentFullUri());
            }
            documentValidationMessagesImpl.trigger();
        }
        finally {
            this.stopValidating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trigger(ContextValidationMessagesImpl contextValidationMessagesImpl) {
        this.startValidating();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Triggering validation for context:", (Object)contextValidationMessagesImpl.getContextUri());
            }
            contextValidationMessagesImpl.trigger();
        }
        finally {
            this.stopValidating();
        }
    }

    public DocumentValidationMessages getResults(WorkSpaceFile workSpaceFile) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Retrieving results for file:", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; returning null.");
            }
            return null;
        }
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.locateActiveFile(workSpaceFile);
        if (documentValidationMessagesImpl == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"Validation not active; returning null");
            }
        } else {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"Validation is active; triggering");
            }
            this.trigger(documentValidationMessagesImpl);
        }
        return documentValidationMessagesImpl;
    }

    public int getMessageCount(WorkSpaceFile workSpaceFile) {
        DocumentValidationMessages documentValidationMessages = this.getResults(workSpaceFile);
        return documentValidationMessages == null ? 0 : documentValidationMessages.getMessageCount();
    }

    public ContextValidationMessages getResults(RepositoryContext repositoryContext) {
        ContextValidationMessagesImpl contextValidationMessagesImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Retrieving results for context:", (Object)repositoryContext.getURI());
        }
        if ((contextValidationMessagesImpl = this.locateExplicitContext(repositoryContext)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Context not active; creating uncached results");
            }
            contextValidationMessagesImpl = this.createUnlinkedContextMessages(repositoryContext);
        }
        this.trigger(contextValidationMessagesImpl);
        return contextValidationMessagesImpl;
    }

    public int getMessageCount(RepositoryContext repositoryContext) {
        return this.getResults(repositoryContext).getMessageCount();
    }

    public ContextValidationMessages getResults() {
        return this.getResults(this.getWorkSpace().getRootContext());
    }

    public int getMessageCount() {
        return this.getResults().getMessageCount();
    }

    protected void applyEnclosedDocuments(List list, RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        this.applyLocalDocuments(list, repositoryContext, contextValidationMessagesImpl);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext2)) continue;
            this.applyEnclosedDocuments(list, repositoryContext2, contextValidationMessagesImpl);
        }
    }

    protected void applyLocalDocuments(List list, RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        Iterator iterator = repositoryContext.getAllList(false).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (workSpaceFile.getType() == null || this.isDeleted((WorkSpacePersistentObject)workSpaceFile)) continue;
            this.applyLocalDocument(list, workSpaceFile, contextValidationMessagesImpl);
        }
    }

    protected void applyLocalDocument(List list, WorkSpaceFile workSpaceFile, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        List list2 = this.selectValidatorClassNames(list, workSpaceFile);
        this.applySelectedValidators(list2, workSpaceFile, contextValidationMessagesImpl);
    }

    protected void applySelectedValidators(List list, WorkSpaceFile workSpaceFile, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        Iterator iterator = list.iterator();
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.locateActiveFile(workSpaceFile);
        DocumentValidationMessagesImpl documentValidationMessagesImpl2 = this.basicCreateDocumentMessages(workSpaceFile, false);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ValidatorValidationMessagesImpl validatorValidationMessagesImpl = documentValidationMessagesImpl == null ? this.basicCreateValidatorMessages(documentValidationMessagesImpl2, string) : (ValidatorValidationMessagesImpl)documentValidationMessagesImpl.getValidatorMessages(string);
            documentValidationMessagesImpl2.addFullChildMessages(string, validatorValidationMessagesImpl);
            documentValidationMessagesImpl2.addLocalChildMessages(string, validatorValidationMessagesImpl);
        }
    }

    public ContextValidationMessages apply(List list, RepositoryContext repositoryContext) {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Applying list of validator classes to context:", (Object)repositoryContext.getURI());
            object = list.iterator();
            while (object.hasNext()) {
                Tr.debug((TraceComponent)tc, (String)("    " + (String)object.next()));
            }
        }
        object = this.basicCreateContextMessages(repositoryContext);
        this.applyEnclosedDocuments(list, repositoryContext, (ContextValidationMessagesImpl)object);
        this.trigger((ContextValidationMessagesImpl)object);
        return object;
    }

    protected void applyEnclosedDocumentsByType(List list, RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        this.applyLocalDocumentsByType(list, repositoryContext, contextValidationMessagesImpl);
        Iterator iterator = repositoryContext.getChildren().iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
            if (this.isDeleted((WorkSpacePersistentObject)repositoryContext2)) continue;
            this.applyEnclosedDocumentsByType(list, repositoryContext2, contextValidationMessagesImpl);
        }
    }

    protected void applyLocalDocumentsByType(List list, RepositoryContext repositoryContext, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        Iterator iterator = repositoryContext.getAllList(false).iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (workSpaceFile.getType() == null || this.isDeleted((WorkSpacePersistentObject)workSpaceFile)) continue;
            this.applyLocalDocumentByType(list, workSpaceFile, contextValidationMessagesImpl);
        }
    }

    protected void applyLocalDocumentByType(List list, WorkSpaceFile workSpaceFile, ContextValidationMessagesImpl contextValidationMessagesImpl) {
        List list2 = this.selectValidatorClassNamesByType(list, workSpaceFile);
        this.applySelectedValidators(list2, workSpaceFile, contextValidationMessagesImpl);
    }

    public ContextValidationMessages applyByType(List list, RepositoryContext repositoryContext) {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Applying typed validators to context:", (Object)repositoryContext.getURI());
            object = list.iterator();
            while (object.hasNext()) {
                Tr.debug((TraceComponent)tc, (String)("    " + (String)object.next()));
            }
        }
        object = this.basicCreateContextMessages(repositoryContext);
        this.applyEnclosedDocumentsByType(list, repositoryContext, (ContextValidationMessagesImpl)object);
        this.trigger((ContextValidationMessagesImpl)object);
        return object;
    }

    protected boolean isDeleted(WorkSpacePersistentObject workSpacePersistentObject) {
        return workSpacePersistentObject.getState() == WorkSpaceFileState.DELETED;
    }

    protected boolean isNew(WorkSpacePersistentObject workSpacePersistentObject) {
        return workSpacePersistentObject.getState() == WorkSpaceFileState.ADDED;
    }

    protected boolean wasUpdated(WorkSpacePersistentObject workSpacePersistentObject) {
        return workSpacePersistentObject.getState() == WorkSpaceFileState.UPDATED;
    }

    protected boolean isExtractFile(WorkSpaceEvent workSpaceEvent) {
        return workSpaceEvent.getType() == 23;
    }

    protected boolean isNewFile(WorkSpaceEvent workSpaceEvent) {
        return workSpaceEvent.getType() == 20;
    }

    protected boolean isUpdateFile(WorkSpaceEvent workSpaceEvent) {
        return workSpaceEvent.getType() == 22;
    }

    protected boolean isRemoveFile(WorkSpaceEvent workSpaceEvent) {
        return workSpaceEvent.getType() == 21;
    }

    protected boolean isReleaseFile(WorkSpaceEvent workSpaceEvent) {
        return workSpaceEvent.getType() == 24;
    }

    protected WorkSpaceFile getFile(WorkSpaceEvent workSpaceEvent) {
        return (WorkSpaceFile)workSpaceEvent.getSource();
    }

    protected RepositoryContext getContext(WorkSpaceEvent workSpaceEvent) {
        return (RepositoryContext)workSpaceEvent.getSource();
    }

    protected void handleNewFile(WorkSpaceEvent workSpaceEvent) {
        WorkSpaceFile workSpaceFile = this.getFile(workSpaceEvent);
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Handling new file:", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
            }
            return;
        }
        ContextValidationMessagesImpl contextValidationMessagesImpl = this.locateEnclosingContext(workSpaceFile);
        if (contextValidationMessagesImpl != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"File enclosed by active context");
            }
            this.placeLocal(workSpaceFile, contextValidationMessagesImpl);
        }
        this.handleByPolicy(workSpaceFile);
    }

    protected void handleExtractFile(WorkSpaceEvent workSpaceEvent) {
        WorkSpaceFile workSpaceFile = this.getFile(workSpaceEvent);
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Handling extracted file:", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
            }
            return;
        }
        this.handleByPolicy(workSpaceFile);
    }

    protected void handleByPolicy(WorkSpaceFile workSpaceFile) {
        boolean bl = tc.isDebugEnabled();
        ValidationPolicy validationPolicy = this.getPolicy();
        if (validationPolicy.getIncludeAll()) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"Activating: Policy is ALL");
            }
            this.enableValidation(workSpaceFile);
        } else {
            if (validationPolicy.getIncludeExtracted()) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"Activating: Policy is EXTRACTED");
                }
                this.enableValidation(workSpaceFile);
            }
            if (validationPolicy.getIncludeParentChain()) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"Activating parent chain");
                }
                this.enableValidationOfParents(workSpaceFile);
            }
            if (validationPolicy.getIncludeLocalSiblings()) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)"Activating local siblings");
                }
                this.enableValidationOfLocalSiblings(workSpaceFile);
            }
        }
    }

    protected void handleUpdateFile(WorkSpaceEvent workSpaceEvent) {
        WorkSpaceFile workSpaceFile = this.getFile(workSpaceEvent);
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Handling update to file:", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
            }
            return;
        }
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.locateActiveFile(workSpaceFile);
        if (documentValidationMessagesImpl == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"No active validation; ignoring");
            }
            return;
        }
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Active validation; clearing messages");
        }
        documentValidationMessagesImpl.clear();
    }

    protected void handleRemoveFile(WorkSpaceEvent workSpaceEvent) {
        WorkSpaceFile workSpaceFile = this.getFile(workSpaceEvent);
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)"Handling removal of file:", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
            }
            return;
        }
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.removeDocumentValidation(workSpaceFile);
        if (documentValidationMessagesImpl == null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"No active validation; ignoring");
            }
            return;
        }
        ContextValidationMessagesImpl contextValidationMessagesImpl = this.locateEnclosingContext(workSpaceFile);
        if (contextValidationMessagesImpl != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Active validation; removing messages structure");
            }
            contextValidationMessagesImpl.removeChildMessages(documentValidationMessagesImpl);
        }
    }

    protected void handleReleaseFile(WorkSpaceEvent workSpaceEvent) {
        boolean bl;
        WorkSpaceFile workSpaceFile = this.getFile(workSpaceEvent);
        boolean bl2 = tc.isDebugEnabled();
        if (bl2) {
            Tr.debug((TraceComponent)tc, (String)"Handling release of file: ", (Object)workSpaceFile.getURI());
        }
        if (workSpaceFile.getType() == null) {
            if (bl2) {
                Tr.debug((TraceComponent)tc, (String)"File has no type; ignoring");
            }
            return;
        }
        DocumentValidationMessagesImpl documentValidationMessagesImpl = this.locateActiveFile(workSpaceFile);
        if (documentValidationMessagesImpl == null) {
            if (bl2) {
                Tr.debug((TraceComponent)tc, (String)"No active validation; ignoring");
            }
            return;
        }
        ValidationPolicy validationPolicy = this.getPolicy();
        if (validationPolicy.getIncludeAll() || validationPolicy.getIncludeLocalSiblings() || validationPolicy.getIncludeParentChain()) {
            if (bl2) {
                Tr.debug((TraceComponent)tc, (String)"Policy requires that validation remain");
            }
            bl = true;
        } else {
            ContextValidationMessagesImpl contextValidationMessagesImpl = this.locateEnclosingContext(workSpaceFile);
            if (contextValidationMessagesImpl != null) {
                if (bl2) {
                    Tr.debug((TraceComponent)tc, (String)"A parent context is enabled");
                }
                bl = true;
            } else {
                if (bl2) {
                    Tr.debug((TraceComponent)tc, (String)"Removing explicit validation");
                }
                bl = false;
                this.removeDocumentValidation(workSpaceFile);
            }
        }
        if (bl) {
            documentValidationMessagesImpl.clear();
        }
    }

    protected void handleRemoveContext(WorkSpaceEvent workSpaceEvent) {
        RepositoryContext repositoryContext = this.getContext(workSpaceEvent);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Handling removal of context:", (Object)repositoryContext.getURI());
        }
        this.removeContextValidation(repositoryContext);
    }

    public void handle(WorkSpaceEvent workSpaceEvent) {
        if (!this.isValidating() && this.isExtractFile(workSpaceEvent)) {
            this.handleExtractFile(workSpaceEvent);
        } else if (this.isUpdateFile(workSpaceEvent)) {
            this.handleUpdateFile(workSpaceEvent);
        } else if (this.isNewFile(workSpaceEvent)) {
            this.handleNewFile(workSpaceEvent);
        } else if (this.isReleaseFile(workSpaceEvent)) {
            this.handleReleaseFile(workSpaceEvent);
        } else if (this.isRemoveFile(workSpaceEvent)) {
            this.handleRemoveFile(workSpaceEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

