/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.ctx;

import com.sun.jndi.toolkit.ctx.PartialCompositeContext;
import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;

public class Continuation
extends ResolveResult {
    protected Name starter;
    protected Object followingLink = null;
    protected Hashtable environment = null;
    protected boolean continuing = false;
    protected Context resolvedContext = null;
    protected Name relativeResolvedName = null;
    private static final long serialVersionUID = 8162530656132624308L;

    public Continuation() {
    }

    public Continuation(Name name, Hashtable hashtable) {
        this.starter = name;
        this.environment = hashtable;
    }

    public boolean isContinue() {
        return this.continuing;
    }

    public void setSuccess() {
        this.continuing = false;
    }

    public NamingException fillInException(NamingException namingException) {
        namingException.setRemainingName(this.remainingName);
        namingException.setResolvedObj(this.resolvedObj);
        if (this.starter == null) {
            namingException.setResolvedName(null);
        } else if (this.remainingName == null) {
            namingException.setResolvedName(this.starter);
        } else {
            namingException.setResolvedName(this.starter.getPrefix(this.starter.size() - this.remainingName.size()));
        }
        if (namingException instanceof CannotProceedException) {
            CannotProceedException cannotProceedException = (CannotProceedException)namingException;
            Hashtable hashtable = this.environment == null ? new Hashtable(11) : (Hashtable)this.environment.clone();
            cannotProceedException.setEnvironment(hashtable);
            cannotProceedException.setAltNameCtx(this.resolvedContext);
            cannotProceedException.setAltName(this.relativeResolvedName);
        }
        return namingException;
    }

    public void setErrorNNS(Object object, Name name) {
        Name name2 = (Name)name.clone();
        try {
            name2.add("");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        this.setErrorAux(object, name2);
    }

    public void setErrorNNS(Object object, String string) {
        CompositeName compositeName = new CompositeName();
        try {
            if (string != null && !string.equals("")) {
                compositeName.add(string);
            }
            compositeName.add("");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        this.setErrorAux(object, compositeName);
    }

    public void setError(Object object, Name name) {
        this.remainingName = name != null ? (Name)name.clone() : null;
        this.setErrorAux(object, this.remainingName);
    }

    public void setError(Object object, String string) {
        CompositeName compositeName = new CompositeName();
        if (string != null && !string.equals("")) {
            try {
                compositeName.add(string);
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
        this.setErrorAux(object, compositeName);
    }

    private void setErrorAux(Object object, Name name) {
        this.remainingName = name;
        this.resolvedObj = object;
        this.continuing = false;
    }

    private void setContinueAux(Object object, Name name, Context context, Name name2) {
        if (object instanceof LinkRef) {
            this.setContinueLink(object, name, context, name2);
        } else {
            this.remainingName = name2;
            this.resolvedObj = object;
            this.relativeResolvedName = name;
            this.resolvedContext = context;
            this.continuing = true;
        }
    }

    public void setContinueNNS(Object object, Name name, Context context) {
        CompositeName compositeName = new CompositeName();
        this.setContinue(object, name, context, PartialCompositeContext._NNS_NAME);
    }

    public void setContinueNNS(Object object, String string, Context context) {
        CompositeName compositeName = new CompositeName();
        try {
            compositeName.add(string);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.setContinue(object, compositeName, context, PartialCompositeContext._NNS_NAME);
    }

    public void setContinue(Object object, Name name, Context context) {
        this.setContinueAux(object, name, context, (Name)PartialCompositeContext._EMPTY_NAME.clone());
    }

    public void setContinue(Object object, Name name, Context context, Name name2) {
        this.remainingName = name2 != null ? (Name)name2.clone() : new CompositeName();
        this.setContinueAux(object, name, context, this.remainingName);
    }

    public void setContinue(Object object, String string, Context context, String string2) {
        CompositeName compositeName = new CompositeName();
        if (!string.equals("")) {
            try {
                compositeName.add(string);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        CompositeName compositeName2 = new CompositeName();
        if (!string2.equals("")) {
            try {
                compositeName2.add(string2);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        this.setContinueAux(object, compositeName, context, compositeName2);
    }

    public void setContinue(Object object, Object object2) {
        this.setContinue(object, null, (Context)object2);
    }

    private void setContinueLink(Object object, Name name, Context context, Name name2) {
        this.followingLink = object;
        this.remainingName = name2;
        this.resolvedObj = context;
        this.relativeResolvedName = PartialCompositeContext._EMPTY_NAME;
        this.resolvedContext = context;
        this.continuing = true;
    }

    public String toString() {
        if (this.remainingName != null) {
            return this.starter.toString() + "; remainingName: '" + this.remainingName + "'";
        }
        return this.starter.toString();
    }

    public String toString(boolean bl) {
        if (!bl || this.resolvedObj == null) {
            return this.toString();
        }
        return this.toString() + "; resolvedObj: " + this.resolvedObj + "; relativeResolvedName: " + this.relativeResolvedName + "; resolvedContext: " + this.resolvedContext;
    }
}

