/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.lang.reflect.Constructor;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerRef;
import sun.rmi.server.ActivatableRef;
import sun.rmi.transport.ObjectTable;

public abstract class Activatable
extends RemoteServer {
    private ActivationID id;
    private static final long serialVersionUID = -3120617863591563455L;
    private static Class[] idPortParamTypes = new Class[]{ActivationID.class, Integer.TYPE};
    private static Class[] idPortFactoryParamTypes = new Class[]{ActivationID.class, Integer.TYPE, RMIClientSocketFactory.class, RMIServerSocketFactory.class};

    protected Activatable(String string, MarshalledObject marshalledObject, boolean bl, int n) throws ActivationException, RemoteException {
        this.id = Activatable.exportObject((Remote)this, string, marshalledObject, bl, n);
    }

    protected Activatable(String string, MarshalledObject marshalledObject, boolean bl, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        this.id = Activatable.exportObject(this, string, marshalledObject, bl, n, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    protected Activatable(ActivationID activationID, int n) throws RemoteException {
        this.id = activationID;
        Activatable.exportObject(this, activationID, n);
    }

    protected Activatable(ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        this.id = activationID;
        Activatable.exportObject((Remote)this, activationID, n, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    protected ActivationID getID() {
        return this.id;
    }

    public static Remote register(ActivationDesc activationDesc) throws UnknownGroupException, ActivationException, RemoteException {
        ActivationID activationID = ActivationGroup.getSystem().registerObject(activationDesc);
        return ActivatableRef.getStub((ActivationDesc)activationDesc, (ActivationID)activationID);
    }

    public static boolean inactive(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        return ActivationGroup.currentGroup().inactiveObject(activationID);
    }

    public static void unregister(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        ActivationGroup.getSystem().unregisterObject(activationID);
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject marshalledObject, boolean bl, int n) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl);
        ActivationID activationID = ActivationGroup.getSystem().registerObject(activationDesc);
        Remote remote2 = Activatable.exportObject(remote, activationID, n);
        ActivationGroup.currentGroup().activeObject(activationID, remote);
        return activationID;
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject marshalledObject, boolean bl, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl);
        ActivationID activationID = ActivationGroup.getSystem().registerObject(activationDesc);
        Remote remote2 = Activatable.exportObject(remote, activationID, n, rMIClientSocketFactory, rMIServerSocketFactory);
        ActivationGroup.currentGroup().activeObject(activationID, remote);
        return activationID;
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n) throws RemoteException {
        Object[] objectArray = new Object[]{activationID, new Integer(n)};
        return Activatable.exportObject(remote, "ActivatableServerRef", idPortParamTypes, objectArray);
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        Object[] objectArray = new Object[]{activationID, new Integer(n), rMIClientSocketFactory, rMIServerSocketFactory};
        return Activatable.exportObject(remote, "ActivatableServerRef", idPortFactoryParamTypes, objectArray);
    }

    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        return ObjectTable.unexportObject(remote, bl);
    }

    private static Remote exportObject(Remote remote, String string, Class[] classArray, Object[] objectArray) throws RemoteException {
        ServerRef serverRef;
        Class<?> clazz;
        String string2 = "sun.rmi.server." + string;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExportException("No class found for server ref type: " + string);
        }
        if (!ServerRef.class.isAssignableFrom(clazz)) {
            throw new ExportException("Server ref class not instance of " + ServerRef.class.getName() + ": " + clazz.getName());
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            serverRef = (ServerRef)constructor.newInstance(objectArray);
            if (remote instanceof Activatable) {
                ((Activatable)remote).ref = serverRef;
            }
        }
        catch (Exception exception) {
            throw new ExportException("Exception creating instance of server ref class: " + clazz.getName(), exception);
        }
        return serverRef.exportObject(remote, null);
    }
}

