/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters;

import com.ibm.vap.converters.VapAbstractConverter;

public class VapCharToBoolean
extends VapAbstractConverter {
    static VapCharToBoolean singleton = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2000";

    private boolean compareTrueCharsTo(char aChar) {
        return aChar == 'Y' || aChar == 'y' || aChar == 'T' || aChar == 't' || aChar == '1';
    }

    public Object dataFrom(Object aBoolean) {
        if (aBoolean == null) {
            return null;
        }
        return (Boolean)aBoolean != false ? new String("Y") : new String("N");
    }

    public static String[] getSourceDatatype() {
        return VapAbstractConverter.getStringDatatypes();
    }

    public static String getTargetClassName() {
        return "java.lang.Boolean";
    }

    public Object objectFrom(Object aField) {
        if (aField == null) {
            return null;
        }
        String tempString = aField.toString();
        return new Boolean(!tempString.equals(null) && tempString.length() != 0 && this.compareTrueCharsTo(tempString.charAt(0)));
    }

    public static void reset() {
        singleton = null;
    }

    public static VapCharToBoolean singleton() {
        if (singleton == null) {
            singleton = new VapCharToBoolean();
        }
        return singleton;
    }
}

