/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters;

import com.ibm.vap.converters.VapStringToPrimitiveWrapperConverter;

public class VapStringToBooleanConverter
extends VapStringToPrimitiveWrapperConverter {
    static VapStringToBooleanConverter singleton = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2000";

    public static boolean compareTrueCharsTo(char aChar) {
        return aChar == 'Y' || aChar == 'y' || aChar == 'T' || aChar == 't' || aChar == '1';
    }

    public Object dataFrom(Object aBoolean) {
        if (aBoolean == null) {
            return null;
        }
        return (Boolean)aBoolean != false ? "Y" : "N";
    }

    public static String getTargetClassName() {
        return "java.lang.Boolean";
    }

    public Object objectFrom(Object aField) {
        if (aField == null) {
            return null;
        }
        String aString = (String)aField;
        return new Boolean(aString.length() != 0 && VapStringToBooleanConverter.compareTrueCharsTo(aString.charAt(0)));
    }

    public static void reset() {
        singleton = null;
    }

    public static VapStringToBooleanConverter singleton() {
        if (singleton == null) {
            singleton = new VapStringToBooleanConverter();
        }
        return singleton;
    }
}

