/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters.streams;

import com.ibm.vap.converters.streams.VapStreamToObjectConverter;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.util.Vector;

public abstract class VapUnicodeStreamToObjectConverter
extends VapStreamToObjectConverter {
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2000";

    public Object dataFrom(Object anObject) {
        if (anObject == null) {
            return null;
        }
        return anObject.toString();
    }

    public Object objectFrom(Object aField) {
        if (aField == null) {
            return null;
        }
        if (aField instanceof Reader) {
            return this.stringFromReader((Reader)aField);
        }
        if (aField instanceof Clob) {
            return this.stringFromClob((Clob)aField);
        }
        return aField;
    }

    protected String stringFromReader(Reader reader) {
        char[] rawChars = null;
        int rawCharsLength = 0;
        try {
            int charsRead = 0;
            Vector<char[]> charBuffers = new Vector<char[]>();
            Vector<Integer> charBufferLengths = new Vector<Integer>();
            while (charsRead != -1) {
                char[] nextRawChars = new char[2000];
                charsRead = reader.read(nextRawChars);
                if (charsRead <= 0) continue;
                rawCharsLength += charsRead;
                charBuffers.addElement(nextRawChars);
                charBufferLengths.addElement(new Integer(charsRead));
            }
            if (rawCharsLength > 0) {
                rawChars = new char[rawCharsLength];
                int rawCharsPosition = 0;
                int charBufferCount = charBuffers.size();
                int i = 0;
                while (i < charBufferCount) {
                    char[] chars = (char[])charBuffers.elementAt(i);
                    charsRead = (Integer)charBufferLengths.elementAt(i);
                    int j = 0;
                    while (j < charsRead) {
                        rawChars[rawCharsPosition + j] = chars[j];
                        ++j;
                    }
                    rawCharsPosition += charsRead;
                    ++i;
                }
            }
        }
        catch (IOException exc) {
            RuntimeException rtExc = new RuntimeException(exc.getMessage());
            rtExc.fillInStackTrace();
            throw rtExc;
        }
        return new String(rawChars);
    }
}

