/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.bc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;

public class UpdateExpressPorts {
    private static final boolean debug = true;
    private static final String SERVER_XML = "server.xml";
    private static final String SERVERINDEX_XML = "serverindex.xml";
    private static final String VIRTUALHOSTS_XML = "virtualhosts.xml";
    private static final String WSADMIN_PROPS = "wsadmin.properties";
    private static final String PORTTYPE_ARG = "-portType";
    private static final String PORTNAME_ARG = "-portName";
    private static final String PORTVALUE_ARG = "-portValue";
    private static final String PORTCONNTYPE_ARG = "-portConnType";
    private static final String SERVER_ARG = "-server";
    private static final String VHOSTALIAS_ARG = "-vhostAlias";
    private static final String VHOSTNAME_ARG = "-vhostName";
    private static final String REMOVEADMINPORTS_ARG = "-removeAdminPorts";
    private static final String PORT_CONN_TYPE_RMI = "RMI";
    private static final String PORT_CONN_TYPE_SOAP = "SOAP";
    private static final String PORT_TYPE_BOOTSTRAP = "bootstrap";
    private static final String PORT_TYPE_HTTP = "http";
    private static final String PORT_TYPE_SOAP = "soap";
    private static final String PORT_TYPE_WSADMIN = "wsadmin";
    private static final String PORT_NAME_BOOTSTRAP = "BOOTSTRAP_ADDRESS";
    private static final String PORT_NAME_HTTP = "HTTPTransport_";
    private static final String PORT_NAME_SOAP = "SOAP_CONNECTOR_ADDRESS";
    private static final String PORT_NAME_VHOSTALIAS = "HostAlias_";
    private static final String PORT_NAME_VHOST = "VirtualHost_";
    private static final int INVALID_ARG = 4;
    private static final int INVALID_ARG_VALUE = 5;
    private static final int INVALID_ARG_VALUE_FOR_TYPE = 6;
    private static final int INVALID_PROP_FILE = 7;
    private static final int MISC_ERROR = 99;
    private static boolean updateServerXml = false;
    private static boolean updateServerIndexXml = false;
    private static boolean updateVirtualHostsXml = false;
    private static boolean updateWsAdminProps = false;
    private static String portType = null;
    private static String portName = null;
    private static String portValue = null;
    private static String portConnType = null;
    private static String server = null;
    private static String vhostAlias = null;
    private static String vhostName = null;
    private static boolean removeAdminPorts = false;

    public static void changePortsXml(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(UpdateExpressPorts.loadFile(fileReader));
            fileReader.close();
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            String string2 = null;
            String string3 = null;
            if (portType.equalsIgnoreCase(PORT_TYPE_BOOTSTRAP)) {
                string3 = PORT_NAME_BOOTSTRAP;
            } else if (portType.equalsIgnoreCase(PORT_TYPE_SOAP)) {
                string3 = PORT_NAME_SOAP;
            } else if (portType.equalsIgnoreCase(PORT_TYPE_HTTP) && string.endsWith(SERVER_XML)) {
                string3 = portName;
            } else if (portType.equalsIgnoreCase(PORT_TYPE_HTTP) && string.endsWith(VIRTUALHOSTS_XML)) {
                if (vhostAlias != null) {
                    string3 = vhostAlias;
                } else if (vhostName != null) {
                    string3 = vhostName;
                }
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(string3) != -1) {
                    if (removeAdminPorts && string.endsWith(VIRTUALHOSTS_XML)) {
                        while ((string2 = bufferedReader.readLine()) != null && !string2.trim().equalsIgnoreCase("</host:VirtualHost>")) {
                        }
                        continue;
                    }
                    if (removeAdminPorts && string.endsWith(SERVER_XML)) {
                        while ((string2 = bufferedReader.readLine()) != null && !string2.trim().equalsIgnoreCase("</transports>")) {
                        }
                        continue;
                    }
                    if (string.endsWith(SERVER_XML) || string.endsWith(SERVERINDEX_XML)) {
                        printWriter.println(string2);
                        string2 = bufferedReader.readLine();
                        printWriter.println(UpdateExpressPorts.replace(string2, "port=\"", "port=\"" + portValue + "\"/>"));
                        continue;
                    }
                    if (string.endsWith(VIRTUALHOSTS_XML)) {
                        printWriter.println(UpdateExpressPorts.replace(string2, "port=\"", "port=\"" + portValue + "\"/>"));
                        continue;
                    }
                    printWriter.println(string2);
                    continue;
                }
                printWriter.println(string2);
            }
            printWriter.flush();
            printWriter.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: Could not locate " + string);
            fileNotFoundException.printStackTrace();
            System.exit(7);
        }
        catch (IOException iOException) {
            System.err.println("Error: Could not parse " + string);
            iOException.printStackTrace();
            System.exit(7);
        }
    }

    static String replace(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        return stringBuffer.toString();
    }

    public static void changePortsProp(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(UpdateExpressPorts.loadFile(fileReader));
            fileReader.close();
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            String string2 = null;
            boolean bl = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().startsWith("com.ibm.ws.scripting.connectionType=")) {
                    if (portConnType.equalsIgnoreCase(PORT_CONN_TYPE_RMI)) {
                        printWriter.println("#com.ibm.ws.scripting.connectionType=SOAP");
                        printWriter.println("com.ibm.ws.scripting.connectionType=RMI");
                        continue;
                    }
                    if (!portConnType.equalsIgnoreCase(PORT_CONN_TYPE_SOAP)) continue;
                    printWriter.println("com.ibm.ws.scripting.connectionType=SOAP");
                    printWriter.println("#com.ibm.ws.scripting.connectionType=RMI");
                    continue;
                }
                if (string2.trim().startsWith("#com.ibm.ws.scripting.connectionType=")) continue;
                if (string2.trim().startsWith("com.ibm.ws.scripting.port=") || string2.trim().startsWith("#com.ibm.ws.scripting.port=")) {
                    if (bl) continue;
                    printWriter.println("com.ibm.ws.scripting.port=" + portValue);
                    bl = true;
                    continue;
                }
                printWriter.println(string2);
            }
            if (!bl) {
                printWriter.println("com.ibm.ws.scripting.port=" + portValue);
            }
            printWriter.flush();
            printWriter.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: Could not locate " + string);
            fileNotFoundException.printStackTrace();
            System.exit(7);
        }
        catch (IOException iOException) {
            System.err.println("Error: Could not parse " + string);
            iOException.printStackTrace();
            System.exit(7);
        }
    }

    public static void parseCmdLine(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (i == stringArray.length - 1 && !string.equalsIgnoreCase(REMOVEADMINPORTS_ARG)) {
                System.err.println("Error: No value specified for argument, " + string);
                System.exit(4);
                continue;
            }
            if (string.equalsIgnoreCase(PORTTYPE_ARG)) {
                if (UpdateExpressPorts.isValidCmdLineArg(PORTTYPE_ARG, portType = stringArray[++i])) continue;
                System.err.println("Error: Invalid value, " + portType + ", supplied for argument, " + string);
                System.exit(5);
                continue;
            }
            if (string.equalsIgnoreCase(PORTNAME_ARG)) {
                if (UpdateExpressPorts.isValidCmdLineArg(PORTNAME_ARG, portName = stringArray[++i])) continue;
                System.err.println("Error: Invalid value, " + portName + ", supplied for argument, " + string);
                System.exit(5);
                continue;
            }
            if (string.equalsIgnoreCase(PORTVALUE_ARG)) {
                if (UpdateExpressPorts.isValidCmdLineArg(PORTVALUE_ARG, portValue = stringArray[++i])) continue;
                System.err.println("Error: Invalid value, " + portValue + ", supplied for argument, " + string);
                System.exit(5);
                continue;
            }
            if (string.equalsIgnoreCase(PORTCONNTYPE_ARG)) {
                if (UpdateExpressPorts.isValidCmdLineArg(PORTCONNTYPE_ARG, portConnType = stringArray[++i])) continue;
                System.err.println("Error: Invalid value, " + portConnType + ", supplied for argument, " + string);
                System.exit(5);
                continue;
            }
            if (string.equalsIgnoreCase(SERVER_ARG)) {
                server = stringArray[++i];
                continue;
            }
            if (string.equalsIgnoreCase(VHOSTALIAS_ARG)) {
                if (UpdateExpressPorts.isValidCmdLineArg(VHOSTALIAS_ARG, vhostAlias = stringArray[++i])) continue;
                System.err.println("Error: Invalid value, " + vhostAlias + ", supplied for argument, " + string);
                System.exit(5);
                continue;
            }
            if (string.equalsIgnoreCase(VHOSTNAME_ARG)) {
                if (UpdateExpressPorts.isValidCmdLineArg(VHOSTNAME_ARG, vhostName = stringArray[++i])) continue;
                System.err.println("Error: Invalid value, " + vhostName + ", supplied for argument, " + string);
                System.exit(5);
                continue;
            }
            if (string.equalsIgnoreCase(REMOVEADMINPORTS_ARG)) {
                removeAdminPorts = true;
                portType = PORT_TYPE_HTTP;
                portName = null;
                portValue = null;
                portConnType = null;
                server = null;
                vhostAlias = null;
                vhostName = null;
                continue;
            }
            System.err.println("Error: Invalid argument, " + string);
            System.exit(4);
        }
    }

    private static void setFilesToUpdate() {
        if (portType != null) {
            if (portType.equalsIgnoreCase(PORT_TYPE_SOAP)) {
                if (portName != null && portName.equalsIgnoreCase(PORT_NAME_SOAP) && portValue != null) {
                    updateServerIndexXml = true;
                } else {
                    UpdateExpressPorts.errorWrongArgs();
                }
            } else if (portType.equalsIgnoreCase(PORT_TYPE_BOOTSTRAP)) {
                if (portName != null && portName.equalsIgnoreCase(PORT_NAME_BOOTSTRAP) && portValue != null) {
                    updateServerIndexXml = true;
                } else {
                    UpdateExpressPorts.errorWrongArgs();
                }
            } else if (portType.equalsIgnoreCase(PORT_TYPE_WSADMIN)) {
                if (portConnType != null && portValue != null) {
                    updateWsAdminProps = true;
                } else {
                    UpdateExpressPorts.errorWrongArgs();
                }
            } else if (portType.equalsIgnoreCase(PORT_TYPE_HTTP)) {
                if (removeAdminPorts) {
                    updateServerXml = true;
                    updateVirtualHostsXml = true;
                } else if (portName != null && vhostAlias != null && portValue != null && server != null) {
                    updateServerXml = true;
                    updateVirtualHostsXml = true;
                } else {
                    System.out.println("no files to update");
                    UpdateExpressPorts.errorWrongArgs();
                }
            }
        } else {
            UpdateExpressPorts.errorWrongArgs();
        }
    }

    private static void errorWrongArgs() {
        if (portType != null) {
            System.err.println("Error: Wrong arguments specified for portType, " + portType + ".");
            if (portType.equalsIgnoreCase(PORT_TYPE_BOOTSTRAP) || portType.equalsIgnoreCase(PORT_TYPE_SOAP)) {
                if (portName != null) {
                    System.err.println("portName: " + portName);
                } else {
                    System.err.println("portName: Not specified");
                }
                if (portValue != null) {
                    System.err.println("portValue: " + portValue);
                } else {
                    System.err.println("portValue: Not specified");
                }
            } else if (portType.equalsIgnoreCase(PORT_TYPE_WSADMIN)) {
                if (portConnType != null) {
                    System.err.println("portConnType: " + portConnType);
                } else {
                    System.err.println("portConnType: Not specified");
                }
                if (portValue != null) {
                    System.err.println("portValue: " + portValue);
                } else {
                    System.err.println("portValue: Not specified");
                }
            } else if (portType.equalsIgnoreCase(PORT_TYPE_HTTP)) {
                if (server != null) {
                    System.err.println("server: " + server);
                } else {
                    System.err.println("server: Not specified");
                }
                if (portName != null) {
                    System.err.println("portName: " + portName);
                } else {
                    System.err.println("portName: Not specified");
                }
                if (vhostAlias != null) {
                    System.err.println("vhostAlias: " + vhostAlias);
                } else {
                    System.err.println("vhostAlias: Not specified");
                }
                if (portValue != null) {
                    System.err.println("portValue: " + portValue);
                } else {
                    System.err.println("portValue: Not specified");
                }
                if (removeAdminPorts) {
                    if (vhostName != null) {
                        System.err.println("vhostName: " + vhostName);
                    } else {
                        System.err.println("vhostName: Not specified");
                    }
                    System.err.println("removeAdminPorts: " + removeAdminPorts);
                }
            }
        } else {
            System.err.println("No portType specified");
        }
        System.exit(6);
    }

    private static boolean isValidCmdLineArg(String string, String string2) {
        if (string.equalsIgnoreCase(PORTTYPE_ARG) && (string2.equalsIgnoreCase(PORT_TYPE_BOOTSTRAP) || string2.equalsIgnoreCase(PORT_TYPE_HTTP) || string2.equalsIgnoreCase(PORT_TYPE_SOAP) || string2.equalsIgnoreCase(PORT_TYPE_WSADMIN))) {
            return true;
        }
        if (string.equalsIgnoreCase(PORTNAME_ARG) && (string2.equalsIgnoreCase(PORT_NAME_BOOTSTRAP) || string2.startsWith(PORT_NAME_HTTP) || string2.equalsIgnoreCase(PORT_NAME_SOAP))) {
            return true;
        }
        if (string.equalsIgnoreCase(PORTVALUE_ARG)) {
            try {
                new Integer(string2);
                int n = Integer.parseInt(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (string.equalsIgnoreCase(PORTCONNTYPE_ARG) && (string2.equalsIgnoreCase("rmi") || string2.equalsIgnoreCase(PORT_TYPE_SOAP))) {
            return true;
        }
        if (string.equalsIgnoreCase(VHOSTALIAS_ARG) && string2.startsWith(PORT_NAME_VHOSTALIAS)) {
            return true;
        }
        return string.equalsIgnoreCase(VHOSTNAME_ARG) && string2.startsWith(PORT_NAME_VHOST);
    }

    public static Reader loadFile(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringWriter stringWriter = new StringWriter();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringWriter.write(string + "\r\n");
        }
        StringReader stringReader = new StringReader(stringWriter.toString());
        return stringReader;
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("  UpdateExpressPorts -portType soap  -portName SOAP_CONNECTOR_ADDRESS -portValue xxxx");
        System.out.println("  UpdateExpressPorts -portType bootstrap  -portName BOOTSTRAP_ADDRESS -portValue yyyy");
        System.out.println("  UpdateExpressPorts -portType wsadmin   -portConnType soap -portValue xxxx");
        System.out.println("  UpdateExpressPorts -portType wsadmin   -portConnType rmi -portValue yyyy");
        System.out.println("  UpdateExpressPorts -portType http -server server1 -portName HTTPTransport_1 -vhostAlias HostAlias_1 -portValue zzzz");
        System.out.println("  UpdateExpressPorts -portType http -server server1 -portName HTTPTransport_2 -vhostAlias HostAlias_3 -portValue aaaa");
        System.out.println("  UpdateExpressPorts -removeAdminPorts");
    }

    public static void dump() {
        System.out.println("currentValues");
        System.out.println("portType, portName, portValue, portConnType, server, vhostAlias, vhostName, removeAdminPorts, updateServerXml, updateServerIndexXml, updateVirtualHostsXml, updateWsAdminProps:");
        System.out.println(portType + ", " + portName + ", " + portValue + ", " + portConnType + ", " + server + ", " + vhostAlias + ", " + vhostName + ", " + removeAdminPorts + ", " + updateServerXml + ", " + updateServerIndexXml + ", " + updateVirtualHostsXml + ", " + updateWsAdminProps);
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("was.root");
        if (string == null) {
            System.err.println("Error: Could not determine WAS_HOME");
            System.exit(-1);
        }
        if (stringArray.length < 1) {
            UpdateExpressPorts.usage();
            System.exit(-1);
        }
        UpdateExpressPorts.parseCmdLine(stringArray);
        UpdateExpressPorts.setFilesToUpdate();
        UpdateExpressPorts updateExpressPorts = new UpdateExpressPorts();
        if (updateServerXml && updateVirtualHostsXml && removeAdminPorts) {
            server = "server1";
            portName = "HTTPTransport_3";
            UpdateExpressPorts.changePortsXml(string + "/config/cells/DefaultNode/nodes/DefaultNode/servers/" + server + "/" + SERVER_XML);
            portName = "HTTPTransport_4";
            UpdateExpressPorts.changePortsXml(string + "/config/cells/DefaultNode/nodes/DefaultNode/servers/" + server + "/" + SERVER_XML);
            vhostName = "VirtualHost_2";
            UpdateExpressPorts.changePortsXml(string + "/config/cells/DefaultNode/" + VIRTUALHOSTS_XML);
        } else if (updateServerXml && updateVirtualHostsXml) {
            UpdateExpressPorts.changePortsXml(string + "/config/cells/DefaultNode/nodes/DefaultNode/servers/" + server + "/" + SERVER_XML);
            UpdateExpressPorts.changePortsXml(string + "/config/cells/DefaultNode/" + VIRTUALHOSTS_XML);
        } else if (updateServerIndexXml) {
            UpdateExpressPorts.changePortsXml(string + "/config/cells/DefaultNode/nodes/DefaultNode/" + SERVERINDEX_XML);
        } else if (updateWsAdminProps) {
            UpdateExpressPorts.changePortsProp(string + "/properties/" + WSADMIN_PROPS);
        } else {
            System.err.println("Could not determine which config file needs to be updated");
            System.exit(99);
        }
    }
}

