/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import java.lang.reflect.Array;
import java.text.NumberFormat;
import java.text.ParseException;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.Trace;

public class TypeConverter {
    static Object[] convertObjectArray(Class[] classArray, Object[] objectArray) throws IllegalArgumentException {
        if (classArray.length != objectArray.length) {
            throw new IllegalArgumentException(ResourceHandler.getMessage("com.method.argCountInvalid"));
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = TypeConverter.convertObject(classArray[i], objectArray[i]);
        }
        return objectArray2;
    }

    public static Object convertObject(Class clazz, Object object) throws IllegalArgumentException {
        if (object == null) {
            return object;
        }
        Class<?> clazz2 = object.getClass();
        Trace.msgLiveConnectPrintln("com.field.needsConversion", new Object[]{clazz2.getName(), clazz.getName()});
        if (clazz.isAssignableFrom(clazz2)) {
            return object;
        }
        if (clazz == String.class) {
            if (object instanceof Number) {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                try {
                    return numberFormat.parse(object.toString()).toString();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return object.toString();
        }
        if (clazz.isArray()) {
            if (clazz2.isArray()) {
                Class<?> clazz3 = clazz.getComponentType();
                int n = Array.getLength(object);
                Object object2 = Array.newInstance(clazz3, n);
                for (int i = 0; i < n; ++i) {
                    Array.set(object2, i, TypeConverter.convertObject(clazz3, Array.get(object, i)));
                }
                return object2;
            }
        } else if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean") || string.equals("java.lang.Boolean")) {
                return new Boolean(object.toString());
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                if (string.equals("byte") || string.equals("java.lang.Byte")) {
                    return new Byte(number.byteValue());
                }
                if (string.equals("short") || string.equals("java.lang.Short")) {
                    return new Short(number.shortValue());
                }
                if (string.equals("int") || string.equals("java.lang.Integer")) {
                    return new Integer(number.intValue());
                }
                if (string.equals("long") || string.equals("java.lang.Long")) {
                    return new Long(number.longValue());
                }
                if (string.equals("float") || string.equals("java.lang.Float")) {
                    return new Float(number.floatValue());
                }
                if (string.equals("double") || string.equals("java.lang.Double")) {
                    return new Double(number.doubleValue());
                }
                if (string.equals("char") || string.equals("java.lang.Character")) {
                    return new Character((char)number.shortValue());
                }
                return object;
            }
            return object;
        }
        throw new IllegalArgumentException(clazz2.getName() + ResourceHandler.getMessage("com.field.typeInvalid") + clazz.getName());
    }
}

