/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import sun.plugin.com.BeanClass;
import sun.plugin.com.Utils;
import sun.plugin.com.event.COMEventListener;

public class COMEventHandler
implements COMEventListener {
    private int handle;
    private BeanClass bClass;
    private static final String propertyChange = "propertyChange";
    private static final String vetoableChange = "vetoableChange";

    COMEventHandler(int n, BeanClass beanClass) {
        this.handle = n;
        this.bClass = beanClass;
    }

    public void notify(Object object, Method method) throws Throwable {
        if (method.getName().equals(propertyChange)) {
            this.propertyChangeHandler((PropertyChangeEvent)object);
        } else if (method.getName().equals(vetoableChange)) {
            this.vetoableChangeHandler((PropertyChangeEvent)object);
        }
        int n = this.bClass.getEventId(method.getName());
        if (n != -1) {
            this.notifyEvent(this.handle, n, object, method);
        }
    }

    private void notifyEvent(int n, int n2, Object object, Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        Object object2 = Utils.convertReturn(classArray[0], object);
        this.nativeNotifyEvent(n, n2, new Object[]{object2});
    }

    private void propertyChangeHandler(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        int n = this.bClass.getPropertyId(string);
        if (n != -1) {
            this.nativeNotifyProperty(this.handle, n);
        }
    }

    private void vetoableChangeHandler(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = propertyChangeEvent.getPropertyName();
        boolean bl = true;
        int n = this.bClass.getPropertyId(string);
        if (n != -1 && !this.nativeNotifyVetoable(this.handle, n)) {
            throw new PropertyVetoException(string, propertyChangeEvent);
        }
    }

    private native boolean nativeNotifyVetoable(int var1, int var2);

    private native void nativeNotifyProperty(int var1, int var2);

    private native void nativeNotifyEvent(int var1, int var2, Object[] var3);
}

