/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.client.PmiClient;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import java.util.ArrayList;
import javax.management.ObjectName;

public class PmiClientTest
implements PmiConstants {
    static PmiClient pmiClnt = null;
    static String nodeName = null;
    static String serverName = null;
    static String portNumber = null;
    static String connectorType = null;
    static boolean success = true;

    public static void main(String[] stringArray) {
        try {
            Object[] objectArray;
            if (stringArray.length < 1) {
                System.out.println("Parameters: host [portNumber] [connectorType] [serverName]");
                return;
            }
            nodeName = stringArray[0];
            if (stringArray.length > 1) {
                portNumber = stringArray[1];
            }
            if (stringArray.length > 2) {
                connectorType = stringArray[2];
            }
            pmiClnt = new PmiClient(nodeName, portNumber, "WAS50", false, connectorType);
            PerfDescriptor[] perfDescriptorArray = pmiClnt.listNodes();
            nodeName = perfDescriptorArray[0].getNodeName();
            System.out.println("use node " + nodeName);
            if (stringArray.length == 4) {
                serverName = stringArray[3];
            } else {
                objectArray = pmiClnt.listServers(nodeName);
                if (objectArray == null || objectArray.length == 0) {
                    System.out.println("No server is found on node " + nodeName);
                    System.exit(1);
                }
                serverName = objectArray[0].getName();
                System.out.println("Choose server " + serverName);
            }
            objectArray = pmiClnt.listMBeans(nodeName, serverName);
            PerfDescriptor perfDescriptor = null;
            PerfDescriptor perfDescriptor2 = null;
            PerfDescriptor perfDescriptor3 = null;
            PerfDescriptor perfDescriptor4 = null;
            PerfDescriptor perfDescriptor5 = null;
            ArrayList<PerfDescriptor> arrayList = new ArrayList<PerfDescriptor>(10);
            if (objectArray != null) {
                String string;
                System.out.println("Number of MBeans retrieved= " + objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    PerfDescriptor perfDescriptor6 = objectArray[i];
                    string = perfDescriptor6.getKeyProperty("type");
                    if (string != null && string.equals("Server")) {
                        perfDescriptor2 = perfDescriptor6;
                        continue;
                    }
                    if (string != null && string.equals("Perf")) {
                        perfDescriptor = perfDescriptor6;
                        continue;
                    }
                    if (string != null && string.equals("WLM")) {
                        perfDescriptor3 = perfDescriptor6;
                        continue;
                    }
                    if (string != null && string.equals("EntityBean")) {
                        perfDescriptor4 = perfDescriptor6;
                        arrayList.add(perfDescriptor4);
                        continue;
                    }
                    if (string == null || !string.equals("JVM")) continue;
                    perfDescriptor5 = perfDescriptor6;
                }
                PmiClientTest.testSetLevel(perfDescriptor2);
                PmiClientTest.testGetStats(arrayList);
                PmiClientTest.testGetStats2(new ObjectName[]{perfDescriptor5, perfDescriptor4});
                StatDescriptor statDescriptor = new StatDescriptor(new String[]{"wlmModule.server"});
                string = new MBeanStatDescriptor((ObjectName)perfDescriptor3, statDescriptor);
                Stats stats = pmiClnt.getStats(nodeName, serverName, (MBeanStatDescriptor)string, false);
                if (stats != null) {
                    System.out.println("\n\n WLM server data\n\n + " + stats.toString());
                } else {
                    System.out.println("\n\n No WLM server data is availalbe.");
                }
                PmiClientTest.testListStatMembers((ObjectName)perfDescriptor2);
                PmiClientTest.testUpdate((ObjectName)perfDescriptor5, false, true);
            } else {
                System.out.println("No ObjectNames returned from Query");
            }
        }
        catch (Exception exception) {
            new AdminException((Throwable)exception).printStackTrace();
            System.out.println("Exception = " + exception);
            exception.printStackTrace();
            success = false;
        }
        if (success) {
            System.out.println("\n\n All tests are passed");
        } else {
            System.out.println("\n\n Some tests are failed. Check for the exceptions");
        }
    }

    private static MBeanStatDescriptor[] getMBeanStatDescriptor(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        MBeanStatDescriptor[] mBeanStatDescriptorArray = new MBeanStatDescriptor[arrayList.size()];
        for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
            mBeanStatDescriptorArray[i] = arrayList.get(i) instanceof ObjectName ? new MBeanStatDescriptor((ObjectName)arrayList.get(i)) : (MBeanStatDescriptor)arrayList.get(i);
        }
        return mBeanStatDescriptorArray;
    }

    private static void processStats(Stats stats) {
        PmiClientTest.processStats(stats, "");
    }

    private static void processStats(Stats stats, String string) {
        Stats[] statsArray;
        if (stats == null) {
            return;
        }
        System.out.println("\n\n");
        String string2 = stats.getName();
        System.out.println(string + "stats name=" + string2);
        com.ibm.websphere.management.statistics.Statistic[] statisticArray = stats.getStatistics();
        Statistic[] statisticArray2 = (Statistic[])statisticArray;
        if (statisticArray2 != null) {
            for (int i = 0; i < statisticArray2.length; ++i) {
                TimeStatisticImpl timeStatisticImpl;
                System.out.print(string + "    " + "data name=" + PmiClient.getNLSValue(statisticArray2[i].getName()) + ", description=" + PmiClient.getNLSValue(statisticArray2[i].getDescription()) + ", unit=" + PmiClient.getNLSValue(statisticArray2[i].getUnit()) + ", startTime=" + statisticArray2[i].getStartTime() + ", lastSampleTime=" + statisticArray2[i].getLastSampleTime());
                if (statisticArray2[i].getDataInfo().getType() == 2) {
                    System.out.println(", count=" + ((CountStatisticImpl)statisticArray2[i]).getCount());
                    continue;
                }
                if (statisticArray2[i].getDataInfo().getType() == 4) {
                    timeStatisticImpl = (TimeStatisticImpl)statisticArray2[i];
                    System.out.println(", count=" + timeStatisticImpl.getCount() + ", total=" + timeStatisticImpl.getTotal() + ", mean=" + timeStatisticImpl.getMean() + ", min=" + timeStatisticImpl.getMin() + ", max=" + timeStatisticImpl.getMax());
                    continue;
                }
                if (statisticArray2[i].getDataInfo().getType() != 5) continue;
                timeStatisticImpl = (RangeStatisticImpl)statisticArray2[i];
                System.out.println(", current=" + timeStatisticImpl.getCurrent() + ", lowWaterMark=" + timeStatisticImpl.getLowWaterMark() + ", highWaterMark=" + timeStatisticImpl.getHighWaterMark() + ", integral=" + timeStatisticImpl.getIntegral() + ", avg=" + timeStatisticImpl.getMean());
            }
        }
        if ((statsArray = stats.getSubStats()) == null || statsArray.length == 0) {
            return;
        }
        for (int i = 0; i < statsArray.length; ++i) {
            PmiClientTest.processStats(statsArray[i], string + "    ");
        }
    }

    private static void testSetLevel(ObjectName objectName) {
        System.out.println("\n\n testSetLevel\n\n");
        try {
            MBeanLevelSpec mBeanLevelSpec = new MBeanLevelSpec(objectName, null, 7);
            pmiClnt.setStatLevel(nodeName, serverName, mBeanLevelSpec, true);
            System.out.println("after setInstrumentaionLevel high on server MBean\n\n");
            MBeanLevelSpec[] mBeanLevelSpecArray = pmiClnt.getStatLevel(nodeName, serverName, objectName, true);
            if (mBeanLevelSpecArray == null) {
                System.out.println("error: null from getInstrumentationLevel");
            } else {
                for (int i = 0; i < mBeanLevelSpecArray.length; ++i) {
                    if (mBeanLevelSpecArray[i] == null) continue;
                    int n = mBeanLevelSpecArray[i].getLevel();
                    ObjectName objectName2 = mBeanLevelSpecArray[i].getObjectName();
                    StatDescriptor statDescriptor = mBeanLevelSpecArray[i].getStatDescriptor();
                }
            }
        }
        catch (Exception exception) {
            new AdminException((Throwable)exception).printStackTrace();
            exception.printStackTrace();
            System.out.println("Exception in testLevel");
            success = false;
        }
    }

    private static void testListStatMembers(ObjectName objectName) {
        System.out.println("\n\ntestListStatMembers \n");
        try {
            MBeanStatDescriptor[] mBeanStatDescriptorArray;
            int n;
            MBeanStatDescriptor[] mBeanStatDescriptorArray2 = pmiClnt.listStatMembers(nodeName, serverName, objectName);
            if (mBeanStatDescriptorArray2 == null) {
                return;
            }
            System.out.println(" listStatMembers for server MBean, num members (i.e. top level modules) is " + mBeanStatDescriptorArray2.length);
            for (n = 0; n < mBeanStatDescriptorArray2.length; ++n) {
                if (mBeanStatDescriptorArray2[n] == null) continue;
                mBeanStatDescriptorArray = mBeanStatDescriptorArray2[n].getObjectName();
                StatDescriptor statDescriptor = mBeanStatDescriptorArray2[n].getStatDescriptor();
            }
            for (n = 0; n < mBeanStatDescriptorArray2.length; ++n) {
                if (mBeanStatDescriptorArray2[n] == null) continue;
                System.out.println("\n\nlistStatMembers for msd=" + mBeanStatDescriptorArray2[n].toString());
                mBeanStatDescriptorArray = pmiClnt.listStatMembers(nodeName, serverName, mBeanStatDescriptorArray2[n]);
            }
        }
        catch (Exception exception) {
            new AdminException((Throwable)exception).printStackTrace();
            exception.printStackTrace();
            System.out.println("Exception in testListStatMembers");
            success = false;
        }
    }

    private static void testGetStats(ArrayList arrayList) {
        System.out.println("\n\n testgetStats\n\n");
        try {
            Stats[] statsArray = pmiClnt.getStats(nodeName, serverName, PmiClientTest.getMBeanStatDescriptor(arrayList), true);
            if (statsArray == null) {
                return;
            }
            for (int i = 0; i < statsArray.length; ++i) {
                PmiClientTest.processStats(statsArray[i]);
            }
        }
        catch (Exception exception) {
            new AdminException((Throwable)exception).printStackTrace();
            exception.printStackTrace();
            System.out.println("exception from testGetStats");
            success = false;
        }
    }

    private static void testGetStats2(ObjectName[] objectNameArray) {
        System.out.println("\n\n testGetStats2\n\n");
        try {
            Stats[] statsArray = pmiClnt.getStats(nodeName, serverName, objectNameArray, true);
            if (statsArray != null) {
                for (int i = 0; i < statsArray.length; ++i) {
                    if (statsArray[i] == null) continue;
                    System.out.println(statsArray[i].toString());
                }
            } else {
                System.out.println("null stat");
            }
        }
        catch (Exception exception) {
            new AdminException((Throwable)exception).printStackTrace();
            exception.printStackTrace();
            System.out.println("exception from testGetStats2");
            success = false;
        }
    }

    private static void testUpdate(ObjectName objectName, boolean bl, boolean bl2) {
        System.out.println("\n\n testUpdate\n\n");
        try {
            MBeanLevelSpec mBeanLevelSpec = new MBeanLevelSpec(objectName, null, 0);
            pmiClnt.setStatLevel(nodeName, serverName, mBeanLevelSpec, true);
            Stats stats = pmiClnt.getStats(nodeName, serverName, objectName, false);
            Stats stats2 = pmiClnt.getStats(nodeName, serverName, objectName, true);
            mBeanLevelSpec = new MBeanLevelSpec(objectName, null, 7);
            pmiClnt.setStatLevel(nodeName, serverName, mBeanLevelSpec, true);
            Stats stats3 = pmiClnt.getStats(nodeName, serverName, objectName, true);
            System.out.println("\n\n stats3 is");
            PmiClientTest.processStats(stats3);
            stats.update(stats3, bl, bl2);
            System.out.println("\n\n update stats1");
            PmiClientTest.processStats(stats);
            stats2.update(stats3, bl, bl2);
            System.out.println("\n\n update stats2");
            PmiClientTest.processStats(stats2);
        }
        catch (Exception exception) {
            System.out.println("\n\n Exception in testUpdate");
            exception.printStackTrace();
            success = false;
        }
    }
}

