/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.client.CpdCollection;
import com.ibm.websphere.pmi.client.CpdData;
import com.ibm.websphere.pmi.client.CpdLoad;
import com.ibm.websphere.pmi.client.CpdStat;
import com.ibm.websphere.pmi.client.CpdValue;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.client.PerfDescriptorList;
import com.ibm.websphere.pmi.client.PmiClient;

public class PmiTester
implements PmiConstants {
    public static void main(String[] stringArray) {
        String string = null;
        String string2 = "2809";
        String string3 = "RMI";
        String string4 = "WAS50";
        if (stringArray.length < 1) {
            System.out.println("Usage: <host> [<port>] [<connectorType>] [<version>]");
            return;
        }
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        if (stringArray.length >= 3) {
            string3 = stringArray[2];
        }
        if (stringArray.length >= 4) {
            string4 = stringArray[3];
        }
        try {
            int n;
            PmiClient pmiClient = new PmiClient(string, string2, string4, false, string3);
            PerfDescriptor[] perfDescriptorArray = pmiClient.listNodes();
            if (perfDescriptorArray == null) {
                System.out.println("no nodes");
                return;
            }
            String string5 = perfDescriptorArray[0].getName();
            System.out.println("after listNodes: " + string5);
            PerfDescriptor[] perfDescriptorArray2 = pmiClient.listServers(perfDescriptorArray[0].getName());
            if (perfDescriptorArray2 == null || perfDescriptorArray2.length == 0) {
                System.out.println("NO app server in node");
                return;
            }
            for (n = 0; n < perfDescriptorArray2.length; ++n) {
                System.out.println("server " + n + ": " + perfDescriptorArray2[n].getName());
            }
            for (n = 0; n < perfDescriptorArray2.length; ++n) {
                int n2;
                System.out.println("server " + n + ": " + perfDescriptorArray2[n].getName());
                PerfDescriptor[] perfDescriptorArray3 = pmiClient.listMembers(perfDescriptorArray2[n]);
                if (perfDescriptorArray3 == null) {
                    System.out.println("null from listMembers");
                    continue;
                }
                PerfDescriptorList perfDescriptorList = new PerfDescriptorList();
                for (int i = 0; i < perfDescriptorArray3.length; ++i) {
                    System.out.println("add to pdList: " + perfDescriptorArray3[i].getModuleName());
                    perfDescriptorList.addDescriptor(perfDescriptorArray3[i]);
                    if (i % 2 != 0) continue;
                    pmiClient.add(perfDescriptorArray3[i]);
                }
                CpdCollection[] cpdCollectionArray = pmiClient.gets(perfDescriptorList, true);
                if (cpdCollectionArray == null) {
                    if (pmiClient.getErrorCode() <= 0) continue;
                    System.out.println(pmiClient.getErrorMessage());
                    continue;
                }
                for (n2 = 0; n2 < cpdCollectionArray.length; ++n2) {
                    PmiTester.processCpdCollection(cpdCollectionArray[n2], "");
                }
                System.out.println("\n\n\n ---- get data using gets(true) ----- ");
                cpdCollectionArray = pmiClient.gets(true);
                if (cpdCollectionArray == null) {
                    if (pmiClient.getErrorCode() <= 0) continue;
                    System.out.println(pmiClient.getErrorMessage());
                    continue;
                }
                for (n2 = 0; n2 < cpdCollectionArray.length; ++n2) {
                    System.out.println(cpdCollectionArray[n2].toString());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception calling CollectorAE");
            exception.printStackTrace();
        }
    }

    private static void processCpdCollection(CpdCollection cpdCollection, String string) {
        CpdData[] cpdDataArray = cpdCollection.dataMembers();
        String string2 = string;
        System.out.println("\n" + string2 + "--- CpdCollection " + cpdCollection.getDescriptor().getName() + " ---");
        string2 = string2 + "   ";
        for (int i = 0; i < cpdDataArray.length; ++i) {
            double d;
            CpdValue cpdValue;
            if (cpdDataArray[i] == null) continue;
            PmiDataInfo pmiDataInfo = cpdDataArray[i].getPmiDataInfo();
            CpdValue cpdValue2 = cpdDataArray[i].getValue();
            if (cpdValue2.getType() == 4) {
                cpdValue = (CpdStat)cpdValue2;
                double d2 = cpdValue.mean();
                d = cpdValue.sumSquares();
                int n = cpdValue.count();
                double d3 = cpdValue.total();
                System.out.println(string2 + "CpdData id=" + cpdDataArray[i].getId() + " type=stat mean=" + d2);
                continue;
            }
            if (cpdValue2.getType() == 5) {
                cpdValue = (CpdLoad)cpdValue2;
                long l = cpdValue.getTime();
                d = cpdValue.mean();
                double d4 = cpdValue.getCurrentLevel();
                double d5 = cpdValue.getIntegral();
                double d6 = cpdValue.getWeight();
                System.out.println(string2 + "CpdData id=" + cpdDataArray[i].getId() + " type=load mean=" + d + " currentLevel=" + d4);
                continue;
            }
            if (cpdValue2.getType() == 2) {
                cpdValue = cpdValue2;
                long l = (long)cpdValue.getValue();
                System.out.println(string2 + "CpdData id=" + cpdDataArray[i].getId() + " type=long value=" + l);
                continue;
            }
            if (cpdValue2.getType() == 3) {
                cpdValue = cpdValue2;
                double d7 = cpdValue.getValue();
                System.out.println(string2 + "CpdData id=" + cpdDataArray[i].getId() + " type=double value=" + d7);
                continue;
            }
            if (cpdValue2.getType() != 1) continue;
            cpdValue = cpdValue2;
            int n = (int)cpdValue.getValue();
            System.out.println(string2 + "CpdData id=" + cpdDataArray[i].getId() + " type=int value=" + n);
        }
        CpdCollection[] cpdCollectionArray = cpdCollection.subcollections();
        for (int i = 0; i < cpdCollectionArray.length; ++i) {
            PmiTester.processCpdCollection(cpdCollectionArray[i], string2);
        }
    }

    private static void report(CpdCollection cpdCollection) {
        CpdCollection[] cpdCollectionArray;
        System.out.println("\n\n");
        if (cpdCollection == null) {
            System.out.println("report: null CpdCollection");
            return;
        }
        System.out.println("report - CpdCollection ");
        PmiTester.printPD(cpdCollection.getDescriptor());
        CpdData[] cpdDataArray = cpdCollection.dataMembers();
        if (cpdDataArray != null) {
            System.out.println("report CpdCollection: dataMembers is " + cpdDataArray.length);
            for (int i = 0; i < cpdDataArray.length; ++i) {
                CpdData cpdData = cpdDataArray[i];
                PmiTester.printPD(cpdData.getDescriptor());
            }
        }
        if ((cpdCollectionArray = cpdCollection.subcollections()) != null) {
            for (int i = 0; i < cpdCollectionArray.length; ++i) {
                PmiTester.report(cpdCollectionArray[i]);
            }
        }
    }

    private static void printPD(PerfDescriptor perfDescriptor) {
        System.out.println(perfDescriptor.getFullName());
    }
}

