/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import java.util.HashMap;

public class wsStatsUtil {
    private static NLS defaultNLS;
    private static HashMap translatedConfigMap;
    private static boolean debug;

    /*
     * Enabled aggressive block sorting
     */
    public static PmiModuleConfig getNLSConfig(PmiModuleConfig pmiModuleConfig) {
        String string;
        if (pmiModuleConfig == null) {
            return null;
        }
        PmiModuleConfig pmiModuleConfig2 = (PmiModuleConfig)translatedConfigMap.get(pmiModuleConfig.getShortName());
        if (pmiModuleConfig2 != null) {
            if (!debug) return pmiModuleConfig2;
            System.out.println("[wsStatsUtil] getNLSConfig(): Config cache hit " + pmiModuleConfig.getShortName());
            return pmiModuleConfig2;
        }
        if (debug) {
            System.out.println("[wsStatsUtil] getNLSConfig(): Config cache miss " + pmiModuleConfig.getShortName());
        }
        if ((string = pmiModuleConfig.getResourceBundle()) != null) {
            NLS nLS = new NLS(string, true);
            if (nLS != null) {
                pmiModuleConfig2 = wsStatsUtil.translate(pmiModuleConfig, nLS);
                translatedConfigMap.put(pmiModuleConfig.getShortName(), pmiModuleConfig2);
                return pmiModuleConfig2;
            }
            if (!debug) return pmiModuleConfig;
            System.out.println("[wsStatsUtil] getNLSConfig(): Error loading resource bundle " + string);
            return pmiModuleConfig;
        }
        if (defaultNLS == null) {
            defaultNLS = new NLS("com.ibm.websphere.pmi.property.pmi", true);
            if (defaultNLS != null) return pmiModuleConfig2;
            if (!debug) return pmiModuleConfig;
            System.out.println("[wsStatsUtil] getNLSConfig(): Error loading default resource bundle com.ibm.websphere.pmi.property.pmi");
            return pmiModuleConfig;
        }
        pmiModuleConfig2 = wsStatsUtil.translate(pmiModuleConfig, defaultNLS);
        translatedConfigMap.put(pmiModuleConfig.getShortName(), pmiModuleConfig2);
        return pmiModuleConfig2;
    }

    private static PmiModuleConfig translate(PmiModuleConfig pmiModuleConfig, NLS nLS) {
        pmiModuleConfig.setDescription(nLS.getString(pmiModuleConfig.getDescription(), pmiModuleConfig.getDescription()));
        PmiDataInfo[] pmiDataInfoArray = pmiModuleConfig.listAllData();
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            pmiDataInfoArray[i].setName(nLS.getString(pmiDataInfoArray[i].getName(), pmiDataInfoArray[i].getName()));
            pmiDataInfoArray[i].setDescription(nLS.getString(pmiDataInfoArray[i].getDescription(), pmiDataInfoArray[i].getDescription()));
            pmiDataInfoArray[i].setUnit(nLS.getString(pmiDataInfoArray[i].getUnit(), pmiDataInfoArray[i].getUnit()));
        }
        return pmiModuleConfig;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    static {
        translatedConfigMap = new HashMap();
        debug = true;
    }
}

