/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.client;

import com.ibm.websphere.pmi.client.CpdStat;

public class Confidence {
    private static double[] z_table = new double[]{1.282, 1.311, 1.341, 1.372, 1.405, 1.44, 1.476, 1.514, 1.555, 1.598, 1.645, 1.695, 1.751, 1.812, 1.881, 1.96, 2.054, 2.171, 2.326, 2.576};
    private static double[][] t_table = new double[][]{{0.0, -1.0, -1.0, -1.0}, {1.0, 6.314, 12.706, 63.657}, {2.0, 2.92, 4.303, 9.925}, {3.0, 2.353, 3.182, 5.841}, {4.0, 2.132, 2.776, 4.604}, {5.0, 2.015, 2.571, 4.032}, {6.0, 1.943, 2.447, 3.707}, {7.0, 1.895, 2.365, 3.499}, {8.0, 1.86, 2.306, 3.355}, {9.0, 1.833, 2.262, 3.25}, {10.0, 1.812, 2.208, 3.169}, {11.0, 1.796, 2.201, 3.106}, {12.0, 1.782, 2.179, 3.055}, {13.0, 1.771, 2.16, 3.012}, {14.0, 1.761, 2.145, 2.977}, {15.0, 1.753, 2.131, 2.947}, {16.0, 1.746, 2.12, 2.921}, {17.0, 1.74, 2.11, 2.898}, {18.0, 1.734, 2.101, 2.878}, {19.0, 1.729, 2.093, 2.861}, {20.0, 1.725, 2.086, 2.845}, {21.0, 1.721, 2.08, 2.831}, {22.0, 1.717, 2.074, 2.819}, {23.0, 1.714, 2.069, 2.807}, {24.0, 1.711, 2.064, 2.797}, {25.0, 1.708, 2.06, 2.787}, {26.0, 1.706, 2.056, 2.779}, {27.0, 1.703, 2.052, 2.771}, {28.0, 1.701, 2.048, 2.763}, {29.0, 1.699, 2.045, 2.756}, {30.0, 1.697, 2.042, 2.75}};

    private static final double zValue(int n) {
        if (n < 80) {
            n = 80;
        } else if (n > 99) {
            n = 99;
        }
        return z_table[n - 80];
    }

    private static final double tValue(int n, int n2) {
        double d = n2 <= 90 ? t_table[n - 1][1] : (n2 <= 95 ? t_table[n - 1][2] : t_table[n - 1][3]);
        return d;
    }

    public static final double interval(CpdStat cpdStat, int n) {
        int n2 = cpdStat.count();
        if (n2 < 2) {
            return Double.POSITIVE_INFINITY;
        }
        double d = n2 >= 30 ? Confidence.zValue(n) : Confidence.tValue(n2, n);
        return d * cpdStat.standardDeviation() / Math.sqrt(n2);
    }

    public static final int level(CpdStat cpdStat, int n) {
        if (cpdStat.count() < 30) {
            if (n <= 90) {
                return 90;
            }
            if (n <= 95) {
                return 95;
            }
            return 99;
        }
        if (n <= 80) {
            return 80;
        }
        if (n > 99) {
            return 99;
        }
        return n;
    }
}

