/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.client;

import com.ibm.websphere.pmi.client.CpdCollection;
import com.ibm.websphere.pmi.client.CpdData;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.client.PmiClient;
import com.ibm.websphere.pmi.client.event.CpdEvent;
import com.ibm.websphere.pmi.client.event.CpdEventSender;
import com.ibm.websphere.pmi.client.event.CpdEventSenderImpl;
import java.util.ArrayList;
import java.util.Iterator;

public class CpdCollectionImpl
extends CpdEventSenderImpl
implements CpdCollection {
    private PerfDescriptor descriptor = null;
    private String description = null;
    private ArrayList members = new ArrayList();
    private ArrayList subgroups = new ArrayList();
    private CpdCollection parent = null;
    private int instrumentationLevel;
    private boolean preserveSubcollections = false;

    public CpdCollectionImpl(PerfDescriptor perfDescriptor, String string, ArrayList arrayList, ArrayList arrayList2, int n) {
        Iterator iterator;
        if (perfDescriptor == null) {
            System.err.println("ERROR: null pd passed to CpdCollectionImpl");
            this.descriptor = PmiClient.createPerfDescriptor();
        } else {
            this.descriptor = perfDescriptor;
        }
        this.description = string;
        this.instrumentationLevel = n;
        if (arrayList != null) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.addAMember((CpdData)iterator.next());
            }
        }
        if (arrayList2 != null) {
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                this.addACollection((CpdCollection)iterator.next());
            }
        }
    }

    public CpdCollectionImpl(PerfDescriptor perfDescriptor, String string, ArrayList arrayList, int n) {
        if (perfDescriptor == null) {
            System.err.println("ERROR: null pd passed to CpdCollectionImpl");
            this.descriptor = PmiClient.createPerfDescriptor();
        } else {
            this.descriptor = perfDescriptor;
        }
        this.description = string;
        this.instrumentationLevel = n;
        if (arrayList == null) {
            return;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof CpdData) {
                this.addAMember((CpdData)e);
                continue;
            }
            this.addACollection((CpdCollection)e);
        }
    }

    public PerfDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setParent(CpdCollection cpdCollection) {
        this.parent = cpdCollection;
    }

    public CpdCollection getParent() {
        return this.parent;
    }

    public synchronized void reset() {
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            ((CpdData)iterator.next()).reset();
        }
    }

    public int getLevel() {
        return this.instrumentationLevel;
    }

    public int numDataMembers() {
        return this.members.size();
    }

    public CpdData[] dataMembers() {
        CpdData[] cpdDataArray = new CpdData[this.members.size()];
        for (int i = 0; i < cpdDataArray.length; ++i) {
            cpdDataArray[i] = (CpdData)this.members.get(i);
        }
        return cpdDataArray;
    }

    public CpdData getData(int n) {
        return (CpdData)this.members.get(n);
    }

    public CpdData findData(PerfDescriptor perfDescriptor) {
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            CpdData cpdData = (CpdData)iterator.next();
            if (!cpdData.getDescriptor().equals(perfDescriptor)) continue;
            return cpdData;
        }
        return null;
    }

    public int numSubcollections() {
        return this.subgroups.size();
    }

    public CpdCollection[] subcollections() {
        CpdCollection[] cpdCollectionArray = new CpdCollection[this.subgroups.size()];
        for (int i = 0; i < cpdCollectionArray.length; ++i) {
            cpdCollectionArray[i] = (CpdCollection)this.subgroups.get(i);
        }
        return cpdCollectionArray;
    }

    public CpdCollection getSubcollection(int n) {
        return (CpdCollection)this.subgroups.get(n);
    }

    public CpdCollection getSubcollection(String string) {
        for (int i = 0; i < this.subgroups.size(); ++i) {
            CpdCollection cpdCollection = (CpdCollection)this.subgroups.get(i);
            if (!cpdCollection.getDescriptor().getName().equals(string)) continue;
            return cpdCollection;
        }
        return null;
    }

    public void addSubcollection(CpdCollection cpdCollection) {
        this.addACollection(cpdCollection);
        this.notifyListeners(new CpdEvent(cpdCollection, 1));
    }

    private CpdCollection findSubcollection(PerfDescriptor perfDescriptor) {
        String string = this.descriptor.getFullName();
        String string2 = perfDescriptor.getFullName();
        if (!string2.startsWith(string)) {
            return null;
        }
        if (string2.equals(string)) {
            return this;
        }
        String[] stringArray = this.descriptor.getPath();
        String[] stringArray2 = perfDescriptor.getPath();
        int n = stringArray.length == 1 && stringArray[0] == null ? 0 : stringArray.length;
        CpdCollection cpdCollection = this;
        CpdCollection cpdCollection2 = null;
        for (int i = n; i < stringArray2.length; ++i) {
            cpdCollection2 = cpdCollection.getSubcollection(stringArray2[i]);
            if (cpdCollection2 == null) {
                String[] stringArray3 = new String[i + 1];
                for (int j = 0; j <= i; ++j) {
                    stringArray3[j] = stringArray2[j];
                }
                PerfDescriptor perfDescriptor2 = PmiClient.createPerfDescriptor(stringArray3);
                if (perfDescriptor2 == null) {
                    System.out.println("null pd in findSubcollection");
                    return null;
                }
                String string3 = "a data collection";
                if (perfDescriptor2.getType() == 11) {
                    string3 = "a node";
                } else if (perfDescriptor2.getType() == 12) {
                    string3 = "a server";
                }
                cpdCollection2 = new CpdCollectionImpl(perfDescriptor2, string3, null, null, -1);
                cpdCollection.addSubcollection(cpdCollection2);
            }
            cpdCollection = cpdCollection2;
        }
        return cpdCollection2;
    }

    private synchronized void removeSubcollection(CpdCollection[] cpdCollectionArray) {
        if (cpdCollectionArray == null || cpdCollectionArray.length == 0) {
            for (int i = this.subgroups.size() - 1; i >= 0; --i) {
                CpdCollection cpdCollection = (CpdCollection)this.subgroups.get(i);
                this.subgroups.remove(cpdCollection);
                this.notifyListeners(new CpdEvent(cpdCollection, 5));
            }
            this.subgroups = new ArrayList();
            return;
        }
        int n = 0;
        int n2 = 0;
        for (n = this.subgroups.size() - 1; n >= 0; --n) {
            boolean bl = false;
            CpdCollection cpdCollection = (CpdCollection)this.subgroups.get(n);
            for (n2 = 0; n2 < cpdCollectionArray.length; ++n2) {
                CpdCollection cpdCollection2 = cpdCollectionArray[n2];
                int n3 = cpdCollection.getDescriptor().getName().compareTo(cpdCollection2.getDescriptor().getName());
                if (n3 != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.subgroups.remove(cpdCollection);
            this.notifyListeners(new CpdEvent(cpdCollection, 5));
        }
    }

    public synchronized void update(CpdCollection cpdCollection, boolean bl, boolean bl2) {
        if (cpdCollection == null) {
            return;
        }
        PerfDescriptor perfDescriptor = cpdCollection.getDescriptor();
        if (perfDescriptor == null) {
            return;
        }
        String string = this.descriptor.getFullName();
        String string2 = perfDescriptor.getFullName();
        if (!string2.startsWith(string)) {
            System.out.println("WARNING: cannot update because the new CpdCollection is not in the subtree of this collection");
            return;
        }
        if (string2.equals(string)) {
            this.myupdate(cpdCollection, bl, bl2);
            return;
        }
        CpdCollectionImpl cpdCollectionImpl = (CpdCollectionImpl)this.findSubcollection(perfDescriptor);
        cpdCollectionImpl.myupdate(cpdCollection, bl, bl2);
    }

    public synchronized void update(CpdCollection cpdCollection, boolean bl) {
        this.update(cpdCollection, bl, true);
    }

    public synchronized void update(CpdCollection cpdCollection) {
        this.update(cpdCollection, false);
    }

    public synchronized void update(CpdCollection cpdCollection, boolean bl, boolean bl2, boolean bl3) {
        this.preserveSubcollections = bl3;
        this.update(cpdCollection, bl, bl2);
        this.preserveSubcollections = false;
    }

    protected synchronized void myupdate(CpdCollection cpdCollection, boolean bl, boolean bl2) {
        if (cpdCollection == null) {
            return;
        }
        this.instrumentationLevel = cpdCollection.getLevel();
        this.description = cpdCollection.getDescription();
        if (bl) {
            this.updateMembers2(cpdCollection);
        } else {
            this.updateMembers(cpdCollection);
        }
        CpdCollection[] cpdCollectionArray = cpdCollection.subcollections();
        if (!bl && !this.preserveSubcollections) {
            this.removeSubcollection(cpdCollectionArray);
        }
        if (bl2) {
            for (int i = 0; i < cpdCollectionArray.length; ++i) {
                this.update(cpdCollectionArray[i], bl);
            }
        }
    }

    protected synchronized void myupdate(CpdCollection cpdCollection, boolean bl) {
        this.myupdate(cpdCollection, bl, true);
    }

    private void updateMembers(CpdCollection cpdCollection) {
        int n;
        CpdData cpdData;
        CpdData cpdData2;
        boolean bl;
        int n2 = 0;
        int n3 = 0;
        if (cpdCollection.numDataMembers() == 0) {
            for (n2 = this.members.size() - 1; n2 >= 0; --n2) {
                Object e = this.members.remove(n2);
                this.notifyListeners(new CpdEvent((CpdData)e, 4));
            }
            return;
        }
        CpdData[] cpdDataArray = cpdCollection.dataMembers();
        for (n2 = this.members.size() - 1; n2 >= 0; --n2) {
            bl = false;
            cpdData2 = (CpdData)this.members.get(n2);
            for (n3 = 0; n3 < cpdDataArray.length; ++n3) {
                cpdData = cpdDataArray[n3];
                n = cpdData2.getId() - cpdData.getId();
                if (n != 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.members.remove(cpdData2);
            this.notifyListeners(new CpdEvent(cpdData2, 4));
        }
        for (n3 = 0; n3 < cpdDataArray.length; ++n3) {
            bl = false;
            cpdData = cpdDataArray[n3];
            for (n2 = 0; n2 < this.members.size(); ++n2) {
                cpdData2 = (CpdData)this.members.get(n2);
                n = cpdData2.getId() - cpdData.getId();
                if (n == 0) {
                    cpdData2.setValue(cpdData.getValue());
                    cpdData2.setBaseValue(cpdData.getBaseValue());
                    bl = true;
                    break;
                }
                if (n <= 0) continue;
                this.members.add(n2, cpdData);
                cpdData.setParent(this);
                this.notifyListeners(new CpdEvent(cpdData, 0));
                bl = true;
                break;
            }
            if (bl) continue;
            this.members.add(cpdData);
            cpdData.setParent(this);
            this.notifyListeners(new CpdEvent(cpdData, 0));
        }
        this.notifyListeners(new CpdEvent(this, 2));
    }

    private void updateMembers2(CpdCollection cpdCollection) {
        int n = 0;
        int n2 = 0;
        if (cpdCollection.numDataMembers() == 0) {
            return;
        }
        CpdData[] cpdDataArray = cpdCollection.dataMembers();
        while (n < this.members.size() && n2 < cpdDataArray.length) {
            CpdData cpdData = (CpdData)this.members.get(n);
            CpdData cpdData2 = cpdDataArray[n2];
            int n3 = cpdData.getId() - cpdData2.getId();
            if (n3 == 0) {
                cpdData.setValue(cpdData2.getValue());
                cpdData.setBaseValue(cpdData2.getBaseValue());
                ++n;
                ++n2;
                continue;
            }
            if (n3 > 0) {
                this.members.add(n, cpdData2);
                ++n;
                ++n2;
                cpdData2.setParent(this);
                this.notifyListeners(new CpdEvent(cpdData2, 0));
                continue;
            }
            ++n;
        }
        while (n2 < cpdDataArray.length) {
            this.members.add(cpdDataArray[n2]);
            this.notifyListeners(new CpdEvent(cpdDataArray[n2], 0));
            cpdDataArray[n2].setParent(this);
            ++n2;
        }
        this.notifyListeners(new CpdEvent(this, 2));
    }

    public synchronized void addAMember(CpdData cpdData) {
        if (cpdData == null) {
            return;
        }
        for (int i = 0; i < this.members.size(); ++i) {
            CpdData cpdData2 = (CpdData)this.members.get(i);
            int n = cpdData2.getId() - cpdData.getId();
            if (n == 0) {
                return;
            }
            if (n <= 0) continue;
            this.members.add(i, cpdData);
            cpdData.setParent(this);
            return;
        }
        this.members.add(cpdData);
        cpdData.setParent(this);
    }

    private synchronized void addACollection(CpdCollection cpdCollection) {
        if (cpdCollection == null) {
            return;
        }
        for (int i = 0; i < this.subgroups.size(); ++i) {
            CpdCollection cpdCollection2 = (CpdCollection)this.subgroups.get(i);
            String string = cpdCollection2.getDescriptor().getName();
            int n = string.compareTo(cpdCollection.getDescriptor().getName());
            if (n == 0) {
                return;
            }
            if (n <= 0) continue;
            this.subgroups.add(i, cpdCollection);
            ((CpdCollectionImpl)cpdCollection).setParent(this);
            return;
        }
        this.subgroups.add(cpdCollection);
        ((CpdCollectionImpl)cpdCollection).setParent(this);
    }

    public String toXML() {
        return this.toXML("");
    }

    public String toXML(String string) {
        return this.toXML(string, false);
    }

    public String toXML(String string, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string).append("    ");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string).append("<CpdCollection name=\"").append(this.descriptor.getFullName()).append("\" level=\"").append(this.instrumentationLevel).append("\">\n");
        for (n = 0; n < this.numDataMembers(); ++n) {
            stringBuffer2.append(this.getData(n).toXML(stringBuffer.toString(), bl)).append("\n");
        }
        for (n = 0; n < this.numSubcollections(); ++n) {
            stringBuffer2.append(this.getSubcollection(n).toXML(stringBuffer.toString(), bl)).append("\n");
        }
        return stringBuffer2.append(string).append("</CpdCollection>").toString();
    }

    public void fromXML(String string) {
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        CpdEventSender cpdEventSender;
        int n;
        String string2 = string + "  ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("CpdCollection name=");
        stringBuffer.append(this.descriptor.getFullName());
        stringBuffer.append(" description=");
        stringBuffer.append(this.description);
        stringBuffer.append("\n");
        for (n = 0; n < this.members.size(); ++n) {
            cpdEventSender = (CpdData)this.members.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(cpdEventSender.toString());
            stringBuffer.append("\n");
        }
        for (n = 0; n < this.subgroups.size(); ++n) {
            cpdEventSender = (CpdCollection)this.subgroups.get(n);
            stringBuffer.append(cpdEventSender.toString(string2));
        }
        return stringBuffer.toString();
    }
}

