/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.client;

import com.ibm.websphere.pmi.client.CpdLoad;
import com.ibm.websphere.pmi.client.CpdValue;
import com.ibm.ws.pmi.client.CpdValueImpl;
import java.text.NumberFormat;

public class CpdLoadImpl
extends CpdValueImpl
implements CpdLoad {
    protected double currentLevel = 0.0;
    protected double timeWeight = 0.0;
    protected long lowWaterMark = 0L;
    protected long highWaterMark = 0L;
    protected long lowerBound = 0L;
    protected long upperBound = 0L;

    public CpdLoadImpl(double d, double d2, double d3, double d4) {
        super(d, d3, 5, 0.0);
        this.currentLevel = d2;
        this.timeWeight = d4;
    }

    public CpdLoadImpl(double d, double d2, double d3, double d4, double d5, long l, long l2, long l3, long l4) {
        super(d, d3, 5, d5);
        this.currentLevel = d2;
        this.timeWeight = d4;
        this.lowWaterMark = l;
        this.highWaterMark = l2;
        this.lowerBound = l3;
        this.upperBound = l4;
    }

    public double getIntegral() {
        return this.value;
    }

    public double getCurrentLevel() {
        return this.currentLevel;
    }

    public double getValue() {
        return this.getCurrentLevel();
    }

    public double getWeight() {
        return this.timeWeight;
    }

    public long lowWaterMark() {
        return this.lowWaterMark;
    }

    public long highWaterMark() {
        return this.highWaterMark;
    }

    public long lowerBound() {
        return this.lowerBound;
    }

    public long upperBound() {
        return this.upperBound;
    }

    public CpdValue delta(CpdValue cpdValue) {
        if (cpdValue.getType() != 5) {
            return null;
        }
        return new CpdLoadImpl(this.value - ((CpdLoadImpl)cpdValue).value, this.currentLevel, this.time, this.timeWeight - ((CpdLoad)cpdValue).getWeight());
    }

    public double mean() {
        if (this.timeWeight == 0.0) {
            return 0.0;
        }
        double d = this.value / this.timeWeight;
        return d;
    }

    public CpdValue changeInValue(CpdValue cpdValue) {
        CpdLoad cpdLoad = (CpdLoad)cpdValue;
        return new CpdValueImpl(this.currentLevel - cpdLoad.getCurrentLevel(), this.time, 3.0);
    }

    public CpdValue rateChangeOfValue(CpdValue cpdValue) {
        CpdLoad cpdLoad = (CpdLoad)cpdValue;
        if (this.time - (double)cpdValue.getTime() == 0.0) {
            return null;
        }
        double d = this.time - (double)cpdValue.getTime();
        return new CpdValueImpl((this.currentLevel - cpdLoad.getCurrentLevel()) / d, this.time, 3.0);
    }

    public void combine(CpdValue cpdValue) {
        if (cpdValue.getType() != 5) {
            System.err.println("Wrong type passed to CpdLoadImpl.combine");
            return;
        }
        this.currentLevel += ((CpdLoad)cpdValue).getCurrentLevel();
        CpdLoadImpl cpdLoadImpl = (CpdLoadImpl)cpdValue;
        double d = cpdLoadImpl.getWeight();
        if (d <= this.timeWeight) {
            this.value += cpdLoadImpl.getValue();
        } else {
            double d2 = cpdLoadImpl.getValue() * (this.timeWeight / d);
            this.value += d2;
        }
    }

    public String valueToString() {
        return this.currentLevel + "";
    }

    public String meanToString() {
        double d = this.mean();
        double d2 = Math.abs(d);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(d2 > 0.1 ? 3 : (d2 < 1.0E-4 ? 8 : 5));
        return numberFormat.format(d);
    }

    public String toString() {
        double d = Math.abs(this.value);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(d > 0.1 ? 3 : (d < 1.0E-4 ? 8 : 5));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" timeWeight=");
        stringBuffer.append(this.timeWeight);
        stringBuffer.append(" currentLevel=");
        stringBuffer.append(this.currentLevel);
        stringBuffer.append(" integral=");
        stringBuffer.append(numberFormat.format(this.value));
        return stringBuffer.toString();
    }

    public String toXML() {
        return this.toXML("");
    }

    public String toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("<CpdLoad integral=\"");
        stringBuffer.append(this.value);
        stringBuffer.append("\" currentLevel=\"");
        stringBuffer.append(this.currentLevel);
        stringBuffer.append("\" lowWaterMark=\"");
        stringBuffer.append(this.lowWaterMark);
        stringBuffer.append("\" highWaterMark=\"");
        stringBuffer.append(this.highWaterMark);
        stringBuffer.append("\" lowerBound=\"");
        stringBuffer.append(this.lowerBound);
        stringBuffer.append("\" upperBound=\"");
        stringBuffer.append(this.upperBound);
        stringBuffer.append("\" weight=\"");
        stringBuffer.append(this.timeWeight);
        stringBuffer.append("\" time=\"");
        stringBuffer.append(this.time);
        stringBuffer.append("\" startTime=\"");
        stringBuffer.append(this.startTime);
        stringBuffer.append("\"/>");
        return stringBuffer.toString();
    }

    public void setStartTime(double d) {
        this.startTime = d;
    }
}

