/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.client;

import com.ibm.websphere.pmi.client.CpdStat;
import com.ibm.websphere.pmi.client.CpdValue;
import com.ibm.ws.pmi.client.Confidence;
import com.ibm.ws.pmi.client.CpdValueImpl;
import java.text.NumberFormat;

public class CpdStatImpl
implements CpdStat {
    protected double time = 0.0;
    protected double startTime = 0.0;
    protected double lastSampleTime = 0.0;
    protected double total = 0.0;
    protected long num = 0L;
    protected double sumSquares = 0.0;
    protected double min = 0.0;
    protected double max = 0.0;

    public CpdStatImpl() {
    }

    public CpdStatImpl(double d, double d2) {
        if (!Double.isNaN(d)) {
            this.total = d;
            this.num = 1L;
            this.sumSquares = d * d;
        }
        this.time = d2;
    }

    public CpdStatImpl(double d, long l, double d2, double d3) {
        if (!Double.isNaN(d) && l >= 0L) {
            this.total = d;
            this.num = l;
            this.sumSquares = d2;
        }
        this.time = d3;
    }

    public CpdStatImpl(double d, long l, double d2, double d3, double d4, double d5, double d6) {
        this(d, l, d2, d3);
        this.startTime = d4;
        this.min = d5;
        this.max = d6;
    }

    public int getType() {
        return 4;
    }

    public double getAccurateTime() {
        return this.time;
    }

    public long getTime() {
        return (long)this.time;
    }

    public long getStartTime() {
        return (long)this.startTime;
    }

    public long getLastSampleTime() {
        return (long)this.lastSampleTime;
    }

    public void setLastSampleTime(double d) {
        this.lastSampleTime = d;
    }

    public CpdValue changeInValue(CpdValue cpdValue) {
        CpdStat cpdStat = (CpdStat)cpdValue;
        return new CpdValueImpl(this.mean() - cpdStat.mean(), this.time, 3.0);
    }

    public CpdValue rateChangeOfValue(CpdValue cpdValue) {
        CpdStat cpdStat = (CpdStat)cpdValue;
        if (this.time - (double)cpdValue.getTime() == 0.0) {
            return null;
        }
        double d = this.time - (double)cpdValue.getTime();
        return new CpdValueImpl((this.mean() - cpdStat.mean()) / d, this.time, 3.0);
    }

    public CpdValue delta(CpdValue cpdValue) {
        CpdStat cpdStat = (CpdStat)cpdValue;
        return new CpdStatImpl(this.total - cpdStat.mean() * (double)cpdStat.count(), this.num - (long)cpdStat.count(), this.sumSquares - cpdStat.sumSquares(), this.time);
    }

    public void setMinMix(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public int count() {
        return (int)this.num;
    }

    public double total() {
        return this.total;
    }

    public double mean() {
        return this.num > 0L ? this.total / (double)this.num : 0.0;
    }

    public long min() {
        return (long)this.min;
    }

    public long max() {
        return (long)this.max;
    }

    public double sumSquares() {
        return this.sumSquares;
    }

    public double variance() {
        return (this.sumSquares - this.total * this.total / (double)this.num) / (double)(this.num - 1L);
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public double confidence(int n) {
        return Confidence.interval(this, n);
    }

    public double getValue() {
        return this.mean();
    }

    public String toXML() {
        return this.toXML("");
    }

    public String toXML(String string, boolean bl) {
        return this.toXML(string);
    }

    public String valueToString() {
        double d = this.mean();
        double d2 = Math.abs(d);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(d2 > 0.1 ? 3 : (d2 < 1.0E-4 ? 8 : 5));
        return numberFormat.format(d);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" time=");
        stringBuffer.append(this.getTime());
        stringBuffer.append(" count=");
        stringBuffer.append(this.num);
        stringBuffer.append(" total=");
        stringBuffer.append(this.total);
        stringBuffer.append(" mean=");
        stringBuffer.append(this.mean());
        stringBuffer.append(" sumOfSquares=");
        stringBuffer.append(this.sumSquares);
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void combine(CpdValue cpdValue) {
        if (cpdValue.getType() != 4) {
            System.err.println("Wrong type passed to CpdStat.combine");
            return;
        }
        CpdStat cpdStat = (CpdStat)cpdValue;
        this.total += cpdStat.mean() * (double)cpdStat.count();
        this.num += (long)cpdStat.count();
        this.sumSquares += cpdStat.sumSquares();
    }

    public void fromXML(String string) {
    }

    public String toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("<CpdStat total=\"");
        stringBuffer.append(this.total);
        stringBuffer.append("\" number=\"");
        stringBuffer.append(this.num);
        stringBuffer.append("\" min=\"");
        stringBuffer.append(this.min);
        stringBuffer.append("\" max=\"");
        stringBuffer.append(this.max);
        stringBuffer.append("\" sumSquares=\"");
        stringBuffer.append(this.sumSquares);
        stringBuffer.append("\" time=\"");
        stringBuffer.append(this.time);
        stringBuffer.append("\" startTime=\"");
        stringBuffer.append(this.startTime);
        stringBuffer.append("\"/>");
        return stringBuffer.toString();
    }
}

