/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.client;

import com.ibm.websphere.pmi.client.CpdDouble;
import com.ibm.websphere.pmi.client.CpdInt;
import com.ibm.websphere.pmi.client.CpdLong;
import com.ibm.websphere.pmi.client.CpdValue;
import java.text.NumberFormat;

public class CpdValueImpl
implements CpdValue,
CpdInt,
CpdDouble,
CpdLong {
    protected double value = 0.0;
    protected double time = 0.0;
    protected double startTime = 0.0;
    protected double lastSampleTime = 0.0;
    protected int type = 3;

    public CpdValueImpl(double d, double d2, int n, double d3) {
        this.value = d;
        this.time = d2;
        this.type = n;
        this.startTime = d3;
    }

    public CpdValueImpl(double d, double d2) {
        this(d, d2, 3, 0.0);
    }

    public CpdValueImpl(long l, double d) {
        this(l, d, 2, 0.0);
    }

    public CpdValueImpl(double d, double d2, double d3) {
        this(d, d2, 3, d3);
    }

    public CpdValueImpl(long l, double d, double d2) {
        this(l, d, 2, d2);
    }

    public int getType() {
        return this.type;
    }

    public double getAccurateTime() {
        return this.time;
    }

    public long getTime() {
        return (long)this.time;
    }

    public long getStartTime() {
        return (long)this.startTime;
    }

    public long getLastSampleTime() {
        return (long)this.lastSampleTime;
    }

    public void setLastSampleTime(double d) {
        this.lastSampleTime = d;
    }

    public double getValue() {
        return this.value;
    }

    public CpdValue delta(CpdValue cpdValue) {
        return new CpdValueImpl(this.value - cpdValue.getValue(), this.time, (double)this.type);
    }

    public CpdValue changeInValue(CpdValue cpdValue) {
        return new CpdValueImpl(this.value - cpdValue.getValue(), this.time, 3.0);
    }

    public CpdValue rateChangeOfValue(CpdValue cpdValue) {
        if (this.time - (double)cpdValue.getTime() == 0.0) {
            return null;
        }
        double d = this.time - (double)cpdValue.getTime();
        return new CpdValueImpl((this.value - cpdValue.getValue()) / d, this.time, 3.0);
    }

    public void combine(CpdValue cpdValue) {
        int n = cpdValue.getType();
        if (n != 1 && n != 2 && n != 3) {
            System.err.println("Wrong type passed to CpdValueImpl.combine");
            return;
        }
        this.value += cpdValue.getValue();
    }

    public String toXML() {
        return this.toXML("");
    }

    public String toXML(String string, boolean bl) {
        return this.toXML(string);
    }

    public String toXML(String string) {
        String string2 = null;
        String string3 = null;
        switch (this.type) {
            case 2: {
                string2 = "<CpdLong";
                string3 = this.longValue() + "";
                break;
            }
            case 3: {
                string2 = "<CpdDouble";
                string3 = this.doubleValue() + "";
                break;
            }
            default: {
                string3 = this.value + "";
                string2 = "<CpdValue";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(" value=\"");
        stringBuffer.append(string3);
        stringBuffer.append("\" time=\"");
        stringBuffer.append(this.time);
        stringBuffer.append("\"/>");
        return stringBuffer.toString();
    }

    public void fromXML(String string) {
    }

    public Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String valueToString() {
        switch (this.type) {
            case 1: {
                return (int)this.value + "";
            }
            case 2: {
                return (long)this.value + "";
            }
            case 3: {
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(Math.abs(this.value) > 0.1 ? 3 : (Math.abs(this.value) < 1.0E-4 ? 8 : 5));
                return numberFormat.format(this.value);
            }
        }
        return this.value + "";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" time=");
        stringBuffer.append(this.getTime());
        stringBuffer.append(" value=");
        switch (this.type) {
            case 1: {
                return stringBuffer.append((int)this.value).toString();
            }
            case 2: {
                return stringBuffer.append((long)this.value).toString();
            }
            case 3: {
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(Math.abs(this.value) > 0.1 ? 3 : (Math.abs(this.value) < 1.0E-4 ? 8 : 5));
                return stringBuffer.append(numberFormat.format(this.value)).toString();
            }
        }
        return "WRONG_TYPE";
    }

    public int intValue() {
        return (int)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public long longValue() {
        return (long)this.value;
    }
}

