/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.client;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.pmi.server.DataDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;

public class PerfDescriptorImpl
implements PerfDescriptor,
PmiConstants {
    private String node = null;
    private String server = null;
    private DataDescriptor dd = null;
    private int type = -1;
    private transient StringBuffer fullName = new StringBuffer();
    private transient String moduleName = null;
    private transient String name = null;

    public PerfDescriptorImpl() {
        this.init(null, null, null);
    }

    public PerfDescriptorImpl(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.init(null, null, null);
        } else if (stringArray.length == 1) {
            this.init(stringArray[0], null, null);
        } else if (stringArray.length == 2) {
            this.init(stringArray[0], stringArray[1], null);
        } else {
            String[] stringArray2 = new String[stringArray.length - 2];
            System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
            this.init(stringArray[0], stringArray[1], new DataDescriptor(stringArray2));
        }
    }

    public PerfDescriptorImpl(String[] stringArray, int n) {
        this(stringArray, new int[]{n});
    }

    public PerfDescriptorImpl(String[] stringArray, int[] nArray) {
        if (stringArray == null || stringArray.length < 3) {
            this.type = -1;
        } else {
            String[] stringArray2 = new String[stringArray.length - 2];
            System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
            DataDescriptor dataDescriptor = new DataDescriptor(stringArray2, nArray);
            this.init(stringArray[0], stringArray[1], dataDescriptor);
        }
    }

    public PerfDescriptorImpl(PerfDescriptor perfDescriptor, String string) {
        if (perfDescriptor == null) {
            this.init(string, null, null);
        } else if (perfDescriptor.getType() == 10) {
            this.init(string, null, null);
        } else if (perfDescriptor.getType() == 11) {
            this.init(perfDescriptor.getNodeName(), string, null);
        } else if (perfDescriptor.getType() == 12) {
            this.init(perfDescriptor.getNodeName(), perfDescriptor.getServerName(), new DataDescriptor(new String[]{string}));
        } else if (perfDescriptor.getDataDescriptor() != null) {
            DataDescriptor dataDescriptor = new DataDescriptor(perfDescriptor.getDataDescriptor(), string);
            if (dataDescriptor.getType() == -1) {
                this.type = -1;
            } else {
                this.init(perfDescriptor.getNodeName(), perfDescriptor.getServerName(), dataDescriptor);
            }
        } else {
            this.type = -1;
        }
    }

    public PerfDescriptorImpl(PerfDescriptor perfDescriptor, int n) {
        this(perfDescriptor, new int[]{n});
    }

    public PerfDescriptorImpl(PerfDescriptor perfDescriptor, int[] nArray) {
        if (perfDescriptor == null) {
            this.type = -1;
        } else if (perfDescriptor.getDataDescriptor() == null) {
            this.type = -1;
        } else {
            DataDescriptor dataDescriptor = new DataDescriptor(perfDescriptor.getDataDescriptor(), nArray);
            if (dataDescriptor.getType() == -1) {
                this.type = -1;
            } else {
                this.init(perfDescriptor.getNodeName(), perfDescriptor.getServerName(), dataDescriptor);
            }
        }
    }

    public PerfDescriptorImpl(String string, String string2, DataDescriptor dataDescriptor) {
        this.init(string, string2, dataDescriptor);
    }

    private void init(String string, String string2, DataDescriptor dataDescriptor) {
        this.node = string;
        this.server = string2;
        this.dd = dataDescriptor;
        this.moduleName = null;
        if (dataDescriptor != null) {
            if (string == null) {
                this.type = -1;
            } else {
                this.type = dataDescriptor.getType();
                this.moduleName = dataDescriptor.getModuleName();
            }
        } else {
            this.type = string == null && string2 == null ? 10 : (string != null && string2 == null ? 11 : (string != null && string2 != null ? 12 : -1));
        }
    }

    public void postInit() {
        if (this.fullName.length() > 0) {
            return;
        }
        if (this.type == -1) {
            return;
        }
        if (this.type == 10) {
            this.name = "pmiroot";
        } else if (this.type == 11) {
            this.name = this.node;
        } else if (this.type == 12) {
            this.name = this.server;
        } else if (this.dd != null) {
            this.moduleName = this.dd.getModuleName();
            this.name = this.dd.getName();
        }
        this.fullName.append("root");
        if (this.node != null) {
            this.fullName.append(",").append(this.node);
        }
        if (this.server != null) {
            this.fullName.append(",").append(this.server);
        }
        if (this.dd != null) {
            String[] stringArray = this.dd.getPath();
            for (int i = 0; i < stringArray.length; ++i) {
                this.fullName.append(",").append(stringArray[i]);
            }
        }
    }

    public void postInit(String string) {
        this.postInit();
        if (this.type == 18) {
            this.name = string;
            this.fullName.append(",").append(string);
        }
    }

    public String getNodeName() {
        return this.node;
    }

    public String getServerName() {
        return this.server;
    }

    public DataDescriptor getDataDescriptor() {
        return this.dd;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String string) {
        if (string != null) {
            this.moduleName = string;
        }
    }

    public String getFullName() {
        return this.fullName.toString();
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getName(int n) {
        if (this.type == -1) {
            return null;
        }
        if (n > this.getMaxPathLength()) {
            return null;
        }
        if (n == 1) {
            return this.node;
        }
        if (n == 2) {
            return this.server;
        }
        return this.dd.getPath()[n - 2 - 1];
    }

    public String[] getPath() {
        if (this.type == -1) {
            return null;
        }
        if (this.dd == null) {
            if (this.server == null) {
                return new String[]{this.node};
            }
            return new String[]{this.node, this.server};
        }
        String[] stringArray = new String[this.dd.getPath().length + 2];
        stringArray[0] = this.node;
        stringArray[1] = this.server;
        System.arraycopy(this.dd.getPath(), 0, stringArray, 2, stringArray.length - 2);
        return stringArray;
    }

    public int[] getDataIds() {
        return this.dd.getDataIds();
    }

    public int getType(int n) {
        if (this.type == -1) {
            return this.type;
        }
        if (n > this.getMaxPathLength()) {
            return -1;
        }
        if (n == 1) {
            return 11;
        }
        if (n == 2) {
            return 12;
        }
        return this.dd.getType(n - 2);
    }

    public int getMaxPathLength() {
        if (this.type == -1) {
            return 0;
        }
        int n = 0;
        n = this.type == 11 ? 1 : (this.type == 12 ? 2 : 2 + this.dd.getPath().length);
        return n;
    }

    public boolean equals(PerfDescriptor perfDescriptor) {
        return this.getFullName().equals(perfDescriptor.getFullName());
    }

    public boolean isDescendingFrom(PerfDescriptor perfDescriptor) {
        return this.getFullName().startsWith(perfDescriptor.getFullName(), 0);
    }

    public String toXMLTagStart(boolean bl) {
        return null;
    }

    public String toXMLTagEnd(boolean bl) {
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fullName = new StringBuffer();
    }
}

