/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.perfServer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.perfServer.Collector;
import com.ibm.ws.pmi.perfServer.CollectorJMX;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdCollectionImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DataCache
implements PmiConstants {
    private static boolean debug = false;
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$pmi$perfServer$DataCache == null ? (class$com$ibm$ws$pmi$perfServer$DataCache = DataCache.class$("com.ibm.ws.pmi.perfServer.DataCache")) : class$com$ibm$ws$pmi$perfServer$DataCache, null, "com.ibm.websphere.pmi.property.pmi");
    protected static String nodeName = null;
    static /* synthetic */ Class class$com$ibm$ws$pmi$perfServer$DataCache;

    public static synchronized Collector createCollector(String string, String string2, String string3, boolean bl, String string4, Properties properties) throws RemoteException {
        Tr.entry(tc, "createCollectors");
        Collector collector = null;
        String string5 = null;
        boolean bl2 = false;
        if (string3.equalsIgnoreCase("AE")) {
            string5 = "com.ibm.ws.pmi.perfServer.CollectorAE";
        } else if (string3.equalsIgnoreCase("AES")) {
            string5 = "com.ibm.ws.pmi.perfServer.CollectorAES";
        } else if (string3.equalsIgnoreCase("EPM")) {
            string5 = "com.ibm.ws.pmi.perfServer.CollectorEPM";
        } else if (string3.equalsIgnoreCase("WAS50") || string3.equalsIgnoreCase("WAS50ND")) {
            string5 = "com.ibm.ws.pmi.perfServer.CollectorJMX";
            bl2 = true;
        } else {
            System.out.println("---- WARNING: DataCache.createCollector: wrong version " + string3);
            throw new RemoteException("Error: unsupported version: " + string3);
        }
        try {
            Class<?> clazz = Class.forName(string5);
            collector = (Collector)clazz.newInstance();
            if (!bl2) {
                collector.init(string, string2, bl);
            } else {
                ((CollectorJMX)collector).init(string, string2, bl, string4, properties);
            }
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new RemoteException("Failed to instantiate a new instance of " + string5, exception);
        }
        Tr.exit(tc, "createCollectors");
        return collector;
    }

    public static PerfDescriptor[] listNodes(Collector collector) {
        Tr.entry(tc, "listNodes");
        if (collector == null) {
            System.out.println("---- ERROR: collector is null");
            return null;
        }
        String[] stringArray = collector.listNodes();
        if (stringArray == null) {
            System.out.println("ERROR: no node in the collector");
            return null;
        }
        PerfDescriptor[] perfDescriptorArray = new PerfDescriptorImpl[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            perfDescriptorArray[i] = new PerfDescriptorImpl(new String[]{stringArray[i]});
        }
        Tr.exit(tc, "listNodes");
        return perfDescriptorArray;
    }

    public static PerfDescriptor[] listServers(Collector collector, String string) {
        Tr.entry(tc, "listServers");
        if (string == null) {
            return null;
        }
        if (collector == null) {
            return null;
        }
        String[] stringArray = collector.listServers(string);
        if (stringArray == null) {
            return null;
        }
        PerfDescriptor[] perfDescriptorArray = new PerfDescriptorImpl[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(new String[]{string, stringArray[i]});
            perfDescriptorArray[i] = perfDescriptorImpl;
        }
        Tr.exit(tc, "listServers");
        return perfDescriptorArray;
    }

    public static int getAdminState(Collector collector, String string) {
        Tr.entry(tc, "getAdminState");
        if (string == null) {
            return -1;
        }
        if (collector == null) {
            return -1;
        }
        int n = collector.getAdminState(string);
        Tr.exit(tc, "getAdminState");
        return n;
    }

    public static int getAdminState(Collector collector, String string, String string2) {
        Tr.entry(tc, "getAdminState");
        if (string == null) {
            return -1;
        }
        if (collector == null) {
            return -1;
        }
        int n = collector.getAdminState(string, string2);
        Tr.exit(tc, "getAdminState");
        return n;
    }

    public static PerfDescriptor[] listMembers(Collector collector, PerfDescriptor perfDescriptor) {
        Tr.entry(tc, "listMembers");
        if (perfDescriptor == null || perfDescriptor.getType() == 11 || perfDescriptor.getType() == 18) {
            return null;
        }
        if (collector == null) {
            return null;
        }
        DataDescriptor[] dataDescriptorArray = collector.listMembers(perfDescriptor.getNodeName(), perfDescriptor.getServerName(), perfDescriptor.getDataDescriptor());
        if (dataDescriptorArray == null) {
            return null;
        }
        PerfDescriptor[] perfDescriptorArray = new PerfDescriptorImpl[dataDescriptorArray.length];
        for (int i = 0; i < perfDescriptorArray.length; ++i) {
            perfDescriptorArray[i] = new PerfDescriptorImpl(perfDescriptor.getNodeName(), perfDescriptor.getServerName(), dataDescriptorArray[i]);
        }
        Tr.exit(tc, "listMembers");
        return perfDescriptorArray;
    }

    public static PmiModuleConfig[] getConfigs(Collector collector) {
        return collector.getConfigs();
    }

    public static PmiModuleConfig[] getConfigs(Collector collector, String string) {
        return collector.getConfigs(string);
    }

    public static PmiModuleConfig[] getConfigs(Collector collector, String string, String string2) {
        return collector.getConfigs(string, string2);
    }

    private static WpdCollection[] retrieveDataFromServer(Collector collector, String string, String string2, DataDescriptor[] dataDescriptorArray, boolean bl) {
        Tr.entry(tc, "retrieveDataFromServer");
        if (string == null || string2 == null) {
            Tr.exit(tc, "retrieveDataFromServer - null nodeName or serverName");
            return null;
        }
        if (collector == null) {
            Tr.exit(tc, "retrieveDataFromServer - cannot find collector");
            return null;
        }
        WpdCollection[] wpdCollectionArray = collector.gets(string, string2, dataDescriptorArray, bl);
        if (wpdCollectionArray == null) {
            return null;
        }
        for (int i = 0; i < wpdCollectionArray.length; ++i) {
            if (wpdCollectionArray[i] == null || wpdCollectionArray[i].getType() != 12) continue;
            wpdCollectionArray[i].setName(string2);
        }
        Tr.exit(tc, "retrieveDataFromServer");
        return wpdCollectionArray;
    }

    private static WpdCollection[] getDataInOneServer(Collector collector, String string, String string2, DataDescriptor[] dataDescriptorArray, int n, boolean bl) {
        Tr.entry(tc, "getDataInOneServer");
        WpdCollection[] wpdCollectionArray = DataCache.retrieveDataFromServer(collector, string, string2, dataDescriptorArray, bl);
        if (wpdCollectionArray == null) {
            wpdCollectionArray = new WpdCollection[dataDescriptorArray.length];
            for (int i = 0; i < wpdCollectionArray.length; ++i) {
                wpdCollectionArray[i] = null;
            }
            Tr.exit(tc, "getDataInOneServer - server stopped or wrong pds");
            return wpdCollectionArray;
        }
        Tr.exit(tc, "getDataInOneServer - from server");
        return wpdCollectionArray;
    }

    private static WpdCollection[] getData(Collector collector, String string, String string2, DataDescriptor[] dataDescriptorArray, int n, boolean bl) {
        Tr.entry(tc, "getData");
        if (dataDescriptorArray == null) {
            return null;
        }
        WpdCollection[] wpdCollectionArray = new WpdCollection[dataDescriptorArray.length];
        for (int i = 0; i < wpdCollectionArray.length; ++i) {
            wpdCollectionArray[i] = null;
        }
        if (string == null) {
            Tr.exit(tc, "getData - node is null");
            return wpdCollectionArray;
        }
        if (string2 != null) {
            wpdCollectionArray = DataCache.getDataInOneServer(collector, string, string2, dataDescriptorArray, n, bl);
        } else {
            String[] stringArray = null;
            if (collector != null) {
                stringArray = collector.listServers(string);
            }
            if (stringArray != null) {
                int n2;
                for (n2 = 0; n2 < wpdCollectionArray.length; ++n2) {
                    wpdCollectionArray[n2] = DataCache.createWpdCollection(collector, string, 11);
                }
                if (dataDescriptorArray.length == 1 && dataDescriptorArray[0] == null && !bl) {
                    return wpdCollectionArray;
                }
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    WpdCollection[] wpdCollectionArray2 = DataCache.getDataInOneServer(collector, string, stringArray[n2], dataDescriptorArray, n, bl);
                    for (int i = 0; i < dataDescriptorArray.length; ++i) {
                        WpdCollection wpdCollection;
                        WpdCollection wpdCollection2;
                        if (dataDescriptorArray[i] == null) {
                            if (wpdCollectionArray2[i] != null) {
                                wpdCollectionArray[i].add(wpdCollectionArray2[i]);
                                continue;
                            }
                            wpdCollection2 = DataCache.createWpdCollection(collector, stringArray[n2], 12);
                            wpdCollectionArray[i].add(wpdCollection2);
                            continue;
                        }
                        wpdCollection2 = dataDescriptorArray[i].getPath();
                        if (((String[])wpdCollection2).length == 1 || wpdCollectionArray2[i] == null) {
                            wpdCollection = DataCache.createWpdCollection(collector, stringArray[n2], 12);
                            wpdCollectionArray[i].add(wpdCollection);
                            wpdCollection.add(wpdCollectionArray2[i]);
                            continue;
                        }
                        wpdCollection = DataCache.createWpdCollection(collector, stringArray[n2], 12);
                        WpdCollection wpdCollection3 = DataCache.createWpdCollection(collector, (String)wpdCollection2[0], 13);
                        wpdCollectionArray[i].add(wpdCollection);
                        wpdCollection.add(wpdCollection3);
                        WpdCollection wpdCollection4 = wpdCollection3;
                        for (int j = 1; j < ((WpdCollection)wpdCollection2).length - 1; ++j) {
                            WpdCollection wpdCollection5 = DataCache.createWpdCollection(collector, (String)wpdCollection2[j], 17);
                            wpdCollection4.add(wpdCollection5);
                            wpdCollection4 = wpdCollection5;
                        }
                        wpdCollection4.add(wpdCollectionArray2[i]);
                    }
                }
            }
        }
        Tr.exit(tc, "getData");
        return wpdCollectionArray;
    }

    private static WpdCollection createWpdCollection(Collector collector, String string, int n) {
        if (collector.getType().equals("WAS50")) {
            return new StatsImpl(string, n);
        }
        return new WpdCollectionImpl(string, n);
    }

    public static WpdCollection get(Collector collector, PerfDescriptor perfDescriptor, boolean bl, int n) {
        Tr.entry(tc, "get");
        if (perfDescriptor == null) {
            return null;
        }
        DataDescriptor[] dataDescriptorArray = new DataDescriptor[]{perfDescriptor.getDataDescriptor()};
        WpdCollection[] wpdCollectionArray = DataCache.getData(collector, perfDescriptor.getNodeName(), perfDescriptor.getServerName(), dataDescriptorArray, n, bl);
        Tr.exit(tc, "get");
        return wpdCollectionArray[0];
    }

    private static Hashtable getPdsPerServer(PerfDescriptor[] perfDescriptorArray) {
        if (perfDescriptorArray == null) {
            return null;
        }
        Hashtable<String, ServerPDmap> hashtable = new Hashtable<String, ServerPDmap>();
        ServerPDmap serverPDmap = null;
        for (int i = 0; i < perfDescriptorArray.length; ++i) {
            if (perfDescriptorArray[i] == null) continue;
            String string = perfDescriptorArray[i].getNodeName() + ":" + perfDescriptorArray[i].getServerName();
            if (hashtable.containsKey(string)) {
                serverPDmap = (ServerPDmap)hashtable.get(string);
                serverPDmap.add(i);
                continue;
            }
            serverPDmap = new ServerPDmap(perfDescriptorArray[i].getNodeName(), perfDescriptorArray[i].getServerName(), perfDescriptorArray[i].getType());
            serverPDmap.add(i);
            hashtable.put(string, serverPDmap);
        }
        return hashtable;
    }

    public static WpdCollection[] gets(Collector collector, PerfDescriptor[] perfDescriptorArray, boolean bl, int n) {
        int n2;
        WpdCollection[] wpdCollectionArray;
        Tr.entry(tc, "gets");
        if (perfDescriptorArray == null) {
            return null;
        }
        Hashtable hashtable = DataCache.getPdsPerServer(perfDescriptorArray);
        Enumeration enumeration = hashtable.elements();
        ServerPDmap serverPDmap = null;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            serverPDmap = (ServerPDmap)enumeration.nextElement();
            wpdCollectionArray = new DataDescriptor[serverPDmap.pdIndex.size()];
            for (n2 = 0; n2 < wpdCollectionArray.length; ++n2) {
                wpdCollectionArray[n2] = perfDescriptorArray[serverPDmap.getPdIndex(n2)].getDataDescriptor();
            }
            serverPDmap.collections = DataCache.getData(collector, serverPDmap.nodeName, serverPDmap.serverName, (DataDescriptor[])wpdCollectionArray, n, bl);
            ++n3;
        }
        wpdCollectionArray = new WpdCollection[perfDescriptorArray.length];
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            serverPDmap = (ServerPDmap)enumeration.nextElement();
            for (n2 = 0; n2 < serverPDmap.numPds(); ++n2) {
                wpdCollectionArray[serverPDmap.getPdIndex((int)n2)] = serverPDmap.collections[n2];
            }
        }
        Tr.exit(tc, "gets");
        return wpdCollectionArray;
    }

    public static void enableDisableData(Collector collector, boolean bl, PerfDescriptor[] perfDescriptorArray, boolean bl2) {
        Tr.entry(tc, "enableData");
        if (perfDescriptorArray == null) {
            Tr.exit(tc, "enableData - null pds");
            return;
        }
        Hashtable hashtable = DataCache.getPdsPerServer(perfDescriptorArray);
        Enumeration enumeration = hashtable.elements();
        ServerPDmap serverPDmap = null;
        while (enumeration.hasMoreElements()) {
            serverPDmap = (ServerPDmap)enumeration.nextElement();
            DataDescriptor[] dataDescriptorArray = new DataDescriptor[serverPDmap.pdIndex.size()];
            for (int i = 0; i < dataDescriptorArray.length; ++i) {
                dataDescriptorArray[i] = perfDescriptorArray[serverPDmap.getPdIndex(i)].getDataDescriptor();
            }
            if (collector == null) {
                Tr.warning(tc, "Cannot find Collector for the node ", serverPDmap.nodeName);
            }
            if (bl) {
                collector.enableData(serverPDmap.nodeName, serverPDmap.serverName, dataDescriptorArray, bl2);
                continue;
            }
            collector.disableData(serverPDmap.nodeName, serverPDmap.serverName, dataDescriptorArray, bl2);
        }
        Tr.exit(tc, "enableData - null pds");
    }

    public static void setNodeName(String string) {
        nodeName = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ServerPDmap {
        String nodeName;
        String serverName;
        int type;
        ArrayList pdIndex;
        WpdCollection[] collections;

        public ServerPDmap(String string, String string2, int n) {
            this.nodeName = string;
            this.serverName = string2;
            this.type = n;
            this.pdIndex = new ArrayList();
            this.collections = null;
        }

        public void add(int n) {
            this.pdIndex.add(new Integer(n));
        }

        public int getPdIndex(int n) {
            return (Integer)this.pdIndex.get(n);
        }

        public int numPds() {
            return this.pdIndex.size();
        }
    }
}

