/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.pcf.PCFHeader;
import java.io.IOException;

public class MQCFH
extends PCFHeader {
    public static final String copyright = "Copyright (c) IBM Corp. 1998   All rights reserved.";
    public int type = 1;
    public static final int strucLength = 36;
    public int version = 1;
    public int command;
    public int msgSeqNumber = 1;
    public int control = 1;
    public int compCode;
    public int reason;
    public int parameterCount;

    public static int write(MQMessage mQMessage, int n, int n2) throws IOException {
        mQMessage.writeInt(1);
        mQMessage.writeInt(36);
        mQMessage.writeInt(1);
        mQMessage.writeInt(n);
        mQMessage.writeInt(1);
        mQMessage.writeInt(1);
        mQMessage.writeInt(0);
        mQMessage.writeInt(0);
        mQMessage.writeInt(n2);
        return 36;
    }

    public MQCFH() {
    }

    public MQCFH(int n, int n2) {
        this.command = n;
        this.parameterCount = n2;
    }

    public MQCFH(MQMessage mQMessage) throws MQException, IOException {
        this.initialize(mQMessage);
    }

    public void initialize(MQMessage mQMessage) throws MQException, IOException {
        this.type = mQMessage.readInt();
        if (this.type != 1 && this.type != 2 && this.type != 7) {
            throw new MQException(2, 3001, (Object)mQMessage);
        }
        if (mQMessage.readInt() != 36) {
            throw new MQException(2, 3002, (Object)mQMessage);
        }
        this.version = mQMessage.readInt();
        this.command = mQMessage.readInt();
        this.msgSeqNumber = mQMessage.readInt();
        this.control = mQMessage.readInt();
        this.compCode = mQMessage.readInt();
        this.reason = mQMessage.readInt();
        this.parameterCount = mQMessage.readInt();
    }

    public int write(MQMessage mQMessage) throws IOException {
        mQMessage.writeInt(this.type);
        mQMessage.writeInt(36);
        mQMessage.writeInt(this.version);
        mQMessage.writeInt(this.command);
        mQMessage.writeInt(this.msgSeqNumber);
        mQMessage.writeInt(this.control);
        mQMessage.writeInt(this.compCode);
        mQMessage.writeInt(this.reason);
        mQMessage.writeInt(this.parameterCount);
        return 36;
    }

    public int size() {
        return 36;
    }

    public String toString() {
        return new String(String.valueOf(this.getClass().getName()) + ":\n" + "   - type: " + this.type + "\n" + "   - strucLength: " + 36 + "\n" + "   - version: " + this.version + "\n" + "   - command: " + this.command + "\n" + "   - msgSeqNumber: " + this.msgSeqNumber + "\n" + "   - control: " + this.control + "\n" + "   - compCode: " + this.compCode + "\n" + "   - reason: " + this.reason + "\n" + "   - parameterCount: " + this.parameterCount + "\n");
    }
}

