/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.pcf;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.pcf.MQCFH;
import com.ibm.mq.pcf.PCFParameter;
import java.io.IOException;
import java.util.Vector;

public class PCFAgent {
    public static final String copyright = "Copyright (c) IBM Corp. 1998   All rights reserved.";
    static final String MODEL_QUEUE_NAME = "SYSTEM.DEFAULT.MODEL.QUEUE";
    final MQPutMessageOptions pmo = new MQPutMessageOptions();
    final MQGetMessageOptions gmo = new MQGetMessageOptions();
    public final String replyQueueName = String.valueOf(this.getClass().getName().toUpperCase()) + Long.toString(System.currentTimeMillis(), 10) + "...";
    protected int expiryTime = 300;
    protected int waitInterval = 30000;
    protected MQQueueManager qmanager;
    protected int qmanager_level;
    protected String qmanager_name;
    protected MQQueue adminQueue;
    protected MQQueue replyQueue;

    public PCFAgent() {
    }

    public PCFAgent(MQQueueManager mQQueueManager) throws MQException {
        this();
        this.connect(mQQueueManager);
    }

    public PCFAgent(String string, int n, String string2) throws MQException {
        this();
        this.connect(string, n, string2);
    }

    public PCFAgent(String string) throws MQException {
        this();
        this.connect(string);
    }

    public synchronized void connect(MQQueueManager mQQueueManager) throws MQException {
        this.open(mQQueueManager, true);
    }

    public synchronized void connect(String string, int n, String string2) throws MQException {
        MQEnvironment.hostname = string;
        MQEnvironment.port = n;
        MQEnvironment.channel = string2;
        this.open(new MQQueueManager(""), false);
    }

    public synchronized void connect(String string) throws MQException {
        this.open(new MQQueueManager(string), false);
    }

    protected synchronized void open(MQQueueManager mQQueueManager, boolean bl) throws MQException {
        try {
            this.disconnect();
        }
        catch (MQException mQException) {}
        this.adminQueue = mQQueueManager.accessQueue(mQQueueManager.getCommandInputQueueName(), 16, "", "", "mqm");
        this.replyQueue = mQQueueManager.accessQueue(MODEL_QUEUE_NAME, 4, "", this.replyQueueName, "mqm");
        if (!bl) {
            this.qmanager = mQQueueManager;
        }
        try {
            int[] nArray = new int[1];
            byte[] byArray = new byte[48];
            mQQueueManager.inquire(new int[]{31, 2015}, nArray, byArray);
            this.qmanager_level = nArray[0];
            this.qmanager_name = new String(byArray).trim();
            return;
        }
        catch (MQException mQException) {
            this.qmanager_level = 0;
            this.qmanager_name = null;
            return;
        }
    }

    public synchronized void disconnect() throws MQException {
        try {
            this.adminQueue.close();
            this.replyQueue.close();
            this.qmanager.disconnect();
        }
        catch (NullPointerException nullPointerException) {}
        this.adminQueue = null;
        this.replyQueue = null;
        this.qmanager = null;
        this.qmanager_name = null;
    }

    public synchronized MQMessage[] send(int n, PCFParameter[] pCFParameterArray) throws MQException, IOException {
        MQMessage mQMessage = new MQMessage();
        Vector<MQMessage> vector = new Vector<MQMessage>();
        boolean bl = false;
        if (this.qmanager_level < 500) {
            mQMessage.setVersion(1);
        }
        mQMessage.messageType = 1;
        mQMessage.expiry = this.expiryTime;
        mQMessage.feedback = 0;
        mQMessage.format = "MQADMIN ";
        mQMessage.replyToQueueName = this.replyQueueName;
        if (pCFParameterArray == null) {
            MQCFH.write(mQMessage, n, 0);
        } else {
            MQCFH.write(mQMessage, n, pCFParameterArray.length);
            int n2 = 0;
            while (n2 < pCFParameterArray.length) {
                pCFParameterArray[n2].write(mQMessage);
                ++n2;
            }
        }
        this.adminQueue.put(mQMessage, this.pmo);
        byte[] byArray = mQMessage.correlationId;
        this.gmo.options = 16385;
        this.gmo.waitInterval = this.waitInterval;
        do {
            mQMessage = new MQMessage();
            mQMessage.correlationId = byArray;
            this.replyQueue.get(mQMessage, this.gmo);
            vector.addElement(mQMessage);
            bl = new MQCFH((MQMessage)mQMessage).control == 1;
            mQMessage.seek(0);
        } while (!bl);
        Object[] objectArray = new MQMessage[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setWaitInterval(int n) {
        if (n >= 0) {
            this.expiryTime = n * 10;
            this.waitInterval = n * 1000;
        }
    }

    public String getQManagerName() {
        return this.qmanager_name;
    }
}

