/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

public class CreationParams {
    private String executable;
    private String[] commandLineArgs;
    private String[] environment;
    private String userId;
    private String groupId;
    private String workingDirectory;
    private int umask;
    private String[] stdFileNames;
    private int priority = 20;
    private int processGroup;
    private String processName;
    private boolean inheritPOStreams = false;
    private boolean detachProcess = false;

    public String getExecutable() {
        return this.executable;
    }

    public boolean getInheritParentStreams() {
        return this.inheritPOStreams;
    }

    public void setExecutable(String string) {
        this.executable = string;
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public void setCommandLineArgs(String[] stringArray) {
        if (stringArray != null) {
            this.commandLineArgs = this.stripNullsFromArray(stringArray);
        }
    }

    public String[] getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String[] stringArray) {
        if (stringArray != null) {
            this.environment = this.stripNullsFromArray(stringArray);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String string) {
        this.userId = string != null && string.length() > 0 ? string : null;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String string) {
        this.groupId = string != null && string.length() > 0 ? string : null;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public int getUmask() {
        return this.umask;
    }

    public void setUmask(int n) {
        this.umask = n;
    }

    public String[] getStdFileNames() {
        return this.stdFileNames;
    }

    public void setStdFileName(int n, String string) {
        if (this.stdFileNames == null) {
            this.stdFileNames = new String[3];
        }
        this.stdFileNames[n] = string != null && string.length() > 0 ? string : null;
    }

    public int getProcessPriority() {
        return this.priority;
    }

    public void setProcessPriority(int n) {
        this.priority = n;
    }

    public int getProcessGroupId() {
        return this.processGroup;
    }

    public void setProcessGroupId(int n) {
        this.processGroup = n;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String string) {
        this.processName = string;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.executable != null) {
            stringBuffer.append("[executable:] ");
            stringBuffer.append(this.executable);
            stringBuffer.append(" ");
        }
        if (this.commandLineArgs != null) {
            stringBuffer.append("[command line args:] ");
            for (n = 0; n < this.commandLineArgs.length; ++n) {
                stringBuffer.append(this.commandLineArgs[n]);
                stringBuffer.append(" ");
            }
        }
        if (this.environment != null) {
            stringBuffer.append("[environment:] ");
            for (n = 0; n < this.environment.length; ++n) {
                stringBuffer.append(this.environment[n]);
                stringBuffer.append(" ");
            }
        }
        if (this.userId != null) {
            stringBuffer.append("[user ID:] ");
            stringBuffer.append(this.userId);
            stringBuffer.append(" ");
        }
        if (this.groupId != null) {
            stringBuffer.append("[group ID:] ");
            stringBuffer.append(this.groupId);
            stringBuffer.append(" ");
        }
        if (this.workingDirectory != null) {
            stringBuffer.append("[working directory:] ");
            stringBuffer.append(this.workingDirectory);
            stringBuffer.append(" ");
        }
        stringBuffer.append("[umask:] ");
        stringBuffer.append(Integer.toOctalString(this.umask));
        stringBuffer.append(" ");
        if (this.stdFileNames != null) {
            stringBuffer.append("[Standard out/err filenames:] ");
            for (n = 0; n < this.stdFileNames.length; ++n) {
                stringBuffer.append(this.stdFileNames[n]);
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("[priority:] ");
        stringBuffer.append(this.priority);
        stringBuffer.append(" ");
        stringBuffer.append("[process group:] ");
        stringBuffer.append(this.processGroup);
        stringBuffer.append(" ");
        if (this.processName != null) {
            stringBuffer.append("[process name:] ");
            stringBuffer.append(this.processName);
            stringBuffer.append(" ");
        }
        stringBuffer.append("[inheritParentStreams:] ");
        stringBuffer.append(this.inheritPOStreams);
        stringBuffer.append("[detachProcess:] ");
        stringBuffer.append(this.detachProcess);
        return stringBuffer.toString();
    }

    private String[] stripNullsFromArray(String[] stringArray) {
        String[] stringArray2;
        int n;
        int n2 = stringArray.length;
        boolean bl = false;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (stringArray[n] != null) continue;
            bl = true;
            ++n3;
        }
        if (bl) {
            stringArray2 = new String[n2 - n3];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (stringArray[i] == null) continue;
                stringArray2[n] = stringArray[i];
                ++n;
            }
        } else {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    public void setInheritParentStreams(boolean bl) {
        this.inheritPOStreams = bl;
    }

    public void setDetachProcess(boolean bl) {
        this.detachProcess = bl;
    }

    public boolean getDetachProcess() {
        return this.detachProcess;
    }
}

