/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appprofile.accessintent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.appprofile.accessintent.ReadAheadHint;
import com.ibm.ws.appprofile.accessintent.AccessIntentKey;
import com.ibm.ws.appprofile.accessintent.InternalAccessIntent;
import com.ibm.ws.appprofile.accessintent.ReadAheadHintImpl;
import java.util.HashMap;

public class AccessIntentImpl
implements AccessIntent,
InternalAccessIntent {
    private static final int USE_DEFAULT = 0;
    private int _accessType;
    private int _concurrencyControl;
    private boolean _nocollision;
    private boolean _exclusive;
    private boolean _weakestLockAtLoad;
    private int _collectionScope;
    private int _collectionIncrement;
    private ReadAheadHintImpl _readAheadHint;
    private int _resourceManagerPreFetchIncrement;
    private int _updateHintValue;
    private int _hash;
    private boolean _postinit = false;
    private static HashMap _instanceSet = new HashMap(13);
    private static final TraceComponent _tc = Tr.register(class$com$ibm$ws$appprofile$accessintent$AccessIntentImpl == null ? (class$com$ibm$ws$appprofile$accessintent$AccessIntentImpl = AccessIntentImpl.class$("com.ibm.ws.appprofile.accessintent.AccessIntentImpl")) : class$com$ibm$ws$appprofile$accessintent$AccessIntentImpl, "AppProfile", "com.ibm.ws.appprofile.accessintent.resources.accessintent");
    static /* synthetic */ Class class$com$ibm$ws$appprofile$accessintent$AccessIntentImpl;

    public AccessIntentKey toAccessIntentKey() {
        AccessIntentKey accessIntentKey = new AccessIntentKey();
        accessIntentKey.setAccessType(this._accessType);
        accessIntentKey.setConcurrencyControl(this._concurrencyControl);
        accessIntentKey.setNoCollision(this._nocollision);
        accessIntentKey.setExclusive(this._exclusive);
        accessIntentKey.setWeakestLockAtLoad(this._weakestLockAtLoad);
        accessIntentKey.setCollectionScope(this._collectionScope);
        accessIntentKey.setCollectionIncrement(this._collectionIncrement);
        if (this._readAheadHint != null) {
            accessIntentKey.setReadAheadHint(this._readAheadHint.getOriginalHintSpecification());
        }
        accessIntentKey.setResourceManagerPreFetchIncrement(this._resourceManagerPreFetchIncrement);
        return accessIntentKey;
    }

    public static AccessIntentImpl getAccessIntent(AccessIntentKey accessIntentKey) {
        AccessIntentImpl accessIntentImpl;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAccessIntent", accessIntentKey);
        }
        if (_instanceSet.get(accessIntentImpl = new AccessIntentImpl(accessIntentKey)) == null) {
            _instanceSet.put(accessIntentImpl, accessIntentImpl);
            accessIntentImpl.postinit();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, accessIntentImpl + " is a new access intent of " + _instanceSet.size());
            }
        } else {
            accessIntentImpl = (AccessIntentImpl)_instanceSet.get(accessIntentImpl);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAccessIntent", accessIntentImpl);
        }
        return accessIntentImpl;
    }

    private AccessIntentImpl(AccessIntentKey accessIntentKey) {
        this._accessType = accessIntentKey._accessType;
        this._collectionIncrement = accessIntentKey._collectionIncrement;
        this._collectionScope = accessIntentKey._collectionScope;
        this._concurrencyControl = accessIntentKey._concurrencyControl;
        this._exclusive = accessIntentKey._exclusive;
        this._nocollision = accessIntentKey._nocollision;
        if (accessIntentKey._readAheadHint != null) {
            this._readAheadHint = (ReadAheadHintImpl)ReadAheadHintImpl.getReadAheadHint(accessIntentKey._readAheadHint);
        }
        this._resourceManagerPreFetchIncrement = accessIntentKey._resourceManagerPreFetchIncrement;
        this._weakestLockAtLoad = accessIntentKey._weakestLockAtLoad;
        this.calculateUpdateHintValue();
        this.calculateHash();
    }

    void postinit() {
        this._postinit = true;
    }

    private void calculateHash() {
        if (!this._postinit) {
            this._hash = ("" + this._accessType + this._collectionIncrement + this._collectionScope + this._concurrencyControl + this._exclusive + this._nocollision + this._weakestLockAtLoad + this._resourceManagerPreFetchIncrement).hashCode();
            if (this._readAheadHint != null) {
                this._hash ^= this._readAheadHint.strictHashCode();
            }
        }
    }

    public int getConcurrencyControl() {
        return this._concurrencyControl;
    }

    public int getAccessType() {
        return this._accessType;
    }

    public boolean getPessimisticUpdateHintWeakestLockAtLoad() {
        return this._weakestLockAtLoad;
    }

    public boolean getPessimisticUpdateHintNoCollision() {
        return this._nocollision;
    }

    public boolean getPessimisticUpdateHintExclusive() {
        return this._exclusive;
    }

    public int getPessimisticUpdateLockHint() {
        if (this._weakestLockAtLoad) {
            return 2;
        }
        if (this._nocollision) {
            return 1;
        }
        if (this._exclusive) {
            return 4;
        }
        return 3;
    }

    public int getCollectionScope() {
        return this._collectionScope;
    }

    public int getCollectionIncrement() {
        return this._collectionIncrement;
    }

    public ReadAheadHint getReadAheadHint() {
        if (this._readAheadHint != null) {
            return (ReadAheadHint)this._readAheadHint.clone();
        }
        return null;
    }

    public int getResourceManagerPreFetchIncrement() {
        return this._resourceManagerPreFetchIncrement;
    }

    public int getUpdateHintValue() {
        return this._updateHintValue;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        try {
            if (this._postinit) {
                if (object != this) {
                    AccessIntentImpl accessIntentImpl = (AccessIntentImpl)object;
                    if (this._readAheadHint == null || accessIntentImpl._readAheadHint == null) {
                        bl = false;
                    } else if (!this._readAheadHint.equals(accessIntentImpl._readAheadHint) || this._accessType != accessIntentImpl._accessType || this._collectionIncrement != accessIntentImpl._collectionIncrement || this._collectionScope != accessIntentImpl._collectionScope || this._concurrencyControl != accessIntentImpl._concurrencyControl || this._exclusive != accessIntentImpl._exclusive || this._nocollision != accessIntentImpl._nocollision || this._weakestLockAtLoad != accessIntentImpl._weakestLockAtLoad || this._resourceManagerPreFetchIncrement != accessIntentImpl._resourceManagerPreFetchIncrement) {
                        bl = false;
                    }
                }
            } else {
                AccessIntentImpl accessIntentImpl = (AccessIntentImpl)object;
                if (this._accessType != accessIntentImpl._accessType || this._collectionIncrement != accessIntentImpl._collectionIncrement || this._collectionScope != accessIntentImpl._collectionScope || this._concurrencyControl != accessIntentImpl._concurrencyControl || this._exclusive != accessIntentImpl._exclusive || this._nocollision != accessIntentImpl._nocollision || this._weakestLockAtLoad != accessIntentImpl._weakestLockAtLoad || this._resourceManagerPreFetchIncrement != accessIntentImpl._resourceManagerPreFetchIncrement) {
                    bl = false;
                } else if (this._readAheadHint != null && !this._readAheadHint.strictEquals(accessIntentImpl._readAheadHint)) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int hashCode() {
        return this._hash;
    }

    private void calculateUpdateHintValue() {
        int n = this._nocollision ? 1 : 0;
        int n2 = this._exclusive ? 1 : 0;
        this._updateHintValue = n << 1 | n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("access intent: ");
        if (this._concurrencyControl == 2) {
            stringBuffer.append("(optimistic");
        } else if (this._concurrencyControl == 1) {
            stringBuffer.append("(pessimistic");
        }
        if (this._accessType == 2) {
            stringBuffer.append(" read");
        } else if (this._accessType == 1) {
            stringBuffer.append(" update");
        }
        if (this._weakestLockAtLoad) {
            stringBuffer.append("-weakestLockAtLoad");
        }
        if (this._nocollision) {
            stringBuffer.append("-noCollision");
        }
        if (this._exclusive) {
            stringBuffer.append("-exclusive");
        }
        stringBuffer.append(")");
        stringBuffer.append("(collections:");
        if (this._collectionScope == 2) {
            stringBuffer.append(" ActivitySession");
        } else if (this._collectionScope == 1) {
            stringBuffer.append(" transaction");
        }
        stringBuffer.append("/" + this._collectionIncrement);
        stringBuffer.append(")");
        stringBuffer.append(" (resource manager prefetch: " + this._resourceManagerPreFetchIncrement + ")");
        if (this._readAheadHint != null) {
            stringBuffer.append(this._readAheadHint.toString());
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

