/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.jaaslogin.JAASConfiguration;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.jaaslogin.JAASModuleControlFlag;
import com.ibm.websphere.models.config.properties.Property;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;

public class JaasWCCMHelper {
    private static TraceComponent tc = Tr.register((String)"JaasWCCMHelper", null, (String)"com.ibm.ejs.resources.security");
    public static final String SYSTEM_CONFIG_LOGIN_JAAS = "security.loginconfig.system";
    public static final String APPL_CONFIG_LOGIN_JAAS = "security.loginconfig.application";

    public static String convertMapToString(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertMapToString, in Map= " + hashMap));
        }
        String string = null;
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (hashMap != null) {
            Set set = hashMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                if (string2 == null) {
                    Tr.error((TraceComponent)tc, (String)"security.jaasconfig.helper.baddata", (Object)new Object[]{"convertMapToString", "alias", null});
                    continue;
                }
                stringBuffer.append(entry.getKey()).append(" ").append('{').append('\n');
                Vector vector = (Vector)entry.getValue();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    AppConfigurationEntry appConfigurationEntry = (AppConfigurationEntry)vector.elementAt(i);
                    JaasWCCMHelper.printACE(stringBuffer, appConfigurationEntry);
                }
                stringBuffer.append("};\n");
            }
        }
        string = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The internal JAAS config map has been converted to:\n" + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertMapToString");
        }
        return string;
    }

    private static void printACE(StringBuffer stringBuffer, AppConfigurationEntry appConfigurationEntry) {
        if (stringBuffer == null || appConfigurationEntry == null) {
            return;
        }
        String string = appConfigurationEntry.getControlFlag().toString();
        string = string.substring(string.indexOf(58) + 1);
        stringBuffer.append("    ").append(appConfigurationEntry.getLoginModuleName()).append(" ").append(string);
        Map<String, ?> map = appConfigurationEntry.getOptions();
        if (map != null && map.size() > 0) {
            Set<Map.Entry<String, ?>> set = map.entrySet();
            Iterator<Map.Entry<String, ?>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ?> entry = iterator.next();
                String string2 = entry.getKey();
                String string3 = (String)entry.getValue();
                stringBuffer.append("\n       ").append(string2).append('=').append('\"').append(string3).append('\"');
            }
        }
        stringBuffer.append("   ").append(";\n");
    }

    public static HashMap convertToConfiguration(JAASConfiguration jAASConfiguration, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertToConfiguration " + jAASConfiguration));
        }
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        if (jAASConfiguration == null) {
            return null;
        }
        Iterator iterator = jAASConfiguration.getEntries().iterator();
        while (iterator.hasNext()) {
            JAASConfigurationEntry jAASConfigurationEntry = (JAASConfigurationEntry)iterator.next();
            if (jAASConfigurationEntry.getAlias().length() != 0) {
                String string = jAASConfigurationEntry.getAlias();
                if (bl) {
                    string = "system." + string;
                }
                if (hashMap.containsKey(string)) {
                    Tr.warning((TraceComponent)tc, (String)"security.init.wccmjaas.dupentry", (Object)new Object[]{string});
                }
                hashMap.put(string, JaasWCCMHelper.convertToAppEntry(jAASConfigurationEntry));
                continue;
            }
            Tr.warning((TraceComponent)tc, (String)"security.wccmjaas.no.alias", (Object)new Object[]{jAASConfiguration});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertToConfiguration ");
        }
        return hashMap;
    }

    private static Vector convertToAppEntry(JAASConfigurationEntry jAASConfigurationEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertToAppEntry " + jAASConfigurationEntry));
        }
        Vector<AppConfigurationEntry> vector = new Vector<AppConfigurationEntry>();
        Iterator iterator = jAASConfigurationEntry.getLoginModules().iterator();
        while (iterator.hasNext()) {
            JAASLoginModule jAASLoginModule = (JAASLoginModule)iterator.next();
            vector.add(JaasWCCMHelper.convertWCCMtoJaasConfig(jAASLoginModule));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertToAppEntry ");
        }
        return vector;
    }

    private static AppConfigurationEntry convertWCCMtoJaasConfig(JAASLoginModule jAASLoginModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertWCCMtoJaasConfig " + jAASLoginModule));
        }
        AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(JaasWCCMHelper.buildLoginModule(jAASLoginModule), JaasWCCMHelper.buildFlag(jAASLoginModule), JaasWCCMHelper.buildOptions(jAASLoginModule));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertWCCMtoJaasConfig ");
        }
        return appConfigurationEntry;
    }

    private static String buildLoginModule(JAASLoginModule jAASLoginModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("buildLoginModule " + jAASLoginModule));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("buildLoginModule " + jAASLoginModule));
        }
        return jAASLoginModule.getModuleClassName();
    }

    private static AppConfigurationEntry.LoginModuleControlFlag buildFlag(JAASLoginModule jAASLoginModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("buildModuleControlFlag " + jAASLoginModule));
        }
        Object var1_1 = null;
        JAASModuleControlFlag jAASModuleControlFlag = jAASLoginModule.getAuthenticationStrategy();
        int n = jAASModuleControlFlag.getValue();
        switch (n) {
            case 0: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            }
            case 1: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
            case 2: {
                return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
            case 3: {
                return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
        }
        System.out.println("Error: switch on wcLModule.getAuthenticationStrategy().getValueAuthenticationStrategy() did not match");
        return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    }

    private static Map buildOptions(JAASLoginModule jAASLoginModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("buildOptions " + jAASLoginModule));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = jAASLoginModule.getOptions().iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            hashMap.put(property.getName(), property.getValue());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("buildOptions " + hashMap));
        }
        return hashMap;
    }
}

