/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.FilePathUtil;
import com.ibm.ws.security.policy.PolicyTemplate;
import com.ibm.ws.security.policy.TraceOutput;
import com.ibm.ws.security.util.ParserException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

abstract class Parser
implements TraceOutput {
    private WSPolicyTemplate policyTemplate = new WSPolicyTemplate();
    String keyStoreUrlString;
    String keyStoreType;
    List grants = new ArrayList();
    com.ibm.ws.security.util.Parser parser = null;
    boolean expandProp = false;
    static final String NEW_LINE = System.getProperty("line.separator");
    static final String QUOTED_STRING = "quoted string";
    static final String PERMISSION_TYPE = "permission type";
    static final String GRANT_KEYWORD = "grant";
    static final String KEYSTORE_KEYWORD = "keystore";
    static final String CODEBASE_KEYWORD = "codeBase";
    static final String PERMISSION_KEYWORD = "permission";
    static final String SIGNEDBY_KEYWORD = "signedBy";
    static final String FILTER_KEYWORD = "filterMask";
    static /* synthetic */ Class class$java$lang$String;

    Parser(Reader reader, boolean bl) {
        this.init(reader, bl);
    }

    public String toString() {
        return this.getClass().getName();
    }

    Iterator grantEntries() {
        return this.grants.iterator();
    }

    void parse() throws IOException, ParserException {
        this.parser.nextToken();
        while (!this.parser.eof()) {
            if (this.parser.peek(GRANT_KEYWORD)) {
                GrantEntry grantEntry = this.parseGrantEntry();
                if (grantEntry != null) {
                    this.grants.add(grantEntry);
                }
            } else if (this.parser.peek(KEYSTORE_KEYWORD)) {
                if (this.keyStoreUrlString == null) {
                    this.parseKeystoreEntry();
                    if (this.keyStoreType == null) {
                        this.keyStoreType = "JKS";
                    }
                    this.warning("security.policy.parser.keystore", new Object[]{this.keyStoreUrlString, this.keyStoreType});
                }
            } else {
                throw new ParserException(this.parser.getLineNumber(), "Unexpected keyword \"" + this.parser.getStringValue() + "\"");
            }
            this.parser.match(";");
        }
        this.createPolicyTemplate();
    }

    void createPolicyTemplate() {
        Iterator iterator = this.grantEntries();
        while (iterator.hasNext()) {
            this.policyTemplate.add((GrantEntry)iterator.next());
        }
    }

    PolicyTemplate getPolicyTemplate() {
        return this.policyTemplate;
    }

    Permission getPermissionInstance(PermissionEntry permissionEntry) {
        Permission permission = null;
        if (permissionEntry.getSignatures() == null) {
            try {
                Class<?> clazz = Class.forName(permissionEntry.getPermissionType());
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Parser.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Parser.class$("java.lang.String")) : class$java$lang$String);
                permission = (Permission)constructor.newInstance(permissionEntry.getName(), permissionEntry.getAction());
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.policy.Parser.getPermissionInstance", (String)"93", (Object)this);
                permission = new UnresolvedPermission(permissionEntry.getPermissionType(), permissionEntry.getName(), permissionEntry.getAction(), null);
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.security.policy.Parser.getPermissionInstance", (String)"96", (Object)this);
                Throwable throwable = invocationTargetException.getTargetException();
                this.error("security.policy.perminstance.targetexception", new Object[]{throwable});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.policy.Parser.getPermissionInstance", (String)"100", (Object)this);
                this.error("security.policy.perminstance.exception", new Object[]{exception});
            }
        }
        return permission;
    }

    void parseKeystoreEntry() throws IOException, ParserException {
        this.parser.match(KEYSTORE_KEYWORD);
        this.keyStoreUrlString = this.parser.match(QUOTED_STRING);
        if (!this.parser.peek(",")) {
            return;
        }
        this.parser.match(",");
        if (!this.parser.peek("\"")) {
            throw new ParserException(this.parser.getLineNumber(), "expected keystore type");
        }
        this.keyStoreType = this.parser.match(QUOTED_STRING);
    }

    GrantEntry parseGrantEntry() throws IOException, ParserException {
        GrantEntry grantEntry = new GrantEntry();
        this.parser.match(GRANT_KEYWORD);
        while (!this.parser.peek("{")) {
            if (this.parser.peek(CODEBASE_KEYWORD)) {
                this.parser.match(CODEBASE_KEYWORD);
                grantEntry.codeBase = this.parser.match(QUOTED_STRING);
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            if (this.parser.peek(SIGNEDBY_KEYWORD)) {
                this.parser.match(SIGNEDBY_KEYWORD);
                grantEntry.signedBy = this.parser.match(QUOTED_STRING);
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected codeBase or signedBy");
        }
        this.parser.match("{");
        while (!this.parser.peek("}")) {
            if (this.parser.peek(PERMISSION_KEYWORD)) {
                try {
                    PermissionEntry permissionEntry = this.parsePermissionEntry();
                    grantEntry.add(permissionEntry);
                }
                catch (ExpandException expandException) {
                    FFDCFilter.processException((Throwable)expandException, (String)"com.ibm.ws.security.policy.Parser.parseGrantEntry", (String)"147", (Object)this);
                    this.warning("security.policy.parser.expandperm", new Object[]{expandException});
                    this.parser.skipEntry();
                }
                this.parser.match(";");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected permission entry");
        }
        this.parser.match("}");
        try {
            if (grantEntry.codeBase != null) {
                grantEntry.codeBase = this.expand(grantEntry.codeBase, true);
            }
            grantEntry.signedBy = this.expand(grantEntry.signedBy);
        }
        catch (ExpandException expandException) {
            FFDCFilter.processException((Throwable)expandException, (String)"com.ibm.ws.security.policy.Parser.parseGrantEntry", (String)"163", (Object)this);
            this.warning("security.policy.parser.expandgrant", new Object[]{expandException});
            return null;
        }
        return grantEntry;
    }

    PermissionEntry parsePermissionEntry() throws IOException, ParserException, ExpandException {
        PermissionEntry permissionEntry = new PermissionEntry();
        this.parser.match(PERMISSION_KEYWORD);
        permissionEntry.permissionType = this.parser.match(PERMISSION_TYPE);
        if (this.parser.peek("\"")) {
            permissionEntry.name = this.expand(this.parser.match_p(QUOTED_STRING)).trim();
        }
        if (!this.parser.peek(",")) {
            return permissionEntry;
        }
        this.parser.match(",");
        if (this.parser.peek("\"")) {
            permissionEntry.action = this.expand(this.parser.match(QUOTED_STRING));
            if (!this.parser.peek(",")) {
                return permissionEntry;
            }
            this.parser.match(",");
        }
        try {
            if (this.parser.peek(SIGNEDBY_KEYWORD)) {
                this.parser.match(SIGNEDBY_KEYWORD);
                permissionEntry.signedBy = this.expand(this.parser.match(QUOTED_STRING));
            }
        }
        catch (ExpandException expandException) {
            FFDCFilter.processException((Throwable)expandException, (String)"com.ibm.ws.security.policy.Parser.parsePermissionEntry", (String)"198", (Object)this);
            this.warning("security.policy.parser.expandsignedby", new Object[]{expandException});
            return null;
        }
        return permissionEntry;
    }

    String expand(String string) throws ExpandException {
        return this.expand(string, false);
    }

    String expand(String string, boolean bl) throws ExpandException {
        if (this.expandProp) {
            int n = 0;
            if (string == null || (n = string.length()) == 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(n + 25);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = string.indexOf("${", i);
                if (n2 == -1) {
                    stringBuffer.append(string.substring(i));
                    break;
                }
                stringBuffer.append(string.substring(i, n2));
                i = string.indexOf("}", n2);
                if (i == -1) {
                    stringBuffer.append(string.substring(n2));
                    break;
                }
                String string2 = string.substring(n2 + 2, i);
                if (string2.equals("/")) {
                    stringBuffer.append(File.separator);
                    continue;
                }
                String string3 = System.getProperty(string2);
                if (string3 != null) {
                    if (bl) {
                        string3 = FilePathUtil.encodeFilePath(string3);
                    }
                    stringBuffer.append(string3);
                    continue;
                }
                StringBuffer stringBuffer2 = new StringBuffer(32);
                stringBuffer2.append("line ").append(this.parser.getLineNumber()).append(": ");
                stringBuffer2.append("unable to expand \"").append(string2).append("\"");
                String string4 = stringBuffer2.toString();
                this.error("security.policy.parser.encodeFilePath", new Object[]{string4});
                throw new ExpandException(string4);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private void init(Reader reader, boolean bl) {
        this.parser = new com.ibm.ws.security.util.Parser(reader);
        this.expandProp = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class WSPolicyTemplate
    implements PolicyTemplate {
        private HashMap entries = new HashMap();

        private WSPolicyTemplate() {
        }

        public String[] getSymbols() {
            return this.entries.keySet().toArray(new String[this.entries.size()]);
        }

        public ArrayList get(String string) {
            ArrayList arrayList = (ArrayList)this.entries.get(string);
            if (arrayList != null) {
                arrayList = (ArrayList)arrayList.clone();
            }
            return arrayList;
        }

        public String toString() {
            return this.entries.toString();
        }

        private void add(GrantEntry grantEntry) {
            String string = grantEntry.codeBase;
            if (string == null || string.length() == 0) {
                string = "${default}";
            } else {
                string = grantEntry.codeBase;
                if (string.startsWith("${") && string.endsWith("}")) {
                    string = string.toLowerCase();
                }
            }
            Object v = this.entries.get(string);
            ArrayList<Permission> arrayList = null;
            if (v != null) {
                arrayList = (ArrayList<Permission>)v;
            } else {
                arrayList = new ArrayList<Permission>();
                this.entries.put(string, arrayList);
            }
            Iterator iterator = grantEntry.getPermissions();
            while (iterator.hasNext()) {
                arrayList.add(Parser.this.getPermissionInstance((PermissionEntry)iterator.next()));
            }
        }
    }

    class GrantEntry {
        String codeBase;
        String signedBy;
        private List permissionEntries = new ArrayList();

        GrantEntry() {
        }

        GrantEntry(String string, String string2) {
            this.codeBase = string;
            this.signedBy = string2;
        }

        void add(PermissionEntry permissionEntry) {
            if (!this.permissionEntries.contains(permissionEntry)) {
                this.permissionEntries.add(permissionEntry);
            }
        }

        boolean remove(PermissionEntry permissionEntry) {
            return this.permissionEntries.remove(permissionEntry);
        }

        boolean contains(PermissionEntry permissionEntry) {
            return this.permissionEntries.contains(permissionEntry);
        }

        Iterator getPermissions() {
            return this.permissionEntries.iterator();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.permissionEntries.size() * 40);
            stringBuffer.append(Parser.GRANT_KEYWORD).append(' ');
            if (this.codeBase != null) {
                stringBuffer.append(Parser.CODEBASE_KEYWORD).append(" \"").append(this.codeBase).append("\" ");
                if (this.signedBy != null) {
                    stringBuffer.append(", ");
                }
            }
            if (this.signedBy != null) {
                stringBuffer.append(Parser.SIGNEDBY_KEYWORD).append(" \"").append(this.signedBy).append("\" ");
            }
            stringBuffer.append('{').append(NEW_LINE);
            Iterator iterator = this.permissionEntries.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append("};").append(NEW_LINE);
            return stringBuffer.toString();
        }
    }

    class PermissionEntry {
        private String permissionType;
        private String name;
        private String action;
        private String signedBy;

        private PermissionEntry() {
        }

        private PermissionEntry(String string, String string2, String string3, String string4) {
            this.permissionType = string;
            this.name = string2;
            this.action = string3;
            this.signedBy = string4;
        }

        public int hashCode() {
            int n = this.permissionType.hashCode();
            if (this.name != null) {
                n ^= this.name.hashCode();
            }
            if (this.action != null) {
                n ^= this.action.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PermissionEntry)) {
                return false;
            }
            PermissionEntry permissionEntry = (PermissionEntry)object;
            if (this.permissionType == null ? permissionEntry.permissionType != null : !this.permissionType.equals(permissionEntry.permissionType)) {
                return false;
            }
            if (this.name == null ? permissionEntry.name != null : !this.name.equals(permissionEntry.name)) {
                return false;
            }
            if (this.action == null ? permissionEntry.action != null : !this.action.equals(permissionEntry.action)) {
                return false;
            }
            return !(this.signedBy == null ? permissionEntry.signedBy != null : !this.signedBy.equals(permissionEntry.signedBy));
        }

        public String toString() {
            if (this.permissionType == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer("  ");
            stringBuffer.append(Parser.PERMISSION_KEYWORD).append(' ').append(this.permissionType);
            if (this.name != null) {
                stringBuffer.append(" \"").append(this.name).append('\"');
            }
            if (this.action != null) {
                stringBuffer.append(", \"").append(this.action).append('\"');
            }
            if (this.signedBy != null) {
                stringBuffer.append(", ").append(Parser.SIGNEDBY_KEYWORD).append(" \"").append(this.signedBy).append('\"');
            }
            stringBuffer.append(';').append(NEW_LINE);
            return stringBuffer.toString();
        }

        String getPermissionType() {
            return this.permissionType;
        }

        String getName() {
            return this.name;
        }

        String getAction() {
            return this.action;
        }

        String getSignatures() {
            return this.signedBy;
        }
    }

    class ExpandException
    extends GeneralSecurityException {
        ExpandException(String string) {
            super(string);
        }
    }
}

