/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.ecore.utilities;

import com.ibm.etools.emf.ecore.utilities.DanglingHREFException;
import com.ibm.etools.emf.ecore.utilities.IsLoadingDetector;
import com.ibm.etools.emf.ecore.utilities.IsLoadingProxyAdapter;
import com.ibm.etools.wft.nls.ResourceHandler;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ExtendedEcoreUtil
extends EcoreUtil {
    private static FileNotFoundDetector FILE_NOT_FOUND_DETECTOR;
    private static String NAME_ATTRIBUTE_STRING;

    public static void setFileNotFoundDetector(FileNotFoundDetector fileNotFoundDetector) {
        FILE_NOT_FOUND_DETECTOR = fileNotFoundDetector;
    }

    public static FileNotFoundDetector getFileNotFoundDetector() {
        if (FILE_NOT_FOUND_DETECTOR == null) {
            FILE_NOT_FOUND_DETECTOR = new FileNotFoundDetector(){

                public boolean isFileNotFound(WrappedException wrappedException) {
                    return ExtendedEcoreUtil.getInnerFileNotFoundException(wrappedException) != null;
                }
            };
        }
        return FILE_NOT_FOUND_DETECTOR;
    }

    public static FileNotFoundException getInnerFileNotFoundException(WrappedException wrappedException) {
        if (wrappedException.exception() instanceof FileNotFoundException) {
            return (FileNotFoundException)wrappedException.exception();
        }
        if (wrappedException.exception() instanceof WrappedException) {
            return ExtendedEcoreUtil.getInnerFileNotFoundException((WrappedException)wrappedException.exception());
        }
        return null;
    }

    public static void eSetOrAdd(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
        ExtendedEcoreUtil.eSetOrAdd(eObject, eStructuralFeature, object, 0);
    }

    public static void eSetOrAdd(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        if (eStructuralFeature.isMany() && object != null) {
            if (n >= 0) {
                ((List)eObject.eGet(eStructuralFeature)).add(n, object);
            } else {
                ((List)eObject.eGet(eStructuralFeature)).add(object);
            }
        } else {
            eObject.eSet(eStructuralFeature, object);
        }
    }

    public static void eUnsetOrRemove(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
        if (eStructuralFeature == null || eStructuralFeature.isMany()) {
            ((List)eObject.eGet(eStructuralFeature)).remove(object);
        } else {
            eObject.eUnset(eStructuralFeature);
        }
    }

    public static String getName(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (eObject instanceof ENamedElement) {
            return ((ENamedElement)eObject).getName();
        }
        EList eList = eObject.eClass().getEAllAttributes();
        int n = eList.size();
        EAttribute eAttribute = null;
        int n2 = 0;
        while (n2 < n) {
            EAttribute eAttribute2 = (EAttribute)eList.get(n2);
            if (NAME_ATTRIBUTE_STRING.equals(eAttribute2.getName())) {
                eAttribute = eAttribute2;
                break;
            }
            ++n2;
        }
        if (eAttribute != null) {
            return (String)eObject.eGet(eAttribute);
        }
        return null;
    }

    public static void addLoadingTag(Resource resource) {
        resource.eAdapters().add((Object)IsLoadingDetector.INSTANCE);
    }

    public static void removeLoadingTag(Resource resource) {
        resource.eAdapters().remove((Object)IsLoadingDetector.INSTANCE);
    }

    public static boolean isLoading(Resource resource) {
        if (resource != null) {
            return resource.eAdapters().contains((Object)IsLoadingDetector.INSTANCE);
        }
        return false;
    }

    public static Adapter createAdapterForLoading(Adapter adapter, EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null || ExtendedEcoreUtil.isLoading(resource)) {
            return new IsLoadingProxyAdapter(adapter, eObject);
        }
        return adapter;
    }

    public static void preRegisterPackage(String string, EPackage.Descriptor descriptor) {
        if (!EPackage.Registry.INSTANCE.containsKey((Object)string)) {
            EPackage.Registry.INSTANCE.put((Object)string, (Object)descriptor);
        }
    }

    public static void unload(EObject eObject) {
        Resource resource = eObject.eResource();
        EObject eObject2 = eObject.eContainer();
        if (eObject2 == null) {
            resource.getContents().remove((Object)eObject);
        } else {
            EReference eReference = eObject.eContainmentFeature();
            ExtendedEcoreUtil.eUnsetOrRemove(eObject2, (EStructuralFeature)eReference, eObject);
        }
        ExtendedEcoreUtil.becomeProxy(eObject, resource);
    }

    public static void becomeProxy(EObject eObject, Resource resource) {
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            ExtendedEcoreUtil.doBecomeProxy((InternalEObject)treeIterator.next(), resource);
        }
        ExtendedEcoreUtil.doBecomeProxy((InternalEObject)eObject, resource);
    }

    protected static void doBecomeProxy(InternalEObject internalEObject, Resource resource) {
        internalEObject.eSetProxyURI(resource.getURI().appendFragment(resource.getURIFragment((EObject)internalEObject)));
        internalEObject.eAdapters().clear();
    }

    public static void checkProxy(EObject eObject) throws DanglingHREFException {
        if (eObject == null || !eObject.eIsProxy()) {
            return;
        }
        String string = ResourceHandler.getString((String)"DANGLING_HREF_ERROR_", (Object[])new Object[]{((InternalEObject)eObject).eProxyURI()});
        throw new DanglingHREFException(string);
    }

    static {
        NAME_ATTRIBUTE_STRING = "name";
    }

    public static interface FileNotFoundDetector {
        public boolean isFileNotFound(WrappedException var1);
    }
}

