/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.ecore.utilities;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class IDUtil {
    public static void assignID(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof XMLResource) {
            IDUtil.assignID(eObject, (XMLResource)resource);
        }
    }

    public static String getOrAssignID(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof XMLResource) {
            return IDUtil.getOrAssignID(eObject, (XMLResource)resource);
        }
        return null;
    }

    public static String getOrAssignID(EObject eObject, XMLResource xMLResource) {
        String string = xMLResource.getID(eObject);
        if (string == null) {
            return IDUtil.assignID(eObject, xMLResource);
        }
        return string;
    }

    public static String assignID(EObject eObject, XMLResource xMLResource) {
        String string = IDUtil.getBaseIDForAssignment(eObject);
        if (string == null) {
            return null;
        }
        String string2 = IDUtil.ensureUniqueID(xMLResource, string);
        xMLResource.setID(eObject, string2);
        return string2;
    }

    protected static String ensureUniqueID(XMLResource xMLResource, String string) {
        string = string + "_";
        long l = System.currentTimeMillis();
        String string2 = string + l;
        Map map = xMLResource.getIDToEObjectMap();
        while (map.get(string2) != null) {
            string2 = string + ++l;
        }
        return string2;
    }

    protected static String getBaseIDForAssignment(EObject eObject) {
        EClass eClass = eObject.eClass();
        return eClass.getName();
    }
}

