/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.ecore.utilities;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public class ResourceDependencyRegister {
    private static final String copyright = "(c) Copyright IBM Corporation 2003.";
    protected static Map GLOBAL_DEPENDENCIES = new HashMap();
    private static String RESOURCE_DEPENDENCY_TYPE = "ResourceDependencyAdapter";
    protected Map localDependencies = new HashMap();

    public static void registerDependency(URI uRI, URI uRI2) {
        if (uRI != null && uRI2 != null) {
            GLOBAL_DEPENDENCIES.put(uRI2, uRI);
        }
    }

    public ResourceDependencyRegister(ResourceSet resourceSet) {
        this.initialize(resourceSet);
    }

    ResourceDependencyRegister() {
    }

    protected void initialize(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new NullPointerException("The ResourceSet cannot be null.");
        }
        this.initializeLocalDependencies(resourceSet);
        this.setupDependencyAdapters(resourceSet);
        this.setupResourceSetListener(resourceSet);
    }

    protected void setupResourceSetListener(ResourceSet resourceSet) {
        resourceSet.eAdapters().add((Object)new ResourceSetListener());
    }

    protected void setupDependencyAdapters(ResourceSet resourceSet) {
        if (!resourceSet.getResources().isEmpty()) {
            Iterator iterator = this.localDependencies.entrySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                URI uRI = (URI)entry.getKey();
                URI uRI2 = (URI)entry.getValue();
                this.setupDependencyAdapter(resourceSet, uRI, uRI2);
            }
        }
    }

    protected void setupDependencyAdapter(ResourceSet resourceSet, URI uRI, URI uRI2) {
        Resource resource = resourceSet.getResource(uRI, false);
        if (resource != null) {
            this.setupDependencyAdapter(resource, uRI2, resourceSet);
        }
    }

    protected void setupDependencyAdapter(Resource resource, URI uRI, ResourceSet resourceSet) {
        Resource resource2 = resourceSet.getResource(uRI, false);
        if (resource2 == null) {
            resource2 = resourceSet.createResource(uRI);
        }
        resource2.eAdapters().add((Object)new ResourceDependencyAdapter(resource));
    }

    protected void initializeLocalDependencies(ResourceSet resourceSet) {
        URIConverter uRIConverter = resourceSet.getURIConverter();
        this.initializeLocalDependencies(uRIConverter);
    }

    protected void initializeLocalDependencies(URIConverter uRIConverter) {
        Iterator iterator = GLOBAL_DEPENDENCIES.entrySet().iterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            URI uRI = (URI)entry.getKey();
            URI uRI2 = (URI)entry.getValue();
            uRI = this.normalize(uRI, uRIConverter, hashMap);
            uRI2 = this.normalize(uRI2, uRIConverter, hashMap);
            this.localDependencies.put(uRI, uRI2);
        }
    }

    protected URI normalize(URI uRI, URIConverter uRIConverter, Map map) {
        URI uRI2 = (URI)map.get(uRI);
        if (uRI2 == null) {
            uRI2 = uRIConverter.normalize(uRI);
            map.put(uRI, uRI2);
        }
        return uRI2;
    }

    protected void proccessAddedResource(ResourceSet resourceSet, Resource resource) {
        URI uRI = (URI)this.localDependencies.get(resource.getURI());
        if (uRI != null) {
            this.setupDependencyAdapter(resource, uRI, resourceSet);
        }
    }

    class ResourceSetListener
    extends AdapterImpl {
        ResourceSetListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 3) {
                ResourceDependencyRegister.this.proccessAddedResource((ResourceSet)notification.getNotifier(), (Resource)notification.getNewValue());
            }
        }
    }

    class ResourceDependencyAdapter
    extends AdapterImpl {
        Resource dependentResource;

        ResourceDependencyAdapter(Resource resource) {
            this.dependentResource = resource;
            this.dependentResource.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(Object object) {
            return RESOURCE_DEPENDENCY_TYPE.equals(object);
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(null)) {
                case 4: {
                    if (notification.getNotifier() == this.dependentResource || !notification.getOldBooleanValue() || notification.getNewBooleanValue()) break;
                    this.dependentResource.unload();
                    break;
                }
                case 0: {
                    if (notification.getOldValue() == null || notification.getNewValue() != null) break;
                    if (notification.getNotifier() == this.dependentResource) {
                        ((Resource)this.getTarget()).eAdapters().remove((Object)this);
                        break;
                    }
                    ResourceSet resourceSet = this.dependentResource.getResourceSet();
                    if (resourceSet == null) break;
                    resourceSet.getResources().remove((Object)this.dependentResource);
                }
            }
        }
    }
}

