/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.ecore.utilities.copy;

import com.ibm.etools.emf.ecore.utilities.copy.CopyGroup;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopyUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class EtoolsCopySession
extends EtoolsCopyUtility {
    public static final int RESOURCE_COPIED = 500;
    private EtoolsCopyUtility parentCopyUtility;
    private XMLResource currentResource;
    private XMLResource currentCopyResource;

    public EtoolsCopySession(EtoolsCopyUtility etoolsCopyUtility) {
        this.parentCopyUtility = etoolsCopyUtility;
        this.setPreserveIds(etoolsCopyUtility.preserveIds());
    }

    public void copy(CopyGroup copyGroup) {
        if (copyGroup != null) {
            this.copyResources(copyGroup);
            this.copyRefObjects(copyGroup);
            this.executeDeferredCopyActions();
            this.notifyNewResourcesCopied(copyGroup);
        }
    }

    public EObject copy(EObject eObject, String string) {
        EObject eObject2 = this.containmentCopy(eObject, string);
        this.executeDeferredCopyActions();
        return eObject2;
    }

    public EObject copyObject(EObject eObject, String string) {
        EObject eObject2 = this.containmentCopyObject(eObject, string);
        this.executeDeferredCopyActions();
        return eObject2;
    }

    public Resource copy(Resource resource, String string) {
        Resource resource2 = this.containmentCopy(resource, string);
        this.executeDeferredCopyActions();
        this.copyModificationFlag(resource, resource2);
        this.notifyNewResourceCopied(resource2);
        return resource2;
    }

    protected void notifyNewResourcesCopied(CopyGroup copyGroup) {
        List list = copyGroup.getCopiedResources();
        int n = 0;
        while (n < list.size()) {
            this.notifyNewResourceCopied((Resource)list.get(n));
            ++n;
        }
    }

    protected void notifyNewResourceCopied(Resource resource) {
        resource.eNotify((Notification)new NotificationImpl(500, null, null));
    }

    protected EObject primCopyObject(EObject eObject, String string) {
        EObject eObject2 = super.primCopyObject(eObject, string);
        this.copyIdIfNecessary(eObject, eObject2, string);
        return eObject2;
    }

    protected void copyIdIfNecessary(EObject eObject, EObject eObject2, String string) {
        if (string == null && !this.preserveIds || this.currentResource == null) {
            return;
        }
        String string2 = this.currentResource.getID(eObject);
        if (string2 == null) {
            return;
        }
        string2 = string == null ? string2 : string2 + string;
        this.currentCopyResource.setID(eObject2, string2);
    }

    public void flush() {
        Iterator iterator = this.getCopiedObjects().entrySet().iterator();
        HashMap hashMap = this.getParentCopyUtility().getCopiedObjects();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            EObject eObject = (EObject)entry.getValue();
            eObject.eSetDeliver(true);
            hashMap.put(entry.getKey(), eObject);
        }
        this.copiedObjects = null;
    }

    public EObject getCopy(EObject eObject) {
        EObject eObject2 = super.getCopy(eObject);
        if (eObject2 == null) {
            eObject2 = this.getParentCopyUtility().getCopy(eObject);
        }
        return eObject2;
    }

    protected EtoolsCopyUtility getParentCopyUtility() {
        return this.parentCopyUtility;
    }

    public EObject newInstance(EObject eObject) {
        EObject eObject2 = super.newInstance(eObject);
        eObject2.eSetDeliver(false);
        return eObject2;
    }

    public Resource newInstance(Resource resource, String string) {
        Resource resource2 = super.newInstance(resource, string);
        if (resource instanceof XMLResource) {
            this.currentResource = (XMLResource)resource;
            this.currentCopyResource = (XMLResource)resource2;
        } else {
            this.currentResource = null;
            this.currentCopyResource = null;
        }
        return resource2;
    }
}

