/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.ecore.utilities.copy;

import com.ibm.etools.emf.ecore.utilities.Association;
import com.ibm.etools.emf.ecore.utilities.DeferredReferenceUtilityAction;
import com.ibm.etools.emf.ecore.utilities.copy.CopyGroup;
import com.ibm.etools.emf.ecore.utilities.copy.EtoolsCopySession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;

public class EtoolsCopyUtility {
    protected static final String REFENUMLITERAL_TYPE_NAME = "EEnumLiteral";
    private final EcorePackage pkg = EcorePackage.eINSTANCE;
    private final ETypedElement METAENAME = this.pkg.getENamedElement_Name();
    protected HashMap copiedObjects;
    protected List deferredReferenceCopies;
    protected boolean preserveIds = false;

    protected void addDeferredManyReferenceCopy(EReference eReference, List list, String string, EObject eObject) {
        this.getDeferredReferenceCopies().add(new DeferredManyReferenceCopyAction(eReference, list, string, eObject));
    }

    protected void addDeferredSingleReferenceCopy(EReference eReference, EObject eObject, String string, EObject eObject2) {
        this.getDeferredReferenceCopies().add(new DeferredSingleReferenceCopyAction(eReference, eObject, string, eObject2));
    }

    protected EObject containmentCopy(EObject eObject, String string) {
        EObject eObject2 = this.getCopy(eObject);
        if (eObject2 == null) {
            eObject2 = this.primCopy(eObject, string);
        }
        return eObject2;
    }

    protected EObject containmentCopyObject(EObject eObject, String string) {
        EObject eObject2 = this.getCopy(eObject);
        if (eObject2 == null) {
            eObject2 = this.primCopyObject(eObject, string);
        }
        return eObject2;
    }

    protected Resource containmentCopy(Resource resource, String string) {
        return this.primCopy(resource, string);
    }

    public void copy(CopyGroup copyGroup) {
        if (copyGroup != null) {
            EtoolsCopySession etoolsCopySession = new EtoolsCopySession(this);
            etoolsCopySession.setPreserveIds(copyGroup.getPreserveIds());
            etoolsCopySession.copy(copyGroup);
            etoolsCopySession.flush();
        }
    }

    public EObject copy(EObject eObject) {
        return this.copy(eObject, null);
    }

    public EObject copy(EObject eObject, String string) {
        EtoolsCopySession etoolsCopySession = new EtoolsCopySession(this);
        EObject eObject2 = etoolsCopySession.copy(eObject, string);
        etoolsCopySession.flush();
        return eObject2;
    }

    public EObject copyObject(EObject eObject, String string) {
        EtoolsCopySession etoolsCopySession = new EtoolsCopySession(this);
        EObject eObject2 = etoolsCopySession.copyObject(eObject, string);
        etoolsCopySession.flush();
        return eObject2;
    }

    public Resource copy(Resource resource, String string) {
        EtoolsCopySession etoolsCopySession = new EtoolsCopySession(this);
        Resource resource2 = etoolsCopySession.copy(resource, string);
        etoolsCopySession.flush();
        return resource2;
    }

    protected void copyAttribute(EAttribute eAttribute, EObject eObject, String string, EObject eObject2) {
        if (!eAttribute.isChangeable()) {
            return;
        }
        if (eAttribute.isMany()) {
            List list = (List)eObject.eGet((EStructuralFeature)eAttribute);
            if (list != null) {
                this.copyManyAttribute(eAttribute, list, eObject, string, eObject2);
            }
        } else if (eObject.eIsSet((EStructuralFeature)eAttribute)) {
            Object object = eObject.eGet((EStructuralFeature)eAttribute);
            if (object == null) {
                eObject2.eSet((EStructuralFeature)eAttribute, object);
            } else {
                this.copySingleAttribute(eAttribute, object, eObject, string, eObject2);
            }
        } else if (eAttribute == this.METAENAME) {
            eObject2.eSet((EStructuralFeature)eAttribute, eObject.eGet((EStructuralFeature)eAttribute));
        }
    }

    protected void copyCurrentAttributes(EObject eObject, String string, EObject eObject2) {
        EList eList = eObject.eClass().getEAllAttributes();
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                EAttribute eAttribute = (EAttribute)iterator.next();
                this.copyAttribute(eAttribute, eObject, string, eObject2);
            }
        }
    }

    protected void copyCurrentReferences(EObject eObject, String string, EObject eObject2) {
        EList eList = eObject.eClass().getEAllReferences();
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                EReference eReference = (EReference)iterator.next();
                if (!this.shouldCopyReference(eReference)) continue;
                this.copyReference(eReference, eObject, string, eObject2);
            }
        }
    }

    protected void copyExtent(EList eList, EList eList2) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            eList2.add((Object)this.containmentCopy(eObject, null));
        }
    }

    protected void copyManyAttribute(EAttribute eAttribute, List list, EObject eObject, String string, EObject eObject2) {
        if (eAttribute.getEType() == null) {
            eObject2.eSet((EStructuralFeature)eAttribute, (Object)list);
        } else {
            List list2 = (List)eObject2.eGet((EStructuralFeature)eAttribute);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof EObject) {
                    list2.add(this.containmentCopy((EObject)e, string));
                    continue;
                }
                list2.add(e);
            }
        }
    }

    protected void copyManyReference(EReference eReference, List list, EObject eObject, String string, EObject eObject2) {
        if (!list.isEmpty()) {
            if (eReference.isContainment()) {
                List list2 = (List)eObject2.eGet((EStructuralFeature)eReference);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    EObject eObject3 = (EObject)iterator.next();
                    list2.add(this.containmentCopy(eObject3, string));
                }
            } else {
                this.addDeferredManyReferenceCopy(eReference, list, string, eObject2);
            }
        }
    }

    protected void copyReference(EReference eReference, EObject eObject, String string, EObject eObject2) {
        if (eReference.isMany()) {
            List list = (List)eObject.eGet((EStructuralFeature)eReference);
            if (list != null) {
                this.copyManyReference(eReference, list, eObject, string, eObject2);
            }
        } else if (eObject.eIsSet((EStructuralFeature)eReference)) {
            Object object = eObject.eGet((EStructuralFeature)eReference);
            this.copySingleReference(eReference, (EObject)object, eObject, string, eObject2);
        }
    }

    protected void copyRefObjects(CopyGroup copyGroup) {
        if (copyGroup.primGetRefObjects() != null) {
            Iterator iterator = copyGroup.primGetRefObjects().iterator();
            while (iterator.hasNext()) {
                Association association = (Association)iterator.next();
                EObject eObject = (EObject)association.getKey();
                String string = (String)association.getValue();
                if (string == null) {
                    string = copyGroup.getDefaultIdSuffix();
                }
                copyGroup.addCopied(this.containmentCopy(eObject, string));
            }
        }
    }

    protected void copyResources(CopyGroup copyGroup) {
        if (copyGroup.primGetResources() != null) {
            Iterator iterator = copyGroup.primGetResources().iterator();
            while (iterator.hasNext()) {
                Association association = (Association)iterator.next();
                Resource resource = (Resource)association.getKey();
                String string = (String)association.getValue();
                Resource resource2 = this.containmentCopy(resource, string);
                this.copyModificationFlag(resource, resource2);
                copyGroup.addCopied(resource2);
            }
        }
    }

    protected void copySingleAttribute(EAttribute eAttribute, Object object, EObject eObject, String string, EObject eObject2) {
        if (eAttribute.getEType() == null) {
            eObject2.eSet((EStructuralFeature)eAttribute, object);
        } else if (eAttribute.getEType() instanceof EClass) {
            eObject2.eSet((EStructuralFeature)eAttribute, (Object)this.containmentCopy((EObject)object, string));
        } else {
            eObject2.eSet((EStructuralFeature)eAttribute, object);
        }
    }

    protected void copySingleReference(EReference eReference, EObject eObject, EObject eObject2, String string, EObject eObject3) {
        if (eObject != eObject2.eContainer() || eReference.getEOpposite() == null) {
            if (eReference.isContainment()) {
                eObject3.eSet((EStructuralFeature)eReference, (Object)this.containmentCopy(eObject, string));
            } else {
                this.addDeferredSingleReferenceCopy(eReference, eObject, string, eObject3);
            }
        }
    }

    public static void createCopy(CopyGroup copyGroup) {
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        etoolsCopyUtility.copy(copyGroup);
    }

    public static void createAttributeCopy(EObject eObject, EObject eObject2) {
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        etoolsCopyUtility.copyCurrentAttributes(eObject, null, eObject2);
    }

    public static EObject createCopy(EObject eObject) {
        return EtoolsCopyUtility.createCopy(eObject, null);
    }

    public static EObject createCopy(EObject eObject, String string) {
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        return etoolsCopyUtility.copy(eObject, string);
    }

    public static Resource createCopy(Resource resource, String string) {
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        return etoolsCopyUtility.copy(resource, string);
    }

    protected void executeDeferredCopyActions() {
        if (this.primGetDeferredReferenceCopies() != null) {
            Iterator iterator = this.primGetDeferredReferenceCopies().iterator();
            while (iterator.hasNext()) {
                DeferredReferenceUtilityAction deferredReferenceUtilityAction = (DeferredReferenceUtilityAction)iterator.next();
                deferredReferenceUtilityAction.performAction();
            }
            this.primGetDeferredReferenceCopies().clear();
        }
    }

    protected HashMap getCopiedObjects() {
        if (this.copiedObjects == null) {
            this.copiedObjects = new HashMap(200);
        }
        return this.copiedObjects;
    }

    public EObject getCopy(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return (EObject)this.getCopiedObjects().get(eObject);
    }

    public EObject getCopyIfFound(EObject eObject) {
        EObject eObject2 = this.getCopy(eObject);
        return eObject2 == null ? eObject : eObject2;
    }

    protected List getDeferredReferenceCopies() {
        if (this.deferredReferenceCopies == null) {
            this.deferredReferenceCopies = new ArrayList(100);
        }
        return this.deferredReferenceCopies;
    }

    public EObject newInstance(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        EPackage ePackage = (EPackage)eObject.eClass().eContainer();
        EFactory eFactory = ePackage.getEFactoryInstance();
        EClass eClass = eObject.eClass();
        return eFactory.create(eClass);
    }

    public Resource newInstance(Resource resource, String string) {
        if (resource == null) {
            return null;
        }
        String string2 = resource.getURI().toString();
        string = string == null ? string2 : string;
        Resource.Factory factory = null;
        factory = resource.getResourceSet() == null ? Resource.Factory.Registry.INSTANCE.getFactory(URI.createDeviceURI((String)string2)) : resource.getResourceSet().getResourceFactoryRegistry().getFactory(URI.createDeviceURI((String)string2));
        Resource resource2 = factory.createResource(URI.createDeviceURI((String)string));
        return resource2;
    }

    public boolean preserveIds() {
        return this.preserveIds;
    }

    protected EObject primCopy(EObject eObject, String string) {
        if (eObject == null) {
            return null;
        }
        EObject eObject2 = this.primCopyObject(eObject, string);
        this.copyCurrentReferences(eObject, string, eObject2);
        return eObject2;
    }

    protected EObject primCopyObject(EObject eObject, String string) {
        if (eObject == null) {
            return null;
        }
        EObject eObject2 = this.newInstance(eObject);
        this.recordCopy(eObject, eObject2);
        this.copyCurrentAttributes(eObject, string, eObject2);
        return eObject2;
    }

    protected Resource primCopy(Resource resource, String string) {
        if (resource == null) {
            return null;
        }
        Resource resource2 = this.newInstance(resource, string);
        this.copyExtent(resource.getContents(), resource2.getContents());
        return resource2;
    }

    protected void copyModificationFlag(Resource resource, Resource resource2) {
        if (resource.isModified()) {
            resource2.setModified(true);
        }
    }

    private List primGetDeferredReferenceCopies() {
        return this.deferredReferenceCopies;
    }

    public void recordCopy(EObject eObject, EObject eObject2) {
        this.getCopiedObjects().put(eObject, eObject2);
    }

    public void setPreserveIds(boolean bl) {
        this.preserveIds = bl;
    }

    protected boolean shouldCopyReference(EReference eReference) {
        return eReference.isChangeable();
    }

    protected class DeferredManyReferenceCopyAction
    extends DeferredReferenceUtilityAction {
        public DeferredManyReferenceCopyAction(EReference eReference, List list, String string, EObject eObject) {
            super(eReference, list, string, eObject);
        }

        public void performAction() {
            List list = (List)this.getCopyContainer().eGet((EStructuralFeature)this.getReference());
            Iterator iterator = ((List)this.getReferenceValue()).iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                list.add(EtoolsCopyUtility.this.getCopyIfFound(eObject));
            }
        }
    }

    protected class DeferredSingleReferenceCopyAction
    extends DeferredReferenceUtilityAction {
        public DeferredSingleReferenceCopyAction(EReference eReference, Object object, String string, EObject eObject) {
            super(eReference, object, string, eObject);
        }

        public void performAction() {
            EObject eObject = (EObject)this.getReferenceValue();
            this.getCopyContainer().eSet((EStructuralFeature)this.getReference(), (Object)EtoolsCopyUtility.this.getCopyIfFound(eObject));
        }
    }
}

