/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.xmi.helpers;

import com.ibm.etools.emf.ecore.utilities.IDUtil;
import com.ibm.etools.xmi.helpers.CompatibilityURIConverter;
import com.ibm.etools.xmi.helpers.CompatibilityXMIResource;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;

public class MappedXMIHelper
extends XMLHelperImpl {
    private static final String WORKSPACE_PROTOCOL = "workspace:/";
    private static final String PLATFORM_RESOURCE_PROTOCOL = "platform:/resource/";
    protected boolean usingMaps = true;
    protected Map cachedRelativeURIs;
    protected Map packageURIsToPrefixes;

    public MappedXMIHelper(XMLResource xMLResource, Map map) {
        super(xMLResource);
        this.prefixesToURIs = map;
    }

    public URI resolve(URI uRI, URI uRI2) {
        URI uRI3 = null;
        boolean bl = false;
        ResourceSet resourceSet = this.getResource().getResourceSet();
        if (resourceSet != null) {
            URI uRI4 = null;
            uRI4 = uRI.hasFragment() ? uRI.trimFragment() : uRI;
            boolean bl2 = bl = !((URIConverterImpl.URIMap)resourceSet.getURIConverter().getURIMap()).getURI(uRI4).equals((Object)uRI4);
        }
        if (!bl) {
            if (this.isUsingContainerRelativePaths() && resourceSet != null) {
                uRI3 = resourceSet.getURIConverter().normalize(uRI);
            }
        } else {
            uRI3 = uRI;
        }
        return uRI3 == null ? super.resolve(uRI, uRI2) : uRI3;
    }

    private boolean isUsingContainerRelativePaths() {
        return ((CompatibilityXMIResource)this.resource).getFormat() == 1 || this.usingMaps;
    }

    public void addPrefix(String string, String string2) {
        String string3;
        if (string2.endsWith(".ecore")) {
            this.usingMaps = false;
        }
        if ((string3 = (String)this.prefixesToURIs.get(string)) == null) {
            this.prefixesToURIs.put(string, string2);
        } else if (!string3.equals(string2)) {
            this.getCompatibilityResource().addOriginalPackageURI(string3, string2);
            this.getCompatibilityResource().setFormat(1);
        }
    }

    protected CompatibilityXMIResource getCompatibilityResource() {
        return (CompatibilityXMIResource)this.getResource();
    }

    public String getHREF(EObject eObject) {
        URIConverter uRIConverter;
        if (!this.getCompatibilityResource().usesDefaultFormat() && (uRIConverter = this.getURIConverter()) != null && uRIConverter instanceof CompatibilityURIConverter) {
            String string = this.getCompatibliltyHREF(eObject, (CompatibilityURIConverter)uRIConverter);
            return this.useWorkspaceProtocolIfNecessary(string);
        }
        return super.getHREF(eObject);
    }

    protected String useWorkspaceProtocolIfNecessary(String string) {
        if (string != null && string.startsWith(PLATFORM_RESOURCE_PROTOCOL)) {
            return WORKSPACE_PROTOCOL + string.substring(19);
        }
        return string;
    }

    private String getCompatibliltyHREF(EObject eObject, CompatibilityURIConverter compatibilityURIConverter) {
        InternalEObject internalEObject = (InternalEObject)eObject;
        URI uRI = internalEObject.eProxyURI();
        if (uRI == null) {
            Resource resource = eObject.eResource();
            if (resource == null) {
                uRI = this.handleDanglingHREF(eObject);
                if (uRI == null) {
                    return null;
                }
            } else {
                uRI = resource.getURI().appendFragment(resource.getURIFragment(eObject));
            }
        }
        if (!uRI.isRelative()) {
            uRI = this.makeRelative(uRI, compatibilityURIConverter);
        }
        return uRI.toString();
    }

    protected URI makeRelative(URI uRI, CompatibilityURIConverter compatibilityURIConverter) {
        String string = uRI.fragment();
        uRI = uRI.trimFragment();
        URI uRI2 = (URI)this.getCachedRelativeURIs().get(uRI);
        if (uRI2 == null && (uRI2 = compatibilityURIConverter.deNormalize(uRI)).isRelative()) {
            this.cachedRelativeURIs.put(uRI, uRI2);
        }
        return uRI2.appendFragment(string);
    }

    protected URIConverter getURIConverter() {
        ResourceSet resourceSet = this.getResource().getResourceSet();
        if (resourceSet != null) {
            return resourceSet.getURIConverter();
        }
        return null;
    }

    protected Map getCachedRelativeURIs() {
        if (this.cachedRelativeURIs == null) {
            this.cachedRelativeURIs = new HashMap();
        }
        return this.cachedRelativeURIs;
    }

    public String getID(EObject eObject) {
        if (this.getCompatibilityResource().usesDefaultFormat()) {
            return super.getID(eObject);
        }
        return IDUtil.getOrAssignID(eObject, this.resource);
    }

    public String[] getNSInfo(EPackage ePackage) {
        String string = this.getMappedPrefix(ePackage);
        if (string == null) {
            return new String[]{ePackage.getNsPrefix(), ePackage.getNsURI()};
        }
        return new String[]{string, string + ".xmi"};
    }

    protected String getMappedPrefix(EPackage ePackage) {
        String string = ePackage.getNsURI();
        if (this.usingMaps || !this.getCompatibilityResource().usesDefaultFormat()) {
            return (String)this.packageURIsToPrefixes.get(string);
        }
        return null;
    }

    protected String getMappedPrefixOrDefault(EPackage ePackage) {
        String string = this.getMappedPrefix(ePackage);
        return string == null ? ePackage.getNsPrefix() : string;
    }

    public Map getPackageURIsToPrefixes() {
        return this.packageURIsToPrefixes;
    }

    public void setPackageURIsToPrefixes(Map map) {
        this.packageURIsToPrefixes = map;
    }

    public String getQName(EClass eClass) {
        EPackage ePackage;
        String string = this.getName((ENamedElement)eClass);
        if (this.xmlMap != null && (ePackage = this.xmlMap.getInfo((ENamedElement)eClass)) != null) {
            String string2 = ePackage.getTargetNamespace();
            return this.getQName(string2, string);
        }
        ePackage = eClass.getEPackage();
        this.packages.put(ePackage, null);
        if (ePackage.getNsPrefix().equals("")) {
            return string;
        }
        return this.getMappedPrefixOrDefault(ePackage) + ":" + string;
    }

    public void setValue(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        if (!eStructuralFeature.isTransient()) {
            if (object == null && eStructuralFeature.getEType().getInstanceClass() != null && eStructuralFeature.getEType().getInstanceClass().isPrimitive()) {
                return;
            }
            super.setValue(eObject, eStructuralFeature, object, n);
        }
    }
}

