/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.module;

import com.ibm.security.auth.NTDomainPrincipal;
import com.ibm.security.auth.NTNumericCredential;
import com.ibm.security.auth.NTSidDomainPrincipal;
import com.ibm.security.auth.NTSidGroupPrincipal;
import com.ibm.security.auth.NTSidPrimaryGroupPrincipal;
import com.ibm.security.auth.NTSidUserPrincipal;
import com.ibm.security.auth.NTUserPrincipal;
import com.ibm.security.auth.module.NTActiveSystem;
import java.io.IOException;
import java.security.Principal;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class NTActiveLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private NTUserPrincipal usernamePrincipal;
    private NTSidUserPrincipal userIDPrincipal;
    private NTDomainPrincipal domainPrincipal;
    private NTSidDomainPrincipal domainIDPrincipal;
    private NTSidPrimaryGroupPrincipal primaryGroupIDPrincipal;
    private LinkedList supplementaryGroups = new LinkedList();
    private NTNumericCredential numericCredential;
    private NTActiveSystem system;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    public boolean login() throws LoginException {
        Object object;
        String[] stringArray = null;
        this.succeeded = false;
        this.system = null;
        if (this.callbackHandler == null) {
            this.system = new NTActiveSystem();
            if (this.system == null) {
                if (this.debug) {
                    System.out.println("\t\t[NTActiveLoginModule] Failed in NT login");
                }
                throw new FailedLoginException("Failed in attempt to import the underlying NT system identity information");
            }
        } else {
            Callback[] callbackArray = new Callback[]{new NameCallback("NT username: "), new PasswordCallback("NT password: ", false)};
            try {
                this.callbackHandler.handle(callbackArray);
                String string = ((NameCallback)callbackArray[0]).getName();
                char[] cArray = ((PasswordCallback)callbackArray[1]).getPassword();
                object = new char[cArray.length];
                System.arraycopy(cArray, 0, object, 0, cArray.length);
                ((PasswordCallback)callbackArray[1]).clearPassword();
                this.system = new NTActiveSystem(string, (char[])object);
                if (this.system == null) {
                    if (this.debug) {
                        System.out.println("\t\t[NTActiveLoginModule] Failed in NT login");
                    }
                    throw new FailedLoginException("Failed in NT login");
                }
            }
            catch (IOException iOException) {
                throw new LoginException(iOException.toString());
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to garner authentication " + "information from the user");
            }
        }
        if (this.debug) {
            System.out.println("\t\t[NTActiveLoginModule]: succeeded importing info: ");
            System.out.println("\t\t\tuser       = " + this.system.getName());
            System.out.println("\t\t\tuser id    = " + this.system.getUserSID());
            System.out.println("\t\t\tdomain     = " + this.system.getDomain());
            System.out.println("\t\t\tdomain id  = " + this.system.getDomainSID());
            System.out.println("\t\t\tgroup id   = " + this.system.getPrimaryGroupID());
            stringArray = this.system.getGroupIDs();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("\t\t\tsupp gid = " + stringArray[i]);
            }
            System.out.println("\t\t\tnumeric credential = " + this.system.getImpersonationToken());
        }
        this.usernamePrincipal = new NTUserPrincipal(this.system.getName());
        this.userIDPrincipal = new NTSidUserPrincipal(this.system.getUserSID());
        this.domainPrincipal = new NTDomainPrincipal(this.system.getDomain());
        if (!this.system.getDomainSID().equals("")) {
            this.domainIDPrincipal = new NTSidDomainPrincipal(this.system.getDomainSID());
        }
        this.primaryGroupIDPrincipal = new NTSidPrimaryGroupPrincipal(this.system.getPrimaryGroupID());
        if (this.system.getGroupIDs() != null && this.system.getGroupIDs().length > 0) {
            stringArray = this.system.getGroupIDs();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            object = new NTSidGroupPrincipal(stringArray[i]);
            if (object.getName().equals(this.primaryGroupIDPrincipal.getName())) continue;
            this.supplementaryGroups.add(object);
        }
        this.numericCredential = new NTNumericCredential(this.system.getImpersonationToken());
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[NTActiveLoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.usernamePrincipal)) {
            set.add((Principal)this.usernamePrincipal);
            if (this.debug) {
                System.out.println("\t\t[NTActiveLoginModule]: added NTUserPrincipal");
            }
        }
        if (!set.contains(this.userIDPrincipal)) {
            set.add((Principal)this.userIDPrincipal);
            if (this.debug) {
                System.out.println("\t\t[NTActiveLoginModule]: added NTSidUserPrincipal");
            }
        }
        if (!set.contains(this.domainPrincipal)) {
            set.add((Principal)this.domainPrincipal);
            if (this.debug) {
                System.out.println("\t\t[NTActiveLoginModule]: added NTDomainPrincipal");
            }
        }
        if (this.domainIDPrincipal != null && !set.contains(this.domainIDPrincipal)) {
            set.add((Principal)this.domainIDPrincipal);
            if (this.debug) {
                System.out.println("\t\t[NTActiveLoginModule]: added NTSidDomainPrincipal");
            }
        }
        if (!set.contains(this.primaryGroupIDPrincipal)) {
            set.add((Principal)this.primaryGroupIDPrincipal);
            if (this.debug) {
                System.out.println("\t\t[NTActiveLoginModule]: added NTSidPrimaryGroupPrincipal");
            }
        }
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            if (set.contains(this.supplementaryGroups.get(i))) continue;
            set.add((Principal)this.supplementaryGroups.get(i));
            if (!this.debug) continue;
            System.out.println("\t\t[NTActiveLoginModule]: added NTSidGroupPrincipal");
        }
        if (!this.subject.getPublicCredentials().contains(this.numericCredential)) {
            this.subject.getPublicCredentials().add(this.numericCredential);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[NTActiveLoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.usernamePrincipal = null;
            this.userIDPrincipal = null;
            this.domainPrincipal = null;
            this.domainIDPrincipal = null;
            this.supplementaryGroups = null;
            this.primaryGroupIDPrincipal = null;
            this.numericCredential = null;
            this.system = null;
            this.succeeded = false;
        } else {
            this.logout();
        }
        return this.succeeded;
    }

    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        set.remove(this.usernamePrincipal);
        set.remove(this.userIDPrincipal);
        set.remove(this.domainPrincipal);
        set.remove(this.domainIDPrincipal);
        set.remove(this.primaryGroupIDPrincipal);
        set.remove(this.numericCredential);
        for (int i = 0; i < this.supplementaryGroups.size(); ++i) {
            set.remove(this.supplementaryGroups.get(i));
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.system.logoff();
        this.usernamePrincipal = null;
        this.domainPrincipal = null;
        this.userIDPrincipal = null;
        this.domainIDPrincipal = null;
        this.supplementaryGroups = null;
        this.primaryGroupIDPrincipal = null;
        this.numericCredential = null;
        this.system = null;
        if (this.debug) {
            System.out.println("\t\t[NTActiveLoginModule] completed logout processing");
        }
        return true;
    }
}

