/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AddTaskAction;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ConvertLineDelimitersAction;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;

public class TextEditor
extends StatusTextEditor {
    private static final String LINE_NUMBER_RULER = "lineNumberRuler";
    private static final String LINE_NUMBER_COLOR = "lineNumberColor";
    private static final String OVERVIEW_RULER = "overviewRuler";
    private static final String UNKNOWN_INDICATION_IN_OVERVIEW_RULER = "othersIndicationInOverviewRuler";
    private static final String UNKNOWN_INDICATION = "othersIndication";
    private static final String UNKNOWN_INDICATION_COLOR = "othersIndicationColor";
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private static final String PRINT_MARGIN = "printMargin";
    private static final String PRINT_MARGIN_COLOR = "printMarginColor";
    private static final String PRINT_MARGIN_COLUMN = "printMarginColumn";
    protected IOverviewRuler fOverviewRuler;
    protected IAnnotationAccess fAnnotationAccess;
    protected SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    protected LineNumberRulerColumn fLineNumberRulerColumn;
    protected DefaultEncodingSupport fEncodingSupport;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    static /* synthetic */ Class class$0;

    public TextEditor() {
        this.initializeKeyBindingScopes();
        this.initializeEditor();
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
    }

    protected void initializeEditor() {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#TextEditorContext");
        this.setRulerContextMenuId("#TextRulerContext");
        this.setHelpContextId("org.eclipse.ui.text_editor_context");
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
    }

    public void dispose() {
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        this.fAnnotationPreferences = null;
        this.fAnnotationAccess = null;
        super.dispose();
    }

    public void doSaveAs() {
        if (this.askIfNonWorkbenchEncodingIsOk()) {
            super.doSaveAs();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.askIfNonWorkbenchEncodingIsOk()) {
            super.doSave(monitor);
        } else {
            monitor.setCanceled(true);
        }
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize(this);
    }

    private boolean askIfNonWorkbenchEncodingIsOk() {
        if (this.fEncodingSupport == null) {
            return true;
        }
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IStorageDocumentProvider) {
            IEditorInput input = this.getEditorInput();
            IStorageDocumentProvider storageProvider = (IStorageDocumentProvider)provider;
            String encoding = storageProvider.getEncoding(input);
            String defaultEncoding = storageProvider.getDefaultEncoding();
            if (encoding != null && !encoding.equals(defaultEncoding)) {
                Shell shell = this.getSite().getShell();
                String title = TextEditorMessages.getString("Editor.warning.save.nonWorkbenchEncoding.title");
                String msg = input != null ? MessageFormat.format(TextEditorMessages.getString("Editor.warning.save.nonWorkbenchEncoding.message1"), input.getName(), encoding) : MessageFormat.format(TextEditorMessages.getString("Editor.warning.save.nonWorkbenchEncoding.message2"), encoding);
                return MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
            }
        }
        return true;
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        FileEditorInput newInput;
        IDocumentProvider provider;
        block20: {
            IFile original;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            if (provider.isDeleted((Object)input) && original != null) {
                String message = MessageFormat.format(TextEditorMessages.getString("Editor.warning.save.delete"), original.getName());
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(filePath);
            newInput = new FileEditorInput(file);
            WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
                private final /* synthetic */ IEditorInput val$newInput;
                {
                    this.val$newInput = iEditorInput;
                }

                public void execute(IProgressMonitor monitor) throws CoreException {
                    TextEditor.this.getDocumentProvider().saveDocument(monitor, (Object)this.val$newInput, TextEditor.this.getDocumentProvider().getDocument((Object)TextEditor.this.getEditorInput()), true);
                }
            };
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
                    success = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException x) {
                    Throwable targetException = x.getTargetException();
                    String title = TextEditorMessages.getString("Editor.error.save.title");
                    String msg = MessageFormat.format(TextEditorMessages.getString("Editor.error.save.message"), targetException.getMessage());
                    if (!(targetException instanceof CoreException)) break block20;
                    CoreException coreException = (CoreException)targetException;
                    IStatus status = coreException.getStatus();
                    if (status != null) {
                        switch (status.getSeverity()) {
                            case 1: {
                                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            case 2: {
                                MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                            default: {
                                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                break;
                            }
                        }
                        break block20;
                    }
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
        }
        Object var19_21 = null;
        provider.changed((Object)newInput);
        if (success) {
            this.setInput((IEditorInput)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createActions() {
        super.createActions();
        AddTaskAction action = new AddTaskAction(TextEditorMessages.getResourceBundle(), "Editor.AddTask.", (ITextEditor)this);
        action.setHelpContextId("org.eclipse.ui.addTask_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.setAction("addTask", (IAction)action);
        action = new ConvertLineDelimitersAction(TextEditorMessages.getResourceBundle(), "Editor.ConvertToWindows.", (ITextEditor)this, "\r\n");
        action.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToWindows_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toWindows");
        this.setAction("ConvertLineDelimitersToWindows", (IAction)action);
        action = new ConvertLineDelimitersAction(TextEditorMessages.getResourceBundle(), "Editor.ConvertToUNIX.", (ITextEditor)this, "\n");
        action.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToUNIX_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toUNIX");
        this.setAction("ConvertLineDelimitersToUNIX", (IAction)action);
        action = new ConvertLineDelimitersAction(TextEditorMessages.getResourceBundle(), "Editor.ConvertToMac.", (ITextEditor)this, "\r");
        action.setHelpContextId("org.eclipse.ui.ConvertLineDelimitersToMAC_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.convert.lineDelimiters.toMac");
        this.setAction("ConvertLineDelimitersToMAC", (IAction)action);
        this.markAsStateDependentAction("ConvertLineDelimitersToWindows", true);
        this.markAsStateDependentAction("ConvertLineDelimitersToUNIX", true);
        this.markAsStateDependentAction("ConvertLineDelimitersToMAC", true);
        this.installEncodingSupport();
    }

    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.IEncodingSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.fEncodingSupport;
        }
        return super.getAdapter(adapter);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
        this.fOverviewRuler = new OverviewRuler(this.fAnnotationAccess, 12, sharedColors);
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference preference = (AnnotationPreference)e.next();
            if (!preference.contributesToHeader()) continue;
            this.fOverviewRuler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        SourceViewer sourceViewer = new SourceViewer(parent, ruler, this.fOverviewRuler, this.isOverviewRulerVisible(), styles);
        this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)sourceViewer, this.fOverviewRuler, this.fAnnotationAccess, sharedColors);
        this.configureSourceViewerDecorationSupport();
        return sourceViewer;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess(this.fAnnotationPreferences);
    }

    protected void configureSourceViewerDecorationSupport() {
        Iterator e = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            this.fSourceViewerDecorationSupport.setAnnotationPreference((AnnotationPreference)e.next());
        }
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)"org.eclipse.ui.workbench.texteditor.unknown", UNKNOWN_INDICATION_COLOR, UNKNOWN_INDICATION, UNKNOWN_INDICATION_IN_OVERVIEW_RULER, 0);
        this.fSourceViewerDecorationSupport.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        this.fSourceViewerDecorationSupport.setMarginPainterPreferenceKeys(PRINT_MARGIN, PRINT_MARGIN_COLOR, PRINT_MARGIN_COLUMN);
        this.fSourceViewerDecorationSupport.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    private void showOverviewRuler() {
        if (this.getSourceViewer() instanceof ISourceViewerExtension) {
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(true);
            this.fSourceViewerDecorationSupport.updateOverviewDecorations();
        }
    }

    private void hideOverviewRuler() {
        if (this.getSourceViewer() instanceof ISourceViewerExtension) {
            this.fSourceViewerDecorationSupport.hideAnnotationOverview();
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(false);
        }
    }

    protected boolean isOverviewRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(OVERVIEW_RULER) : false;
    }

    private void showLineNumberRuler() {
        IVerticalRuler v;
        if (this.fLineNumberRulerColumn == null && (v = this.getVerticalRuler()) instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(1, this.createLineNumberRulerColumn());
        }
    }

    private void hideLineNumberRuler() {
        if (this.fLineNumberRulerColumn != null) {
            IVerticalRuler v = this.getVerticalRuler();
            if (v instanceof CompositeRuler) {
                CompositeRuler c = (CompositeRuler)v;
                c.removeDecorator(1);
            }
            this.fLineNumberRulerColumn = null;
        }
    }

    private boolean isLineNumberRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean(LINE_NUMBER_RULER) : false;
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            RGB rgb = null;
            if (store.contains(LINE_NUMBER_COLOR)) {
                rgb = store.isDefault(LINE_NUMBER_COLOR) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR) : PreferenceConverter.getColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR);
            }
            rulerColumn.setForeground(sharedColors.getColor(rgb));
            rgb = null;
            if (!store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") && store.contains("AbstractTextEditor.Color.Background")) {
                rgb = store.isDefault("AbstractTextEditor.Color.Background") ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background") : PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
            }
            rulerColumn.setBackground(sharedColors.getColor(rgb));
            rulerColumn.redraw();
        }
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new LineNumberRulerColumn();
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12));
        if (this.isLineNumberRulerVisible()) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        }
        return ruler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block13: {
            block12: {
                block11: {
                    block10: {
                        try {
                            ISourceViewer sourceViewer = this.getSourceViewer();
                            if (sourceViewer == null) {
                                Object var4_3 = null;
                                break block10;
                            }
                            String property = event.getProperty();
                            if (this.fSourceViewerDecorationSupport != null && this.fOverviewRuler != null && OVERVIEW_RULER.equals(property)) {
                                if (this.isOverviewRulerVisible()) {
                                    this.showOverviewRuler();
                                    break block11;
                                } else {
                                    this.hideOverviewRuler();
                                }
                                break block11;
                            }
                            if (LINE_NUMBER_RULER.equals(property)) {
                                if (this.isLineNumberRulerVisible()) {
                                    this.showLineNumberRuler();
                                    break block12;
                                } else {
                                    this.hideLineNumberRuler();
                                }
                                break block12;
                            }
                            if (this.fLineNumberRulerColumn != null && (LINE_NUMBER_COLOR.equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property))) {
                                this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
                            }
                            break block13;
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            super.handlePreferenceStoreChanged(event);
                            throw throwable;
                        }
                    }
                    super.handlePreferenceStoreChanged(event);
                    return;
                }
                Object var4_4 = null;
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var4_5 = null;
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var4_7 = null;
        super.handlePreferenceStoreChanged(event);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
    }
}

