/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.CacheObject;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.math.BigInteger;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;

public class AuthCache
extends Cache
implements SecurityCache {
    private static AuthCache authCache = null;
    private long cushion = -1L;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$AuthCache == null ? (class$com$ibm$ws$security$auth$AuthCache = AuthCache.class$("com.ibm.ws.security.auth.AuthCache")) : class$com$ibm$ws$security$auth$AuthCache), null, (String)"com.ibm.ejs.resources.security");
    protected static boolean authCacheEnabled = true;
    protected static boolean allowLookupByBasicAuth = true;
    public static final String AUTH_CACHE_ENABLED = "com.ibm.websphere.security.util.authCacheEnabled";
    public static final String AUTH_CACHE_SIZE = "com.ibm.websphere.security.util.authCacheSize";
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    static /* synthetic */ Class class$com$ibm$ws$security$auth$AuthCache;

    public static synchronized AuthCache getInstance() {
        if (authCache == null) {
            Long l = (Long)SecurityConfig.getConfig().getValue("security.CacheTimeout");
            long l2 = l;
            if (tc.isDebugEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("security cache timeout is " + l2));
            }
            Cache.setDefaultTimeout(l2 * 1000L);
            String string = System.getProperty(AUTH_CACHE_SIZE);
            if (string == null || string == "" || new Integer(string) < 0) {
                string = "200";
            }
            authCache = new AuthCache((int)new Integer(string), l2 * 1000L);
        }
        return authCache;
    }

    private AuthCache(int n, long l) {
        super(n, l, true);
        String string = System.getProperty(AUTH_CACHE_ENABLED);
        authCacheEnabled = string == null ? true : !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
        allowLookupByBasicAuth = string == null || !string.equalsIgnoreCase("BasicAuthDisabled");
    }

    public void removeEntry(String string, String string2) throws CacheException {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"removeEntry");
            }
            if (string2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeEntry");
                }
                return;
            }
            if (string == null) {
                string = ContextManagerFactory.getInstance().getDefaultRealm();
            }
            try {
                String string3 = string + ":" + string2;
                CacheObject cacheObject = (CacheObject)this.get(string3);
                if (cacheObject != null) {
                    Object[] objectArray = cacheObject.getKeyArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object = objectArray[i];
                        this.remove(object);
                        if (!(object instanceof ByteArray)) continue;
                        WSCredentialTokenMapper.getInstance().invalidateDistributedObject((Object)((ByteArray)object));
                    }
                    break block10;
                }
                throw new CacheException("User entry not found, check case sensitivity.");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.removeEntry", (String)"133", (Object)this);
                Tr.debug((TraceComponent)tc, (String)"Exception removing credential from cache: ", (Object)new Object[]{exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeEntry");
                }
                throw new CacheException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeEntry");
        }
    }

    public void removeEntry(CacheObject cacheObject) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeEntry");
        }
        if (cacheObject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeEntry");
            }
            return;
        }
        try {
            Object[] objectArray = cacheObject.getKeyArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                this.remove(object);
                if (!(object instanceof ByteArray)) continue;
                WSCredentialTokenMapper.getInstance().invalidateDistributedObject((Object)((ByteArray)object));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.removeEntry", (String)"172", (Object)this);
            Tr.debug((TraceComponent)tc, (String)"Exception removing credential from cache: ", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeEntry");
            }
            throw new CacheException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeEntry");
        }
    }

    public void removeAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAllEntries");
        }
        this.clearAllEntries();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAllEntries");
        }
    }

    public Subject getSubject(byte[] byArray) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject(token)");
        }
        Subject subject = null;
        if (authCacheEnabled) {
            ByteArray byteArray = new ByteArray(byArray);
            subject = this.getSubject(byteArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject(token)");
        }
        return subject;
    }

    public Subject getSubject(Object object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject(object)");
        }
        Subject subject = null;
        if (authCacheEnabled) {
            CacheObject cacheObject = null;
            try {
                cacheObject = (CacheObject)this.get(object);
                if (cacheObject != null) {
                    subject = cacheObject.getSubject();
                    Map map = cacheObject.getPropTokenMap();
                    if (map != null) {
                        this.setPropTokenMapOnThread(map);
                    }
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception trying to get object from cache.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.getSubject", (String)"234", (Object)this);
                throw new CacheException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject(object)");
        }
        return subject;
    }

    public Subject getSubject(String string, String string2, String string3) throws CacheException {
        Subject subject;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSubject(realm, user, password)");
            }
            subject = null;
            try {
                if (!authCacheEnabled || !allowLookupByBasicAuth) break block19;
                if (string2 == null || string3 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Null id or password, returning null credential");
                    }
                    return null;
                }
                BasicAuthCacheData basicAuthCacheData = new BasicAuthCacheData();
                basicAuthCacheData.realm = string;
                basicAuthCacheData.userId = string2;
                byte[] byArray = null;
                try {
                    byArray = ServerCredSigner.getInstance().getOneWayHash(string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("One-way password hash using SHA is: " + new BigInteger(byArray)));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.getSubject", (String)"275", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.sas.encode.error", (Object)new Object[]{exception});
                }
                basicAuthCacheData.password = byArray != null ? byArray : string3.getBytes();
                String string4 = string + ":" + string2;
                CacheObject cacheObject = (CacheObject)this.get(string4);
                if (cacheObject != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found existing cache entry, checking if the password matches.");
                    }
                    Object[] objectArray = cacheObject.getKeyArray();
                    Object var10_12 = null;
                    boolean bl = false;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!(objectArray[i] instanceof BasicAuthCacheData)) continue;
                        BasicAuthCacheData basicAuthCacheData2 = (BasicAuthCacheData)objectArray[i];
                        if (basicAuthCacheData2 != null && !Arrays.equals(basicAuthCacheData2.password, basicAuthCacheData.password)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Passwords do not match, removing existing entry.");
                            }
                            this.removeEntry(string, string2);
                            continue;
                        }
                        bl = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Passwords match, getting existing Subject.");
                    }
                    if (bl && cacheObject != null) {
                        subject = cacheObject.getSubject();
                        Map map = cacheObject.getPropTokenMap();
                        if (map != null) {
                            this.setPropTokenMapOnThread(map);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Did not find cache entry.  Proceeding to login...");
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.getSubject", (String)"338", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Authentication failed for the userid: " + string2));
                    Tr.debug((TraceComponent)tc, (String)"getSubject(realm, user, pw)", (Object)exception);
                }
                throw new CacheException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject(realm, user, password)");
        }
        return subject;
    }

    public Subject getSubject(String string, String string2) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject(realm, user)");
        }
        Subject subject = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
            }
            securityManager.checkPermission((Permission)MAP_CREDENTIAL);
        }
        try {
            if (authCacheEnabled) {
                if (string2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Null id, returning null credential");
                    }
                    return null;
                }
                String string3 = string + ":" + string2;
                CacheObject cacheObject = (CacheObject)this.get(string3);
                if (cacheObject != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found existing cache entry.");
                    }
                    subject = cacheObject.getSubject();
                    Map map = cacheObject.getPropTokenMap();
                    if (map != null) {
                        this.setPropTokenMapOnThread(map);
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.getSubject", (String)"400", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authentication failed for the userid: " + string2));
                Tr.debug((TraceComponent)tc, (String)"getSubject(realm, user, pw)", (Object)exception);
            }
            throw new CacheException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject(realm, user)");
        }
        return subject;
    }

    protected void update(Object object, Cache.Entry entry) throws CacheException {
    }

    public void insert(Subject subject) {
        block10: {
            if (subject == null) {
                return;
            }
            CacheObject cacheObject = new CacheObject();
            cacheObject.setSubject(subject);
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            try {
                if (wSCredential != null) {
                    Object object;
                    Map map;
                    byte[] byArray = wSCredential.getCredentialToken();
                    ByteArray byteArray = new ByteArray(byArray);
                    SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject((Subject)subject);
                    if (singleSignonToken != null && !byteArray.equals((Object)(map = new ByteArray(singleSignonToken.getBytes())))) {
                        cacheObject.setKey(map);
                        this.insert(map, cacheObject);
                    }
                    if ((map = ContextManagerFactory.getInstance().getPropagationTokens()) != null) {
                        object = null;
                        object = this.clonePropTokenMap(map);
                        if (object != null) {
                            cacheObject.setPropTokenMap((Map)object);
                        }
                    }
                    if ((object = WSCredentialTokenMapper.getInstance().getCacheKeyFromHashtable(subject)) != null) {
                        cacheObject.setKey(object);
                        this.insert(object, cacheObject);
                    }
                    String string = wSCredential.getRealmName() + ":" + wSCredential.getSecurityName();
                    String string2 = wSCredential.getRealmName() + ":" + wSCredential.getUniqueSecurityName();
                    cacheObject.setKey(string);
                    cacheObject.setKey(byteArray);
                    cacheObject.setKey(string2);
                    this.insert(string, cacheObject);
                    this.insert(string2, cacheObject);
                    this.insert(byteArray, cacheObject);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No WSCredential found in Subject.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.insert", (String)"383", (Object)this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"Exception inserting Subject into cache: ", (Object)new Object[]{exception});
            }
        }
    }

    public void insert(Subject subject, String string) {
        block13: {
            if (subject == null) {
                return;
            }
            CacheObject cacheObject = new CacheObject();
            cacheObject.setSubject(subject);
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            try {
                Object object;
                Map map;
                String string2;
                String string3;
                Object object2;
                SingleSignonToken singleSignonToken;
                if (wSCredential == null) break block13;
                byte[] byArray = wSCredential.getCredentialToken();
                ByteArray byteArray = new ByteArray(byArray);
                if (byteArray != null) {
                    cacheObject.setKey(byteArray);
                    this.insert(byteArray, cacheObject);
                }
                if ((singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject((Subject)subject)) != null && !byteArray.equals(object2 = new ByteArray(singleSignonToken.getBytes()))) {
                    cacheObject.setKey(object2);
                    this.insert(object2, cacheObject);
                }
                if ((object2 = WSCredentialTokenMapper.getInstance().getCacheKeyFromHashtable(subject)) != null) {
                    cacheObject.setKey(object2);
                    this.insert(object2, cacheObject);
                }
                if ((string3 = wSCredential.getRealmName() + ":" + wSCredential.getSecurityName()) != null) {
                    cacheObject.setKey(string3);
                    this.insert(string3, cacheObject);
                }
                if ((string2 = wSCredential.getRealmName() + ":" + wSCredential.getUniqueSecurityName()) != null) {
                    cacheObject.setKey(string2);
                    this.insert(string2, cacheObject);
                }
                if ((map = ContextManagerFactory.getInstance().getPropagationTokens()) != null) {
                    object = null;
                    object = this.clonePropTokenMap(map);
                    if (object != null) {
                        cacheObject.setPropTokenMap((Map)object);
                    }
                }
                object = new BasicAuthCacheData();
                ((BasicAuthCacheData)object).realm = wSCredential.getRealmName();
                ((BasicAuthCacheData)object).userId = wSCredential.getSecurityName();
                byte[] byArray2 = null;
                try {
                    byArray2 = ServerCredSigner.getInstance().getOneWayHash(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("One-way password hash using SHA is: " + new BigInteger(byArray2)));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.insert", (String)"423", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.sas.encode.error", (Object)new Object[]{exception});
                }
                ((BasicAuthCacheData)object).password = byArray2 != null ? byArray2 : string.getBytes();
                cacheObject.setKey(object);
                this.insert(object, cacheObject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.insert", (String)"602", (Object)this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"Exception inserting Subject into cache: ", (Object)new Object[]{exception});
            }
        }
    }

    public long getCushion() {
        if (this.cushion == -1L) {
            this.cushion = AuthCache.cushion();
        }
        return this.cushion;
    }

    private void setPropTokenMapOnThread(Map map) {
        block6: {
            if (map != null && map.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Setting cached PropagationTokens to thread.");
                }
                try {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        PropagationToken propagationToken = (PropagationToken)map.get(string);
                        if (propagationToken == null) continue;
                        ContextManagerFactory.getInstance().setPropagationToken(string, (PropagationToken)propagationToken.clone());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Completed setting propagation tokens to thread.");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.AuthCache.setPropTokenMapOnThread", (String)"646", (Object)this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Exception setting propagation tokens on thread.", (Object)new Object[]{exception.toString()});
                }
            }
        }
    }

    private Map clonePropTokenMap(Map map) {
        block6: {
            if (map != null && map.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Cloning propagation tokens.");
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                try {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        PropagationToken propagationToken = (PropagationToken)map.get(string);
                        if (propagationToken == null) continue;
                        hashMap.put(string, propagationToken.clone());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Returning cloned map.");
                    }
                    return hashMap;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.AuthCache.clonePropTokenMap", (String)"684", (Object)this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Exception cloning propagation tokens.", (Object)new Object[]{exception.toString()});
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BasicAuthCacheData {
        public String realm;
        public String userId;
        public byte[] password;

        BasicAuthCacheData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof BasicAuthCacheData)) {
                return false;
            }
            return this.realm.equals(((BasicAuthCacheData)object).realm) && this.userId.equals(((BasicAuthCacheData)object).userId) && Arrays.equals(this.password, ((BasicAuthCacheData)object).password);
        }

        public int hashCode() {
            return (this.realm + ":" + this.userId).hashCode();
        }
    }
}

