/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.core.SecurityConfig;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Cache
implements AlarmListener {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$Cache == null ? (class$com$ibm$ws$security$auth$Cache = Cache.class$("com.ibm.ws.security.auth.Cache")) : class$com$ibm$ws$security$auth$Cache));
    private Hashtable table;
    private Hashtable secondaryTable;
    private Hashtable tertiaryTable;
    private int minSize = 0;
    private boolean wipeCache;
    protected static Alarm defaultAlarm;
    static /* synthetic */ Class class$com$ibm$ws$security$auth$Cache;

    public Cache(int n, long l, boolean bl) {
        this.table = new Hashtable(n);
        this.secondaryTable = new Hashtable(n);
        this.tertiaryTable = new Hashtable(n);
        this.minSize = n;
        this.wipeCache = bl;
        Cache.addAlarmListener(this, l);
    }

    public Cache(int n, boolean bl) {
        this(n, defaultAlarm.getTimeout(), bl);
    }

    public void remove(Object object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove");
            StringBuffer stringBuffer = new StringBuffer("Key = ");
            stringBuffer.append(object.toString());
            stringBuffer.append(", key class is ");
            stringBuffer.append(object.getClass().getName());
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
        if (this.table.containsKey(object)) {
            this.table.remove(object);
        }
        if (this.secondaryTable.containsKey(object)) {
            this.secondaryTable.remove(object);
        }
        if (this.tertiaryTable.containsKey(object)) {
            this.tertiaryTable.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) throws CacheException {
        Object object2;
        Object object3;
        Hashtable hashtable = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get");
            object3 = new StringBuffer("Key = ");
            ((StringBuffer)object3).append(object.toString());
            ((StringBuffer)object3).append(", key class is ");
            ((StringBuffer)object3).append(object.getClass().getName());
            Tr.debug((TraceComponent)tc, (String)((StringBuffer)object3).toString());
        }
        if ((object3 = (Entry)this.table.get(object)) == null) {
            object3 = (Entry)this.secondaryTable.get(object);
            if (object3 == null) {
                object3 = (Entry)this.tertiaryTable.get(object);
                if (object3 != null) {
                    hashtable = this.tertiaryTable;
                }
            } else {
                hashtable = this.secondaryTable;
            }
            if (object3 == null) {
                object2 = this.table;
                synchronized (object2) {
                    if (tc.isEntryEnabled() && (this.table.size() + this.secondaryTable.size() + this.tertiaryTable.size()) % 100 == 0) {
                        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
                        stringBuffer.append(" number of entries: ");
                        stringBuffer.append(this.table.size() + this.secondaryTable.size() + this.tertiaryTable.size());
                        Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                    }
                    if ((object3 = (Entry)this.table.get(object)) == null) {
                        object3 = new Entry();
                        ((Entry)object3).marked = true;
                        this.table.put(object, object3);
                    }
                }
            } else {
                this.table.put(object, object3);
                hashtable.remove(object);
            }
        }
        if (((Entry)object3).marked) {
            object2 = object3;
            synchronized (object2) {
                if (((Entry)object3).marked) {
                    this.update(object, (Entry)object3);
                    ((Entry)object3).marked = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get");
        }
        return ((Entry)object3).value;
    }

    protected abstract void update(Object var1, Entry var2) throws CacheException;

    public void insert(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insert", (Object)object);
        }
        Entry entry = new Entry();
        entry.value = object2;
        this.table.put(object, entry);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"insert");
        }
    }

    protected void mark() {
        if (this.wipeCache) {
            this.tertiaryTable.clear();
        } else {
            this.tertiaryTable.putAll(this.secondaryTable);
        }
        this.secondaryTable = this.table;
        this.table = new Hashtable(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size() + 100);
    }

    public void alarm(Object object) {
        long l = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            stringBuffer.append(" Time elapsed cleaning cache: ");
            stringBuffer.append(System.currentTimeMillis() - l);
            stringBuffer.append(" milliseconds, Primary cache size: ");
            stringBuffer.append(this.table.size());
            stringBuffer.append(", Secondary cache size: ");
            stringBuffer.append(this.secondaryTable.size());
            stringBuffer.append(", Tertiary cache size: ");
            stringBuffer.append(this.tertiaryTable.size());
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
    }

    public static void setDefaultTimeout(long l) {
        if (defaultAlarm == null) {
            defaultAlarm = new Alarm(l);
        }
    }

    protected void clearAllEntries() {
        this.table.clear();
        this.secondaryTable.clear();
        this.tertiaryTable.clear();
    }

    public static long getDefaultTimeout() {
        return defaultAlarm.getTimeout();
    }

    public static void addAlarmListener(AlarmListener alarmListener) {
        Cache.addAlarmListener(alarmListener, defaultAlarm.getTimeout());
    }

    public static void addAlarmListener(AlarmListener alarmListener, long l) {
        if (l == defaultAlarm.getTimeout()) {
            defaultAlarm.addAlarmListener(alarmListener);
        } else {
            Alarm alarm = new Alarm(l);
            alarm.addAlarmListener(alarmListener);
        }
    }

    public static long cushion() {
        long l;
        long l2 = 0L;
        long l3 = Cache.getDefaultTimeout();
        long l4 = 0L;
        long l5 = (Integer)SecurityConfig.getConfig().getValue("security.CacheCushionMin") * 60 * 1000 - 5000;
        long l6 = (Integer)SecurityConfig.getConfig().getValue("security.CacheCushionMax") * 60 * 1000;
        if (l6 <= 0L) {
            l6 = 600000L;
        }
        if (((Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred")).booleanValue()) {
            String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
            l4 = string.equals("LTPA") ? (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate") * 60L * 1000L : (Long)SecurityConfig.getConfig().getValue("was.security.ISCF.timeout") * 60L * 1000L;
        }
        l2 = l4 > 0L ? ((l = l4 / 5L) < l5 ? l5 : (l > l6 ? l6 : l)) : 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Cushion is " + l2 / 1000L + " seconds."));
        }
        return l2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener alarmListener) {
            this.alarms.addElement(alarmListener);
        }

        public Alarm(long l) {
            this.timeout = l / 2L;
            this.alarm(null);
        }

        public void alarm(Object object) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(object);
            }
            AlarmManager.create((long)this.timeout, (AlarmListener)this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }

    public static class Entry {
        public Object value;
        public boolean marked = false;
        public int timesAccessed;
    }
}

