/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.SSLSecurityLevel;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocolKind;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionQOP;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageQOP;
import com.ibm.websphere.models.config.orb.securityprotocol.SecureAssociationService;
import com.ibm.websphere.models.config.orb.securityprotocol.ServerIdentity;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportQOP;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.CustomAuthMechanism;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.SASPropFile;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;

public class SASConfig {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$core$SASConfig == null ? (class$com$ibm$ws$security$core$SASConfig = SASConfig.class$("com.ibm.ws.security.core.SASConfig")) : class$com$ibm$ws$security$core$SASConfig), null, (String)"com.ibm.ejs.resources.security");
    private static SASConfig config;
    public static final String SECURITY_ENABLED_PROPERTY = "com.ibm.CORBA.securityEnabled";
    public static final String AUTHENTICATION_TARGET_PROPERTY = "com.ibm.CORBA.authenticationTarget";
    public static final String PRINCIPAL_NAME_PROPERTY = "com.ibm.CORBA.principalName";
    public static final String LOGIN_USERID = "com.ibm.CORBA.loginUserid";
    public static final String LOGIN_PASSWORD = "com.ibm.CORBA.loginPassword";
    public static final String SECURITY_CACHE_TIMEOUT_PROPERTY = "com.ibm.CORBA.securityCacheTimeout";
    public static final String CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS = "CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS";
    public static final String CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS = "CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS";
    public static final String SAS_SSL_SERVERAUTH_LISTENER_ADDRESS = "SAS_SSL_SERVERAUTH_LISTENER_ADDRESS";
    public static final String CELL_NODE_SERVER = "com.ibm.CSI.CellNodeServer";
    public static final String PLUGGABLE_AUTHZN_PROPERTY = "com.ibm.websphere.security.authorizationTable";
    private static final String[] propNames;
    private static final int SECURITY_ENABLED = 0;
    private static final int AUTHENTICATION_TARGET = 1;
    private static final int PRINCIPAL_NAME = 2;
    private static final int LOGIN_USERID_INDEX = 3;
    private static final int LOGIN_PASSWORD_INDEX = 4;
    private static final int SECURITY_CACHE_TIMEOUT = 5;
    private static final int SERVER_SECURITY_ENABLED = 6;
    private static final String LOCALOS_USERID = "LOCALOS.server.id";
    private static final String LOCALOS_PASSWORD = "LOCALOS.server.pwd";
    private boolean isRequired;
    private boolean forceRestart = false;
    private URL configURL = null;
    private URL futureConfigURL = null;
    private Properties localOSData;
    static /* synthetic */ Class class$com$ibm$ws$security$core$SASConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SASConfig getInstance() {
        if (config == null) {
            Class clazz = class$com$ibm$ws$security$core$SASConfig == null ? (class$com$ibm$ws$security$core$SASConfig = SASConfig.class$("com.ibm.ws.security.core.SASConfig")) : class$com$ibm$ws$security$core$SASConfig;
            synchronized (clazz) {
                if (config == null) {
                    config = new SASConfig();
                }
            }
        }
        return config;
    }

    private SASConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SASConfig");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SASConfig");
        }
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    private boolean isInitialized() {
        return this.configURL != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copy(URL uRL, URL uRL2) throws IOException {
        OutputStream outputStream;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"copy");
            }
            InputStream inputStream = null;
            outputStream = null;
            try {
                try {
                    int n;
                    inputStream = uRL.openStream();
                    outputStream = SASConfig.getOutputStream(uRL2);
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n);
                    }
                    Object var7_7 = null;
                    if (inputStream == null) break block11;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.SASConfig.copy", (String)"146");
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"copy", (Object)iOException);
                    }
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copy");
        }
    }

    public Properties getLoginData(String string) throws IOException {
        Properties properties = null;
        if (string.equals("LOCALOS")) {
            properties = this.localOSData;
        }
        return properties;
    }

    public synchronized void setLoginData(String string, Properties properties) throws IOException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLoginData");
        }
        if (!this.isInitialized()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setLoginData");
            }
            throw new FileNotFoundException("ConfigURL");
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(".server.");
        int n = stringBuffer.length();
        stringBuffer.append("id");
        String string2 = stringBuffer.toString();
        String string3 = properties.getProperty(string2);
        String string4 = this.localOSData.getProperty(string2);
        if (string4 != null && string3 != null && !string4.equals(string3)) {
            this.localOSData.put(string2, string3);
            bl = true;
        }
        stringBuffer.setLength(n);
        stringBuffer.append("pwd");
        string2 = stringBuffer.toString();
        string3 = properties.getProperty(string2);
        string4 = this.localOSData.getProperty(string2);
        if (string4 != null && string3 != null && !string4.equals(string3)) {
            object = null;
            try {
                object = PasswordUtil.decode((String)string3);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                FFDCFilter.processException((Throwable)invalidPasswordDecodingException, (String)"com.ibm.ws.security.core.SASConfig.setLoginData", (String)"218", (Object)this);
                object = string3;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SASConfig.setLoginData", (String)"224", (Object)this);
                object = string3;
                Tr.error((TraceComponent)tc, (String)"security.sas.decode.error", (Object)new Object[]{string3, string2});
            }
            this.localOSData.put(string2, object);
            bl = true;
        }
        if (bl) {
            object = this.loadProperties(this.futureConfigURL);
            Enumeration<?> enumeration = this.localOSData.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                ((Properties)object).put(string2, this.localOSData.getProperty(string2));
            }
            try {
                SASPropFile.encodePropPasswords((Properties)object);
            }
            catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
                FFDCFilter.processException((Throwable)invalidPasswordEncodingException, (String)"com.ibm.ws.security.core.SASConfig.setLoginData", (String)"249", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sas.encode.error", (Object)new Object[]{string2, this.localOSData.getProperty(string2)});
            }
            SASPropFile.saveConfig((Properties)object, (URL)this.futureConfigURL);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setLoginData");
        }
    }

    private boolean isCurrent() {
        boolean bl = false;
        try {
            Properties properties = this.loadProperties(this.configURL);
            Properties properties2 = this.loadProperties(this.futureConfigURL);
            bl = this.equal(properties2, properties);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.SASConfig.isCurrent", (String)"271", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sasconfig.currenterror", (Object)new Object[]{this.configURL.getPath(), this.futureConfigURL.getPath()});
        }
        return bl;
    }

    private boolean equal(Properties properties, Properties properties2) {
        boolean bl = true;
        try {
            for (int i = 0; i < propNames.length; ++i) {
                String string;
                String string2 = properties.getProperty(propNames[i]);
                if (string2.equals(string = properties2.getProperty(propNames[i]))) continue;
                bl = false;
                break;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.SASConfig.equal", (String)"298", (Object)this);
            bl = false;
        }
        return bl;
    }

    private Properties loadProperties(URL uRL) throws IOException {
        return SASConfig.loadProperties(uRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL uRL, boolean bl) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        try {
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (bl) {
            try {
                SASPropFile.decodePropPasswords((Properties)properties);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                FFDCFilter.processException((Throwable)invalidPasswordDecodingException, (String)"com.ibm.ws.security.core.SASConfig.loadProperties", (String)"340");
                Tr.error((TraceComponent)tc, (String)"security.sas.decode.error", (Object)new Object[]{uRL, properties});
            }
        }
        return properties;
    }

    private static OutputStream getOutputStream(URL uRL) throws IOException {
        OutputStream outputStream = null;
        outputStream = uRL.getProtocol().equals("file") ? new FileOutputStream(uRL.getFile()) : uRL.openConnection().getOutputStream();
        return outputStream;
    }

    private static boolean exists(URL uRL) {
        boolean bl = false;
        try {
            InputStream inputStream = uRL.openStream();
            int n = inputStream.read();
            inputStream.close();
            if (n >= 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SASConfig.exists", (String)"381");
        }
        return bl;
    }

    private static boolean delete(URL uRL) {
        boolean bl = false;
        if (uRL.getProtocol().equals("file")) {
            try {
                OutputStream outputStream = SASConfig.getOutputStream(uRL);
                outputStream.close();
                bl = true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.SASConfig.delete", (String)"400");
            }
        }
        return bl;
    }

    private static boolean renameTo(URL uRL, URL uRL2) {
        boolean bl = false;
        if (uRL.getProtocol().equals("file")) {
            try {
                SASConfig.copy(uRL, uRL2);
                SASConfig.delete(uRL);
                bl = true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.SASConfig.renameTo", (String)"418");
            }
        }
        return bl;
    }

    private boolean isORBSecurityEnabled(ORB oRB) {
        boolean bl = false;
        String string = oRB.getProperty(SECURITY_ENABLED_PROPERTY);
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateORBConfig(Security security, Properties properties, EndPointMgr endPointMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateORBConfig");
        }
        Class clazz = class$com$ibm$ws$security$core$SASConfig == null ? (class$com$ibm$ws$security$core$SASConfig = SASConfig.class$("com.ibm.ws.security.core.SASConfig")) : class$com$ibm$ws$security$core$SASConfig;
        synchronized (clazz) {
            Object object;
            try {
                object = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
                SASConfig.refresh((String)object, security, properties, endPointMgr);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SASConfig.updateORBConfig", (String)"478");
                Tr.error((TraceComponent)tc, (String)"security.sasconfig.registryattrs", (Object)new Object[]{exception});
                Tr.debug((TraceComponent)tc, (String)"Exception: ", (Object)new Object[]{exception});
            }
            if (tc.isDebugEnabled()) {
                object = properties.propertyNames();
                while (object.hasMoreElements()) {
                    String string = "updateORBConfig";
                    String string2 = (String)object.nextElement();
                    if (string2 == null) continue;
                    String string3 = properties.getProperty(string2);
                    if (string2.indexOf("Password") != -1 || string2.indexOf("password") != -1) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)(string + ": " + string2 + " = " + SecurityConfiguration.mask((String)string3)));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(string + ": " + string2 + " = " + string3));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateORBConfig");
            }
        }
    }

    private static synchronized void refresh(String string, Security security, Properties properties, EndPointMgr endPointMgr) throws RemoteException, IOException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refresh");
        }
        String string3 = String.valueOf((Boolean)SecurityConfig.getConfig().getValue("cell.security.enabled"));
        properties.put(propNames[0], string3);
        string3 = String.valueOf((Boolean)SecurityConfig.getConfig().getValue("server.security.enabled"));
        properties.put(propNames[6], string3);
        properties.put(propNames[1], (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism"));
        string3 = string2 = (String)SecurityConfig.getConfig().getValue("security.serverId");
        properties.put(LOGIN_USERID, string3);
        string3 = (String)SecurityConfig.getConfig().getValue("process.serverName");
        if (string3 != null) {
            properties.put(CELL_NODE_SERVER, string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiOutboundPropagationEnabled")) != null) {
            properties.put("com.ibm.CSI.rmiOutboundPropagationEnabled", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiOutboundLoginEnabled")) != null) {
            properties.put("com.ibm.CSI.rmiOutboundLoginEnabled", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiInboundPropagationEnabled")) != null) {
            properties.put("com.ibm.CSI.rmiInboundPropagationEnabled", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled")) != null) {
            properties.put("com.ibm.ws.security.webInboundPropagationEnabled", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.ssoInteropModeEnabled")) != null) {
            properties.put("com.ibm.ws.security.ssoInteropModeEnabled", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiInboundLoginConfig")) != null) {
            properties.put("com.ibm.CSI.rmiInboundLoginConfig", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig")) != null) {
            properties.put("com.ibm.ws.security.webInboundLoginConfig", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.rmiOutboundLoginConfig")) != null) {
            properties.put("com.ibm.CSI.rmiOutboundLoginConfig", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.CSI.supportedTargetRealms")) != null) {
            properties.put("com.ibm.CSI.supportedTargetRealms", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webPropagationTransport")) != null) {
            properties.put("com.ibm.ws.security.webPropagationTransport", string3);
        }
        if ((string3 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.propagationExcludeList")) != null) {
            properties.put("com.ibm.ws.security.propagationExcludeList", string3);
        }
        string3 = (String)SecurityConfig.getConfig().getValue("security.serverPasswd");
        try {
            if (string3 instanceof String) {
                string3 = PasswordUtil.encode((String)string3);
            }
        }
        catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
            FFDCFilter.processException((Throwable)invalidPasswordEncodingException, (String)"com.ibm.ws.security.core.SASConfig.refresh", (String)"544");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SASConfig.refresh", (String)"549");
            Tr.error((TraceComponent)tc, (String)"security.sas.encode.error", (Object)new Object[]{string3, LOGIN_PASSWORD});
        }
        properties.put(LOGIN_PASSWORD, string3);
        String string4 = string + "/" + string2;
        properties.put(propNames[2], string4);
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
        if (security.getActiveAuthMechanism() instanceof CustomAuthMechanism) {
            properties.put("com.ibm.CSI.WSSecurityContextCustomOID", (String)SecurityConfig.getConfig().getValue("security.authMechOID"));
            properties.put("com.ibm.CSI.WSSecurityContextCustomClass", (String)SecurityConfig.getConfig().getValue("security.authMechContextImpl"));
        }
        properties.put("com.ibm.CSI.WSSecurityContextActiveOID", (String)SecurityConfig.getConfig().getValue("security.authMechOID"));
        properties.put("com.ibm.CSI.WSSecurityContextActiveClass", (String)SecurityConfig.getConfig().getValue("security.authMechContextImpl"));
        properties.put("com.ibm.CSI.WSSecurityContextActiveForwardable", ((Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred")).toString());
        properties.put("com.ibm.CORBA.processIsServer", "true");
        properties.put("com.ibm.CSI.authMechAuthAlias", (String)SecurityConfig.getConfig().getValue("security.authMechAuthAlias"));
        properties.put("com.ibm.CSI.activeUserRegistry", (String)SecurityConfig.getConfig().getValue("security.activeUserRegistryType"));
        String string5 = (String)SecurityConfig.getConfig().getValue(PLUGGABLE_AUTHZN_PROPERTY);
        if (string5 != null && !string5.equals("")) {
            properties.put(PLUGGABLE_AUTHZN_PROPERTY, (String)SecurityConfig.getConfig().getValue(PLUGGABLE_AUTHZN_PROPERTY));
        }
        if (bl.booleanValue()) {
            properties.put("com.ibm.ws.orb.transport.ConnectionInterceptorName", "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor");
        }
        SASConfig.setCSIValues(security, properties, endPointMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"refresh");
        }
    }

    private static void setCSIValues(Security security, Properties properties, EndPointMgr endPointMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setCSIValues " + security));
        }
        try {
            Object object;
            CommonSecureInterop commonSecureInterop;
            TransportLayer transportLayer;
            String string;
            String string2;
            MessageQOP messageQOP;
            Object object2;
            TransportQOP transportQOP;
            IIOPSecurityProtocol iIOPSecurityProtocol = security.getCSI();
            IIOPSecurityProtocol iIOPSecurityProtocol2 = security.getIBM();
            IIOPSecurityProtocolKind iIOPSecurityProtocolKind = security.getActiveProtocol();
            int n = iIOPSecurityProtocolKind.getValue();
            String string3 = null;
            switch (n) {
                case 2: {
                    string3 = "BOTH";
                    break;
                }
                case 0: {
                    string3 = "IBM";
                    break;
                }
                default: {
                    string3 = "CSI";
                }
            }
            properties.put("com.ibm.CSI.protocol", string3);
            CommonSecureInterop commonSecureInterop2 = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
            if (commonSecureInterop2.isStateful()) {
                properties.put("com.ibm.CSI.claimStateful", "true");
            } else {
                properties.put("com.ibm.CSI.claimStateful", "false");
            }
            IdentityAssertionLayer identityAssertionLayer = null;
            for (int i = 0; i < commonSecureInterop2.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop2.getLayers().get(i) instanceof IdentityAssertionLayer)) continue;
                identityAssertionLayer = (IdentityAssertionLayer)commonSecureInterop2.getLayers().get(i);
                break;
            }
            if (identityAssertionLayer != null) {
                IdentityAssertionQOP identityAssertionQOP = (IdentityAssertionQOP)identityAssertionLayer.getSupportedQOP();
                if (identityAssertionQOP.isEnable()) {
                    properties.put("com.ibm.CSI.claimIdentityAssertionSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.claimIdentityAssertionSupported", "false");
                }
            }
            ServerIdentity serverIdentity = null;
            String string4 = "";
            for (int i = 0; i < identityAssertionLayer.getTrustedServers().size(); ++i) {
                serverIdentity = (ServerIdentity)identityAssertionLayer.getTrustedServers().get(i);
                string4 = i == 0 ? serverIdentity.getServerId() : serverIdentity.getServerId() + ", " + string4;
            }
            properties.put("com.ibm.CSI.trustedPrincipalList", string4);
            MessageLayer messageLayer = null;
            for (int i = 0; i < commonSecureInterop2.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop2.getLayers().get(i) instanceof MessageLayer)) continue;
                messageLayer = (MessageLayer)commonSecureInterop2.getLayers().get(i);
                break;
            }
            if (messageLayer != null) {
                MessageQOP messageQOP2 = (MessageQOP)messageLayer.getSupportedQOP();
                if (messageQOP2.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.claimClientAuthenticationSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.claimClientAuthenticationSupported", "false");
                }
                MessageQOP messageQOP3 = (MessageQOP)messageLayer.getRequiredQOP();
                if (messageQOP3.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.claimClientAuthenticationRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.claimClientAuthenticationRequired", "false");
                }
            }
            TransportLayer transportLayer2 = null;
            for (int i = 0; i < commonSecureInterop2.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop2.getLayers().get(i) instanceof TransportLayer)) continue;
                transportLayer2 = (TransportLayer)commonSecureInterop2.getLayers().get(i);
                break;
            }
            if (transportLayer2 != null) {
                TransportQOP transportQOP2 = (TransportQOP)transportLayer2.getSupportedQOP();
                if (transportQOP2.isEnableProtection()) {
                    properties.put("com.ibm.CSI.claimTransportAssocSSLTLSSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.claimTransportAssocSSLTLSSupported", "false");
                }
                if (transportQOP2.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.claimTLClientAuthenticationSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.claimTLClientAuthenticationSupported", "false");
                }
                if (transportQOP2.isIntegrity()) {
                    properties.put("com.ibm.CSI.claimMessageIntegritySupported", "true");
                } else {
                    properties.put("com.ibm.CSI.claimMessageIntegritySupported", "false");
                }
                if (transportQOP2.isConfidentiality()) {
                    properties.put("com.ibm.CSI.claimMessageConfidentialitySupported", "true");
                } else {
                    properties.put("com.ibm.CSI.claimMessageConfidentialitySupported", "false");
                }
                transportQOP = (TransportQOP)transportLayer2.getRequiredQOP();
                if (transportQOP.isEnableProtection()) {
                    properties.put("com.ibm.CSI.claimTransportAssocSSLTLSRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.claimTransportAssocSSLTLSRequired", "false");
                }
                if (transportQOP.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.claimTLClientAuthenticationRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.claimTLClientAuthenticationRequired", "false");
                }
                if (transportQOP.isIntegrity()) {
                    properties.put("com.ibm.CSI.claimMessageIntegrityRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.claimMessageIntegrityRequired", "false");
                }
                if (transportQOP.isConfidentiality()) {
                    properties.put("com.ibm.CSI.claimMessageConfidentialityRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.claimMessageConfidentialityRequired", "false");
                }
                IIOPTransport iIOPTransport = transportLayer2.getServerAuthentication();
                object2 = iIOPTransport.getSslConfig();
                if (object2 != null) {
                    int n2;
                    messageQOP = null;
                    for (n2 = 0; n2 < security.getRepertoire().size(); ++n2) {
                        if (!((SSLConfig)security.getRepertoire().get(n2)).getAlias().equals(object2)) continue;
                        messageQOP = ((SSLConfig)security.getRepertoire().get(n2)).getSetting();
                        break;
                    }
                    if (messageQOP != null) {
                        if (messageQOP.getKeyFileName() != null) {
                            properties.put("com.ibm.ssl.csi.inbound.keyStore", messageQOP.getKeyFileName());
                        }
                        if (messageQOP.getTrustFileName() != null) {
                            properties.put("com.ibm.ssl.csi.inbound.trustStore", messageQOP.getTrustFileName());
                        }
                        if (messageQOP.getTrustFilePassword() != null) {
                            properties.put("com.ibm.ssl.csi.inbound.trustStorePassword", messageQOP.getTrustFilePassword());
                        }
                        if (messageQOP.getKeyFilePassword() != null) {
                            properties.put("com.ibm.ssl.csi.inbound.keyStorePassword", messageQOP.getKeyFilePassword());
                        }
                        if (messageQOP.getKeyFileFormat() != null) {
                            properties.put("com.ibm.ssl.csi.inbound.keyStoreType", SASConfig.getKeyStoreType(messageQOP.getKeyFileFormat()));
                        }
                        if (messageQOP.getTrustFileFormat() != null) {
                            properties.put("com.ibm.ssl.csi.inbound.trustStoreType", SASConfig.getKeyStoreType(messageQOP.getTrustFileFormat()));
                        }
                        for (n2 = 0; n2 < messageQOP.getProperties().size(); ++n2) {
                            string2 = (Property)messageQOP.getProperties().get(n2);
                            if (string2 == null || string2.getName() == null) continue;
                            properties.put(string2.getName(), string2.getValue());
                            int n3 = string2.getName().lastIndexOf(46);
                            string = string2.getName().substring(n3);
                            properties.put("com.ibm.ssl.csi.inbound" + string, string2.getValue());
                        }
                        if (messageQOP.isEnableCryptoHardwareSupport()) {
                            CryptoHardwareToken cryptoHardwareToken = messageQOP.getCryptoHardware();
                            properties.put("com.ibm.ssl.csi.inbound.tokenType", cryptoHardwareToken.getTokenType());
                            properties.put("com.ibm.ssl.csi.inbound.tokenLibraryFile", cryptoHardwareToken.getLibraryFile());
                            properties.put("com.ibm.ssl.csi.inbound.tokenPassword", cryptoHardwareToken.getPassword());
                        }
                    }
                }
                messageQOP = null;
                try {
                    messageQOP = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SASConfig.setCSIValues", (String)"785");
                }
                if (messageQOP != null) {
                    String string5 = Integer.toString(messageQOP.getPort());
                    if (string5 != null && !string5.equals("")) {
                        properties.put("com.ibm.CSI.SSLPort", string5);
                    } else {
                        properties.put("com.ibm.CSI.SSLPort", "0");
                    }
                } else {
                    properties.put("com.ibm.CSI.SSLPort", "0");
                }
                transportLayer = null;
                try {
                    transportLayer = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SASConfig.setCSIValues", (String)"808");
                }
                if (transportLayer != null) {
                    string2 = Integer.toString(transportLayer.getPort());
                    if (string2 != null && !string2.equals("")) {
                        properties.put("com.ibm.CSI.ClientCertSSLPort", string2);
                    } else {
                        properties.put("com.ibm.CSI.ClientCertSSLPort", "0");
                    }
                } else {
                    properties.put("com.ibm.CSI.ClientCertSSLPort", "0");
                }
            }
            if ((commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getPerforms()).isStateful()) {
                properties.put("com.ibm.CSI.performStateful", "true");
            } else {
                properties.put("com.ibm.CSI.performStateful", "false");
            }
            properties.put("com.ibm.CORBA.sessionGCinterval", Integer.toString(commonSecureInterop.getSessionGCInterval()));
            properties.put("com.ibm.CORBA.sessionGCdiscardunused", Integer.toString(commonSecureInterop.getSessionGCIdleTime()));
            transportQOP = null;
            for (int i = 0; i < commonSecureInterop.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop.getLayers().get(i) instanceof IdentityAssertionLayer)) continue;
                transportQOP = (IdentityAssertionLayer)commonSecureInterop.getLayers().get(i);
                break;
            }
            if (transportQOP != null) {
                IdentityAssertionQOP identityAssertionQOP = (IdentityAssertionQOP)transportQOP.getSupportedQOP();
                if (identityAssertionQOP.isEnable()) {
                    properties.put("com.ibm.CSI.performIdentityAssertionSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performIdentityAssertionSupported", "false");
                }
                object2 = (IdentityAssertionQOP)transportQOP.getRequiredQOP();
                if (object2.isEnable()) {
                    properties.put("com.ibm.CSI.performIdentityAssertionRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performIdentityAssertionRequired", "false");
                }
            }
            MessageLayer messageLayer2 = null;
            for (int i = 0; i < commonSecureInterop.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop.getLayers().get(i) instanceof MessageLayer)) continue;
                messageLayer2 = (MessageLayer)commonSecureInterop.getLayers().get(i);
                break;
            }
            if (messageLayer2 != null) {
                MessageQOP messageQOP4 = (MessageQOP)messageLayer2.getSupportedQOP();
                if (messageQOP4.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.performClientAuthenticationSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performClientAuthenticationSupported", "false");
                }
                messageQOP = (MessageQOP)messageLayer2.getRequiredQOP();
                if (messageQOP.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.performClientAuthenticationRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performClientAuthenticationRequired", "false");
                }
                properties.put("com.ibm.CORBA.authenticationRetryCount", Integer.toString(messageLayer2.getAuthenticationLayerRetryCount()));
                if (messageLayer2.getAuthenticationLayerRetryCount() > 0) {
                    properties.put("com.ibm.CORBA.authenticationRetryEnabled", "true");
                } else {
                    properties.put("com.ibm.CORBA.authenticationRetryEnabled", "false");
                }
            }
            TransportLayer transportLayer3 = null;
            for (int i = 0; i < commonSecureInterop.getLayers().size(); ++i) {
                if (!((IIOPLayer)commonSecureInterop.getLayers().get(i) instanceof TransportLayer)) continue;
                transportLayer3 = (TransportLayer)commonSecureInterop.getLayers().get(i);
                break;
            }
            if (transportLayer3 != null) {
                TransportQOP transportQOP3 = (TransportQOP)transportLayer3.getSupportedQOP();
                if (transportQOP3.isEnableProtection()) {
                    properties.put("com.ibm.CSI.performTransportAssocSSLTLSSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performTransportAssocSSLTLSSupported", "false");
                }
                if (transportQOP3.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.performTLClientAuthenticationSupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performTLClientAuthenticationSupported", "false");
                }
                if (transportQOP3.isIntegrity()) {
                    properties.put("com.ibm.CSI.performMessageIntegritySupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performMessageIntegritySupported", "false");
                }
                if (transportQOP3.isConfidentiality()) {
                    properties.put("com.ibm.CSI.performMessageConfidentialitySupported", "true");
                } else {
                    properties.put("com.ibm.CSI.performMessageConfidentialitySupported", "false");
                }
                transportLayer = (TransportQOP)transportLayer3.getRequiredQOP();
                if (transportLayer.isEnableProtection()) {
                    properties.put("com.ibm.CSI.performTransportAssocSSLTLSRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performTransportAssocSSLTLSRequired", "false");
                }
                if (transportLayer.isEstablishTrustInClient()) {
                    properties.put("com.ibm.CSI.performTLClientAuthenticationRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performTLClientAuthenticationRequired", "false");
                }
                if (transportLayer.isIntegrity()) {
                    properties.put("com.ibm.CSI.performMessageIntegrityRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performMessageIntegrityRequired", "false");
                }
                if (transportLayer.isConfidentiality()) {
                    properties.put("com.ibm.CSI.performMessageConfidentialityRequired", "true");
                } else {
                    properties.put("com.ibm.CSI.performMessageConfidentialityRequired", "false");
                }
                string2 = transportLayer3.getServerAuthentication();
                String string6 = string2.getSslConfig();
                if (string6 != null) {
                    int n4;
                    string = null;
                    for (n4 = 0; n4 < security.getRepertoire().size(); ++n4) {
                        if (!((SSLConfig)security.getRepertoire().get(n4)).getAlias().equals(string6)) continue;
                        string = ((SSLConfig)security.getRepertoire().get(n4)).getSetting();
                        break;
                    }
                    if (string != null) {
                        if (string.getKeyFileName() != null) {
                            properties.put("com.ibm.ssl.csi.outbound.keyStore", string.getKeyFileName());
                        }
                        if (string.getTrustFileName() != null) {
                            properties.put("com.ibm.ssl.csi.outbound.trustStore", string.getTrustFileName());
                        }
                        if (string.getTrustFilePassword() != null) {
                            properties.put("com.ibm.ssl.csi.outbound.trustStorePassword", string.getTrustFilePassword());
                        }
                        if (string.getKeyFilePassword() != null) {
                            properties.put("com.ibm.ssl.csi.outbound.keyStorePassword", string.getKeyFilePassword());
                        }
                        if (string.getKeyFileFormat() != null) {
                            properties.put("com.ibm.ssl.csi.outbound.keyStoreType", SASConfig.getKeyStoreType(string.getKeyFileFormat()));
                        }
                        if (string.getTrustFileFormat() != null) {
                            properties.put("com.ibm.ssl.csi.outbound.trustStoreType", SASConfig.getKeyStoreType(string.getTrustFileFormat()));
                        }
                        for (n4 = 0; n4 < string.getProperties().size(); ++n4) {
                            Property property = (Property)string.getProperties().get(n4);
                            if (property == null || property.getName() == null) continue;
                            properties.put(property.getName(), property.getValue());
                            int n5 = property.getName().lastIndexOf(46);
                            String string7 = property.getName().substring(n5);
                            properties.put("com.ibm.ssl.csi.outbound" + string7, property.getValue());
                        }
                        if (string.isEnableCryptoHardwareSupport()) {
                            CryptoHardwareToken cryptoHardwareToken = string.getCryptoHardware();
                            properties.put("com.ibm.ssl.csi.outbound.tokenType", cryptoHardwareToken.getTokenType());
                            properties.put("com.ibm.ssl.csi.outbound.tokenLibraryFile", cryptoHardwareToken.getLibraryFile());
                            properties.put("com.ibm.ssl.csi.outbound.tokenPassword", cryptoHardwareToken.getPassword());
                        }
                    }
                }
            }
            SecureAssociationService secureAssociationService = (SecureAssociationService)iIOPSecurityProtocol2.getClaims();
            transportLayer = null;
            for (int i = 0; i < secureAssociationService.getLayers().size(); ++i) {
                if (!((IIOPLayer)secureAssociationService.getLayers().get(i) instanceof TransportLayer)) continue;
                transportLayer = (TransportLayer)secureAssociationService.getLayers().get(i);
                break;
            }
            if (transportLayer != null) {
                TransportQOP transportQOP4 = (TransportQOP)transportLayer.getSupportedQOP();
                if (transportQOP4.isEnableProtection()) {
                    properties.put("com.ibm.CORBA.SSLTypeIClientAssociationEnabled", "true");
                } else {
                    properties.put("com.ibm.CORBA.SSLTypeIClientAssociationEnabled", "false");
                }
                if (transportQOP4.isConfidentiality()) {
                    properties.put("com.ibm.CORBA.standardClaimQOPModels", "high");
                } else if (transportQOP4.isIntegrity()) {
                    properties.put("com.ibm.CORBA.standardClaimQOPModels", "medium");
                } else {
                    properties.put("com.ibm.CORBA.standardClaimQOPModels", "low");
                }
                IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
                string = iIOPTransport.getSslConfig();
                if (string != null) {
                    int n6;
                    SecureSocketLayer secureSocketLayer = null;
                    for (n6 = 0; n6 < security.getRepertoire().size(); ++n6) {
                        if (!((SSLConfig)security.getRepertoire().get(n6)).getAlias().equals(string)) continue;
                        secureSocketLayer = ((SSLConfig)security.getRepertoire().get(n6)).getSetting();
                        break;
                    }
                    if (secureSocketLayer != null) {
                        if (secureSocketLayer.getKeyFileName() != null) {
                            properties.put("com.ibm.ssl.sas.inbound.keyStore", secureSocketLayer.getKeyFileName());
                        }
                        if (secureSocketLayer.getTrustFileName() != null) {
                            properties.put("com.ibm.ssl.sas.inbound.trustStore", secureSocketLayer.getTrustFileName());
                        }
                        if (secureSocketLayer.getTrustFilePassword() != null) {
                            properties.put("com.ibm.ssl.sas.inbound.trustStorePassword", secureSocketLayer.getTrustFilePassword());
                        }
                        if (secureSocketLayer.getKeyFilePassword() != null) {
                            properties.put("com.ibm.ssl.sas.inbound.keyStorePassword", secureSocketLayer.getKeyFilePassword());
                        }
                        if (secureSocketLayer.getKeyFileFormat() != null) {
                            properties.put("com.ibm.ssl.sas.inbound.keyStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getKeyFileFormat()));
                        }
                        if (secureSocketLayer.getTrustFileFormat() != null) {
                            properties.put("com.ibm.ssl.sas.inbound.trustStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getTrustFileFormat()));
                        }
                        for (n6 = 0; n6 < secureSocketLayer.getProperties().size(); ++n6) {
                            Property property = (Property)secureSocketLayer.getProperties().get(n6);
                            if (property == null || property.getName() == null) continue;
                            properties.put(property.getName(), property.getValue());
                            int n7 = property.getName().lastIndexOf(46);
                            object = property.getName().substring(n7);
                            properties.put("com.ibm.ssl.sas.inbound" + (String)object, property.getValue());
                        }
                        if (secureSocketLayer.isEnableCryptoHardwareSupport()) {
                            CryptoHardwareToken cryptoHardwareToken = secureSocketLayer.getCryptoHardware();
                            properties.put("com.ibm.ssl.sas.inbound.tokenType", cryptoHardwareToken.getTokenType());
                            properties.put("com.ibm.ssl.sas.inbound.tokenLibraryFile", cryptoHardwareToken.getLibraryFile());
                            properties.put("com.ibm.ssl.sas.inbound.tokenPassword", cryptoHardwareToken.getPassword());
                        }
                    }
                }
                EndPoint endPoint = null;
                try {
                    endPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(SAS_SSL_SERVERAUTH_LISTENER_ADDRESS);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SASConfig.setCSIValues", (String)"1083");
                }
                if (endPoint != null) {
                    String string8 = Integer.toString(endPoint.getPort());
                    if (string8 != null && !string8.equals("")) {
                        properties.put("com.ibm.CORBA.SSLPort", string8);
                    } else {
                        properties.put("com.ibm.CORBA.SSLPort", "0");
                    }
                } else {
                    properties.put("com.ibm.CORBA.SSLPort", "0");
                }
            }
            SecureAssociationService secureAssociationService2 = (SecureAssociationService)iIOPSecurityProtocol2.getPerforms();
            TransportLayer transportLayer4 = null;
            for (int i = 0; i < secureAssociationService2.getLayers().size(); ++i) {
                if (!((IIOPLayer)secureAssociationService2.getLayers().get(i) instanceof TransportLayer)) continue;
                transportLayer4 = (TransportLayer)secureAssociationService2.getLayers().get(i);
                break;
            }
            if (transportLayer4 != null) {
                TransportQOP transportQOP5 = (TransportQOP)transportLayer4.getSupportedQOP();
                if (transportQOP5.isEnableProtection()) {
                    properties.put("com.ibm.CORBA.SSLTypeIServerAssociationEnabled", "true");
                } else {
                    properties.put("com.ibm.CORBA.SSLTypeIServerAssociationEnabled", "false");
                }
                if (transportQOP5.isConfidentiality()) {
                    properties.put("com.ibm.CORBA.standardPerformQOPModels", "high");
                } else if (transportQOP5.isIntegrity()) {
                    properties.put("com.ibm.CORBA.standardPerformQOPModels", "medium");
                } else {
                    properties.put("com.ibm.CORBA.standardPerformQOPModels", "low");
                }
                IIOPTransport iIOPTransport = transportLayer4.getServerAuthentication();
                String string9 = iIOPTransport.getSslConfig();
                if (string9 != null) {
                    int n8;
                    SecureSocketLayer secureSocketLayer = null;
                    for (n8 = 0; n8 < security.getRepertoire().size(); ++n8) {
                        if (!((SSLConfig)security.getRepertoire().get(n8)).getAlias().equals(string9)) continue;
                        secureSocketLayer = ((SSLConfig)security.getRepertoire().get(n8)).getSetting();
                        break;
                    }
                    if (secureSocketLayer != null) {
                        if (secureSocketLayer.getKeyFileName() != null) {
                            properties.put("com.ibm.ssl.sas.outbound.keyStore", secureSocketLayer.getKeyFileName());
                        }
                        if (secureSocketLayer.getTrustFileName() != null) {
                            properties.put("com.ibm.ssl.sas.outbound.trustStore", secureSocketLayer.getTrustFileName());
                        }
                        if (secureSocketLayer.getTrustFilePassword() != null) {
                            properties.put("com.ibm.ssl.sas.outbound.trustStorePassword", secureSocketLayer.getTrustFilePassword());
                        }
                        if (secureSocketLayer.getKeyFilePassword() != null) {
                            properties.put("com.ibm.ssl.sas.outbound.keyStorePassword", secureSocketLayer.getKeyFilePassword());
                        }
                        if (secureSocketLayer.getKeyFileFormat() != null) {
                            properties.put("com.ibm.ssl.sas.outbound.keyStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getKeyFileFormat()));
                        }
                        if (secureSocketLayer.getTrustFileFormat() != null) {
                            properties.put("com.ibm.ssl.sas.outbound.trustStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getTrustFileFormat()));
                        }
                        for (n8 = 0; n8 < secureSocketLayer.getProperties().size(); ++n8) {
                            object = (Property)secureSocketLayer.getProperties().get(n8);
                            if (object == null || object.getName() == null) continue;
                            properties.put(object.getName(), object.getValue());
                            int n9 = object.getName().lastIndexOf(46);
                            String string10 = object.getName().substring(n9);
                            properties.put("com.ibm.ssl.sas.outbound" + string10, object.getValue());
                        }
                        if (secureSocketLayer.isEnableCryptoHardwareSupport()) {
                            CryptoHardwareToken cryptoHardwareToken = secureSocketLayer.getCryptoHardware();
                            properties.put("com.ibm.ssl.sas.outbound.tokenType", cryptoHardwareToken.getTokenType());
                            properties.put("com.ibm.ssl.sas.outbound.tokenLibraryFile", cryptoHardwareToken.getLibraryFile());
                            properties.put("com.ibm.ssl.sas.outbound.tokenPassword", cryptoHardwareToken.getPassword());
                        }
                    }
                }
            }
            properties.put("com.ibm.CORBA.loginTimeout", new Integer(300).toString());
            properties.put("com.ibm.CORBA.delegateCredentials", "methoddefined");
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SASConfig.updateORBConfig", (String)"1182");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCSIValues");
        }
    }

    private static boolean hasValue(String string) {
        return string != null && string.length() > 0;
    }

    public static String getKeyStoreType(KeyFileFormatKind keyFileFormatKind) {
        String string = null;
        switch (keyFileFormatKind.getValue()) {
            case 2: {
                string = "JCEKS";
                break;
            }
            case 1: {
                string = "PKCS12";
                break;
            }
            default: {
                string = "JKS";
            }
        }
        return string;
    }

    public static String getSecurityLevel(SSLSecurityLevel sSLSecurityLevel) {
        int n = sSLSecurityLevel.getValue();
        String string = null;
        switch (n) {
            case 2: {
                string = "LOW";
                break;
            }
            case 1: {
                string = "MEDIUM";
                break;
            }
            default: {
                string = "HIGH";
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        propNames = SASPropFile.propNames;
    }
}

